/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.common;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ThreadStateInfo
implements Serializable {
    public static int GET_RUNNING_STATE = 0;
    public static int GET_PROCESSING_INFO = 1;
    public static int GET_ALL_INFO = 2;
    public static int GET_ALL2_INFO = 3;
    public SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    public long tid;
    public int mode;
    public String threadId;
    public boolean active;
    public boolean blocked;
    public boolean reconnecting;
    public long elapsedTime;
    public String runningApp;
    public String qString;
    public boolean alive;
    public long requestCount;
    public long avgProcTime;
    public long totalRequestCount;
    public long checkTime;
    public int step;
    public long totalAvgProcTime;

    public ThreadStateInfo(String id, long tid, int mode) {
        this.threadId = id;
        this.mode = mode;
        this.tid = tid;
    }

    public long getTid() {
        return this.tid;
    }

    public String getStatusString() {
        if (this.blocked) {
            return "blocked";
        }
        if (this.reconnecting) {
            return "reconnection";
        }
        if (this.active) {
            return "active";
        }
        return "waiting";
    }

    public String getSmallDetail() {
        return "[rt=" + this.elapsedTime + " ms]" + "[req=" + this.requestCount + ", avgTime=" + this.avgProcTime + " ms, total=" + this.totalRequestCount + ", total avgTime=" + this.totalAvgProcTime + "ms ," + this.step + "]" + "[uri=" + this.runningApp + "]";
    }

    public String toString() {
        String state = "[" + this.threadId + "]";
        if (this.mode == GET_RUNNING_STATE) {
            state = this.blocked ? state + "[blocked , rt=" + this.elapsedTime + " ms, uri=" + this.runningApp + "]" : (this.reconnecting ? state + "[reconnecting , rt=" + this.elapsedTime + " ms, uri=" + this.runningApp + "]" : (this.active ? state + "[active , rt=" + this.elapsedTime + " ms, uri=" + this.runningApp + "]" : state + "[waiting, wt=" + this.elapsedTime + " ms]"));
        } else if (this.mode == GET_PROCESSING_INFO) {
            state = state + "[reqs=" + this.requestCount + ", avgTime=" + this.avgProcTime + " ms, total=" + this.totalRequestCount + ", total avgTime=" + this.totalAvgProcTime + "ms]";
        } else if (this.mode == GET_ALL_INFO || this.mode == GET_ALL2_INFO) {
            if (this.blocked) {
                state = state + "[blocked , " + this.df.format(new Date(this.checkTime)) + ", rt=" + this.elapsedTime + " ms]";
                state = state + "[req=" + this.requestCount + ", avgTime=" + this.avgProcTime + " ms, total=" + this.totalRequestCount + ", total avgTime=" + this.totalAvgProcTime + "ms, " + this.step + "]";
                state = this.mode == GET_ALL_INFO || this.qString == null ? state + "[uri=" + this.runningApp + "][alive=" + this.alive + "]" : state + "[uri=" + this.runningApp + "?" + this.qString + "][alive=" + this.alive + "]";
            } else if (this.reconnecting) {
                state = state + "[reconnecting , " + this.df.format(new Date(this.checkTime)) + ", rt=" + this.elapsedTime + " ms]";
                state = state + "[req=" + this.requestCount + ", avgTime=" + this.avgProcTime + " ms, total=" + this.totalRequestCount + ", total avgTime=" + this.totalAvgProcTime + "ms, " + this.step + "]";
                state = this.mode == GET_ALL_INFO || this.qString == null ? state + "[uri=" + this.runningApp + "][alive=" + this.alive + "]" : state + "[uri=" + this.runningApp + "?" + this.qString + "][alive=" + this.alive + "]";
            } else if (this.active) {
                state = state + "[active , " + this.df.format(new Date(this.checkTime)) + ", rt=" + this.elapsedTime + " ms]";
                state = state + "[req=" + this.requestCount + ", avgTime=" + this.avgProcTime + " ms, total=" + this.totalRequestCount + ", total avgTime=" + this.totalAvgProcTime + "ms, " + this.step + "]";
                state = this.mode == GET_ALL_INFO || this.qString == null ? state + "[uri=" + this.runningApp + "][alive=" + this.alive + "]" : state + "[uri=" + this.runningApp + "?" + this.qString + "][alive=" + this.alive + "]";
            } else {
                state = state + "[waiting, " + this.df.format(new Date(this.checkTime)) + ", wt=" + this.elapsedTime + " ms]";
                state = state + "[req=" + this.requestCount + ", avgTime=" + this.avgProcTime + " ms, total=" + this.totalRequestCount + ", total avgTime=" + this.totalAvgProcTime + " ms, " + this.step + "][alive=" + this.alive + "]";
            }
        }
        return state;
    }

    public String getThreadId() {
        return this.threadId;
    }
}

