/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.deployment.descriptor.ThreadPoolDescriptor;
import jeus.servlet.util.FileUtil;
import jeus.util.JeusProperties;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.util.properties.JeusNetPropertyValues;

public class ConnectionDescriptor
implements Serializable {
    public static final int DEFAULT_POSTDATA_READ_TIMEOUT = 30000;
    public static final String DEFAULT_SCHEME = "http";
    private String listenerId = null;
    private String listenerType = null;
    private String ip = null;
    private int port = 8080;
    private boolean accessControl = false;
    private int backlog = 50;
    private String webServerAddress = JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS;
    private int connectionPortNum = 1;
    private String registerId = "default";
    private String busyNotifyPage;
    private Vector allowedServers = null;
    private String forcedRequestUrlEncoding;
    private String forcedRequestEncoding;
    private String forcedResponseEncoding;
    private String defaultRequestUrlEncoding;
    private String defaultRequestEncoding;
    private String defaultResponseEncoding;
    private String connectionType;
    private int postdataReadTimeout = 30000;
    private ThreadPoolDescriptor tpoolDesc;
    private Vector backupServerDescs;
    private int inputBufferSize = 8192;
    private int outputBufferSize = 8192;
    private boolean requestPrefetch = true;
    private boolean disablePipe = false;
    private String webtobHome = null;
    private int webtobIpcbaseport = -1;
    private String XAResourceClass;
    private boolean enableSecure;
    private String clientAuth;
    private String sslProtocol;
    private String keyAlias;
    private String crlFile;
    private List cipherSuites;
    private String keyStoreFile;
    private String keyStorePass;
    private String keyStoreType;
    private String keyManagementAlgorithm;
    private String keypassword;
    private String trustStoreFile;
    private String trustStorePass;
    private String trustStoreType;
    private String trustManagementAlgorithm;
    private int readTimeout = 0;
    private String dispatcherConfigClass = null;
    private String connectionHandshakerClass = null;
    private String connectionListenerClass = null;
    private long reconnectTimeout = -1L;
    private String scheme = "http";
    private boolean adminChannel = false;
    private String serverGroupName = null;
    private String serverType = null;
    private String serverName = null;
    private String tmaxBackupAddress = null;
    private String tmaxBackupPort = null;
    private String backupServerGroupName = null;
    private String tmaxVersion = "3X";
    private boolean isKeepAlive = true;
    private int maxKeepAliveRequests = 100;
    private boolean useNio = false;
    private String selectorCount = "1";

    public String toString() {
        return this.listenerType + "[" + this.listenerId + "(" + this.webServerAddress + ":" + this.port + ")]";
    }

    public void setListenerId(String id) throws DescriptorException {
        this.listenerId = id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setListenerType(String type) throws DescriptorException {
        if (type == null) throw new DescriptorException(JeusMessage_WebContainer0._1251);
        if (type.equalsIgnoreCase("WebtobListener")) {
            this.listenerType = "WebtobListener";
            return;
        } else if (type.equalsIgnoreCase("HttpListener")) {
            this.listenerType = "HttpListener";
            return;
        } else if (type.equalsIgnoreCase("TCPListener")) {
            this.listenerType = "TCPListener";
            return;
        } else if (type.equalsIgnoreCase("Ajp13Listener")) {
            this.listenerType = "Ajp13Listener";
            return;
        } else if (type.equalsIgnoreCase("TmaxListener")) {
            this.listenerType = "TmaxListener";
            return;
        } else if (type.equalsIgnoreCase("UDPListener")) {
            this.listenerType = "UDPListener";
            return;
        } else {
            if (!type.equalsIgnoreCase("OnePortListener")) throw new DescriptorException(JeusMessage_WebContainer0._1250, new String[]{type});
            this.listenerType = "OnePortListener";
        }
    }

    public void setIp(String ip) throws DescriptorException {
        this.ip = ip;
    }

    public void setPort(String port) throws DescriptorException {
        if (port != null) {
            if (port.equalsIgnoreCase("pipe")) {
                this.port = -1;
            } else {
                try {
                    this.port = Integer.parseInt(port);
                }
                catch (NumberFormatException nfe) {
                    throw new DescriptorException(JeusMessage_WebContainer0._1252, String.valueOf(port));
                }
                if (this.port <= 0) {
                    throw new DescriptorException(JeusMessage_WebContainer0._1253, String.valueOf(port));
                }
            }
        } else {
            throw new DescriptorException(JeusMessage_WebContainer0._1254);
        }
    }

    public void setBacklog(String blog) {
        if (blog != null) {
            try {
                this.backlog = Integer.parseInt(blog);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.backlog <= 0) {
                this.backlog = 50;
            }
        }
    }

    public void setAccessControl(String access) {
        this.accessControl = access != null && access.equals("true");
    }

    public void setWebServerAddress(String addr) {
        if (addr != null) {
            this.webServerAddress = addr;
        }
    }

    public void setConnectionPortNum(String ports) throws DescriptorException {
        if (ports != null) {
            try {
                this.connectionPortNum = Integer.parseInt(ports);
            }
            catch (NumberFormatException nfe) {
                throw new DescriptorException(JeusMessage_WebContainer0._1255, String.valueOf(ports));
            }
            if (this.connectionPortNum <= 0) {
                this.connectionPortNum = 1;
                throw new DescriptorException(JeusMessage_WebContainer0._1255, String.valueOf(ports));
            }
        }
    }

    public void setRegistrationId(String id) {
        if (id != null) {
            this.registerId = id;
        }
    }

    public void setBusyNotifyPage(String page) {
        if (page != null) {
            this.busyNotifyPage = page;
        }
    }

    public void addAllowedServer(String addr) {
        if (this.accessControl && addr != null) {
            if (this.allowedServers == null) {
                this.allowedServers = new Vector();
            }
            this.allowedServers.addElement(addr);
        }
    }

    public void setAllowedServer(Vector servers) {
        if (this.accessControl && servers != null && servers.size() > 0) {
            this.allowedServers = servers;
        }
    }

    public void setInputBufferSize(String size) {
        if (size != null) {
            try {
                this.inputBufferSize = Integer.parseInt(size);
            }
            catch (NumberFormatException nfe) {
                this.inputBufferSize = 8192;
            }
            if (this.inputBufferSize < 0) {
                this.inputBufferSize = 8192;
            }
        }
    }

    public void setOutputBufferSize(String size) {
        if (size != null) {
            try {
                this.outputBufferSize = Integer.parseInt(size);
            }
            catch (NumberFormatException nfe) {
                this.outputBufferSize = 8192;
            }
            if (this.outputBufferSize < 0) {
                this.outputBufferSize = 0;
            }
        }
    }

    public void setReadTimeout(String timeout) {
        if (timeout != null) {
            try {
                this.readTimeout = Integer.parseInt(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setPostdataReadTimeout(String timeout) {
        if (timeout != null) {
            try {
                this.postdataReadTimeout = Integer.parseInt(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setThreadPoolDescriptor(ThreadPoolDescriptor desc) {
        this.tpoolDesc = desc;
    }

    public void addBackupServerDescriptor(ConnectionDescriptor desc) {
        if (this.backupServerDescs == null) {
            this.backupServerDescs = new Vector();
        }
        this.backupServerDescs.addElement(desc);
    }

    public void setRequestPrefetch(boolean value) {
        this.requestPrefetch = value;
    }

    public void setWebtobHome(String value) {
        this.webtobHome = value;
    }

    public void setReconnectTimeout(String value) {
        if (value == null || value.equals("")) {
            return;
        }
        try {
            this.reconnectTimeout = Long.parseLong(value);
            if (this.reconnectTimeout < 0L) {
                this.reconnectTimeout = -1L;
            }
        }
        catch (Exception e) {
            this.reconnectTimeout = -1L;
        }
    }

    public void setDisablePipe(String value) {
        this.disablePipe = value != null && value.equals("true");
    }

    public void setDispatcherConfigClass(String value) {
        this.dispatcherConfigClass = value;
    }

    public void setConnectionHandshakerClass(String value) {
        this.connectionHandshakerClass = value;
    }

    public void setConnectionListenerClass(String value) {
        this.connectionListenerClass = value;
    }

    public void setScheme(String s) {
        if (s != null && !(s = s.trim()).equals("")) {
            this.scheme = s;
        }
    }

    public void setAdminChannel(String value) {
        this.adminChannel = value != null && value.equals("true");
    }

    public void setWebtobIpcbaseport(String port) {
        if (port != null) {
            try {
                this.webtobIpcbaseport = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                this.webtobIpcbaseport = -1;
            }
            if (this.port <= 0) {
                this.webtobIpcbaseport = -1;
            }
        }
    }

    public void setIsKeepAlive(boolean isKeepAlive) {
        this.isKeepAlive = isKeepAlive;
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.maxKeepAliveRequests = maxKeepAliveRequests;
    }

    public void setEnableSecure(boolean enableSecure) {
        this.enableSecure = enableSecure;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void setCrlFile(String crlFile) throws DescriptorException {
        this.crlFile = ConnectionDescriptor.checkAbsolutePath(crlFile);
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public void setCipherSuites(List cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setKeyStoreFile(String keyStoreFile) throws DescriptorException {
        this.keyStoreFile = ConnectionDescriptor.checkAbsolutePath(keyStoreFile);
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setKeyManagementAlgorithm(String keyManagementAlgorithm) {
        this.keyManagementAlgorithm = keyManagementAlgorithm;
    }

    public void setKeypassword(String keypassword) {
        this.keypassword = keypassword;
    }

    public void setTrustStoreFile(String trustStoreFile) throws DescriptorException {
        this.trustStoreFile = ConnectionDescriptor.checkAbsolutePath(trustStoreFile);
    }

    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setTrustManagementAlgorithm(String trustManagementAlgorithm) {
        this.trustManagementAlgorithm = trustManagementAlgorithm;
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String getListenerType() {
        return this.listenerType;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isAccessControl() {
        return this.accessControl;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public String getWebServerAddress() {
        return this.webServerAddress;
    }

    public int getConnectionPortNum() {
        return this.connectionPortNum;
    }

    public String getRegistrationId() {
        return this.registerId;
    }

    public String getBusyNotifyPage() {
        return this.busyNotifyPage;
    }

    public Vector getAllowedServers() {
        if (this.allowedServers == null) {
            return new Vector();
        }
        return this.allowedServers;
    }

    public ThreadPoolDescriptor getThreadPoolDescriptor() {
        return this.tpoolDesc;
    }

    public Vector getBackupServerDescriptor() {
        return this.backupServerDescs;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getPostdataReadTimeout() {
        return this.postdataReadTimeout;
    }

    public boolean getRequestPrefetch() {
        return this.requestPrefetch;
    }

    public String getWebtobHome() {
        return this.webtobHome;
    }

    public long getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public boolean getDisablePipe() {
        return this.disablePipe;
    }

    public String getDispatcherConfigClass() {
        return this.dispatcherConfigClass;
    }

    public String getConnectionHandshakerClass() {
        return this.connectionHandshakerClass;
    }

    public String getConnectionListenerClass() {
        return this.connectionListenerClass;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean getAdminChannel() {
        return this.adminChannel;
    }

    public int getWebtobIpcbasePort() {
        return this.webtobIpcbaseport;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public boolean isEnableSecure() {
        return this.enableSecure;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getCrlFile() {
        return this.crlFile;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public List getCipherSuites() {
        return this.cipherSuites;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyManagementAlgorithm() {
        return this.keyManagementAlgorithm;
    }

    public String getKeypassword() {
        return this.keypassword;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustManagementAlgorithm() {
        return this.trustManagementAlgorithm;
    }

    private static String checkAbsolutePath(String path) throws DescriptorException {
        if (path == null) {
            return null;
        }
        String absolutePath = null;
        absolutePath = !FileUtil.isAbsolutePath(path) ? JeusProperties.JEUS_CONFIG_HOME + File.separator + VirtualDNS.LOCAL_VIRTUALNAME + File.separator + path : path;
        if (!new File(absolutePath).exists()) {
            throw new DescriptorException("File Not Found: " + absolutePath);
        }
        return absolutePath;
    }

    public void printDescriptor(PrintWriter out) {
        out.println("<<< connection [" + this.listenerId + "] >>>");
        out.println("  - type                  : " + this.listenerType);
        out.println("  - address               : " + this.webServerAddress);
        if (this.ip != null) {
            out.println("  - ip                  : " + this.ip);
        }
        out.println("  - port                  : " + this.port);
        out.println("  - scheme                : " + this.scheme);
        if (!this.listenerType.equals("WebtobListener")) {
            out.println("  - backlog               : " + this.backlog);
        }
        out.println("  - output buffer size    : " + this.outputBufferSize);
        if (!this.listenerType.equals("WebtobListener") && !this.listenerType.equals("TCPListener")) {
            out.println("  - busy notify page      : " + this.busyNotifyPage);
        }
        if (this.listenerType.equals("WebtobListener")) {
            out.println("  - hth count                : " + this.connectionPortNum);
            out.println("  - registration id          : " + this.registerId);
            out.println("  - disable pipe             : " + this.disablePipe);
            out.println("  - webtob request prefetch  : " + this.requestPrefetch);
            out.println("  - webtob read timeout      : " + this.readTimeout);
            out.println("  - webtob reconnect timeout : " + this.reconnectTimeout);
            out.println("  - enable admin channel     : " + this.adminChannel);
            if (this.webtobIpcbaseport > 0) {
                out.println("  - webtob ipc base port     : " + this.webtobIpcbaseport);
            }
        }
        out.println("  - server access ctrl    : " + this.accessControl);
        if (this.accessControl) {
            out.println("  ++ allowd server address ++");
            int size = this.allowedServers.size();
            for (int i = 0; i < size; ++i) {
                out.println("  - [" + i + "] " + this.allowedServers.elementAt(i));
            }
        }
        if (this.listenerType.equals("TCPListener")) {
            out.println("  - dispatcher cfg class   : " + this.dispatcherConfigClass);
        }
        out.println("  - postdata read timeout : " + this.postdataReadTimeout);
        this.tpoolDesc.printDescriptor(out);
        if (this.backupServerDescs != null) {
            int cnt = 1;
            Enumeration enum1 = this.backupServerDescs.elements();
            while (enum1.hasMoreElements()) {
                out.println("  ++ backup web server(" + cnt + ") ++");
                ConnectionDescriptor desc = (ConnectionDescriptor)enum1.nextElement();
                desc.printDescriptor2(out);
                ++cnt;
            }
        }
    }

    public void printDescriptor2(PrintWriter out) {
        out.println("    - address                  : " + this.webServerAddress);
        out.println("    - port                     : " + this.port);
        out.println("    - scheme                   : " + this.scheme);
        out.println("    - output buffer size       : " + this.outputBufferSize);
        out.println("    - hth count                : " + this.connectionPortNum);
        out.println("    - registration id          : " + this.registerId);
        out.println("    - disable pipe             : " + this.disablePipe);
        out.println("    - webtob request queueing  : " + this.requestPrefetch);
        out.println("    - webtob read timeout      : " + this.readTimeout);
        out.println("    - webtob reconnect timeout : " + this.reconnectTimeout);
        out.println("    - postdata read timeout    : " + this.postdataReadTimeout);
        out.println("    - enable admin channel     : " + this.adminChannel);
        if (this.webtobIpcbaseport > 0) {
            out.println("    - webtob ipc base port     : " + this.webtobIpcbaseport);
        }
        if (this.tpoolDesc != null) {
            this.tpoolDesc.printDescriptor2(out);
        }
    }

    public String getServerGroupName() {
        return this.serverGroupName;
    }

    public void setServerGroupName(String serverGroupName) {
        this.serverGroupName = serverGroupName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getTmaxBackupAddress() {
        return this.tmaxBackupAddress;
    }

    public void setTmaxBackupAddress(String tmaxBackupAddress) {
        this.tmaxBackupAddress = tmaxBackupAddress;
    }

    public String getTmaxBackupPort() {
        return this.tmaxBackupPort;
    }

    public void setBackupServerGroupName(String backupServerGroupName) {
        this.backupServerGroupName = backupServerGroupName;
    }

    public String getBackupServerGroupName() {
        return this.backupServerGroupName;
    }

    public void setTmaxBackupPort(String tmaxBackupPort) {
        this.tmaxBackupPort = tmaxBackupPort;
    }

    public void setTmaxVersion(String tmaxVersion) {
        if (tmaxVersion != null) {
            this.tmaxVersion = tmaxVersion;
        }
    }

    public String getTmaxVersion() {
        return this.tmaxVersion;
    }

    public String getXAResourceClass() {
        return this.XAResourceClass;
    }

    public void setXAResourceClass(String s) {
        this.XAResourceClass = s;
    }

    public void setUseNIO(boolean useNio) {
        this.useNio = useNio;
    }

    public boolean isUseNio() {
        return this.useNio;
    }

    public void setSelectorCount(String selectorCount) {
        this.selectorCount = selectorCount;
    }

    public String getSelectorCount() {
        return this.selectorCount;
    }

    public void setForcedRequestUrlEncoding(String charset) {
        this.forcedRequestUrlEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public void setForcedRequestEncoding(String charset) {
        this.forcedRequestEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public void setForcedResponseEncoding(String charset) {
        this.forcedResponseEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public void setDefaultRequestUrlEncoding(String charset) {
        this.defaultRequestUrlEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public void setDefaultRequestEncoding(String charset) {
        this.defaultRequestEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public void setDefaultResponseEncoding(String charset) {
        this.defaultResponseEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public String getForcedRequestUrlEncoding() {
        return this.forcedRequestUrlEncoding;
    }

    public String getForcedRequestEncoding() {
        return this.forcedRequestEncoding;
    }

    public String getForcedResponseEncoding() {
        return this.forcedResponseEncoding;
    }

    public String getDefaultRequestUrlEncoding() {
        return this.defaultRequestUrlEncoding;
    }

    public String getDefaultRequestEncoding() {
        return this.defaultRequestEncoding;
    }

    public String getDefaultResponseEncoding() {
        return this.defaultResponseEncoding;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public String getConnectionType() {
        return this.connectionType;
    }
}

