/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.deployment.descriptor.FileCachingDescriptor;
import jeus.servlet.deployment.descriptor.RoleMappingDescriptor;
import jeus.servlet.deployment.descriptor.WebAppDescriptor;
import jeus.servlet.util.FileUtil;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.xml.binding.jeusDD.AppEncodingType;
import jeus.xml.binding.jeusDD.AutoReloadType;
import jeus.xml.binding.jeusDD.EnvType;
import jeus.xml.binding.jeusDD.JeusWebservicesClientDdType;
import jeus.xml.binding.jeusDD.JndiRefType;
import jeus.xml.binding.jeusDD.PropertiesType;
import jeus.xml.binding.jeusDD.UserLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextDescriptor
implements Serializable {
    private String contextName = null;
    private String contextPath = null;
    private String docBase = null;
    private boolean autoReload = false;
    private boolean checkOnDemand = false;
    private boolean enableJsp = true;
    private Vector addedClassPath = null;
    private Vector<String> libraries = null;
    private int maxInstancePoolSize = -1;
    private Vector allowIndexing = null;
    private Hashtable denyDownload = null;
    private Hashtable aliasing = null;
    private FileCachingDescriptor fileCaching = null;
    private RoleMappingDescriptor roleMapping = null;
    private Hashtable ejbRefs;
    private Hashtable resRefs;
    private Hashtable resEnvRefs;
    private Hashtable msgDestRefs;
    private List<EnvType> envType;
    private JndiRefType ejbRefType;
    private JndiRefType resRefType;
    private JndiRefType resEnvRefType;
    private JndiRefType messageDestRefType;
    private JeusWebservicesClientDdType serviceRefType;
    private WebAppDescriptor webAppDesc = null;
    private String webServiceURL = null;
    private Hashtable jspConfig;
    private Hashtable batchJspConfig;
    private boolean earDeploy = false;
    private boolean warDeploy = false;
    private boolean webinfFirst = false;
    private Boolean isFastDeploy = null;
    private Boolean isKeepGenerated = null;
    private String contextGroup;
    private String forcedRequestEncoding;
    private String defaultRequestEncoding;
    private String forcedResponseEncoding;
    private String defaultResponseEncoding;
    private UserLogType logging;
    private boolean webddCreated = false;
    private PropertiesType properties;
    private AutoReloadType autoReloadType;
    private boolean isAttachStacktrace;
    private String contextVersion;
    private String contextVersionTimeout;

    public void setContextVersion(String contextVersion) {
        this.contextVersion = contextVersion;
    }

    public String getContextVersion() {
        return this.contextVersion;
    }

    public void setContextVersionTimeout(String contextVersionTimeout) {
        this.contextVersionTimeout = contextVersionTimeout;
    }

    public String getContextVersionTimeout() {
        return this.contextVersionTimeout;
    }

    public AutoReloadType getAutoReloadType() {
        return this.autoReloadType;
    }

    public String getAutoReload() {
        if (this.autoReloadType != null) {
            return String.valueOf(this.autoReloadType.isEnableReload());
        }
        return String.valueOf(false);
    }

    public void setAutoReloadType(AutoReloadType autoReloadType) {
        this.autoReloadType = autoReloadType;
    }

    public String toString() {
        return this.contextName;
    }

    public void setContextName(String name) throws DescriptorException {
        if (name != null) {
            this.contextName = name.trim();
            if (this.contextName.length() == 0) {
                throw new DescriptorException(JeusMessage_WebContainer0._1256);
            }
        }
    }

    public void setContextGroup(String _contextGroupName) {
        this.contextGroup = _contextGroupName;
    }

    public String getContextGroup() {
        return this.contextGroup;
    }

    public void setContextPath(String path) throws DescriptorException {
        if (path != null) {
            if (!path.startsWith("/")) {
                throw new DescriptorException(JeusMessage_WebContainer0._1300, path);
            }
            this.contextPath = path.trim();
        }
    }

    public void setContextPathByContextRoot(String contextRoot, String contextName) throws DescriptorException {
        if (contextRoot == null && contextName == null) {
            throw new DescriptorException(JeusMessage_WebContainer0._1301);
        }
        String tempPath = contextRoot == null ? contextName : contextRoot;
        if (!tempPath.startsWith("/")) {
            tempPath = "/" + tempPath;
        }
        tempPath = tempPath.trim();
        this.setContextPath(tempPath);
    }

    public void setDocBase(String base) throws DescriptorException {
        if (base == null || base.equals("") || !FileUtil.isAbsolutePath(base)) {
            throw new DescriptorException("Docbase must be set with a absolute path:" + base);
        }
        this.docBase = base.trim();
        if (File.separatorChar == '\\' && this.docBase.indexOf("/") >= 0) {
            this.docBase = this.docBase.replace('/', File.separatorChar);
        }
    }

    public void setAutoReload(String reloading) {
        this.autoReload = Boolean.valueOf(reloading);
        if (this.autoReloadType != null) {
            this.autoReloadType.setEnableReload(Boolean.valueOf(this.autoReload));
        }
    }

    public void setCheckOnDemand(String ondemand) {
        this.checkOnDemand = Boolean.valueOf(ondemand);
    }

    public void setEnableJSP(String enable) {
        this.enableJsp = enable == null || !enable.equals("false");
    }

    public void addAddedClassPath(String classPath) {
        if (classPath != null) {
            if (this.addedClassPath == null) {
                this.addedClassPath = new Vector();
            }
            this.addedClassPath.addElement(classPath);
        }
    }

    public void addLibrary(String library) {
        if (library != null) {
            if (this.libraries == null) {
                this.libraries = new Vector();
            }
            this.libraries.addElement(library);
        }
    }

    public void setMaxInstancePoolSize(String size) {
        if (size != null) {
            try {
                this.maxInstancePoolSize = Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void addAllowIndexing(String dir) {
        if (dir != null) {
            if (this.allowIndexing == null) {
                this.allowIndexing = new Vector();
            }
            dir = this.correctDirFormat(dir);
            this.allowIndexing.addElement(dir);
        }
    }

    public void addDenyDownload(String key, String value) {
        if (value != null) {
            Vector<String> v;
            if (this.denyDownload == null) {
                this.denyDownload = new Hashtable();
            }
            if ((v = (Vector<String>)this.denyDownload.get(key)) == null) {
                v = new Vector<String>();
                this.denyDownload.put(key, v);
            }
            if (key.equals("extension") && value.startsWith(".")) {
                value = value.substring(1);
            } else if (key.equals("directory")) {
                value = this.correctDirFormat(value);
            }
            v.addElement(value);
        }
    }

    public void addAliasing(String name, String path) throws DescriptorException {
        if (name != null && path != null) {
            name = this.correctDirFormat(name);
            File realpath = new File(path);
            if (!realpath.isAbsolute()) {
                throw new DescriptorException(JeusMessage_WebContainer0._1259, new String[]{name, path});
            }
            if (this.aliasing == null) {
                this.aliasing = new Hashtable();
            }
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            this.aliasing.put(name, path);
        }
    }

    public void setFileCaching(FileCachingDescriptor fc) {
        this.fileCaching = fc;
    }

    public void setRoleMapping(RoleMappingDescriptor rm) {
        this.roleMapping = rm;
    }

    public void setEJBRefs(Hashtable refs) {
        this.ejbRefs = refs;
    }

    public void setResourceRefs(Hashtable refs) {
        this.resRefs = refs;
    }

    public void setResourceEnvRefs(Hashtable refs) {
        this.resEnvRefs = refs;
    }

    public void setWebAppDescriptor(WebAppDescriptor desc) {
        this.webAppDesc = desc;
    }

    public void setMessageDestinationRefs(Hashtable refs) {
        this.msgDestRefs = refs;
    }

    public void setWebServiceURL(String url) {
        this.webServiceURL = url;
    }

    public void setJspConfig(Hashtable jspConf) {
        this.jspConfig = jspConf;
    }

    public void setBatchJspConfig(Hashtable batchJspConf) {
        this.batchJspConfig = batchJspConf;
    }

    public void setEarDeploy(boolean value) {
        this.earDeploy = value;
    }

    public void setWarDeploy(boolean value) {
        this.warDeploy = value;
    }

    public void setWebinfFitst(String value) {
        if (value != null) {
            this.webinfFirst = Boolean.valueOf(value);
        }
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getDocBase() {
        return this.docBase;
    }

    public boolean isAutoReload() {
        return this.autoReload;
    }

    public boolean isCheckOnDemand() {
        return this.checkOnDemand;
    }

    public boolean isJspEnable() {
        return this.enableJsp;
    }

    public Vector getAddedClassPath() {
        return this.addedClassPath;
    }

    public Vector<String> getLibraries() {
        return this.libraries;
    }

    public int getMaxInstancePoolSize() {
        return this.maxInstancePoolSize;
    }

    public Vector getAllowIndexing() {
        return this.allowIndexing;
    }

    public Hashtable getDenyDownload() {
        return this.denyDownload;
    }

    public Hashtable getAliasing() {
        return this.aliasing;
    }

    public FileCachingDescriptor getFileCaching() {
        return this.fileCaching;
    }

    public RoleMappingDescriptor getRoleMapping() {
        return this.roleMapping;
    }

    public Hashtable getEJBRefs() {
        return this.ejbRefs;
    }

    public Hashtable getResourceRefs() {
        return this.resRefs;
    }

    public Hashtable getResourceEnvRefs() {
        return this.resEnvRefs;
    }

    public Hashtable getMessageDestinationRefs() {
        return this.msgDestRefs;
    }

    private String correctDirFormat(String dir) {
        String fs = "/";
        if (!dir.startsWith(fs)) {
            dir = fs + dir;
        }
        if (!dir.endsWith(fs)) {
            dir = dir + fs;
        }
        return dir;
    }

    public WebAppDescriptor getWebAppDescriptor() {
        return this.webAppDesc;
    }

    public String getWebServiceURL() {
        return this.webServiceURL;
    }

    public Hashtable getJspConfig() {
        return this.jspConfig;
    }

    public Hashtable getBatchJspConfig() {
        return this.batchJspConfig;
    }

    public boolean isEarDeploy() {
        return this.earDeploy;
    }

    public boolean isWarDeploy() {
        return this.warDeploy;
    }

    public boolean isWebinfFirst() {
        return this.webinfFirst;
    }

    public void printDescriptor(PrintWriter out) {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<<< Context [" + this.contextName + "] Information >>>").append("\n");
        buffer.append("- context path    : " + this.contextPath).append("\n");
        buffer.append("- document base   : " + this.docBase).append("\n");
        buffer.append("- is ear deploy ? : " + this.earDeploy).append("\n");
        buffer.append("- auto reloading  : ").append("\n");
        buffer.append("    + enable      : " + this.autoReload).append("\n");
        buffer.append("    + on demand   : " + this.checkOnDemand).append("\n");
        if (this.addedClassPath != null) {
            buffer.append("  ++ added classpath ++");
            for (i = 0; i < this.addedClassPath.size(); ++i) {
                buffer.append("  - [" + i + "] " + this.addedClassPath.elementAt(i)).append("\n");
            }
        }
        if (this.allowIndexing != null) {
            buffer.append("  ++ allowed directories to be indexed ++");
            for (i = 0; i < this.allowIndexing.size(); ++i) {
                buffer.append("  - [" + i + "] " + this.allowIndexing.elementAt(i)).append("\n");
            }
        }
        if (this.denyDownload != null) {
            int i2;
            buffer.append("  ++ denied files and directories to be downloaded ++");
            Vector v = (Vector)this.denyDownload.get("file");
            if (v != null) {
                for (i2 = 0; i2 < v.size(); ++i2) {
                    buffer.append("  - [file] " + v.elementAt(i2)).append("\n");
                }
            }
            if ((v = (Vector)this.denyDownload.get("extension")) != null) {
                for (i2 = 0; i2 < v.size(); ++i2) {
                    buffer.append("  - [extension] " + v.elementAt(i2)).append("\n");
                }
            }
            if ((v = (Vector)this.denyDownload.get("directory")) != null) {
                for (i2 = 0; i2 < v.size(); ++i2) {
                    buffer.append("  - [directory] " + v.elementAt(i2)).append("\n");
                }
            }
        }
        if (this.aliasing != null) {
            buffer.append("  ++ aliasing ++").append("\n");
            Enumeration enum1 = this.aliasing.keys();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                String path = (String)this.aliasing.get(name);
                buffer.append("  - " + name + " => " + path).append("\n");
            }
        }
        if (this.fileCaching != null) {
            this.fileCaching.printDescriptor(out);
        }
        if (this.roleMapping != null) {
            this.roleMapping.printDescriptor(out);
        }
        if (this.jspConfig != null) {
            buffer.append("- jsp configuration          :").append("\n");
            Enumeration enum1 = this.jspConfig.keys();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                String value = (String)this.jspConfig.get(name);
                buffer.append("    + " + name + " : " + value).append("\n");
            }
        }
        String msg = buffer.toString();
        out.print(msg);
    }

    public String getUserPrincipalForRunAs(String servletName) {
        return null;
    }

    public UserLogType getLogging() {
        return this.logging;
    }

    public void setLogging(UserLogType logging) {
        this.logging = logging;
    }

    public Boolean isFastDeploy() {
        return this.isFastDeploy;
    }

    public void setFastDeploy(Boolean isFastDeploy) {
        this.isFastDeploy = isFastDeploy;
    }

    public Boolean isKeepGenerated() {
        return this.isKeepGenerated;
    }

    public void setKeepGenerated(Boolean isKeepGenerated) {
        this.isKeepGenerated = isKeepGenerated;
    }

    public PropertiesType getProperties() {
        return this.properties;
    }

    public void setProperties(PropertiesType properties) {
        this.properties = properties;
    }

    public List<EnvType> getEnvType() {
        return this.envType;
    }

    public void setEnvType(List<EnvType> envType) {
        this.envType = envType;
    }

    public JndiRefType getEjbRefType() {
        return this.ejbRefType;
    }

    public void setEjbRefType(JndiRefType ejbRefType) {
        this.ejbRefType = ejbRefType;
    }

    public JndiRefType getResRefType() {
        return this.resRefType;
    }

    public void setResRefType(JndiRefType resRefType) {
        this.resRefType = resRefType;
    }

    public JndiRefType getResEnvRefType() {
        return this.resEnvRefType;
    }

    public void setResEnvRefType(JndiRefType resEnvRefType) {
        this.resEnvRefType = resEnvRefType;
    }

    public JndiRefType getMessageDestRefType() {
        return this.messageDestRefType;
    }

    public void setMessageDestRefType(JndiRefType messageDestRefType) {
        this.messageDestRefType = messageDestRefType;
    }

    public JeusWebservicesClientDdType getServiceRefType() {
        return this.serviceRefType;
    }

    public void setServiceRefType(JeusWebservicesClientDdType serviceRefType) {
        this.serviceRefType = serviceRefType;
    }

    public void setEncoding(AppEncodingType encoding) {
        if (encoding.getRequestEncoding() != null) {
            this.forcedRequestEncoding = encoding.getRequestEncoding().getForced();
            this.defaultRequestEncoding = encoding.getRequestEncoding().getDefault();
        }
        if (encoding.getResponseEncoding() != null) {
            this.forcedResponseEncoding = encoding.getResponseEncoding().getForced();
            this.defaultResponseEncoding = encoding.getResponseEncoding().getDefault();
        }
    }

    public void setAttachStacktrace(String attach) {
        this.isAttachStacktrace = attach == null || !attach.equals("false");
    }

    public boolean isAttachStacktrace() {
        return this.isAttachStacktrace;
    }

    public String getForcedRequestEncoding() {
        return this.forcedRequestEncoding;
    }

    public String getDefaultRequestEncoding() {
        return this.defaultRequestEncoding;
    }

    public String getForcedResponseEncoding() {
        return this.forcedResponseEncoding;
    }

    public String getDefaultResponseEncoding() {
        return this.defaultResponseEncoding;
    }

    public boolean isWebddCreated() {
        return this.webddCreated;
    }

    public void setWebddCreated(boolean webddCreated) {
        this.webddCreated = webddCreated;
    }
}

