/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.Serializable;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.deployment.descriptor.SessionCookieDescriptor;
import jeus.xml.binding.jeusDD.SessionConfigType;
import jeus.xml.binding.jeusDD.SessionCookieType;

public class SessionDescriptor
implements Serializable {
    public static final boolean DEFAULT_DISTRIBUTABLE = false;
    public static final boolean DEFAULT_SHARED = false;
    public static final int DEFAULT_TIMEOUT = 30;
    public static final boolean DEFAULT_RELOAD_PERSISTENT = false;
    public static final boolean DEFAULT_URL_REWRITING = false;
    private boolean distributable = false;
    private boolean shared = false;
    private int timeout = 30;
    private boolean reloadPersistent = false;
    private boolean urlRewriting = false;
    private SessionCookieDescriptor sessionCookie = new SessionCookieDescriptor();

    public boolean isDistributable() {
        return this.distributable;
    }

    public boolean isShared() {
        return this.shared;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isReloadPersistent() {
        return this.reloadPersistent;
    }

    public boolean isUrlRewriting() {
        return this.urlRewriting;
    }

    public SessionCookieDescriptor getSessionCookie() {
        return this.sessionCookie;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setReloadPersistent(boolean reloadPersistent) {
        this.reloadPersistent = reloadPersistent;
    }

    public void setUrlRewriting(boolean urlRewriting) {
        this.urlRewriting = urlRewriting;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(2048);
        buffer.append("- session descriptor -").append('\n');
        buffer.append("    - distributable     : ").append(this.distributable).append('\n');
        buffer.append("    - shared            : ").append(this.shared).append('\n');
        buffer.append("    - timeout           : ").append(this.timeout).append("(min)").append('\n');
        buffer.append("    - reload-persistent : ").append(this.reloadPersistent).append('\n');
        buffer.append("    - url-rewriting     : ").append(this.urlRewriting).append('\n');
        buffer.append(this.sessionCookie.toString());
        return buffer.toString();
    }

    public static String getSessionDescriptorTypeInformation(SessionConfigType sessionDescType) {
        String cookieInfo;
        if (sessionDescType == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(2048);
        buffer.append("- session descriptor -").append('\n');
        if (sessionDescType.isDistributable() != null) {
            buffer.append("    - distributable     : ").append(sessionDescType.isDistributable()).append('\n');
        }
        if (sessionDescType.isShared() != null) {
            buffer.append("    - shared            : ").append(sessionDescType.isShared()).append('\n');
        }
        if (sessionDescType.getTimeout() != null) {
            buffer.append("    - timeout           : ").append(sessionDescType.getTimeout()).append("(min)").append('\n');
        }
        if (sessionDescType.isReloadPersistent() != null) {
            buffer.append("    - reload-persistent : ").append(sessionDescType.isReloadPersistent()).append('\n');
        }
        if (sessionDescType.isUrlRewriting() != null) {
            buffer.append("    - url-rewriting     : ").append(sessionDescType.isUrlRewriting()).append('\n');
        }
        if ((cookieInfo = SessionCookieDescriptor.getSesssionCookieTypeInformation(sessionDescType.getSessionCookie())) != null) {
            buffer.append(cookieInfo);
        }
        return buffer.toString();
    }

    public static SessionDescriptor getSessionDescriptor(SessionConfigType ctxSessionDescType, SessionConfigType ctxGroupSessionDescType, SessionConfigType webContainerSessionDescType) {
        SessionDescriptor sessionDesc = new SessionDescriptor();
        try {
            SessionDescriptor.setSessionDescriptor(sessionDesc, webContainerSessionDescType);
        }
        catch (DescriptorException e) {
            e.printStackTrace();
        }
        try {
            SessionDescriptor.setSessionDescriptor(sessionDesc, ctxGroupSessionDescType);
        }
        catch (DescriptorException e) {
            e.printStackTrace();
        }
        try {
            SessionDescriptor.setSessionDescriptor(sessionDesc, ctxSessionDescType);
        }
        catch (DescriptorException e) {
            e.printStackTrace();
        }
        return sessionDesc;
    }

    private static SessionDescriptor setSessionDescriptor(SessionDescriptor sessionDesc, SessionConfigType sessionDescType) throws DescriptorException {
        SessionCookieType sessionCookieType;
        if (sessionDesc == null || sessionDescType == null) {
            return sessionDesc;
        }
        if (sessionDescType.isDistributable() != null) {
            sessionDesc.setDistributable(sessionDescType.isDistributable());
        }
        if (sessionDescType.isShared() != null) {
            sessionDesc.setShared(sessionDescType.isShared());
        }
        if (sessionDescType.getTimeout() != null) {
            sessionDesc.setTimeout(sessionDescType.getTimeout());
        }
        if (sessionDescType.isReloadPersistent() != null) {
            sessionDesc.setReloadPersistent(sessionDescType.isReloadPersistent());
        }
        if (sessionDescType.isUrlRewriting() != null) {
            sessionDesc.setUrlRewriting(sessionDescType.isUrlRewriting());
        }
        if ((sessionCookieType = sessionDescType.getSessionCookie()) != null) {
            SessionCookieDescriptor sessionCookieDesc = sessionDesc.getSessionCookie();
            if (sessionCookieType.getJsessionidName() != null) {
                sessionCookieDesc.setJsessionidName(sessionCookieType.getJsessionidName());
            }
            if (sessionCookieType.getVersion() != null) {
                sessionCookieDesc.setVersion(sessionCookieType.getVersion());
            }
            if (sessionCookieType.getDomain() != null) {
                sessionCookieDesc.setDomain(sessionCookieType.getDomain());
            }
            if (sessionCookieType.getPath() != null) {
                sessionCookieDesc.setPath(sessionCookieType.getPath());
            }
            if (sessionCookieType.getMaxAge() != null) {
                sessionCookieDesc.setMaxAge(sessionCookieType.getMaxAge());
            }
            if (sessionCookieType.isSecure() != null) {
                sessionCookieDesc.setSecure(sessionCookieType.isSecure());
            }
        }
        return sessionDesc;
    }
}

