/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.deployment.descriptor.ThreadStateNotifyDescriptor;
import jeus.sessionmanager.util.SessionManagerUtil;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.xml.binding.jeusDD.ThreadPoolType;

public class ThreadPoolDescriptor
implements Serializable {
    private int minThreadNum;
    private int maxThreadNum;
    private int changingRate = 1;
    private long maxIdleTime = 300000L;
    private int maxWaitQueue = 4;
    private int maxQueue = -1;
    private ThreadStateNotifyDescriptor tsnDesc;
    private ThreadPoolType threadPoolType;

    public ThreadPoolType getThreadPoolType() {
        return this.threadPoolType;
    }

    public void setThreadPoolType(ThreadPoolType threadPoolType) {
        this.threadPoolType = threadPoolType;
    }

    public void setMinThreadNum(String num) throws DescriptorException {
        if (num != null) {
            try {
                this.minThreadNum = Integer.parseInt(num);
            }
            catch (NumberFormatException nfe) {
                throw new DescriptorException(JeusMessage_WebContainer0._1286, num);
            }
            if (this.minThreadNum < 0) {
                this.minThreadNum = 1;
            }
            if (this.threadPoolType != null) {
                this.threadPoolType.setMin(Long.valueOf(this.minThreadNum));
            }
        } else {
            throw new DescriptorException(JeusMessage_WebContainer0._1287);
        }
    }

    public void setMaxThreadNum(String num) {
        if (num != null) {
            try {
                this.maxThreadNum = Integer.parseInt(num);
            }
            catch (NumberFormatException nfe) {
                this.maxThreadNum = this.minThreadNum;
            }
            if (this.maxThreadNum < 0 || this.maxThreadNum < this.minThreadNum) {
                this.maxThreadNum = this.minThreadNum;
            }
        } else {
            this.maxThreadNum = this.minThreadNum;
        }
        if (this.threadPoolType != null) {
            this.threadPoolType.setMax(Long.valueOf(this.maxThreadNum));
        }
    }

    public void setChangingRate(String num) {
        if (num != null) {
            try {
                this.changingRate = Integer.parseInt(num);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.changingRate < 0) {
                this.changingRate = 1;
            }
            if (this.threadPoolType != null) {
                this.threadPoolType.setStep(Long.valueOf(this.changingRate));
            }
        }
    }

    public void setMaxIdleTime(String time) {
        if (time != null) {
            try {
                this.maxIdleTime = Long.parseLong(time);
                if (this.maxIdleTime > 0L && this.maxIdleTime < 1000L) {
                    this.maxIdleTime = 1000L;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.threadPoolType != null) {
                this.threadPoolType.setMaxIdleTime(Integer.valueOf(SessionManagerUtil.safeCasting(this.maxIdleTime)));
            }
        }
    }

    public void setMaxWaitQueue(String queue) {
        if (queue != null) {
            try {
                this.maxWaitQueue = Integer.parseInt(queue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.maxWaitQueue < 0) {
                this.maxWaitQueue = 4;
            }
            if (this.threadPoolType != null) {
                this.threadPoolType.setMaxWaitQueue(Integer.valueOf(this.maxWaitQueue));
            }
        }
    }

    public void setMaxQueue(String queue) {
        if (queue != null) {
            try {
                this.maxQueue = Integer.parseInt(queue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.threadPoolType != null) {
                this.threadPoolType.setMaxQueue(Integer.valueOf(this.maxQueue));
            }
        }
    }

    public void setThreadStateNotifyDescriptor(ThreadStateNotifyDescriptor desc) {
        this.tsnDesc = desc;
    }

    public int getMinThreadNum() {
        return this.minThreadNum;
    }

    public int getMaxThreadNum() {
        return this.maxThreadNum;
    }

    public int getChangingRate() {
        return this.changingRate;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getMaxWaitQueue() {
        return this.maxWaitQueue;
    }

    public int getMaxQueue() {
        return this.maxQueue;
    }

    public ThreadStateNotifyDescriptor getThreadStateNotifyDescriptor() {
        return this.tsnDesc;
    }

    public void printDescriptor(PrintWriter out) {
        out.println("  ++ Thread Pool ++");
        out.println("    - minimum threads (tmin)    : " + this.minThreadNum);
        out.println("    - maximum threads (tmax)    : " + this.maxThreadNum);
        out.println("    - changing rate (trate)     : " + this.changingRate);
        out.println("    - maximum idle time (tidle) : " + this.maxIdleTime);
        out.println("    - maximum wait queue (tmwq) : " + this.maxWaitQueue);
        out.println("    - maximum  queue (tmq)      : " + this.maxQueue);
        if (this.tsnDesc != null) {
            this.tsnDesc.printDescriptor(out);
        }
    }

    public void printDescriptor2(PrintWriter out) {
        out.println("    ++ Thread Pool ++");
        out.println("      - minimum threads (tmin)    : " + this.minThreadNum);
        out.println("      - maximum threads (tmax)    : " + this.maxThreadNum);
        out.println("      - changing rate (trate)     : " + this.changingRate);
        out.println("      - maximum idle time (tidle) : " + this.maxIdleTime);
        out.println("      - maximum wait queue (tmwq) : " + this.maxWaitQueue);
        out.println("      - maximum  queue (tmq)      : " + this.maxQueue);
        if (this.tsnDesc != null) {
            this.tsnDesc.printDescriptor2(out);
        }
    }
}

