/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jeus.descriptor.tool.Descriptor;
import jeus.descriptor.tool.EJBReference;
import jeus.descriptor.tool.EnvironEntry;
import jeus.descriptor.tool.LoginConfig;
import jeus.descriptor.tool.MessageDestinationReference;
import jeus.descriptor.tool.ResourceEnvironReference;
import jeus.descriptor.tool.ResourceReference;
import jeus.descriptor.tool.SecurityConstraint;
import jeus.descriptor.tool.SecurityRole;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ContextParamDescriptor;
import jeus.servlet.deployment.descriptor.ListenerDescriptor;
import jeus.servlet.deployment.descriptor.ServletDescriptor;
import jeus.servlet.deployment.descriptor.WebCommonDescriptor;
import jeus.servlet.filter.FilterDef;
import jeus.servlet.filter.FilterMap;
import jeus.servlet.filter.util.URLPattern;
import jeus.xml.binding.j2ee.DispatcherType;
import jeus.xml.binding.j2ee.EjbLocalRefType;
import jeus.xml.binding.j2ee.EjbRefType;
import jeus.xml.binding.j2ee.EnvEntryType;
import jeus.xml.binding.j2ee.LifecycleCallbackType;
import jeus.xml.binding.j2ee.MessageDestinationRefType;
import jeus.xml.binding.j2ee.PersistenceContextRefType;
import jeus.xml.binding.j2ee.PersistenceUnitRefType;
import jeus.xml.binding.j2ee.ResourceEnvRefType;
import jeus.xml.binding.j2ee.ResourceRefType;
import jeus.xml.binding.j2ee.ServiceRefType;
import jeus.xml.binding.j2ee.WebAppType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppDescriptor
extends Descriptor
implements Serializable {
    private String servletContextName = null;
    private Vector contextParams = null;
    private Hashtable servlets = null;
    private Hashtable servletMappings = null;
    private HashMap filterDefs = null;
    private ArrayList filterMaps = null;
    private ArrayList listeners = null;
    private WebCommonDescriptor webCommonDesc = new WebCommonDescriptor();
    private transient boolean isWebApp_2_3 = false;
    private transient boolean isWebApp_2_4 = false;
    private transient boolean isWebApp_2_5 = true;
    private boolean metadataComplete;
    private WebAppType webApp;
    private boolean isSystemApp = false;
    private Vector allDispatchFilter = new Vector();

    public WebAppDescriptor() {
    }

    protected WebAppDescriptor(WebAppDescriptor desc) {
        this.servletContextName = desc.servletContextName;
        this.contextParams = desc.contextParams;
        this.servlets = desc.servlets;
        this.servletMappings = desc.servletMappings;
        this.filterDefs = desc.filterDefs;
        this.filterMaps = desc.filterMaps;
        this.listeners = desc.listeners;
        this.webCommonDesc = desc.webCommonDesc;
        this.isWebApp_2_3 = desc.isWebApp_2_3;
    }

    public void setServletContextName(String name) {
        this.servletContextName = name;
    }

    public void setContextParams(ContextParamDescriptor[] paramContextParams) {
        if (this.contextParams == null) {
            this.contextParams = new Vector();
        }
        for (int i = 0; i < paramContextParams.length; ++i) {
            this.contextParams.addElement(paramContextParams[i]);
        }
    }

    public void addContextParam(String name, String value, String desc) {
        if (name != null && value != null) {
            if (this.contextParams == null) {
                this.contextParams = new Vector();
            }
            ContextParamDescriptor contextParam = new ContextParamDescriptor(name, value, desc);
            this.contextParams.addElement(contextParam);
        }
    }

    public void setServletDescriptor(ServletDescriptor paramServlet) {
        if (this.servlets == null) {
            this.servlets = new Hashtable();
        }
        this.servlets.put(paramServlet.getServletName(), paramServlet);
    }

    public void setServletDescriptors(ServletDescriptor[] paramServlets) {
        if (this.servlets == null) {
            this.servlets = new Hashtable();
        }
        for (int i = 0; i < paramServlets.length; ++i) {
            String servletName = paramServlets[i].getServletName();
            this.servlets.put(servletName, paramServlets[i]);
        }
    }

    public void setServletDescriptors(Hashtable paramServlets) {
        this.servlets = paramServlets;
    }

    public void addFilterDefs(FilterDef[] filterDefs) {
        if (this.filterDefs == null) {
            this.filterDefs = new HashMap();
        }
        for (int i = 0; i < filterDefs.length; ++i) {
            String filterName = filterDefs[i].getFilterName();
            this.filterDefs.put(filterName, filterDefs[i]);
        }
    }

    public void addFilterDef(String name, FilterDef filterDef) {
        if (this.filterDefs == null) {
            this.filterDefs = new HashMap();
        }
        this.filterDefs.put(name, filterDef);
    }

    public void removeFilterDef(String name) {
        if (this.filterDefs == null || this.filterDefs.isEmpty()) {
            return;
        }
        this.filterDefs.remove(name);
    }

    public void clearFilterDefs() {
        if (this.filterDefs == null) {
            return;
        }
        this.filterDefs.clear();
        this.filterDefs = null;
    }

    public HashMap getFilterDefs() {
        return this.filterDefs;
    }

    public void addFilterMapping(String filterName, String mappingName, boolean isUrl, List dispatchers) {
        if (filterName == null || mappingName == null) {
            return;
        }
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName(filterName);
        if (isUrl) {
            if (this.isWebApp_2_3 && !mappingName.startsWith("/") && !mappingName.startsWith("*.")) {
                mappingName = "/" + mappingName;
            }
            if (!URLPattern.isValid(mappingName)) {
                throw new IllegalArgumentException("Invalid URL Pattern: [" + mappingName + "]");
            }
            filterMap.setURLPattern(mappingName);
        } else {
            filterMap.setServletName(mappingName);
        }
        if (dispatchers != null) {
            for (DispatcherType dispatchType : dispatchers) {
                filterMap.setDispatcher(dispatchType.getValue());
            }
        }
        if (this.filterMaps == null) {
            this.filterMaps = new ArrayList();
        }
        this.filterMaps.add(filterMap);
    }

    public ArrayList getFilterMappings() {
        return this.filterMaps;
    }

    public void clearFilterMapings() {
        if (this.filterMaps == null) {
            return;
        }
        this.filterMaps.clear();
        this.filterMaps = null;
    }

    public void destroy() {
        this.clearFilterDefs();
        this.clearFilterMapings();
        if (this.contextParams != null) {
            this.contextParams.clear();
            this.contextParams = null;
        }
        if (this.servlets != null) {
            this.servlets.clear();
            this.servlets = null;
        }
        if (this.servletMappings != null) {
            this.servletMappings.clear();
            this.servletMappings = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public void addServletDescriptor(String servletName, ServletDescriptor desc) {
        if (this.servlets == null) {
            this.servlets = new Hashtable();
        }
        this.servlets.put(servletName, desc);
    }

    public void addServletMapping(String servletName, String urlPattern) {
        Vector<String> urlPatterns;
        if (this.servletMappings == null) {
            this.servletMappings = new Hashtable();
        }
        if (!(urlPattern = urlPattern.trim()).startsWith("*.") && !urlPattern.startsWith("/")) {
            urlPattern = "/" + urlPattern;
        }
        if ((urlPatterns = (Vector<String>)this.servletMappings.get(servletName)) == null) {
            urlPatterns = new Vector<String>();
            this.servletMappings.put(servletName, urlPatterns);
        }
        urlPatterns.addElement(urlPattern);
    }

    public void addListenerDescriptor(ListenerDescriptor desc) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(desc);
    }

    public void setWebCommonDescriptor(WebCommonDescriptor desc) {
        this.webCommonDesc = desc;
    }

    public void setSessionTimeout(String timeout) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.setSessionTimeout(timeout);
        }
    }

    public void setMimeMappings(String extension, String mimeType) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.setMimeMappings(extension, mimeType);
        }
    }

    public void setWelcomeFileList(String[] paramFileList) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.setWelcomeFileList(paramFileList);
        }
    }

    public void addWelcomeFileList(String welcomeFile) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.addWelcomeFileList(welcomeFile);
        }
    }

    public void addErrorPage(String key, String errorPage) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.addErrorPage(key, errorPage);
        }
    }

    public void addTaglib(String uri, String location) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.addTaglib(uri, location);
        }
    }

    public void setSecurityConstraints(SecurityConstraint[] paramConstraints) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.setSecurityConstraints(paramConstraints);
        }
    }

    public void setLoginConfig(LoginConfig paramLoginConfig) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.setLoginConfig(paramLoginConfig);
        }
    }

    public void setSecurityRoles(SecurityRole[] paramSecurityRoles) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.setSecurityRoles(paramSecurityRoles);
        }
    }

    public void setEnvironEntries(EnvironEntry[] paramEnvironEntries) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.setEnvironEntries(paramEnvironEntries);
        }
    }

    public void setEJBRefs(EJBReference[] paramEJBRefs) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.setEJBRefs(paramEJBRefs);
        }
    }

    public void setEJBLocalRefs(EJBReference[] paramEJBRefs) {
        if (this.webCommonDesc != null) {
            this.webCommonDesc.setEJBLocalRefs(paramEJBRefs);
        }
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public Vector getContextParams() {
        return this.contextParams;
    }

    public Hashtable getServletDescriptors() {
        return this.servlets;
    }

    public ServletDescriptor getServletDescriptor(String servletName) {
        if (this.servlets != null) {
            return (ServletDescriptor)this.servlets.get(servletName);
        }
        return null;
    }

    public Hashtable getServletMappings() {
        return this.servletMappings;
    }

    public ArrayList getListenerDescriptors() {
        return this.listeners;
    }

    public WebCommonDescriptor getWebCommonDescriptor() {
        return this.webCommonDesc;
    }

    public int getSessionTimeout() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getSessionTimeout();
        }
        return -1;
    }

    public Hashtable getMimeMappings() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getMimeMappings();
        }
        return null;
    }

    public String getMimeMapping(String extension) {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getMimeMapping(extension);
        }
        return null;
    }

    public Vector getWelcomeFileList() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getWelcomeFileList();
        }
        return null;
    }

    public Hashtable getErrorPages() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getErrorPages();
        }
        return null;
    }

    public String getErrorPage(String key) {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getErrorPage(key);
        }
        return null;
    }

    public Hashtable getTagLibs() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getTagLibs();
        }
        return null;
    }

    public String getTagLib(String uri) {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getTagLib(uri);
        }
        return null;
    }

    public ResourceReference[] getResourceRefs() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getResourceRefs();
        }
        return null;
    }

    public ResourceEnvironReference[] getResourceEnvRefs() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getResourceEnvRefs();
        }
        return null;
    }

    public MessageDestinationReference[] getMessageDestRefs() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getMessageDestRefs();
        }
        return null;
    }

    public SecurityConstraint[] getSecurityConstraints() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getSecurityConstraints();
        }
        return null;
    }

    public LoginConfig getLoginConfig() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getLoginConfig();
        }
        return null;
    }

    public SecurityRole[] getSecurityRoles() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getSecurityRoles();
        }
        return null;
    }

    public EnvironEntry[] getEnvironEntries() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getEnvironEntries();
        }
        return null;
    }

    public EJBReference[] getEJBRefs() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getEJBRefs();
        }
        return null;
    }

    public EJBReference[] getEJBLocalRefs() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getEJBLocalRefs();
        }
        return null;
    }

    public void printDescriptor(PrintWriter out) {
        Enumeration<Object> enum1;
        out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        out.println("+                                                     +");
        out.println("+            Web Application Information              +");
        out.println("+                                                     +");
        out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        out.println();
        if (this.contextParams != null) {
            out.println("++ context parameters ++");
            enum1 = this.contextParams.elements();
            while (enum1.hasMoreElements()) {
                ContextParamDescriptor contextParam = (ContextParamDescriptor)enum1.nextElement();
                contextParam.printDescriptor(out);
            }
        }
        if (this.servlets != null) {
            out.println("++ servlets ++");
            enum1 = this.servlets.elements();
            while (enum1.hasMoreElements()) {
                ServletDescriptor servletDesc = (ServletDescriptor)enum1.nextElement();
                servletDesc.printDescriptor(out);
            }
        }
        if (this.webCommonDesc != null) {
            this.webCommonDesc.printDescriptor(out);
        }
    }

    public boolean isWebApp_2_3() {
        return this.isWebApp_2_3;
    }

    public void setWebApp_2_3(boolean isWebApp_2_3) {
        this.isWebApp_2_3 = isWebApp_2_3;
        this.isWebApp_2_5 = false;
    }

    public boolean isWebApp_2_4() {
        return this.isWebApp_2_4;
    }

    public void setWebApp_2_4(boolean isWebApp_2_4) {
        this.isWebApp_2_4 = isWebApp_2_4;
        this.isWebApp_2_5 = false;
    }

    public boolean isWebApp_2_5() {
        return this.isWebApp_2_5;
    }

    public void setWebApp_2_5(boolean isWebApp_2_5) {
        this.isWebApp_2_5 = isWebApp_2_5;
    }

    public void merge(WebAppDescriptor other) {
        Hashtable table = other.getServletDescriptors();
        if (table != null) {
            for (ServletDescriptor desc : table.values()) {
                if (this.getServletDescriptor(desc.getServletName()) != null) continue;
                this.setServletDescriptor(desc);
            }
        }
        if ((table = other.getServletMappings()) != null) {
            Enumeration enum1 = table.keys();
            while (enum1.hasMoreElements()) {
                String servletName = (String)enum1.nextElement();
                if (this.servletMappings.get(servletName) != null) continue;
                Vector mapping = (Vector)table.get(servletName);
                this.servletMappings.put(servletName, mapping);
            }
        }
    }

    public WebAppType getWebApp() {
        return this.webApp;
    }

    public void setWebApp(WebAppType jaxbElem) throws StartingException {
        this.webApp = jaxbElem;
    }

    public List<EjbLocalRefType> getEjbLocalRefTypes() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getEjbLocalRefTypes();
        }
        return null;
    }

    public List<EjbRefType> getEjbRefTypes() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getEjbRefTypes();
        }
        return null;
    }

    public List<EnvEntryType> getEnvEntryTypes() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getEnvEntryTypes();
        }
        return null;
    }

    public List<MessageDestinationRefType> getMessageDestinationRefTypes() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getMessageDestinationRefTypes();
        }
        return null;
    }

    public List<ResourceEnvRefType> getResourceEnvRefTypes() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getResourceEnvRefTypes();
        }
        return null;
    }

    public List<ResourceRefType> getResourceRefTypes() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getResourceRefTypes();
        }
        return null;
    }

    public List<ServiceRefType> getServiceRefTypes() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getServiceRefTypes();
        }
        return null;
    }

    public List<PersistenceContextRefType> getPersistenceContextRefTypes() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getPersistenceContextRefTypes();
        }
        return null;
    }

    public List<PersistenceUnitRefType> getPersistenceUnitRefTypes() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getPersistenceUnitRefTypes();
        }
        return null;
    }

    public List<LifecycleCallbackType> getPostConstructTypes() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getPostConstructTypes();
        }
        return null;
    }

    public List<LifecycleCallbackType> getPreDestoryTypes() {
        if (this.webCommonDesc != null) {
            return this.webCommonDesc.getPreDestroyTypes();
        }
        return null;
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(boolean metadataComplete) {
        this.metadataComplete = metadataComplete;
    }

    public boolean isSystemApp() {
        return this.isSystemApp;
    }

    public void setSystemApp(boolean isSystemApp) {
        this.isSystemApp = isSystemApp;
    }
}

