/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jeus.descriptor.tool.EJBReference;
import jeus.descriptor.tool.EnvironEntry;
import jeus.descriptor.tool.LoginConfig;
import jeus.descriptor.tool.MessageDestinationReference;
import jeus.descriptor.tool.ResourceEnvironReference;
import jeus.descriptor.tool.ResourceReference;
import jeus.descriptor.tool.SecurityConstraint;
import jeus.descriptor.tool.SecurityRole;
import jeus.xml.binding.j2ee.EjbLocalRefType;
import jeus.xml.binding.j2ee.EjbRefType;
import jeus.xml.binding.j2ee.EnvEntryType;
import jeus.xml.binding.j2ee.LifecycleCallbackType;
import jeus.xml.binding.j2ee.MessageDestinationRefType;
import jeus.xml.binding.j2ee.PersistenceContextRefType;
import jeus.xml.binding.j2ee.PersistenceUnitRefType;
import jeus.xml.binding.j2ee.ResourceEnvRefType;
import jeus.xml.binding.j2ee.ResourceRefType;
import jeus.xml.binding.j2ee.ServiceRefType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebCommonDescriptor
implements Serializable {
    private int sessionTimeout = Integer.MIN_VALUE;
    private Hashtable mimeMappings = null;
    private Vector welcomeFileList = null;
    private Hashtable errorPages = null;
    private Hashtable tagLibs = null;
    private ResourceEnvironReference[] resourceEnvRefs = null;
    private ResourceReference[] resourceRefs = null;
    private SecurityConstraint[] securityConstraints = null;
    private LoginConfig loginConfig = null;
    private SecurityRole[] securityRoles = null;
    private EnvironEntry[] environEntries = null;
    private EJBReference[] ejbRefs = null;
    private EJBReference[] ejbLocalRefs = null;
    private MessageDestinationReference[] messageDestRefs = null;
    List<EnvEntryType> envEntryTypes = null;
    List<EjbRefType> ejbRefTypes = null;
    List<EjbLocalRefType> ejbLocalRefTypes = null;
    List<ServiceRefType> serviceRefTypes = null;
    List<ResourceRefType> resourceRefTypes = null;
    List<ResourceEnvRefType> resourceEnvRefTypes = null;
    List<MessageDestinationRefType> messageDestinationRefTypes = null;
    List<PersistenceContextRefType> persistenceContextRefTypes = null;
    List<PersistenceUnitRefType> persistenceUnitRefTypes = null;
    List<LifecycleCallbackType> postConstructTypes = null;
    List<LifecycleCallbackType> preDestroyTypes = null;

    public void setSessionTimeout(String timeout) {
        if (timeout != null) {
            try {
                this.sessionTimeout = Integer.parseInt(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setMimeMappings(String extension, String mimeType) {
        if (extension != null && mimeType != null) {
            if (this.mimeMappings == null) {
                this.mimeMappings = new Hashtable();
            }
            this.mimeMappings.put(extension, mimeType);
        }
    }

    public void setWelcomeFileList(String[] paramFileList) {
        if (this.welcomeFileList == null) {
            this.welcomeFileList = new Vector();
        }
        for (int i = 0; i < paramFileList.length; ++i) {
            this.welcomeFileList.addElement(paramFileList[i].trim());
        }
    }

    public void addWelcomeFileList(String welcomeFile) {
        if (welcomeFile != null) {
            if (this.welcomeFileList == null) {
                this.welcomeFileList = new Vector();
            }
            this.welcomeFileList.addElement(welcomeFile.trim());
        }
    }

    public void addErrorPage(String key, String errorPage) {
        if (key != null && errorPage != null) {
            if (this.errorPages == null) {
                this.errorPages = new Hashtable();
            }
            this.errorPages.put(key, errorPage);
        }
    }

    public void addTaglib(String uri, String location) {
        if (uri != null && location != null) {
            if (this.tagLibs == null) {
                this.tagLibs = new Hashtable();
            }
            this.tagLibs.put(uri, location);
        }
    }

    public void setResourceRefs(ResourceReference[] refs) {
        this.resourceRefs = refs;
    }

    public void setResourceEnvRefs(ResourceEnvironReference[] refs) {
        this.resourceEnvRefs = refs;
    }

    public void setSecurityConstraints(SecurityConstraint[] paramConstraints) {
        this.securityConstraints = paramConstraints;
    }

    public void setLoginConfig(LoginConfig paramLoginConfig) {
        this.loginConfig = paramLoginConfig;
    }

    public void setSecurityRoles(SecurityRole[] paramSecurityRoles) {
        this.securityRoles = paramSecurityRoles;
    }

    public void setEnvironEntries(EnvironEntry[] paramEnvironEntries) {
        this.environEntries = paramEnvironEntries;
    }

    public void setEJBRefs(EJBReference[] paramEJBRefs) {
        this.ejbRefs = paramEJBRefs;
    }

    public void setEJBLocalRefs(EJBReference[] paramEJBRefs) {
        this.ejbLocalRefs = paramEJBRefs;
    }

    public void setMessageDestRefs(MessageDestinationReference[] paramMessageDestRefs) {
        this.messageDestRefs = paramMessageDestRefs;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public Hashtable getMimeMappings() {
        return this.mimeMappings;
    }

    public String getMimeMapping(String extension) {
        if (this.mimeMappings != null) {
            return (String)this.mimeMappings.get(extension);
        }
        return null;
    }

    public Vector getWelcomeFileList() {
        return this.welcomeFileList;
    }

    public Hashtable getErrorPages() {
        return this.errorPages;
    }

    public String getErrorPage(String key) {
        if (this.errorPages != null) {
            return (String)this.errorPages.get(key);
        }
        return null;
    }

    public Hashtable getTagLibs() {
        return this.tagLibs;
    }

    public String getTagLib(String uri) {
        return (String)this.tagLibs.get(uri);
    }

    public ResourceReference[] getResourceRefs() {
        return this.resourceRefs;
    }

    public ResourceEnvironReference[] getResourceEnvRefs() {
        return this.resourceEnvRefs;
    }

    public SecurityConstraint[] getSecurityConstraints() {
        return this.securityConstraints;
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public SecurityRole[] getSecurityRoles() {
        return this.securityRoles;
    }

    public EnvironEntry[] getEnvironEntries() {
        return this.environEntries;
    }

    public EJBReference[] getEJBRefs() {
        return this.ejbRefs;
    }

    public EJBReference[] getEJBLocalRefs() {
        return this.ejbLocalRefs;
    }

    public MessageDestinationReference[] getMessageDestRefs() {
        return this.messageDestRefs;
    }

    public void printDescriptor(PrintWriter out) {
        Enumeration<Object> enum1;
        out.println("- common web application information");
        out.println("  - session timeout : " + this.sessionTimeout);
        if (this.welcomeFileList != null) {
            out.println("  ++ welcome file list ++");
            enum1 = this.welcomeFileList.elements();
            while (enum1.hasMoreElements()) {
                String welcomeFile = (String)enum1.nextElement();
                out.println("  - " + welcomeFile);
            }
        }
        if (this.errorPages != null) {
            out.println("  ++ error pages ++");
            enum1 = this.errorPages.keys();
            while (enum1.hasMoreElements()) {
                String error = (String)enum1.nextElement();
                String page = (String)this.errorPages.get(error);
                out.println("  - " + error + " : " + page);
            }
        }
        if (this.tagLibs != null) {
            out.println("  ++ tag libraries ++");
            enum1 = this.tagLibs.keys();
            while (enum1.hasMoreElements()) {
                String uri = (String)enum1.nextElement();
                String location = (String)this.tagLibs.get(uri);
                out.println("  - " + uri + " : " + location);
            }
        }
        if (this.mimeMappings != null) {
            out.println("  ++ mime mappings ++");
            enum1 = this.mimeMappings.keys();
            while (enum1.hasMoreElements()) {
                String extension = (String)enum1.nextElement();
                String mimeType = (String)this.mimeMappings.get(extension);
                out.println("  - " + extension + " : " + mimeType);
            }
        }
    }

    public List<EjbLocalRefType> getEjbLocalRefTypes() {
        return this.ejbLocalRefTypes;
    }

    public void setEjbLocalRefTypes(List<EjbLocalRefType> ejbLocalRefTypes) {
        this.ejbLocalRefTypes = ejbLocalRefTypes;
    }

    public List<EjbRefType> getEjbRefTypes() {
        return this.ejbRefTypes;
    }

    public void setEjbRefTypes(List<EjbRefType> ejbRefTypes) {
        this.ejbRefTypes = ejbRefTypes;
    }

    public List<EnvEntryType> getEnvEntryTypes() {
        return this.envEntryTypes;
    }

    public void setEnvEntryTypes(List<EnvEntryType> envEntryTypes) {
        this.envEntryTypes = envEntryTypes;
    }

    public List<MessageDestinationRefType> getMessageDestinationRefTypes() {
        return this.messageDestinationRefTypes;
    }

    public void setMessageDestinationRefTypes(List<MessageDestinationRefType> messageDestinationRefTypes) {
        this.messageDestinationRefTypes = messageDestinationRefTypes;
    }

    public List<ResourceEnvRefType> getResourceEnvRefTypes() {
        return this.resourceEnvRefTypes;
    }

    public void setResourceEnvRefTypes(List<ResourceEnvRefType> resourceEnvRefTypes) {
        this.resourceEnvRefTypes = resourceEnvRefTypes;
    }

    public List<ResourceRefType> getResourceRefTypes() {
        return this.resourceRefTypes;
    }

    public void setResourceRefTypes(List<ResourceRefType> resourceRefTypes) {
        this.resourceRefTypes = resourceRefTypes;
    }

    public List<ServiceRefType> getServiceRefTypes() {
        return this.serviceRefTypes;
    }

    public void setServiceRefTypes(List<ServiceRefType> serviceRefTypes) {
        this.serviceRefTypes = serviceRefTypes;
    }

    public List<PersistenceContextRefType> getPersistenceContextRefTypes() {
        return this.persistenceContextRefTypes;
    }

    public void setPersistenceContextRefTypes(List<PersistenceContextRefType> persistenceContextRefTypes) {
        this.persistenceContextRefTypes = persistenceContextRefTypes;
    }

    public List<PersistenceUnitRefType> getPersistenceUnitRefTypes() {
        return this.persistenceUnitRefTypes;
    }

    public void setPersistenceUnitRefTypes(List<PersistenceUnitRefType> persistenceUnitRefTypes) {
        this.persistenceUnitRefTypes = persistenceUnitRefTypes;
    }

    public List<LifecycleCallbackType> getPostConstructTypes() {
        return this.postConstructTypes;
    }

    public void setPostConstructTypes(List<LifecycleCallbackType> postConstructTypes) {
        this.postConstructTypes = postConstructTypes;
    }

    public List<LifecycleCallbackType> getPreDestroyTypes() {
        return this.preDestroyTypes;
    }

    public void setPreDestroyTypes(List<LifecycleCallbackType> preDestroyTypes) {
        this.preDestroyTypes = preDestroyTypes;
    }
}

