/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.transaction.ActiveTimerEntry;
import jeus.transaction.GTID;
import jeus.transaction.JTAStatisticsProvider;
import jeus.transaction.JeusSynchronization;
import jeus.transaction.PropagationContext;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TransactionImpl;
import jeus.transaction.TxStatus;
import jeus.transaction.XidImpl;
import jeus.transaction.collector.OnePCommitResponseCollector;
import jeus.transaction.info.TransactionInfo;
import jeus.transaction.info.TransactionInfoImpl;
import jeus.transaction.profile.CoordinatorProfileStages;
import jeus.transaction.profile.ProfileManager;
import jeus.transaction.resources.LocalResource;
import jeus.transaction.resources.XAResourceWrapper;
import jeus.transaction.util.XidToString;
import jeus.util.JeusRuntimeException;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_TM1;
import jeus.util.message.JeusMessage_TM3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Coordinator {
    protected static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    protected final long timeout;
    protected final long prepareTO = TMConfig.prepareTO;
    protected final GTID gtid;
    private byte bqCount;
    private volatile boolean rollbackOnly;
    private final Object bqSync = new Object();
    private final ActiveTimerEntry activeTimer = new ActiveTimerEntry(this);
    private PropagationContext ctx;
    private TransactionImpl transaction;
    protected CopyOnWriteArrayList<LocalResource> localResources = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<Synchronization> localSyncs = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<Synchronization> interposedLocalSyncs = new CopyOnWriteArrayList();
    private final OnePCommitResponseCollector opcCollector = new OnePCommitResponseCollector();
    private CopyOnWriteArrayList<LocalResource> localPrepared;
    protected LocalResource localXAResource;
    protected final Object localXAResourceLock = new Object();
    private final long startTime;
    public static final int TRANSACTION_ALREADY_TIMEOUT = -1;
    private CoordinatorState currentState = CoordinatorState.NONE;
    private int status = 6;
    private final Object stateLock = new Object();

    protected Coordinator(GTID gtid, long timeout) {
        this.gtid = gtid;
        this.timeout = timeout;
        this.startTime = System.currentTimeMillis();
        if (logger.isLoggable(JeusMessage_TM3._5201_LEVEL)) {
            long time = this.startTime + timeout;
            logger.logp(JeusMessage_TM3._5201_LEVEL, "TimerEntry", "<init>", JeusMessage_TM3._5201, new Object[]{this, String.valueOf(time)});
        }
        ScheduledExecutor.getInstance().schedule(this.activeTimer, timeout);
        this.checkAndSetState(CoordinatorState.ACTIVE);
    }

    public final void registerResource(LocalResource resource) {
        if (logger.isLoggable(JeusMessage_TM1._3605_LEVEL)) {
            logger.logp(JeusMessage_TM1._3605_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3605, new Object[]{resource, this.gtid});
        }
        if (this.checkStateForRegisteringSynchronization()) {
            if (logger.isLoggable(JeusMessage_TM1._3612_LEVEL)) {
                logger.logp(JeusMessage_TM1._3612_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3612, new Object[]{this.gtid, this.currentState});
            }
            throw new JeusRuntimeException(JeusMessage_TM1._3612, new String[]{this.gtid.toString(), this.currentState.toString()});
        }
        this.registerOwnToRootCoordinator();
        this.localResources.add(resource);
        if (logger.isLoggable(JeusMessage_TM1._3613_LEVEL)) {
            logger.logp(JeusMessage_TM1._3613_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3613, new Object[]{resource, this.gtid});
        }
    }

    public final void registerSynchronization(Synchronization sync) {
        if (logger.isLoggable(JeusMessage_TM1._3614_LEVEL)) {
            logger.logp(JeusMessage_TM1._3614_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3614, new Object[]{sync, this.gtid});
        }
        if (this.checkStateForRegisteringSynchronization()) {
            if (logger.isLoggable(JeusMessage_TM1._3616_LEVEL)) {
                logger.logp(JeusMessage_TM1._3616_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3616, new Object[]{this.gtid, this.currentState});
            }
            if (sync instanceof JeusSynchronization) {
                if (logger.isLoggable(JeusMessage_TM1._3617_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3617_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3617);
                }
                ((JeusSynchronization)sync).resetTransaction();
            }
            throw new JeusRuntimeException(JeusMessage_TM1._3618, this.gtid.toString());
        }
        this.registerOwnToRootCoordinator();
        this.localSyncs.add(sync);
        if (logger.isLoggable(JeusMessage_TM1._3619_LEVEL)) {
            logger.logp(JeusMessage_TM1._3619_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3619, new Object[]{sync, this.gtid});
        }
    }

    public final void registerInterposedSynchronization(Synchronization sync) {
        if (logger.isLoggable(JeusMessage_TM1._3614_LEVEL)) {
            logger.logp(JeusMessage_TM1._3614_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3614, new Object[]{sync, this.gtid});
        }
        if (this.checkStateForRegisteringSynchronization()) {
            if (logger.isLoggable(JeusMessage_TM1._3616_LEVEL)) {
                logger.logp(JeusMessage_TM1._3616_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3616, new Object[]{this.gtid, this.currentState});
            }
            throw new JeusRuntimeException(JeusMessage_TM1._3618, this.gtid.toString());
        }
        this.registerOwnToRootCoordinator();
        this.interposedLocalSyncs.add(sync);
        if (logger.isLoggable(JeusMessage_TM1._3619_LEVEL)) {
            logger.logp(JeusMessage_TM1._3619_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3619, new Object[]{sync, this.gtid});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStateForRegisteringSynchronization() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.currentState != CoordinatorState.ACTIVE && this.currentState != CoordinatorState.MARKED_ROLLBACK && this.currentState != CoordinatorState.BEFORE_COMPLETING;
        }
    }

    public final void cancelActiveTimer() {
        if (logger.isLoggable(JeusMessage_TM1._3626_LEVEL)) {
            logger.logp(JeusMessage_TM1._3626_LEVEL, "Coordinator", "disableActiveTO", JeusMessage_TM1._3626, (Object)this.gtid);
        }
        this.activeTimer.cancel();
        if (logger.isLoggable(JeusMessage_TM1._3628_LEVEL)) {
            logger.logp(JeusMessage_TM1._3628_LEVEL, "Coordinator", "disableActiveTO", JeusMessage_TM1._3628, (Object)this.gtid);
        }
    }

    public final void activeTimeout() throws IllegalStateException {
        if (logger.isLoggable(JeusMessage_TM1._3629_LEVEL)) {
            logger.logp(JeusMessage_TM1._3629_LEVEL, "Coordinator", "activeTimeout", JeusMessage_TM1._3629, (Object)this.gtid);
        }
        this.setRollbackOnly();
        ProfileManager.getInstance().callListener(CoordinatorProfileStages.BEFORE_ACTIVETIMEOUT, this);
        if (logger.isLoggable(JeusMessage_TM1._3632_LEVEL)) {
            logger.logp(JeusMessage_TM1._3632_LEVEL, "Coordinator", "activeTimeout", JeusMessage_TM1._3632, (Object)this.gtid);
        }
        this.gtid.activeTimeOut();
        JTAStatisticsProvider.incrementActiveTimeOutCount();
        this.handleCommonTimeOut();
        ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_ACTIVETIMEOUT, this);
    }

    protected final void handleCommonTimeOut() {
        JTAStatisticsProvider.incrementTimeOutRolledbackCount();
        JTAStatisticsProvider.incrementTimeOutCount();
        this.ejbSynchronizationTimeOut();
    }

    private void ejbSynchronizationTimeOut() {
        for (Synchronization synchronization : this.localSyncs) {
            try {
                if (!(synchronization instanceof JeusSynchronization)) continue;
                ((JeusSynchronization)synchronization).timeOut(8);
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeCompletion() throws IllegalStateException {
        if (logger.isLoggable(JeusMessage_TM1._3633_LEVEL)) {
            logger.logp(JeusMessage_TM1._3633_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3633, (Object)this.gtid);
        }
        if (this.isRollbackOnly()) {
            if (logger.isLoggable(JeusMessage_TM1._3801_LEVEL)) {
                logger.logp(JeusMessage_TM1._3801_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3801, (Object)this.gtid);
            }
            return;
        }
        if (!this.checkAndSetState(CoordinatorState.BEFORE_COMPLETING)) {
            return;
        }
        boolean alreadyAssociated = false;
        try {
            alreadyAssociated = this.ensureTransactionContext();
            this.preBeforeCompletion();
            if (logger.isLoggable(JeusMessage_TM1._3637_LEVEL)) {
                logger.logp(JeusMessage_TM1._3637_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3637, (Object)this.gtid);
            }
            for (Synchronization sync : this.localSyncs) {
                try {
                    if (logger.isLoggable(JeusMessage_TM1._3638_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3638_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3638, new Object[]{sync, this.gtid});
                    }
                    sync.beforeCompletion();
                }
                catch (Throwable ex) {
                    if (logger.isLoggable(JeusMessage_TM1._3639_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3639_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3639, new Object[]{sync, this.gtid}, ex);
                    }
                    try {
                        this.setRollbackOnly();
                    }
                    catch (IllegalStateException ise) {
                        if (!logger.isLoggable(JeusMessage_TM1._3804_LEVEL)) continue;
                        logger.logp(JeusMessage_TM1._3804_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3639, new String[]{this.gtid.toString(), this.currentState.toString()}, (Throwable)ise);
                    }
                }
            }
            for (Synchronization sync : this.interposedLocalSyncs) {
                try {
                    if (logger.isLoggable(JeusMessage_TM1._3638_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3638_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3638, new Object[]{sync, this.gtid});
                    }
                    sync.beforeCompletion();
                }
                catch (Throwable ex) {
                    if (logger.isLoggable(JeusMessage_TM1._3639_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3639_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3639, new Object[]{sync, this.gtid}, ex);
                    }
                    try {
                        this.setRollbackOnly();
                    }
                    catch (IllegalStateException ise) {
                        if (!logger.isLoggable(JeusMessage_TM1._3804_LEVEL)) continue;
                        logger.logp(JeusMessage_TM1._3804_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3639, new String[]{this.gtid.toString(), this.currentState.toString()}, (Throwable)ise);
                    }
                }
            }
            this.postBeforeCompletion();
            if (logger.isLoggable(JeusMessage_TM1._3644_LEVEL)) {
                logger.logp(JeusMessage_TM1._3644_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3644, (Object)this.gtid);
            }
        }
        finally {
            try {
                this.checkAndSetState(CoordinatorState.BEFORE_COMPLETED);
            }
            catch (IllegalStateException illegalStateException) {}
            if (!alreadyAssociated) {
                ThreadContexts.dissociateTransactionID();
            }
        }
    }

    private boolean ensureTransactionContext() {
        GTID gtid = ThreadContexts.getAssociatedTransactionID();
        if (gtid != null) {
            return true;
        }
        if (this.gtid == null) {
            throw new IllegalStateException("current coodinator has not a valid gtid");
        }
        ThreadContexts.associateTransactionID(this.gtid);
        return false;
    }

    protected void postBeforeCompletion() {
    }

    protected void preBeforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final byte prepare() {
        block53: {
            block52: {
                block51: {
                    if (logger.isLoggable(JeusMessage_TM1._3645_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3645_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3645, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                    }
                    try {
                        if (this.checkAndSetState(CoordinatorState.PREPARING)) break block51;
                        try {
                            this.setGlobalDecision((byte)2);
                        }
                        catch (TMException e) {
                            // empty catch block
                        }
                        byte result = this.setReadOnlyStatus();
                        if (logger.isLoggable(JeusMessage_TM1._3672_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3672_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3672, new Object[]{this.gtid, this.currentState});
                        }
                        return result;
                    }
                    catch (IllegalStateException ise) {
                        return 1;
                    }
                }
                if (logger.isLoggable(JeusMessage_TM1._3807_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3807_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3807, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                }
                ProfileManager.getInstance().callListener(CoordinatorProfileStages.BEFORE_PREPARE, this);
                boolean rollback = this.prePrepare();
                if (logger.isLoggable(JeusMessage_TM1._3649_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3649_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3649, (Object)this.gtid);
                }
                this.localPrepared = new CopyOnWriteArrayList();
                for (LocalResource rsc : this.localResources) {
                    try {
                        this.forcelyEndResource(rsc);
                    }
                    catch (XAException xae) {
                        if (logger.isLoggable(JeusMessage_TM1._3811_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3811_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3811, new String[]{this.gtid.toString(), rsc.toString(), XidToString.getXAErrorCode(xae.errorCode)}, (Throwable)xae);
                        }
                        this.localPrepared.add(rsc);
                        if (logger.isLoggable(JeusMessage_TM1._3653_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3653_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3653, new Object[]{rsc, this.gtid});
                        }
                        rollback = true;
                        continue;
                    }
                    if (logger.isLoggable(JeusMessage_TM1._3651_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3651_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3651, new Object[]{rsc, this.gtid});
                    }
                    switch (rsc.prepare()) {
                        case 0: {
                            this.localPrepared.add(rsc);
                            if (!logger.isLoggable(JeusMessage_TM1._3652_LEVEL)) break;
                            logger.logp(JeusMessage_TM1._3652_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3652, new Object[]{rsc, this.gtid});
                            break;
                        }
                        case 1: {
                            this.localPrepared.add(rsc);
                            if (logger.isLoggable(JeusMessage_TM1._3653_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3653_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3653, new Object[]{rsc, this.gtid});
                            }
                            rollback = true;
                            break;
                        }
                        case 2: {
                            if (!logger.isLoggable(JeusMessage_TM1._3654_LEVEL)) break;
                            logger.logp(JeusMessage_TM1._3654_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3654, new Object[]{rsc, this.gtid});
                            break;
                        }
                        case 5: {
                            Object xae = this.localXAResourceLock;
                            synchronized (xae) {
                                this.localXAResource = rsc;
                            }
                            if (!logger.isLoggable(JeusMessage_TM1._3655_LEVEL)) break;
                            logger.logp(JeusMessage_TM1._3655_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3655, new Object[]{rsc, this.gtid});
                            break;
                        }
                    }
                }
                if (!(rollback = this.postPrepare(rollback)) && !this.isRollbackOnly()) break block52;
                if (logger.isLoggable(JeusMessage_TM1._3671_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3671_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3671, (Object)this.gtid);
                }
                this.setGlobalDecision((byte)1);
                byte i$ = 1;
                try {
                    this.checkAndSetState(CoordinatorState.PREPARED);
                }
                catch (IllegalStateException ise) {
                    // empty catch block
                }
                if (logger.isLoggable(JeusMessage_TM1._3800_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3800_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3800, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                }
                ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_PREPARE, this);
                return i$;
            }
            if (!this.isNoPreparedResource()) break block53;
            this.setGlobalDecision((byte)2);
            byte result = this.setReadOnlyStatus();
            if (logger.isLoggable(JeusMessage_TM1._3672_LEVEL)) {
                logger.logp(JeusMessage_TM1._3672_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3672, new Object[]{this.gtid, TxStatus.getState(result)});
            }
            byte ise = result;
            try {
                this.checkAndSetState(CoordinatorState.PREPARED);
            }
            catch (IllegalStateException ise2) {
                // empty catch block
            }
            if (logger.isLoggable(JeusMessage_TM1._3800_LEVEL)) {
                logger.logp(JeusMessage_TM1._3800_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3800, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
            }
            ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_PREPARE, this);
            return ise;
        }
        this.setGlobalDecision((byte)0);
        byte result = this.setCommitStatus();
        if (logger.isLoggable(JeusMessage_TM1._3672_LEVEL)) {
            logger.logp(JeusMessage_TM1._3672_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3672, new Object[]{this.gtid, TxStatus.getState(result)});
        }
        byte ise = result;
        try {
            this.checkAndSetState(CoordinatorState.PREPARED);
        }
        catch (IllegalStateException ise3) {
            // empty catch block
        }
        if (logger.isLoggable(JeusMessage_TM1._3800_LEVEL)) {
            logger.logp(JeusMessage_TM1._3800_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3800, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
        }
        ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_PREPARE, this);
        return ise;
        catch (Throwable ex) {
            byte by;
            try {
                if (logger.isLoggable(JeusMessage_TM1._3676_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3676_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3676, this.gtid, ex);
                }
                try {
                    this.setGlobalDecision((byte)1);
                }
                catch (TMException e) {
                    e.printStackTrace();
                }
                by = 1;
            }
            catch (Throwable throwable) {
                try {
                    this.checkAndSetState(CoordinatorState.PREPARED);
                }
                catch (IllegalStateException ise4) {
                    // empty catch block
                }
                if (logger.isLoggable(JeusMessage_TM1._3800_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3800_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3800, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                }
                ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_PREPARE, this);
                throw throwable;
            }
            try {
                this.checkAndSetState(CoordinatorState.PREPARED);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (logger.isLoggable(JeusMessage_TM1._3800_LEVEL)) {
                logger.logp(JeusMessage_TM1._3800_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3800, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
            }
            ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_PREPARE, this);
            return by;
        }
    }

    private void forcelyEndResource(LocalResource rsc) throws XAException {
        if (rsc == null) {
            return;
        }
        if (logger.isLoggable(JeusMessage_TM1._3650_LEVEL)) {
            logger.logp(JeusMessage_TM1._3650_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3650, new Object[]{rsc, this.gtid});
        }
        rsc.enforceEnd();
    }

    protected void setGlobalDecision(byte rollback) throws TMException {
    }

    protected boolean isNoPreparedResource() {
        return this.localPrepared == null || this.localPrepared.size() == 0;
    }

    private boolean isNoRegisteredResource() {
        return this.localResources == null || this.localResources.isEmpty();
    }

    private boolean isNoRegisteredSync() {
        return this.localSyncs == null || this.localSyncs.isEmpty();
    }

    private boolean isNoRegisteredInterposedSync() {
        return this.interposedLocalSyncs == null || this.interposedLocalSyncs.isEmpty();
    }

    public boolean isNullCoordinator() {
        return this.isNoRegisteredResource() && this.isNoRegisteredSync() && this.isNoRegisteredInterposedSync();
    }

    protected boolean prePrepare() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void commit() throws IllegalStateException, TMException {
        int response;
        block28: {
            if (logger.isLoggable(JeusMessage_TM1._3696_LEVEL)) {
                logger.logp(JeusMessage_TM1._3696_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3696, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
            }
            if (!this.checkAndSetState(CoordinatorState.COMMITTING)) {
                return;
            }
            if (logger.isLoggable(JeusMessage_TM1._3808_LEVEL)) {
                logger.logp(JeusMessage_TM1._3808_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3808, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
            }
            ProfileManager.getInstance().callListener(CoordinatorProfileStages.BEFORE_COMMIT, this);
            response = 3;
            response = this.preCommit((byte)response);
            if (logger.isLoggable(JeusMessage_TM1._3700_LEVEL)) {
                logger.logp(JeusMessage_TM1._3700_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3700, (Object)this.gtid);
            }
            for (LocalResource rsc : this.localPrepared) {
                if (logger.isLoggable(JeusMessage_TM1._3701_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3701_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3701, new Object[]{rsc, this.gtid});
                }
                if (rsc.commit() != 4) continue;
                response = 4;
                if (!logger.isLoggable(JeusMessage_TM1._3702_LEVEL)) continue;
                logger.logp(JeusMessage_TM1._3702_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3702, new Object[]{rsc, this.gtid});
            }
            if (logger.isLoggable(JeusMessage_TM1._3703_LEVEL)) {
                logger.logp(JeusMessage_TM1._3703_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3703, (Object)this.gtid);
            }
            response = this.postCommit((byte)response);
            try {
                this.checkAndSetState(CoordinatorState.COMMITTED);
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            if (logger.isLoggable(JeusMessage_TM1._3712_LEVEL)) {
                logger.logp(JeusMessage_TM1._3712_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3712, new Object[]{this.gtid, TxStatus.getState(this.status)});
            }
            ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_COMMIT, this);
            try {
                this.afterCompletion(3);
            }
            catch (IllegalStateException e) {}
            break block28;
            catch (Throwable ex) {
                block27: {
                    try {
                        if (!logger.isLoggable(JeusMessage_TM1._3710_LEVEL)) break block27;
                        logger.logp(JeusMessage_TM1._3710_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3710, this.gtid, ex);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.checkAndSetState(CoordinatorState.COMMITTED);
                        }
                        catch (IllegalStateException ise) {
                            // empty catch block
                        }
                        if (logger.isLoggable(JeusMessage_TM1._3712_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3712_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3712, new Object[]{this.gtid, TxStatus.getState(this.status)});
                        }
                        ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_COMMIT, this);
                        try {
                            this.afterCompletion(3);
                        }
                        catch (IllegalStateException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    this.checkAndSetState(CoordinatorState.COMMITTED);
                }
                catch (IllegalStateException ise) {
                    // empty catch block
                }
                if (logger.isLoggable(JeusMessage_TM1._3712_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3712_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3712, new Object[]{this.gtid, TxStatus.getState(this.status)});
                }
                ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_COMMIT, this);
                try {
                    this.afterCompletion(3);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        if (response == 4) {
            throw new TMException("");
        }
    }

    protected byte preCommit(byte response) throws TMException {
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void rollback() throws IllegalStateException, TMException {
        byte response;
        block41: {
            block40: {
                Object i$;
                block38: {
                    if (logger.isLoggable(JeusMessage_TM1._3715_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3715_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3715, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                    }
                    if (!this.checkAndSetState(CoordinatorState.ROLLING_BACK)) {
                        return;
                    }
                    if (logger.isLoggable(JeusMessage_TM1._3809_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3809_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3809, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                    }
                    ProfileManager.getInstance().callListener(CoordinatorProfileStages.BEFORE_ROLLBACK, this);
                    try {
                        response = this.preRollback();
                        boolean prepared = this.isPrepared();
                        if (logger.isLoggable(JeusMessage_TM1._3719_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3719_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3719, new Object[]{prepared ? "requiring" : "all", this.gtid});
                        }
                        if (prepared) {
                            i$ = this.localPrepared.iterator();
                            break block38;
                        }
                        for (LocalResource rsc : this.localResources) {
                            block39: {
                                try {
                                    this.forcelyEndResource(rsc);
                                }
                                catch (XAException xae) {
                                    if (!logger.isLoggable(JeusMessage_TM1._3811_LEVEL)) break block39;
                                    logger.logp(JeusMessage_TM1._3811_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3811, new String[]{this.gtid.toString(), rsc.toString(), XidToString.getXAErrorCode(xae.errorCode)}, (Throwable)xae);
                                }
                            }
                            if (logger.isLoggable(JeusMessage_TM1._3723_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3723_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3723, new Object[]{rsc, this.gtid});
                            }
                            response = rsc.rollback(response);
                        }
                        break block40;
                    }
                    catch (Throwable ex) {
                        try {
                            if (logger.isLoggable(JeusMessage_TM1._3724_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3724_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3724, this.gtid, ex);
                            }
                            response = 4;
                        }
                        catch (Throwable throwable) {
                            try {
                                this.checkAndSetState(CoordinatorState.ROLLEDBACK);
                            }
                            catch (IllegalStateException ise) {
                                // empty catch block
                            }
                            if (logger.isLoggable(JeusMessage_TM1._3726_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3726_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3726, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                            }
                            ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_ROLLBACK, this);
                            try {
                                this.afterCompletion(4);
                                throw throwable;
                            }
                            catch (IllegalStateException e) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            this.checkAndSetState(CoordinatorState.ROLLEDBACK);
                        }
                        catch (IllegalStateException ise) {
                            // empty catch block
                        }
                        if (logger.isLoggable(JeusMessage_TM1._3726_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3726_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3726, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                        }
                        ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_ROLLBACK, this);
                        try {
                            this.afterCompletion(4);
                        }
                        catch (IllegalStateException illegalStateException) {}
                        break block41;
                    }
                }
                while (i$.hasNext()) {
                    LocalResource rsc = i$.next();
                    try {
                        if (logger.isLoggable(JeusMessage_TM1._3720_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3720_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3720, new Object[]{rsc, this.gtid});
                        }
                        response = rsc.rollback(response);
                    }
                    catch (Throwable ex) {
                        if (!logger.isLoggable(JeusMessage_TM1._3794_LEVEL)) continue;
                        logger.log(JeusMessage_TM1._3794_LEVEL, JeusMessage_TM1._3794);
                    }
                }
                if (this.localXAResource != null) {
                    i$ = this.localXAResourceLock;
                    synchronized (i$) {
                        if (this.localXAResource != null) {
                            if (logger.isLoggable(JeusMessage_TM1._3721_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3721_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3721, new Object[]{this.localXAResource, this.gtid});
                            }
                            response = this.localXAResource.rollback(response);
                            this.localXAResource = null;
                        }
                    }
                }
            }
            try {
                this.checkAndSetState(CoordinatorState.ROLLEDBACK);
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            if (logger.isLoggable(JeusMessage_TM1._3726_LEVEL)) {
                logger.logp(JeusMessage_TM1._3726_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3726, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
            }
            ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_ROLLBACK, this);
            try {
                this.afterCompletion(4);
            }
            catch (IllegalStateException e) {}
        }
        if (response != 4) return;
        throw new TMException("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final byte onePhaseCommit() throws IllegalStateException {
        byte response;
        block62: {
            block61: {
                if (logger.isLoggable(JeusMessage_TM1._3727_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3727_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3727, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                }
                try {
                    if (!this.checkAndSetState(CoordinatorState.ONEPHASE_COMMITTING)) {
                        return 4;
                    }
                }
                catch (IllegalStateException ise) {
                    return 4;
                }
                if (logger.isLoggable(JeusMessage_TM1._3810_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3810_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3810, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                }
                ProfileManager.getInstance().callListener(CoordinatorProfileStages.BEFORE_ONEPHASECOMMIT, this);
                response = 0;
                LocalResource rsc = this.localResources.get(0);
                try {
                    this.forcelyEndResource(rsc);
                }
                catch (XAException xae) {
                    if (logger.isLoggable(JeusMessage_TM1._3811_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3811_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3811, new String[]{this.gtid.toString(), rsc.toString(), XidToString.getXAErrorCode(xae.errorCode)}, (Throwable)xae);
                    }
                    response = 1;
                }
                if (response == 0) {
                    response = rsc.onePhaseCommit();
                    break block61;
                }
                response = rsc.rollback(response);
            }
            Object var5_6 = null;
            switch (response) {
                case 0: {
                    if (logger.isLoggable(JeusMessage_TM1._3731_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3731_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3731, (Object)this.gtid);
                    }
                    try {
                        this.checkAndSetState(CoordinatorState.COMMITTED);
                    }
                    catch (IllegalStateException ise) {}
                    break;
                }
                case 1: {
                    if (logger.isLoggable(JeusMessage_TM1._3732_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3732_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3732, (Object)this.gtid);
                    }
                    try {
                        this.checkAndSetState(CoordinatorState.ROLLEDBACK);
                    }
                    catch (IllegalStateException ise) {}
                    break;
                }
                case 4: {
                    if (logger.isLoggable(JeusMessage_TM1._3733_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3733_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3733, (Object)this.gtid);
                    }
                    try {
                        this.checkAndSetState(CoordinatorState.ROLLEDBACK);
                    }
                    catch (IllegalStateException ise) {}
                    break;
                }
                default: {
                    try {
                        this.checkAndSetState(CoordinatorState.ROLLEDBACK);
                        break;
                    }
                    catch (IllegalStateException ise) {
                        // empty catch block
                    }
                }
            }
            if (logger.isLoggable(JeusMessage_TM1._3734_LEVEL)) {
                logger.logp(JeusMessage_TM1._3734_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3734, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
            }
            ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_ONEPHASECOMMIT, this);
            try {
                this.afterCompletion(this.status);
            }
            catch (IllegalStateException e) {}
            break block62;
            {
                catch (Throwable ex) {
                    if (logger.isLoggable(JeusMessage_TM1._3730_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3730_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3730, this.gtid, ex);
                    }
                    Object var5_7 = null;
                    switch (response) {
                        case 0: {
                            if (logger.isLoggable(JeusMessage_TM1._3731_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3731_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3731, (Object)this.gtid);
                            }
                            try {
                                this.checkAndSetState(CoordinatorState.COMMITTED);
                            }
                            catch (IllegalStateException ise) {}
                            break;
                        }
                        case 1: {
                            if (logger.isLoggable(JeusMessage_TM1._3732_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3732_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3732, (Object)this.gtid);
                            }
                            try {
                                this.checkAndSetState(CoordinatorState.ROLLEDBACK);
                            }
                            catch (IllegalStateException ise) {}
                            break;
                        }
                        case 4: {
                            if (logger.isLoggable(JeusMessage_TM1._3733_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3733_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3733, (Object)this.gtid);
                            }
                            try {
                                this.checkAndSetState(CoordinatorState.ROLLEDBACK);
                            }
                            catch (IllegalStateException ise) {}
                            break;
                        }
                        default: {
                            try {
                                this.checkAndSetState(CoordinatorState.ROLLEDBACK);
                                break;
                            }
                            catch (IllegalStateException ise) {
                                // empty catch block
                            }
                        }
                    }
                    if (logger.isLoggable(JeusMessage_TM1._3734_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3734_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3734, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                    }
                    ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_ONEPHASECOMMIT, this);
                    try {
                        this.afterCompletion(this.status);
                    }
                    catch (IllegalStateException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                switch (response) {
                    case 0: {
                        if (logger.isLoggable(JeusMessage_TM1._3731_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3731_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3731, (Object)this.gtid);
                        }
                        try {
                            this.checkAndSetState(CoordinatorState.COMMITTED);
                        }
                        catch (IllegalStateException ise) {}
                        break;
                    }
                    case 1: {
                        if (logger.isLoggable(JeusMessage_TM1._3732_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3732_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3732, (Object)this.gtid);
                        }
                        try {
                            this.checkAndSetState(CoordinatorState.ROLLEDBACK);
                        }
                        catch (IllegalStateException ise) {}
                        break;
                    }
                    case 4: {
                        if (logger.isLoggable(JeusMessage_TM1._3733_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3733_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3733, (Object)this.gtid);
                        }
                        try {
                            this.checkAndSetState(CoordinatorState.ROLLEDBACK);
                        }
                        catch (IllegalStateException ise) {}
                        break;
                    }
                    default: {
                        try {
                            this.checkAndSetState(CoordinatorState.ROLLEDBACK);
                            break;
                        }
                        catch (IllegalStateException ise) {
                            // empty catch block
                        }
                    }
                }
                if (logger.isLoggable(JeusMessage_TM1._3734_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3734_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3734, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
                }
                ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_ONEPHASECOMMIT, this);
                try {
                    this.afterCompletion(this.status);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return response;
    }

    public final void onePhaseCommitResponse(byte response) {
        if (logger.isLoggable(JeusMessage_TM1._3735_LEVEL)) {
            logger.logp(JeusMessage_TM1._3735_LEVEL, "Coordinator", "onePhaseCommitResponse", JeusMessage_TM1._3735, new Object[]{TxStatus.getState(response), this.gtid});
        }
        this.opcCollector.received(response);
    }

    public final void afterCompletion(int state) throws IllegalStateException {
        if (logger.isLoggable(JeusMessage_TM1._3736_LEVEL)) {
            logger.logp(JeusMessage_TM1._3736_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3736, new Object[]{this.gtid, TxStatus.getState(state)});
        }
        if (!this.checkAndSetState(CoordinatorState.AFTER_COMPLETING)) {
            return;
        }
        if (state == 3) {
            JTAStatisticsProvider.incrementCommittedCount();
        } else {
            JTAStatisticsProvider.incrementRolledbackCount();
        }
        for (Synchronization sync : this.interposedLocalSyncs) {
            try {
                if (logger.isLoggable(JeusMessage_TM1._3737_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3737_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3737, new Object[]{sync, this.gtid, TxStatus.getState(state)});
                }
                sync.afterCompletion(state);
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_TM1._3738_LEVEL)) continue;
                logger.logp(JeusMessage_TM1._3738_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3738, new Object[]{sync, this.gtid, TxStatus.getState(state)}, ex);
            }
        }
        for (Synchronization sync : this.localSyncs) {
            try {
                if (logger.isLoggable(JeusMessage_TM1._3737_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3737_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3737, new Object[]{sync, this.gtid, TxStatus.getState(state)});
                }
                sync.afterCompletion(state);
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_TM1._3738_LEVEL)) continue;
                logger.logp(JeusMessage_TM1._3738_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3738, new Object[]{sync, this.gtid, TxStatus.getState(state)}, ex);
            }
        }
        if (logger.isLoggable(JeusMessage_TM1._3740_LEVEL)) {
            logger.logp(JeusMessage_TM1._3740_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3740, (Object)this.gtid);
        }
        try {
            this.checkAndSetState(CoordinatorState.AFTER_COMPLETED);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public final void setRollbackOnly() throws IllegalStateException {
        if (!this.checkAndSetState(CoordinatorState.MARKED_ROLLBACK)) {
            return;
        }
        if (logger.isLoggable(JeusMessage_TM1._3758_LEVEL)) {
            logger.logp(JeusMessage_TM1._3758_LEVEL, "Coordinator", "setRollbackOnly", JeusMessage_TM1._3758, (Object)this.gtid);
        }
        this.rollbackOnly = true;
    }

    public final boolean isRollbackOnly() {
        if (logger.isLoggable(JeusMessage_TM1._3759_LEVEL)) {
            logger.logp(JeusMessage_TM1._3759_LEVEL, "Coordinator", "isRollbackOnly", JeusMessage_TM1._3759, new Object[]{this.gtid, this.rollbackOnly ? "" : "not "});
        }
        return this.rollbackOnly;
    }

    public final int getStatus() {
        return this.status;
    }

    public final TransactionImpl getTransaction() {
        if (logger.isLoggable(JeusMessage_TM1._3761_LEVEL)) {
            logger.logp(JeusMessage_TM1._3761_LEVEL, "Coordinator", "getTransaction", JeusMessage_TM1._3761, (Object)this.gtid);
        }
        if (this.transaction == null) {
            this.transaction = new TransactionImpl(this, this.gtid);
        }
        return this.transaction;
    }

    public final GTID getGTID() {
        if (logger.isLoggable(JeusMessage_TM1._3763_LEVEL)) {
            logger.logp(JeusMessage_TM1._3763_LEVEL, "Coordinator", "getGTID", JeusMessage_TM1._3763, (Object)this.gtid);
        }
        return this.gtid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Xid createXID() {
        byte seq;
        Object object = this.bqSync;
        synchronized (object) {
            byte by = this.bqCount;
            this.bqCount = (byte)(by + 1);
            seq = by;
        }
        byte[] bq = TMServer.makeBQ(this.gtid, seq);
        if (logger.isLoggable(JeusMessage_TM1._3764_LEVEL)) {
            logger.logp(JeusMessage_TM1._3764_LEVEL, "Coordinator", "createXID", JeusMessage_TM1._3764, new Object[]{new Byte(this.bqCount), this.gtid});
        }
        return new XidImpl(this.gtid.toBytes(), bq);
    }

    public final LocalResource getLocalResource(XAResource xaResource) {
        if (logger.isLoggable(JeusMessage_TM1._3765_LEVEL)) {
            logger.logp(JeusMessage_TM1._3765_LEVEL, "Coordinator", "getLocalResource", JeusMessage_TM1._3765, new Object[]{xaResource, this.gtid});
        }
        for (LocalResource localResource : this.localResources) {
            if (localResource.getXAResource() != xaResource) continue;
            return localResource;
        }
        return null;
    }

    private Vector<LocalResource> getLocalResources() {
        Vector<LocalResource> resources = new Vector<LocalResource>();
        if (this.localResources != null) {
            resources.addAll(this.localResources);
        }
        return resources;
    }

    public final PropagationContext getPropagationContext() {
        if (this.ctx == null) {
            this.ctx = new PropagationContext(this.gtid, this.timeout);
        }
        if (logger.isLoggable(JeusMessage_TM1._3766_LEVEL)) {
            logger.logp(JeusMessage_TM1._3766_LEVEL, "Coordinator", "getPropagationContext", JeusMessage_TM1._3766, new Object[]{this.ctx, this.gtid});
        }
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (logger.isLoggable(JeusMessage_TM1._3767_LEVEL)) {
            logger.logp(JeusMessage_TM1._3767_LEVEL, "Coordinator", "destroy", JeusMessage_TM1._3767, (Object)this.gtid);
        }
        try {
            if (!this.checkAndSetState(CoordinatorState.DESTROYING)) {
                return;
            }
        }
        catch (IllegalStateException ise) {
            return;
        }
        ProfileManager.getInstance().callListener(CoordinatorProfileStages.BEFORE_DESTROY, this);
        if (logger.isLoggable(JeusMessage_TM1._3768_LEVEL)) {
            logger.logp(JeusMessage_TM1._3768_LEVEL, "Coordinator", "destroy", JeusMessage_TM1._3768);
        }
        this.gtid.invalidate();
        this.innerDestroy();
        this.transaction = null;
        this.activeTimer.cancel();
        if (logger.isLoggable(JeusMessage_TM1._3770_LEVEL)) {
            logger.logp(JeusMessage_TM1._3770_LEVEL, "Coordinator", "destroy", JeusMessage_TM1._3770);
        }
        if (this.localResources != null) {
            this.localResources.clear();
        }
        if (this.localSyncs != null) {
            this.localSyncs.clear();
        }
        if (this.interposedLocalSyncs != null) {
            this.interposedLocalSyncs.clear();
        }
        if (logger.isLoggable(JeusMessage_TM1._3771_LEVEL)) {
            logger.logp(JeusMessage_TM1._3771_LEVEL, "Coordinator", "destroy", JeusMessage_TM1._3771);
        }
        if (this.localPrepared != null) {
            this.localPrepared.clear();
        }
        Object ise = this.localXAResourceLock;
        synchronized (ise) {
            if (this.localXAResource != null) {
                this.localXAResource = null;
            }
        }
        JTAStatisticsProvider.decrementActiveCount();
        JTAStatisticsProvider.addExecutionTime(System.currentTimeMillis() - this.startTime);
        try {
            this.checkAndSetState(CoordinatorState.DESTROYED);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (logger.isLoggable(JeusMessage_TM1._3772_LEVEL)) {
            logger.logp(JeusMessage_TM1._3772_LEVEL, "Coordinator", "destroy", JeusMessage_TM1._3772, (Object)this.gtid);
        }
        ProfileManager.getInstance().callListener(CoordinatorProfileStages.AFTER_DESTROY, this);
    }

    public final void flush() throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3773_LEVEL)) {
            logger.logp(JeusMessage_TM1._3773_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3773, (Object)this.gtid);
        }
        ThreadContexts.associateTransactionID(this.gtid);
        this.innerFlush();
    }

    public final void flush_subcoordinator() throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3784_LEVEL)) {
            logger.logp(JeusMessage_TM1._3784_LEVEL, "Coordinator", "flush_subcoordinator", JeusMessage_TM1._3784, (Object)this.gtid);
        }
        for (Synchronization sync : this.localSyncs) {
            try {
                if (logger.isLoggable(JeusMessage_TM1._3785_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3785_LEVEL, "Coordinator", "flush_subcoordinator", JeusMessage_TM1._3785, new Object[]{sync, this.gtid});
                }
                if (!(sync instanceof JeusSynchronization)) continue;
                ((JeusSynchronization)sync).flush();
            }
            catch (Throwable ex) {
                throw new TMException(JeusMessage_TM1._3786, new String[]{sync.toString(), this.gtid.toString()}, ex);
            }
        }
        if (logger.isLoggable(JeusMessage_TM1._3787_LEVEL)) {
            logger.logp(JeusMessage_TM1._3787_LEVEL, "Coordinator", "flush_subcoordinator", JeusMessage_TM1._3787, (Object)this.gtid);
        }
    }

    public final String toString() {
        return this.gtid.toString();
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final int getTimeoutInSeconds() {
        return this.timeout / 1000L < Integer.MAX_VALUE ? (int)(this.timeout / 1000L) : Integer.MAX_VALUE;
    }

    public final long getElapseSinceBegin() {
        if (this.startTime <= 0L) {
            throw new IllegalStateException("transaction is not begun");
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public final long getRemainingTimeout() {
        long elapse;
        long timeout = this.timeout;
        if (timeout <= 0L) {
            timeout = TMConfig.activeTO;
        }
        if ((elapse = System.currentTimeMillis() - this.startTime) < 0L) {
            elapse = 0L;
        }
        if (timeout >= elapse) {
            return timeout - elapse;
        }
        return -1L;
    }

    public void setExternalXid(Xid xid) {
    }

    public final Xid getXidFromXAResource(XAResource xaResource) {
        if (xaResource == null) {
            return null;
        }
        if (xaResource instanceof XAResourceWrapper) {
            return ((XAResourceWrapper)xaResource).getXID();
        }
        LocalResource localResource = this.getLocalResource(xaResource);
        if (localResource == null) {
            return null;
        }
        return localResource.getXid();
    }

    public final TransactionInfo getTransactionInfoFromCoordinator() {
        Xid externalXid;
        TransactionInfoImpl transactionInfo = null;
        GTID gtid = this.getGTID();
        if (gtid == null) {
            return null;
        }
        transactionInfo = new TransactionInfoImpl(new XidImpl(gtid.toBytes(), new byte[0], 303077));
        TMInfo tminfo = gtid.getTMInfo();
        if (tminfo != null) {
            transactionInfo.setCoordinator(tminfo.getIPString() + ":" + tminfo.getPort());
        }
        if ((externalXid = gtid.getExternalXid()) != null) {
            transactionInfo.setExternalXid(new XidImpl(externalXid));
        }
        transactionInfo.setTimeout(this.getTimeout());
        transactionInfo.setElapseSinceBegin(this.getElapseSinceBegin());
        transactionInfo.setStatus(TxStatus.getState(this.getStatus()));
        Vector<String> stringResources = new Vector<String>();
        Vector<LocalResource> localResources = this.getLocalResources();
        for (LocalResource resource : localResources) {
            stringResources.add(resource.getName());
        }
        if (!stringResources.isEmpty()) {
            transactionInfo.setXaResources(stringResources.toArray(new String[stringResources.size()]));
        }
        return transactionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean checkAndSetState(CoordinatorState newState) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.currentState == newState) {
                if (logger.isLoggable(JeusMessage_TM1._3803_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3803_LEVEL, "Coordinator", "checkAndSetState", JeusMessage_TM1._3803, (Object[])new String[]{this.gtid.toString(), this.currentState.toString(), newState.toString()});
                }
                return false;
            }
            boolean illegalState = false;
            if (newState == CoordinatorState.NONE) {
                illegalState = true;
            } else if (newState == CoordinatorState.ACTIVE) {
                if (this.currentState == CoordinatorState.NONE) {
                    this.status = 0;
                } else {
                    illegalState = true;
                }
            } else if (newState == CoordinatorState.BEFORE_COMPLETING) {
                if (this.currentState != CoordinatorState.ACTIVE) {
                    illegalState = true;
                }
            } else if (newState == CoordinatorState.BEFORE_COMPLETED) {
                if (this.currentState == CoordinatorState.MARKED_ROLLBACK) {
                    return false;
                }
                if (this.currentState != CoordinatorState.BEFORE_COMPLETING && logger.isLoggable(JeusMessage_TM1._3802_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3802_LEVEL, "Coordinator", "checkAndSetState", JeusMessage_TM1._3802, (Object[])new String[]{this.gtid.toString(), this.currentState.toString(), newState.toString()});
                }
            } else if (newState == CoordinatorState.AFTER_COMPLETING) {
                if (this.currentState != CoordinatorState.COMMITTED && this.currentState != CoordinatorState.ROLLEDBACK && this.currentState != CoordinatorState.PREPARED && this.currentState != CoordinatorState.BEFORE_COMPLETED) {
                    illegalState = true;
                }
            } else if (newState == CoordinatorState.AFTER_COMPLETED) {
                if (this.currentState != CoordinatorState.AFTER_COMPLETING && logger.isLoggable(JeusMessage_TM1._3802_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3802_LEVEL, "Coordinator", "checkAndSetState", JeusMessage_TM1._3802, (Object[])new String[]{this.gtid.toString(), this.currentState.toString(), newState.toString()});
                }
            } else if (newState == CoordinatorState.PREPARING) {
                if (this.currentState == CoordinatorState.BEFORE_COMPLETED) {
                    this.status = 7;
                } else {
                    illegalState = true;
                }
            } else if (newState == CoordinatorState.PREPARED) {
                if (this.currentState != CoordinatorState.PREPARING && logger.isLoggable(JeusMessage_TM1._3802_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3802_LEVEL, "Coordinator", "checkAndSetState", JeusMessage_TM1._3802, (Object[])new String[]{this.gtid.toString(), this.currentState.toString(), newState.toString()});
                }
                this.status = 2;
            } else if (newState == CoordinatorState.ONEPHASE_COMMITTING) {
                if (this.currentState == CoordinatorState.BEFORE_COMPLETED || this.currentState == CoordinatorState.PREPARED) {
                    this.status = 8;
                } else {
                    illegalState = true;
                }
            } else if (newState == CoordinatorState.COMMITTING) {
                if (this.currentState == CoordinatorState.PREPARED) {
                    this.status = 8;
                } else {
                    illegalState = true;
                }
            } else if (newState == CoordinatorState.COMMITTED) {
                if (this.currentState != CoordinatorState.ONEPHASE_COMMITTING && this.currentState != CoordinatorState.COMMITTING && logger.isLoggable(JeusMessage_TM1._3802_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3802_LEVEL, "Coordinator", "checkAndSetState", JeusMessage_TM1._3802, (Object[])new String[]{this.gtid.toString(), this.currentState.toString(), newState.toString()});
                }
                this.status = 3;
            } else if (newState == CoordinatorState.ROLLING_BACK) {
                if (this.currentState == CoordinatorState.ACTIVE || this.currentState == CoordinatorState.PREPARED || this.currentState == CoordinatorState.MARKED_ROLLBACK) {
                    this.status = 9;
                } else {
                    illegalState = true;
                }
            } else if (newState == CoordinatorState.ROLLEDBACK) {
                if (this.currentState != CoordinatorState.ROLLING_BACK && this.currentState != CoordinatorState.ONEPHASE_COMMITTING && logger.isLoggable(JeusMessage_TM1._3802_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3802_LEVEL, "Coordinator", "checkAndSetState", JeusMessage_TM1._3802, (Object[])new String[]{this.gtid.toString(), this.currentState.toString(), newState.toString()});
                }
                this.status = 4;
            } else if (newState == CoordinatorState.MARKED_ROLLBACK) {
                if (this.currentState == CoordinatorState.ACTIVE || this.currentState == CoordinatorState.BEFORE_COMPLETING) {
                    this.status = 1;
                } else {
                    illegalState = true;
                }
            } else if (newState == CoordinatorState.DESTROYING) {
                if (this.currentState != CoordinatorState.AFTER_COMPLETED) {
                    illegalState = true;
                }
            } else if (newState == CoordinatorState.DESTROYED) {
                if (this.currentState != CoordinatorState.DESTROYING && logger.isLoggable(JeusMessage_TM1._3802_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3802_LEVEL, "Coordinator", "checkAndSetState", JeusMessage_TM1._3802, (Object[])new String[]{this.gtid.toString(), this.currentState.toString(), newState.toString()});
                }
            } else {
                illegalState = true;
            }
            if (illegalState) {
                if (logger.isLoggable(JeusMessage_TM1._3806_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3806_LEVEL, "Coordinator", "checkAndSetState", JeusMessage_TM1._3806, (Object[])new String[]{this.gtid.toString(), this.currentState.toString(), newState.toString()});
                }
                throw new IllegalStateException(JeusMessageBundles.getMessage(JeusMessage_TM1._3806, this.gtid.toString(), this.currentState.toString(), newState.toString()));
            }
            if (logger.isLoggable(JeusMessage_TM1._3805_LEVEL)) {
                logger.logp(JeusMessage_TM1._3805_LEVEL, "Coordinator", "checkAndSetState", JeusMessage_TM1._3805, (Object[])new String[]{this.currentState.toString(), newState.toString(), this.gtid.toString()});
            }
            this.currentState = newState;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isPrepared() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.currentState == CoordinatorState.PREPARED;
        }
    }

    protected abstract boolean postPrepare(boolean var1);

    protected abstract byte postCommit(byte var1);

    protected abstract byte preRollback() throws TMException;

    protected abstract byte setCommitStatus();

    protected abstract byte setReadOnlyStatus();

    protected abstract void registerOwnToRootCoordinator();

    protected abstract void innerFlush() throws TMException;

    protected abstract void innerDestroy();

    public abstract void addIndoubtXid(Xid var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CoordinatorState {
        NONE,
        ACTIVE,
        BEFORE_COMPLETING,
        BEFORE_COMPLETED,
        AFTER_COMPLETING,
        AFTER_COMPLETED,
        PREPARING,
        PREPARED,
        ONEPHASE_COMMITTING,
        COMMITTING,
        COMMITTED,
        ROLLING_BACK,
        ROLLEDBACK,
        MARKED_ROLLBACK,
        DESTROYING,
        DESTROYED;

    }
}

