/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.Vector;
import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.TMException;
import jeus.transaction.ThreadContexts;
import jeus.util.ScheduleTask;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatorCleanupTask
extends ScheduleTask {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    private final long destroyTimeout;

    public CoordinatorCleanupTask(long destroyTimeout) {
        this.destroyTimeout = destroyTimeout;
    }

    @Override
    public void run() {
        try {
            this.cleanup(ThreadContexts.getLocalCoordinatorList());
            this.cleanup(ThreadContexts.getSubCoordinatorList());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void cleanup(Vector<Coordinator> coordinators) {
        if (coordinators == null) {
            return;
        }
        for (Coordinator coord : coordinators) {
            try {
                GTID gtid = coord.getGTID();
                long elapseSinceBegin = coord.getElapseSinceBegin();
                long timeout = coord.getTimeout();
                if (gtid == null || !gtid.isActiveTimedOut() || elapseSinceBegin < this.destroyTimeout + timeout) continue;
                if (logger.isLoggable(JeusMessage_TM4._7500_LEVEL)) {
                    logger.log(JeusMessage_TM4._7500_LEVEL, JeusMessage_TM4._7500, (Object[])new String[]{gtid.toString(), String.valueOf(timeout), String.valueOf(elapseSinceBegin)});
                }
                try {
                    coord.rollback();
                }
                catch (IllegalStateException ise) {
                }
                catch (TMException e) {
                    // empty catch block
                }
                coord.destroy();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_TM4._7501_LEVEL)) continue;
                logger.log(JeusMessage_TM4._7501_LEVEL, JeusMessage_TM4._7501, coord, t);
            }
        }
    }
}

