/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.io.Serializable;
import jeus.transaction.GTID;
import jeus.util.ByteUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;
import jeus.util.message.JeusMessage_TM2;

public final class PropagationContext
implements Serializable {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    private final GTID gtid;
    private final long timeout;
    private final byte[] bytes;
    public static final int SIZE_GTID_LENGTH_FIELD = 2;
    public static final int TYPE_NULL_CTX = -1;
    public static final int TYPE_UNSPECIFIED_CTX = -2;
    public static final int TYPE_UNSPECIFIED_CTX_WITH_XID = -3;

    public PropagationContext(byte[] bytes) {
        if (logger.isLoggable(JeusMessage_TM2._4701_LEVEL)) {
            logger.logp(JeusMessage_TM2._4701_LEVEL, "PropagationContext", "<init>", JeusMessage_TM2._4701, (Object)Utility.getDump(bytes));
        }
        this.bytes = bytes;
        int length = ByteUtil.convertToUnsignedShort(bytes, 0);
        int gtidLength = length - 4;
        byte[] result = new byte[gtidLength];
        System.arraycopy(bytes, 2, result, 0, gtidLength);
        this.timeout = ByteUtil.convertToInt(bytes, 2 + gtidLength);
        this.gtid = new GTID(result);
    }

    public PropagationContext(GTID gtid, long timeout) {
        if (logger.isLoggable(JeusMessage_TM2._4702_LEVEL)) {
            logger.logp(JeusMessage_TM2._4702_LEVEL, "PropagationContext", "<init>", JeusMessage_TM2._4702, new Object[]{gtid, String.valueOf(timeout)});
        }
        this.gtid = gtid;
        this.timeout = timeout;
        byte[] gtidBytes = gtid.toBytes();
        int length = gtidBytes.length;
        byte[] result = new byte[2 + length + 4];
        ByteUtil.putUnsingedShort(result, 0, length + 4);
        System.arraycopy(gtidBytes, 0, result, 2, length);
        ByteUtil.putInt(result, length + 2, timeout > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeout);
        this.bytes = result;
    }

    public final GTID getGTID() {
        return this.gtid;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    public final String toString() {
        return this.gtid + " : " + this.timeout + " msec";
    }
}

