/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import javax.transaction.xa.Xid;
import jeus.transaction.GTID;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.Transaction;
import jeus.transaction.TransactionImpl;
import jeus.transaction.XAResourceFactory;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM3;

public class TMCommonService {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");

    public static void registerDataSource(XAResourceFactory factory, String exportName) throws TMException {
        if (factory == null) {
            return;
        }
        if (logger.isLoggable(JeusMessage_TM3._5705_LEVEL)) {
            logger.logp(JeusMessage_TM3._5705_LEVEL, "TMService", "registerDataSource", JeusMessage_TM3._5705, (Object[])new String[]{exportName, factory.toString()});
        }
        TMServer.registerXAResourceReference(factory, exportName);
        if (logger.isLoggable(JeusMessage_TM3._5706_LEVEL)) {
            logger.logp(JeusMessage_TM3._5706_LEVEL, "TMService", "registerDataSource", JeusMessage_TM3._5706);
        }
    }

    public static void associateNullTransaction() {
        if (logger.isLoggable(JeusMessage_TM3._5707_LEVEL)) {
            logger.logp(JeusMessage_TM3._5707_LEVEL, "TMService", "associateNullTransaction", JeusMessage_TM3._5707);
        }
        ThreadContexts.dissociateTransactionID();
    }

    public static void associateTransactionContext(javax.transaction.Transaction tx) {
        if (logger.isLoggable(JeusMessage_TM3._5708_LEVEL)) {
            logger.logp(JeusMessage_TM3._5708_LEVEL, "TMService", "associateTransactionContext", JeusMessage_TM3._5708, (Object)tx);
        }
        TMServer.associateThread(((TransactionImpl)tx).getGTID());
    }

    public static GTID suspendCurrentTransaction() {
        if (logger.isLoggable(JeusMessage_TM3._5709_LEVEL)) {
            logger.logp(JeusMessage_TM3._5709_LEVEL, "TMService", "suspendCurrentTransaction", JeusMessage_TM3._5709);
        }
        GTID id = ThreadContexts.getAssociatedTransactionID();
        ThreadContexts.dissociateTransactionID();
        return id;
    }

    public static void resumeCurrentTransaction(GTID id) {
        if (logger.isLoggable(JeusMessage_TM3._5710_LEVEL)) {
            logger.logp(JeusMessage_TM3._5710_LEVEL, "TMService", "resumeCurrentTransaction", JeusMessage_TM3._5710, (Object)id);
        }
        ThreadContexts.associateTransactionID(id);
    }

    public static boolean isAssociatedWithNullTransaction() {
        boolean associated;
        GTID gtid = ThreadContexts.getAssociatedTransactionID();
        boolean bl = associated = gtid == null || gtid.isInvalid();
        if (logger.isLoggable(JeusMessage_TM3._5711_LEVEL)) {
            logger.logp(JeusMessage_TM3._5711_LEVEL, "TMService", "isAssociatedWithNullTransaction", JeusMessage_TM3._5711, (Object)associated);
        }
        return associated;
    }

    public static boolean isAssociatedWithTransaction() {
        GTID gtid = ThreadContexts.getAssociatedTransactionID();
        return gtid != null && !gtid.isInvalid();
    }

    public static boolean isAssociatedWithTransaction(javax.transaction.Transaction tx) {
        GTID gtid = ThreadContexts.getAssociatedTransactionID();
        if (gtid == null || gtid.isInvalid()) {
            return false;
        }
        if (tx instanceof TransactionImpl) {
            TransactionImpl jeusTxImpl = (TransactionImpl)tx;
            return gtid.equals(jeusTxImpl.getGTID());
        }
        if (tx instanceof Transaction) {
            Transaction jeusTx = (Transaction)tx;
            byte[] gtidBytes = jeusTx.getGlobalTransactionId();
            return gtidBytes != null && gtid.equals(new GTID(gtidBytes));
        }
        return false;
    }

    public static void waitForRecovery() {
        TMServer.waitForRecovery();
    }

    public static boolean isTxTimeout() {
        GTID gtid = ThreadContexts.getAssociatedTransactionID();
        return gtid != null && gtid.isActiveTimedOut();
    }

    public static boolean isTxTimeout(javax.transaction.Transaction tx) {
        return tx instanceof Transaction && ((Transaction)tx).isTimedOut();
    }

    public static boolean isTxTimeout(GTID gtid) {
        return gtid != null && gtid.isActiveTimedOut();
    }

    public static boolean isTxAlive(GTID gtid) {
        return gtid != null && !gtid.isInvalid();
    }

    public static boolean isGeneratedAtThisTM(Xid xid) {
        if (xid == null) {
            return false;
        }
        byte[] gtidBytes = xid.getGlobalTransactionId();
        if (gtidBytes == null) {
            return false;
        }
        TMInfo tmInfo = TMServer.getTMInfo();
        if (tmInfo == null) {
            return false;
        }
        GTID jeusGtid = new GTID(gtidBytes);
        return tmInfo.isGeneratedAtThisTM(jeusGtid);
    }
}

