/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.net.ConnectorException;
import jeus.transaction.ContextSenderReceiver;
import jeus.transaction.Coordinator;
import jeus.transaction.CoordinatorCleanupTask;
import jeus.transaction.GTID;
import jeus.transaction.JTAStatisticsProvider;
import jeus.transaction.PropagationContext;
import jeus.transaction.ServerContextSenderReceiver;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMNotAvailableException;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TransactionManagerDescriptor;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.comm.TMLink;
import jeus.transaction.comm.TMLinkManager;
import jeus.transaction.logging.HowlLogManager;
import jeus.transaction.logging.IncompletedTx;
import jeus.transaction.logging.LogManager;
import jeus.transaction.logging.NullLogManager;
import jeus.transaction.logging.ReferenceInfo;
import jeus.transaction.logging.TxRecoveryDelegator;
import jeus.transaction.profile.ProfileListener;
import jeus.transaction.profile.ProfileManager;
import jeus.transaction.resources.JeusXAResource;
import jeus.transaction.resources.LocalResource;
import jeus.transaction.root.RootCoordinator;
import jeus.transaction.sub.RootCoordinatorDelegate;
import jeus.transaction.sub.SubCoordinator;
import jeus.util.ByteUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.ScheduleTask;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;
import jeus.util.message.JeusMessage_TM3;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusTMProperties;
import org.objectweb.howl.log.xa.XACommittingTx;

public final class TMServer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    private static int listenPort = 0;
    private static int serverVirtualPort = -1;
    private static int clientStartPort = 0;
    private static TMInfo tmServer;
    public static byte[] bqbase;
    private static final AtomicLong localHandlerIDs;
    private static final byte[] BQ_MAGIC;
    private static final int BQ_SEQ_SIZE = 1;
    public static final int BQ_SEQ_INDEX = 0;
    private static int BQ_PRE_GTID_LENGTH;
    private static final long LOCAL_RESOURCE_RETRIAL_INTERVAL;
    private static final long LOCAL_RESOURCE_RETRIAL_COUNT;
    public static final long SHUTDOWN_LOCK_TIMEOUT = 30000L;
    private static final long DEFAULT_COORDINATOR_CLEANUP_TIMEOUT_INTERVAL = 1800000L;
    private static final long DEFAULT_COORDINATOR_CLEANUP_TIMEOUT = 1800000L;
    private static ScheduleTask coordCleanupTask;
    private static final ReentrantReadWriteLock rRWlock;
    private static final Lock readLock;
    private static final Lock writeLock;
    private static AtomicBoolean running;
    private static LogManager logManager;
    private static TMLinkManager linkManager;
    private static final ConcurrentHashMap<LocalResource, Byte> failedLocalResources;
    private static AtomicBoolean retrialThreadRunning;
    private static long startTime;

    public static void initForServer(TransactionManagerDescriptor desc, String name, int port, int vport) throws TMException {
        listenPort = port;
        serverVirtualPort = vport;
        clientStartPort = port;
        TMServer.initialize(desc, name, listenPort, serverVirtualPort, clientStartPort);
    }

    public static void initForClient(TransactionManagerDescriptor desc, String name, int port, int startPort) throws TMException {
        if (port > 0) {
            listenPort = port;
        }
        serverVirtualPort = -1;
        clientStartPort = startPort;
        TMServer.initialize(desc, name, listenPort, serverVirtualPort, clientStartPort);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initialize(TransactionManagerDescriptor desc, String name, int port, int vport, int startPort) throws TMException {
        boolean success = false;
        if (!running.compareAndSet(false, true)) {
            return;
        }
        writeLock.lock();
        try {
            try {
                long destroyTimeoutInterval;
                int foundPort;
                if (logger.isLoggable(JeusMessage_TM3._5401_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5401_LEVEL, "TMServer", "init", JeusMessage_TM3._5401);
                }
                TMConfig.isClientTM = false;
                TMServer.setTMProfile();
                TMConfig.configure(desc);
                byte[] ipaddr = JeusNetPropertyValues.getLocalInetAddress().getAddress();
                if (logger.isLoggable(JeusMessage_TM3._5415_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5415_LEVEL, "TMServer", "getEnvironments", JeusMessage_TM3._5415, (Object)Utility.getDump(ipaddr));
                }
                linkManager = new TMLinkManager(TMConfig.nonBlocking);
                startTime = System.currentTimeMillis();
                int starttime = (int)(startTime % Integer.MAX_VALUE);
                int tmMin = desc != null ? desc.getTMMin() : JeusTMProperties.tmMin;
                int tmMax = desc != null ? desc.getTMMax() : JeusTMProperties.tmMax;
                long tmResizingPeriod = desc != null ? desc.getTMResizingPeriod() : JeusTMProperties.tmResizingPeriod;
                int tmCapacity = desc != null ? desc.getTMCapacity() : JeusTMProperties.tmCapacity;
                ThreadContexts.initContexts(tmCapacity);
                if (logger.isLoggable(JeusMessage_TM3._5404_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5404_LEVEL, "TMServer", "init", JeusMessage_TM3._5404);
                }
                if ((foundPort = linkManager.init(ipaddr, port, startPort, starttime, vport, tmMin, tmMax, tmResizingPeriod)) > 0 && listenPort <= 0) {
                    listenPort = foundPort;
                }
                tmServer = linkManager.getMyInfo();
                if (logger.isLoggable(JeusMessage_TM3._5405_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5405_LEVEL, "TMServer", "init", JeusMessage_TM3._5405);
                }
                logManager = JeusTMProperties.NO_LOGGING ? new NullLogManager() : new HowlLogManager(name, tmServer, TMConfig.txLogDir);
                bqbase = TMServer.makeBQBase(tmServer);
                BQ_PRE_GTID_LENGTH = 1 + bqbase.length;
                ContextSenderReceiver.setContextSenderReceiver(new ServerContextSenderReceiver());
                long destroyTimeout = JeusTMProperties.COORDINATOR_DESTROY_TIMEOUT;
                if (destroyTimeout <= 0L) {
                    destroyTimeout = 1800000L;
                }
                if ((destroyTimeoutInterval = JeusTMProperties.COORDINATOR_DESTROY_TIMEOUT_CHECK_INTERVAL) <= 0L) {
                    destroyTimeoutInterval = 1800000L;
                }
                if (logger.isLoggable(JeusMessage_TM3._5407_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5407_LEVEL, "TMServer", "init", JeusMessage_TM3._5407, (Object[])new String[]{String.valueOf(destroyTimeout), String.valueOf(destroyTimeoutInterval)});
                }
                coordCleanupTask = new CoordinatorCleanupTask(destroyTimeout);
                ScheduledExecutor.getInstance().scheduleWithFixedDelay(coordCleanupTask, destroyTimeoutInterval, destroyTimeoutInterval);
                if (logger.isLoggable(JeusMessage_TM3._5412_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5412_LEVEL, "TMServer", "init", JeusMessage_TM3._5412, (Object)tmServer);
                }
                success = true;
            }
            catch (Throwable ex) {
                if (!(ex instanceof TMException)) throw new TMException(JeusMessage_TM3._5411, ex);
                throw (TMException)ex;
            }
            Object var19_16 = null;
            writeLock.unlock();
            if (success) return;
        }
        catch (Throwable throwable) {
            Object var19_17 = null;
            writeLock.unlock();
            if (success) throw throwable;
            try {
                TMServer.shutdown();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable t) {}
        TMServer.shutdown();
        return;
    }

    private static void setTMProfile() {
        ProfileManager profileManager = ProfileManager.getInstance();
        String profileClasses = JeusTMProperties.PROFILE_LISTENER_CLASSES;
        if (profileClasses == null) {
            profileManager.setEnable(false);
            return;
        }
        profileManager.setEnable(true);
        StringTokenizer tokenizer = new StringTokenizer(profileClasses, ",; ");
        if (logger.isLoggable(JeusMessage_TM3._5570_LEVEL)) {
            logger.logp(JeusMessage_TM3._5570_LEVEL, "TMServer", "setTMProfile", JeusMessage_TM3._5570, (Object)profileClasses);
        }
        while (tokenizer.hasMoreTokens()) {
            String listener = tokenizer.nextToken().trim();
            try {
                Class<?> listenerClass;
                Object obj;
                if (logger.isLoggable(JeusMessage_TM3._5571_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5571_LEVEL, "TMServer", "setTMProfile", JeusMessage_TM3._5571, (Object)listener);
                }
                if ((obj = (listenerClass = Class.forName(listener, true, TMServer.class.getClassLoader())).newInstance()) instanceof ProfileListener) {
                    profileManager.addListener((ProfileListener)obj);
                    continue;
                }
                if (!logger.isLoggable(JeusMessage_TM3._5572_LEVEL)) continue;
                logger.logp(JeusMessage_TM3._5572_LEVEL, "TMServer", "setTMProfile", JeusMessage_TM3._5572, obj);
            }
            catch (ClassNotFoundException cnfe) {
                if (!logger.isLoggable(JeusMessage_TM3._5573_LEVEL)) continue;
                logger.logp(JeusMessage_TM3._5573_LEVEL, "TMServer", "setTMProfile", JeusMessage_TM3._5573, listener, (Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                if (!logger.isLoggable(JeusMessage_TM3._5573_LEVEL)) continue;
                logger.logp(JeusMessage_TM3._5573_LEVEL, "TMServer", "setTMProfile", JeusMessage_TM3._5573, listener, (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                if (!logger.isLoggable(JeusMessage_TM3._5573_LEVEL)) continue;
                logger.logp(JeusMessage_TM3._5573_LEVEL, "TMServer", "setTMProfile", JeusMessage_TM3._5573, listener, (Throwable)iae);
            }
        }
    }

    private static void unsetTMProfile() {
        ProfileManager.getInstance().removeAllListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        readLock.lock();
        try {
            boolean bl = running.get();
            Object var2_1 = null;
            readLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        block6: {
            if (!running.compareAndSet(true, false)) {
                return;
            }
            try {
                if (writeLock.tryLock(30000L, TimeUnit.MILLISECONDS)) {
                    try {
                        TMServer.internalDestroy();
                        Object var1 = null;
                        writeLock.unlock();
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var1_1 = null;
                        writeLock.unlock();
                        throw throwable;
                    }
                }
                TMServer.internalDestroy();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                TMServer.internalDestroy();
            }
        }
    }

    private static void internalDestroy() {
        block11: {
            if (logger.isLoggable(JeusMessage_TM3._5445_LEVEL)) {
                logger.logp(JeusMessage_TM3._5445_LEVEL, "TMServer", "shutdown", JeusMessage_TM3._5445);
            }
            if (coordCleanupTask != null) {
                try {
                    coordCleanupTask.cancel();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                coordCleanupTask = null;
            }
            if (logger.isLoggable(JeusMessage_TM3._5447_LEVEL)) {
                logger.logp(JeusMessage_TM3._5447_LEVEL, "TMServer", "shutdown", JeusMessage_TM3._5447);
            }
            try {
                if (logManager != null) {
                    logManager.close();
                }
            }
            catch (TMException ex) {
                if (!logger.isLoggable(JeusMessage_TM3._5449_LEVEL)) break block11;
                logger.logp(JeusMessage_TM3._5449_LEVEL, "TMServer", "shutdown", JeusMessage_TM3._5449, (Throwable)ex);
            }
        }
        if (logger.isLoggable(JeusMessage_TM3._5446_LEVEL)) {
            logger.logp(JeusMessage_TM3._5446_LEVEL, "TMServer", "shutdown", JeusMessage_TM3._5446);
        }
        if (linkManager != null) {
            linkManager.unexport();
        }
        retrialThreadRunning.set(false);
        failedLocalResources.clear();
        TMServer.unsetTMProfile();
        if (logger.isLoggable(JeusMessage_TM3._5450_LEVEL)) {
            logger.logp(JeusMessage_TM3._5450_LEVEL, "TMServer", "shutdown", JeusMessage_TM3._5450);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startRecovery() throws TMException {
        block8: {
            block7: {
                readLock.lock();
                try {
                    if (running.get()) break block7;
                    boolean bl = false;
                    Object var3_3 = null;
                    readLock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    readLock.unlock();
                    throw throwable;
                }
            }
            if (logManager == null) {
                throw new TMException("transaction manager must be initialized before starting recovery");
            }
            if (logManager.start(startTime)) break block8;
            boolean bl = false;
            Object var3_4 = null;
            readLock.unlock();
            return bl;
        }
        if (logger.isLoggable(JeusMessage_TM3._5408_LEVEL)) {
            logger.logp(JeusMessage_TM3._5408_LEVEL, "TMServer", "startRecovery", JeusMessage_TM3._5408, (Object)tmServer);
        }
        RecoveryThread t = new RecoveryThread(logManager, "jeus.transaction.TMServer$RecoveryThread");
        t.start();
        if (logger.isLoggable(JeusMessage_TM3._5409_LEVEL)) {
            logger.logp(JeusMessage_TM3._5409_LEVEL, "TMServer", "startRecovery", JeusMessage_TM3._5409);
        }
        boolean bl = true;
        Object var3_5 = null;
        readLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doRecovery(Map dslist) {
        block5: {
            block4: {
                readLock.lock();
                try {
                    if (running.get()) break block4;
                    boolean bl = true;
                    Object var3_4 = null;
                    readLock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    readLock.unlock();
                    throw throwable;
                }
            }
            if (!logManager.inRecovery()) break block5;
            boolean bl = false;
            Object var3_5 = null;
            readLock.unlock();
            return bl;
        }
        logManager.resyncXAResources(dslist);
        boolean bl = true;
        Object var3_6 = null;
        readLock.unlock();
        return bl;
    }

    static void unspecifiedContextPropagated(byte[] ctx) throws TMNotAvailableException {
        block5: {
            if (logger.isLoggable(Level.FINE)) {
                if (logger.isLoggable(JeusMessage_TM3._5506_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5506_LEVEL, "TMServer", "unspecifiedContextPropagated", JeusMessage_TM3._5506);
                }
                if (logger.isLoggable(JeusMessage_TM3._5556_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5556_LEVEL, "TMServer", "unspecifiedContextPropagated", JeusMessage_TM3._5556, (Object)Thread.currentThread());
                }
            }
            ThreadContexts.dissociateTransactionID();
            int time = ByteUtil.convertToInt(ctx, 1);
            try {
                TMServer.create(time);
            }
            catch (NotSupportedException e) {
                if (!logger.isLoggable(JeusMessage_TM3._5507_LEVEL)) break block5;
                logger.logp(JeusMessage_TM3._5507_LEVEL, "TMServer", "unspecifiedContextPropagated", JeusMessage_TM3._5507, (Throwable)e);
            }
        }
    }

    static Coordinator create(long timeout) throws NotSupportedException, TMNotAvailableException {
        return TMServer.create(null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Coordinator create(Xid xid, long timeout) throws NotSupportedException, TMNotAvailableException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            if (logger.isLoggable(JeusMessage_TM3._5508_LEVEL)) {
                logger.logp(JeusMessage_TM3._5508_LEVEL, "TMServer", "create", JeusMessage_TM3._5508, (Object)String.valueOf(timeout));
            }
            logManager.waitForRecovery();
            if (ThreadContexts.getOnGoingLocalTxNum() != 0) {
                if (logger.isLoggable(JeusMessage_TM3._5510_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5510_LEVEL, "TMServer", "create", JeusMessage_TM3._5510);
                }
                throw new NotSupportedException(ErrorMsgManager.getLocalizedString(JeusMessage_TM3._5510));
            }
            GTID gtid = ThreadContexts.getAssociatedTransactionID();
            if (gtid != null && !gtid.isInvalid()) {
                if (logger.isLoggable(JeusMessage_TM3._5511_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5511_LEVEL, "TMServer", "create", JeusMessage_TM3._5511);
                }
                throw new NotSupportedException(ErrorMsgManager.getLocalizedString(JeusMessage_TM3._5511));
            }
            long ltid = localHandlerIDs.getAndIncrement();
            gtid = new GTID(tmServer, ltid, xid);
            gtid.setLocal();
            RootCoordinator coord = new RootCoordinator(gtid, logManager, timeout);
            ThreadContexts.putCoordinator(ltid, (Coordinator)coord);
            if (logger.isLoggable(JeusMessage_TM3._5555_LEVEL)) {
                logger.logp(JeusMessage_TM3._5555_LEVEL, "TMServer", "create", JeusMessage_TM3._5555, new Object[]{gtid, Thread.currentThread()});
            }
            ThreadContexts.associateTransactionID(gtid);
            if (logger.isLoggable(JeusMessage_TM3._5512_LEVEL)) {
                logger.logp(JeusMessage_TM3._5512_LEVEL, "TMServer", "create", JeusMessage_TM3._5512);
            }
            JTAStatisticsProvider.incrementActiveCount();
            RootCoordinator rootCoordinator = coord;
            Object var9_6 = null;
            readLock.unlock();
            return rootCoordinator;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    static boolean contextPropagated(PropagationContext ctx) throws TMNotAvailableException {
        long timeout = ctx.getTimeout();
        GTID gtid = ctx.getGTID();
        return TMServer.processPropagation(gtid, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processPropagation(GTID gtid, long timeout) throws TMNotAvailableException {
        readLock.lock();
        try {
            boolean result;
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            if (logger.isLoggable(JeusMessage_TM3._5513_LEVEL)) {
                logger.logp(JeusMessage_TM3._5513_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5513, new Object[]{gtid, new Long(timeout)});
            }
            logManager.waitForRecovery();
            if (gtid.getTMInfo().equals(tmServer)) {
                if (logger.isLoggable(JeusMessage_TM3._5515_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5515_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5515, (Object)gtid);
                }
                gtid.setLocal();
                if (logger.isLoggable(JeusMessage_TM3._5555_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5555_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5555, new Object[]{gtid, Thread.currentThread()});
                }
                ThreadContexts.associateTransactionID(gtid);
                result = false;
            } else {
                SubCoordinator coord = (SubCoordinator)ThreadContexts.getCoordinator(gtid);
                if (coord == null) {
                    if (logger.isLoggable(JeusMessage_TM3._5516_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5516_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5516, (Object)gtid);
                    }
                    RootCoordinatorDelegate root = new RootCoordinatorDelegate(gtid.getTMInfo(), gtid.getLTID(), linkManager);
                    coord = new SubCoordinator(root, gtid, timeout);
                    ThreadContexts.putCoordinator(gtid, (Coordinator)coord);
                    if (logger.isLoggable(JeusMessage_TM3._5555_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5555_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5555, new Object[]{gtid, Thread.currentThread()});
                    }
                    ThreadContexts.associateTransactionID(gtid);
                    if (JeusTMProperties.forcedRegister) {
                        if (logger.isLoggable(JeusMessage_TM3._5517_LEVEL)) {
                            logger.logp(JeusMessage_TM3._5517_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5517, (Object)gtid);
                        }
                        coord.registerOwnToRootCoordinator();
                    }
                } else {
                    if (logger.isLoggable(JeusMessage_TM3._5518_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5518_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5518, (Object)gtid);
                    }
                    if (logger.isLoggable(JeusMessage_TM3._5555_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5555_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5555, new Object[]{gtid, Thread.currentThread()});
                    }
                    ThreadContexts.associateTransactionID(gtid);
                }
                result = coord.isRegCheckRequired();
            }
            boolean bl = result;
            Object var7_6 = null;
            readLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    public static void disconnectContext() {
        if (logger.isLoggable(JeusMessage_TM3._5519_LEVEL)) {
            logger.logp(JeusMessage_TM3._5519_LEVEL, "TMServer", "disconnectContext", JeusMessage_TM3._5519);
        }
        ThreadContexts.dissociateTransactionID();
    }

    public static SubCoordinator getSubCoordinator(GTID gtid) {
        return (SubCoordinator)ThreadContexts.getCoordinator(gtid);
    }

    public static RootCoordinator getRootCoordinator(long ltid) {
        return ThreadContexts.getCoordinator(ltid);
    }

    static void associateThread(GTID gtid) {
        ThreadContexts.associateTransactionID(gtid);
    }

    public static Coordinator getCoordinator() throws InvalidTransactionException {
        return ThreadContexts.getCurrentCoordinator();
    }

    static Coordinator dissociateThread() {
        return ThreadContexts.dissociateFromThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerXAResourceReference(XAResourceFactory factory, String exportName) {
        readLock.lock();
        try {
            if (!running.get()) {
                Object var4_2 = null;
                readLock.unlock();
                return;
            }
            if (logManager != null) {
                if (logger.isLoggable(JeusMessage_TM3._5537_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5537_LEVEL, "TMServer", "registerDataSource", JeusMessage_TM3._5537, new Object[]{factory, exportName});
                }
                try {
                    logManager.logXAResourceReference(exportName, factory);
                }
                catch (Exception e) {
                    if (logger.isLoggable(JeusMessage_TM3._5817_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5817_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5817, factory, (Throwable)e);
                    }
                }
            } else if (logger.isLoggable(JeusMessage_TM3._5538_LEVEL)) {
                logger.logp(JeusMessage_TM3._5538_LEVEL, "TMServer", "registerDataSource", JeusMessage_TM3._5538);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            readLock.unlock();
            throw throwable;
        }
        Object var4_3 = null;
        readLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addFailedLocalResource(LocalResource localRsc, byte phase) {
        block10: {
            block9: {
                block8: {
                    readLock.lock();
                    try {
                        if (!running.get()) {
                            Object var4_2 = null;
                            readLock.unlock();
                            return;
                        }
                        if (logger.isLoggable(JeusMessage_TM3._5818_LEVEL)) {
                            logger.logp(JeusMessage_TM3._5818_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5818, (Object)localRsc);
                        }
                        if (failedLocalResources.putIfAbsent(localRsc, new Byte(phase)) != null) {
                            break block8;
                        }
                        if (logger.isLoggable(JeusMessage_TM3._5820_LEVEL)) {
                            logger.logp(JeusMessage_TM3._5820_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5820, (Object)new Integer(failedLocalResources.size()));
                        }
                        if (!retrialThreadRunning.compareAndSet(false, true)) {
                            break block9;
                        }
                        if (logger.isLoggable(JeusMessage_TM3._5819_LEVEL)) {
                            logger.logp(JeusMessage_TM3._5819_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5819);
                        }
                        Thread retrialThread = new Thread((Runnable)new LocalResourceRetrialThread(), "LocalResource Rertrial");
                        retrialThread.setDaemon(true);
                        retrialThread.start();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        readLock.unlock();
                        throw throwable;
                    }
                }
                Object var4_3 = null;
                readLock.unlock();
                return;
            }
            Object var4_4 = null;
            readLock.unlock();
            return;
        }
        Object var4_5 = null;
        readLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte getDecisionForUncompletedTx(long ltid, int time) {
        block3: {
            readLock.lock();
            try {
                if (running.get()) break block3;
                byte by = -1;
                Object var5_4 = null;
                readLock.unlock();
                return by;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                readLock.unlock();
                throw throwable;
            }
        }
        byte by = logManager.getDecisionForIncompletedTx(ltid, time);
        Object var5_5 = null;
        readLock.unlock();
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGlobalDecisionForUncompletedExternalTransaction(Xid xid, boolean isCommit) throws TMException, XAException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            logManager.setGlobalDecisionForIncompletedTransaction(xid, isCommit);
            Object var3_2 = null;
            readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xid[] getIncompleteExternalXids() {
        block3: {
            readLock.lock();
            try {
                if (running.get()) break block3;
                Xid[] xidArray = new Xid[]{};
                Object var2_2 = null;
                readLock.unlock();
                return xidArray;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                readLock.unlock();
                throw throwable;
            }
        }
        Xid[] xidArray = logManager.getIncompleteExternalXids();
        Object var2_3 = null;
        readLock.unlock();
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forgetIncompleteTx(Xid xid) throws TMException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            logManager.forgetIncompleteTx(xid);
            Object var2_1 = null;
            readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forgetIncompleteTxForSubXids(Xid xid) throws TMException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            logManager.forgetIncompleteTxForSubXids(xid);
            Object var2_1 = null;
            readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncompletedTx[] getAllincompletedTx() {
        block3: {
            readLock.lock();
            try {
                if (running.get()) break block3;
                IncompletedTx[] incompletedTxArray = new IncompletedTx[]{};
                Object var2_2 = null;
                readLock.unlock();
                return incompletedTxArray;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                readLock.unlock();
                throw throwable;
            }
        }
        IncompletedTx[] incompletedTxArray = logManager.getAllIncompletedTx();
        Object var2_3 = null;
        readLock.unlock();
        return incompletedTxArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xid[] getSubXids(TMInfo socketID) throws TMException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            Xid[] xidArray = logManager.getSubXids(socketID);
            Object var3_2 = null;
            readLock.unlock();
            return xidArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkExternalXidIncompleted(Xid xid) {
        block3: {
            readLock.lock();
            try {
                if (running.get()) break block3;
                boolean bl = false;
                Object var3_3 = null;
                readLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                readLock.unlock();
                throw throwable;
            }
        }
        boolean bl = logManager.getIncompletedExternalTx(xid) != null;
        Object var3_4 = null;
        readLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceInfo[] getRecoveredXAResourceInfo() {
        block3: {
            readLock.lock();
            try {
                if (running.get()) break block3;
                ReferenceInfo[] referenceInfoArray = new ReferenceInfo[]{};
                Object var2_2 = null;
                readLock.unlock();
                return referenceInfoArray;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                readLock.unlock();
                throw throwable;
            }
        }
        ReferenceInfo[] referenceInfoArray = logManager.getRecoveredXAResourceInfo();
        Object var2_3 = null;
        readLock.unlock();
        return referenceInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceInfo[] getCurrentXAResourceInfo() {
        block3: {
            readLock.lock();
            try {
                if (running.get()) break block3;
                ReferenceInfo[] referenceInfoArray = new ReferenceInfo[]{};
                Object var2_2 = null;
                readLock.unlock();
                return referenceInfoArray;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                readLock.unlock();
                throw throwable;
            }
        }
        ReferenceInfo[] referenceInfoArray = logManager.getCurrentXAResourceInfo();
        Object var2_3 = null;
        readLock.unlock();
        return referenceInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeXAResourceInfo(ReferenceInfo ref) {
        readLock.lock();
        try {
            if (!running.get()) {
                Object var2_1 = null;
                readLock.unlock();
                return;
            }
            logManager.removeRecoveredReferenceInfo(ref);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            readLock.unlock();
            throw throwable;
        }
        Object var2_2 = null;
        readLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIncompleteSubTx(SubCoordinator coord) {
        readLock.lock();
        try {
            if (!running.get()) {
                Object var2_1 = null;
                readLock.unlock();
                return;
            }
            logManager.addIncompletedSubTX(coord);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            readLock.unlock();
            throw throwable;
        }
        Object var2_2 = null;
        readLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGlobalDecisionForSubXids(Xid xid, boolean commit) throws TMException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            logManager.setGlobalDecisionForSubXids(xid, commit);
            Object var3_2 = null;
            readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeIncompleteSubTx(SubCoordinator coord) {
        readLock.lock();
        try {
            if (!running.get()) {
                Object var2_1 = null;
                readLock.unlock();
                return;
            }
            logManager.removeIncompleteSubTx(coord);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            readLock.unlock();
            throw throwable;
        }
        Object var2_2 = null;
        readLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean completeRecoveredSubCoordinator(GTID gtid, boolean isCommit) throws TMException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new TMNotAvailableException("TMServer is not initialized or already destroyed");
            }
            boolean bl = logManager.completeRecoveredSubCoordinator(gtid, isCommit);
            Object var4_3 = null;
            readLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TMLink getLink(TMInfo tmServer) throws ConnectorException {
        readLock.lock();
        try {
            if (!running.get()) {
                throw new ConnectorException("TMServer is not initialized or already destroyed");
            }
            TMLink tMLink = linkManager.getLink(tmServer);
            Object var3_2 = null;
            readLock.unlock();
            return tMLink;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    public static void waitForRecovery() {
        if (!running.get()) {
            return;
        }
        if (logManager != null) {
            logManager.waitForRecovery();
        }
    }

    public static TMInfo getTMInfo() {
        return tmServer;
    }

    public static String getTxLogDir() {
        if (logManager instanceof HowlLogManager) {
            return ((HowlLogManager)logManager).getLogDir();
        }
        return null;
    }

    static byte[] makeBQ(GTID gtid, byte seq) {
        byte[] bq = new byte[BQ_PRE_GTID_LENGTH + gtid.getByteLength()];
        bq[0] = seq;
        System.arraycopy(bqbase, 0, bq, 1, bqbase.length);
        gtid.toBytes(bq, BQ_PRE_GTID_LENGTH);
        return bq;
    }

    public static ConcurrentHashMap getFailedLocalResources() {
        return failedLocalResources;
    }

    public static byte[] makeBQBase(TMInfo tmInfo) {
        if (tmInfo == null) {
            return new byte[0];
        }
        byte[] bqBase = new byte[4 + tmInfo.getByteLength()];
        System.arraycopy(BQ_MAGIC, 0, bqBase, 0, BQ_MAGIC.length);
        tmInfo.toBytes(bqBase, BQ_MAGIC.length);
        return bqBase;
    }

    public static void completeTxFromJeusGtid(GTID jeusGtid) {
        TMServer.completeTxFromJeusGtid(jeusGtid, null);
    }

    private static void completeTxFromJeusGtid(GTID jeusGtid, Xid completedChild) {
        block9: {
            if (logger.isLoggable(JeusMessage_TM3._5826_LEVEL)) {
                logger.logp(JeusMessage_TM3._5826_LEVEL, "TMServer", "completeTx", JeusMessage_TM3._5826, (Object[])new String[]{jeusGtid == null ? "null" : jeusGtid.toString(), completedChild == null ? "null" : completedChild.toString()});
            }
            if (jeusGtid == null) {
                return;
            }
            try {
                IncompletedTx tx = logManager.getIncompletedTx(jeusGtid);
                if (tx == null) {
                    return;
                }
                if (tx.hasFailedSubCoordinators()) {
                    return;
                }
                if (completedChild != null) {
                    tx.removeRuntimeChildXid(completedChild);
                }
                if (tx.isChildsEmpty()) {
                    logManager.logXaDone((XACommittingTx)tx.getHandback());
                    logManager.removeIncompletedTx(tx);
                    if (logger.isLoggable(JeusMessage_TM3._5827_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5827_LEVEL, "TMServer", "completeTx", JeusMessage_TM3._5827, (Object)jeusGtid);
                    }
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_TM3._5825_LEVEL)) break block9;
                logger.logp(JeusMessage_TM3._5825_LEVEL, "TMServer", "completeTx", JeusMessage_TM3._5825, jeusGtid, t);
            }
        }
    }

    public static TxRecoveryDelegator getTxRecoveryDelegator() {
        if (!(logManager instanceof HowlLogManager)) {
            return null;
        }
        HowlLogManager currentLogManager = (HowlLogManager)logManager;
        return currentLogManager.getTxRecoveryDelegator();
    }

    static {
        localHandlerIDs = new AtomicLong(0L);
        BQ_MAGIC = ByteUtil.convertToByte(-1416153395);
        LOCAL_RESOURCE_RETRIAL_INTERVAL = JeusTMProperties.RECOVERY_INTERVAL;
        LOCAL_RESOURCE_RETRIAL_COUNT = JeusTMProperties.RECOVERY_RETRIAL;
        rRWlock = new ReentrantReadWriteLock(true);
        readLock = rRWlock.readLock();
        writeLock = rRWlock.writeLock();
        running = new AtomicBoolean(false);
        failedLocalResources = new ConcurrentHashMap();
        retrialThreadRunning = new AtomicBoolean(false);
    }

    private static final class LocalResourceRetrialThread
    implements Runnable {
        private LocalResourceRetrialThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block23: {
                do {
                    try {
                        Thread.sleep(LOCAL_RESOURCE_RETRIAL_INTERVAL);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!retrialThreadRunning.get()) break block23;
                    Iterator iter = failedLocalResources.keySet().iterator();
                    while (iter.hasNext()) {
                        Object var11_11;
                        LocalResource localRsc = (LocalResource)iter.next();
                        byte phase = (Byte)failedLocalResources.get(localRsc);
                        int decision = 4;
                        XAResourceFactory xaResourceFactory = null;
                        XAResource newXAResource = null;
                        try {
                            JeusXAResource jeusXAResource;
                            XAResource xaResource = localRsc.getXAResource();
                            if (xaResource instanceof JeusXAResource && (xaResourceFactory = (jeusXAResource = (JeusXAResource)xaResource).getXAResourceFactory()) != null) {
                                try {
                                    newXAResource = xaResourceFactory.getXAResource();
                                }
                                catch (Exception e) {
                                    localRsc.increaseFailCount();
                                    if ((long)localRsc.getFailCount() > LOCAL_RESOURCE_RETRIAL_COUNT) {
                                        iter.remove();
                                    }
                                    if (logger.isLoggable(JeusMessage_TM3._5823_LEVEL)) {
                                        logger.logp(JeusMessage_TM3._5823_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5823, localRsc, (Throwable)e);
                                    }
                                    var11_11 = null;
                                    if (xaResourceFactory == null || newXAResource == null) continue;
                                    xaResourceFactory.close(newXAResource);
                                    continue;
                                }
                                if (newXAResource != null) {
                                    jeusXAResource.replaceXAResource(newXAResource);
                                }
                            }
                            switch (phase) {
                                case 1: {
                                    if (logger.isLoggable(JeusMessage_TM3._5822_LEVEL)) {
                                        logger.logp(JeusMessage_TM3._5822_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5822, new Object[]{"commit", localRsc});
                                    }
                                    decision = localRsc.commit();
                                    break;
                                }
                                case 0: 
                                case 2: 
                                case 3: {
                                    if (logger.isLoggable(JeusMessage_TM3._5822_LEVEL)) {
                                        logger.logp(JeusMessage_TM3._5822_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5822, new Object[]{"rollback", localRsc});
                                    }
                                    decision = localRsc.rollback((byte)1);
                                }
                            }
                            if (decision != 4) {
                                iter.remove();
                                this.completeTx(localRsc);
                            } else {
                                if ((long)localRsc.getFailCount() > LOCAL_RESOURCE_RETRIAL_COUNT) {
                                    iter.remove();
                                }
                                if (logger.isLoggable(JeusMessage_TM3._5823_LEVEL)) {
                                    logger.logp(JeusMessage_TM3._5823_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5823, (Object)localRsc);
                                }
                            }
                            var11_11 = null;
                            if (xaResourceFactory == null || newXAResource == null) continue;
                            xaResourceFactory.close(newXAResource);
                        }
                        catch (Throwable throwable) {
                            var11_11 = null;
                            if (xaResourceFactory != null && newXAResource != null) {
                                xaResourceFactory.close(newXAResource);
                            }
                            throw throwable;
                        }
                    }
                    if (!logger.isLoggable(JeusMessage_TM3._5824_LEVEL)) continue;
                    logger.logp(JeusMessage_TM3._5824_LEVEL, "TMServer", "localResourceRetrial", JeusMessage_TM3._5824, (Object)new Integer(failedLocalResources.size()));
                } while (!failedLocalResources.isEmpty());
                retrialThreadRunning.set(false);
            }
        }

        private void completeTx(LocalResource localResource) {
            if (localResource == null) {
                return;
            }
            Xid xid = localResource.getXid();
            if (xid == null) {
                return;
            }
            byte[] gtidBytes = xid.getGlobalTransactionId();
            if (gtidBytes == null) {
                return;
            }
            GTID jeusGtid = null;
            try {
                jeusGtid = new GTID(gtidBytes);
            }
            catch (Throwable t) {
                // empty catch block
            }
            TMServer.completeTxFromJeusGtid(jeusGtid, xid);
        }
    }

    public static final class RecoveryThread
    extends Thread {
        private final LogManager logManager;

        public RecoveryThread(LogManager logManager, String name) {
            super(name);
            this.logManager = logManager;
        }

        public final void run() {
            if (this.logManager == null) {
                return;
            }
            try {
                this.logManager.doRecover();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

