/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.List;
import jeus.transaction.JeusLocalTransaction;
import jeus.transaction.RecoveryThread;
import jeus.transaction.TMCommonService;
import jeus.transaction.TMException;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TransactionImpl;
import jeus.transaction.TransactionManagerDescriptor;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.client.TMClient;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM3;

public final class TMService
extends TMCommonService {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    public static final TransactionImpl nullTransaction = new TransactionImpl(null, null);

    public static void initTMServer(TransactionManagerDescriptor desc, String name, int port, int vport) throws TMException {
        if (logger.isLoggable(JeusMessage_TM3._5701_LEVEL)) {
            logger.logp(JeusMessage_TM3._5701_LEVEL, "TMService", "init", JeusMessage_TM3._5701);
        }
        if (port <= 0) {
            throw new TMException("port must be initialized");
        }
        if (vport < 0) {
            throw new TMException("vport must be initialized");
        }
        TMServer.initForServer(desc, name, port, vport);
        if (logger.isLoggable(JeusMessage_TM3._5702_LEVEL)) {
            logger.logp(JeusMessage_TM3._5702_LEVEL, "TMService", "init", JeusMessage_TM3._5702);
        }
    }

    public static void initTMServerInClient(TransactionManagerDescriptor desc, String name, int port, int startPort) throws TMException {
        if (logger.isLoggable(JeusMessage_TM3._5701_LEVEL)) {
            logger.logp(JeusMessage_TM3._5701_LEVEL, "TMService", "init", JeusMessage_TM3._5701);
        }
        if (port <= 0 && startPort <= 0) {
            throw new TMException("port or startPort must be initialized");
        }
        TMServer.initForClient(desc, name, port, startPort);
        TMService.startRecovery();
        if (logger.isLoggable(JeusMessage_TM3._5702_LEVEL)) {
            logger.logp(JeusMessage_TM3._5702_LEVEL, "TMService", "init", JeusMessage_TM3._5702);
        }
    }

    public static void initTMClient(TransactionManagerDescriptor desc, int port, int startPort) throws TMException {
        if (logger.isLoggable(JeusMessage_TM3._5701_LEVEL)) {
            logger.logp(JeusMessage_TM3._5701_LEVEL, "TMService", "init", JeusMessage_TM3._5701);
        }
        if (port <= 0 && startPort <= 0) {
            throw new TMException("port or startPort must be initialized");
        }
        TMClient.init(desc, port, startPort);
        if (logger.isLoggable(JeusMessage_TM3._5702_LEVEL)) {
            logger.logp(JeusMessage_TM3._5702_LEVEL, "TMService", "init", JeusMessage_TM3._5702);
        }
    }

    public static void destroyTMServer() {
        if (logger.isLoggable(JeusMessage_TM3._5703_LEVEL)) {
            logger.logp(JeusMessage_TM3._5703_LEVEL, "TMService", "shutdown", JeusMessage_TM3._5703);
        }
        try {
            TMServer.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (logger.isLoggable(JeusMessage_TM3._5704_LEVEL)) {
            logger.logp(JeusMessage_TM3._5704_LEVEL, "TMService", "shutdown", JeusMessage_TM3._5704, (Object)JeusMessage_TM3._5704_LEVEL);
        }
    }

    public static void destroyTMClient() {
        if (logger.isLoggable(JeusMessage_TM3._5703_LEVEL)) {
            logger.logp(JeusMessage_TM3._5703_LEVEL, "TMService", "shutdown", JeusMessage_TM3._5703);
        }
        try {
            TMClient.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (logger.isLoggable(JeusMessage_TM3._5704_LEVEL)) {
            logger.logp(JeusMessage_TM3._5704_LEVEL, "TMService", "shutdown", JeusMessage_TM3._5704, (Object)JeusMessage_TM3._5704_LEVEL);
        }
    }

    public static void enlistLocalTransaction(JeusLocalTransaction jeusLocalTx) {
        if (logger.isLoggable(JeusMessage_TM3._5713_LEVEL)) {
            logger.logp(JeusMessage_TM3._5713_LEVEL, "TMService", "enlistLocalTransaction", JeusMessage_TM3._5713, (Object)jeusLocalTx);
        }
        ThreadContexts.associateLocalTransaction(jeusLocalTx);
    }

    public static void delistLocalTransaction(JeusLocalTransaction jeusLocalTx) {
        if (logger.isLoggable(JeusMessage_TM3._5712_LEVEL)) {
            logger.logp(JeusMessage_TM3._5712_LEVEL, "TMService", "delistLocalTransaction", JeusMessage_TM3._5712, (Object)jeusLocalTx);
        }
        ThreadContexts.dissociateLocalTransaction(jeusLocalTx);
    }

    public static void clearLocalTx(int recordedStackHeight) throws TMException {
        List<JeusLocalTransaction> list;
        if (logger.isLoggable(JeusMessage_TM3._5541_LEVEL)) {
            logger.logp(JeusMessage_TM3._5541_LEVEL, "TMServer", "clearLocalTx", JeusMessage_TM3._5541, (Object)Thread.currentThread());
        }
        if ((list = ThreadContexts.getAssociatedLocalTransactions()) == null) {
            return;
        }
        int currentHeight = list.size();
        if (currentHeight > recordedStackHeight) {
            if (logger.isLoggable(JeusMessage_TM3._5542_LEVEL)) {
                logger.logp(JeusMessage_TM3._5542_LEVEL, "TMServer", "clearLocalTx", JeusMessage_TM3._5542, new Object[]{String.valueOf(currentHeight - recordedStackHeight), Thread.currentThread()});
            }
            for (int i = currentHeight - 1; i >= recordedStackHeight; --i) {
                JeusLocalTransaction localTx = list.remove(i);
                localTx.rollback();
            }
        }
        if (logger.isLoggable(JeusMessage_TM3._5716_LEVEL)) {
            logger.logp(JeusMessage_TM3._5716_LEVEL, "TMService", "clearLocalTx", JeusMessage_TM3._5716);
        }
    }

    public static void registerXAResource(XAResourceFactory xaResourceFactory, String exportName) {
        if (xaResourceFactory == null) {
            return;
        }
        if (logger.isLoggable(JeusMessage_TM3._5705_LEVEL)) {
            logger.logp(JeusMessage_TM3._5705_LEVEL, "TMService", "registerDataSource", JeusMessage_TM3._5705, (Object[])new String[]{exportName, xaResourceFactory.toString()});
        }
        TMServer.registerXAResourceReference(xaResourceFactory, exportName);
        if (logger.isLoggable(JeusMessage_TM3._5706_LEVEL)) {
            logger.logp(JeusMessage_TM3._5706_LEVEL, "TMService", "registerDataSource", JeusMessage_TM3._5706);
        }
    }

    public static boolean startRecovery() throws TMException {
        return TMServer.startRecovery();
    }

    public static Thread startRecoveryWithXaResourceFactory(XAResourceFactory xaResourceFactory) {
        if (xaResourceFactory == null) {
            return null;
        }
        RecoveryThread t = new RecoveryThread(xaResourceFactory);
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static Thread startRecoveryWithExportName(String exportName) {
        if (exportName == null) {
            return null;
        }
        RecoveryThread t = new RecoveryThread(exportName);
        t.setDaemon(true);
        t.start();
        return t;
    }
}

