/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicMixedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMServer;
import jeus.transaction.Terminator;
import jeus.transaction.ThreadContexts;
import jeus.transaction.XidImpl;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.root.RootCoordinator;
import jeus.transaction.util.XidToString;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM2;

public final class TMXAResource
implements XAResource,
XATerminator {
    public static final int STATUS_UNKNOWN = -1;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    private static final TMXAResource tmxaResource = new TMXAResource("default");
    private static final ConcurrentHashMap<String, TransactionState> XID_MAPPER = new ConcurrentHashMap();
    private static final Object IN_USE_LOCK = new Object();
    private static final ConcurrentHashMap<String, Xid> PREPARED_XIDS = new ConcurrentHashMap();
    private final AtomicLong defaultTimeout = new AtomicLong(TMConfig.activeTO);
    private final String debugName;

    public TMXAResource() {
        this.debugName = "TMXAResource@" + this.hashCode();
    }

    public TMXAResource(String name) {
        this.debugName = name;
    }

    public String toString() {
        return this.debugName;
    }

    public final int getTransactionTimeout() throws XAException {
        long seconds = this.defaultTimeout.get() / 1000L;
        if (seconds > Integer.MAX_VALUE) {
            seconds = Integer.MAX_VALUE;
        }
        return (int)seconds;
    }

    public final boolean setTransactionTimeout(int seconds) {
        if (seconds < 0) {
            return false;
        }
        if (seconds == 0) {
            this.defaultTimeout.set(TMConfig.activeTO);
        } else {
            this.defaultTimeout.set(seconds * 1000);
        }
        logger.log(JeusMessage_TM2._4207_LEVEL, JeusMessage_TM2._4207, new Object[]{this.debugName, seconds});
        return true;
    }

    public final boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource instanceof TMXAResource;
    }

    public final Xid[] recover(int flag) throws XAException {
        Xid[] xids = TMServer.getIncompleteExternalXids();
        if (PREPARED_XIDS.size() > 0) {
            ArrayList<Xid> incompleteXids = new ArrayList<Xid>();
            incompleteXids.addAll(PREPARED_XIDS.values());
            for (int i = 0; i < xids.length; ++i) {
                incompleteXids.add(xids[i]);
            }
            return incompleteXids.toArray(new Xid[incompleteXids.size()]);
        }
        return xids;
    }

    public final int prepare(Xid xid) throws XAException {
        return this.prepare(xid, null);
    }

    public final int prepare(Xid xid, ResourceImpl rsc) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "prepare called for the xid : " + xid);
        }
        String xidString = XidToString.getGtidStringFromXid(xid);
        GTID gtid = null;
        TransactionState tx = XID_MAPPER.get(xidString);
        if (tx != null) {
            gtid = tx.getGtid();
        }
        if (PREPARED_XIDS.containsKey(xidString) || gtid == null) {
            return 3;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "xid " + xid + " mapped to the gtid " + gtid);
        }
        try {
            int response;
            RootCoordinator coord = this.getCoordinator(gtid, xid);
            if (coord == null) {
                response = 106;
            } else {
                coord.setOTSResource(rsc);
                response = Terminator.prepareForXA(coord);
            }
            switch (response) {
                case 0: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "return XA_OK for this xid : " + xid);
                    }
                    PREPARED_XIDS.put(xidString, xid);
                    return 0;
                }
                case 3: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "return XA_RONLY for this xid : " + xid);
                    }
                    XID_MAPPER.remove(xidString);
                    gtid.invalidate();
                    return 3;
                }
            }
            throw new XAException(response);
        }
        catch (XAException ex) {
            XID_MAPPER.remove(xidString);
            gtid.invalidate();
            throw ex;
        }
        catch (Throwable t) {
            XID_MAPPER.remove(xidString);
            gtid.invalidate();
            throw new XAException(-3);
        }
    }

    public final void forget(Xid xid) throws XAException {
        Xid preparedXid = PREPARED_XIDS.get(XidToString.getGtidStringFromXid(xid));
        if (preparedXid != null) {
            throw new XAException("cannot forget a prepared transaction");
        }
        try {
            TMServer.forgetIncompleteTx(xid);
        }
        catch (TMException e) {
            e.printStackTrace();
            throw new XAException(-3);
        }
    }

    public final void rollback(Xid xid) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "rollback called for the xid : " + xid);
        }
        String xidString = XidToString.getGtidStringFromXid(xid);
        if (TMServer.checkExternalXidIncompleted(xid)) {
            try {
                try {
                    TMServer.setGlobalDecisionForUncompletedExternalTransaction(xid, false);
                }
                catch (TMException e) {
                    if (logger.isLoggable(JeusMessage_TM2._4905_LEVEL)) {
                        logger.log(JeusMessage_TM2._4905_LEVEL, JeusMessage_TM2._4905, xid, (Throwable)e);
                    }
                    throw new XAException(e.getMessage());
                }
                Object var5_3 = null;
                XID_MAPPER.remove(xidString);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                XID_MAPPER.remove(xidString);
                PREPARED_XIDS.remove(xidString);
                throw throwable;
            }
            PREPARED_XIDS.remove(xidString);
            return;
        }
        GTID gtid = null;
        TransactionState tx = XID_MAPPER.get(xidString);
        if (tx != null) {
            gtid = tx.getGtid();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "xid " + xid + " mapped to the gtid " + gtid);
        }
        this.rollback(gtid, xid);
    }

    public final boolean isKnownXid(Xid xid) {
        boolean isKnownXid;
        GTID gtid = null;
        TransactionState tx = XID_MAPPER.get(XidToString.getGtidStringFromXid(xid));
        if (tx != null) {
            gtid = tx.getGtid();
        }
        boolean bl = isKnownXid = TMServer.checkExternalXidIncompleted(xid) || gtid != null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "check if the xid is started or recovered for JEUS : " + xid + ", isKnown : " + isKnownXid);
        }
        return isKnownXid;
    }

    private void rollback(GTID gtid, Xid xid) throws XAException {
        try {
            try {
                RootCoordinator coord = this.getCoordinator(gtid, xid);
                if (coord != null && Terminator.rollback(coord) == 4) {
                    throw new XAException(-7);
                }
                Object var5_6 = null;
            }
            catch (XAException xe) {
                throw xe;
            }
            catch (Throwable t) {
                throw new XAException(-3);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            String xidString = XidToString.getGtidStringFromXid(xid);
            XID_MAPPER.remove(xidString);
            PREPARED_XIDS.remove(xidString);
            throw throwable;
        }
        String xidString = XidToString.getGtidStringFromXid(xid);
        XID_MAPPER.remove(xidString);
        PREPARED_XIDS.remove(xidString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void end(Xid xid, int flags) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "end called for the xid : " + xid + ", and flag " + flags);
        }
        GTID gtid = null;
        Object object = IN_USE_LOCK;
        synchronized (object) {
            TransactionState tx = XID_MAPPER.get(XidToString.getGtidStringFromXid(xid));
            if (tx != null) {
                gtid = tx.getGtid();
                tx.unsetUse();
            }
        }
        if (flags == 0x20000000) {
            if (gtid != null) {
                this.rollback(gtid, xid);
            }
        } else {
            ThreadContexts.dissociateTransactionID();
        }
    }

    public final boolean begin(Xid xid) throws TMException, XAException {
        return this.begin(xid, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean begin(Xid xid, long txTimeout) throws TMException, XAException {
        boolean setTx;
        if (txTimeout <= 0L) {
            txTimeout = this.defaultTimeout.get();
        }
        logger.log(JeusMessage_TM2._4203_LEVEL, JeusMessage_TM2._4203, new Object[]{xid, txTimeout});
        String xidString = XidToString.getGtidStringFromXid(xid);
        GTID gtid = null;
        Object object = IN_USE_LOCK;
        synchronized (object) {
            TransactionState tx = XID_MAPPER.get(xidString);
            if (tx != null) {
                if (tx.isInUse()) {
                    throw new XAException(-8);
                }
                gtid = tx.getGtid();
            }
            if (gtid == null) {
                Coordinator coord;
                if (logger.isLoggable(JeusMessage_TM2._4204_LEVEL)) {
                    logger.logp(JeusMessage_TM2._4204_LEVEL, "ExternalTransactionManager", "begin", JeusMessage_TM2._4204);
                }
                try {
                    coord = ThreadContexts.getCurrentCoordinator();
                }
                catch (InvalidTransactionException ex) {
                    ex.printStackTrace();
                    coord = null;
                }
                if (coord != null) {
                    gtid = coord.getGTID();
                    Xid externalXidOfGTID = gtid.getExternalXid();
                    if (externalXidOfGTID != null && XidImpl.equalsXid(xid, externalXidOfGTID)) {
                        setTx = false;
                    } else {
                        ThreadContexts.dissociateTransactionID();
                        gtid = this.createTxForForeignTx(xid, txTimeout);
                        setTx = true;
                    }
                } else {
                    gtid = this.createTxForForeignTx(xid, txTimeout);
                    setTx = true;
                }
                XID_MAPPER.putIfAbsent(xidString, new TransactionState(gtid));
            } else {
                Coordinator coord;
                Coordinator prevCoordinator;
                if (logger.isLoggable(JeusMessage_TM2._4205_LEVEL)) {
                    logger.logp(JeusMessage_TM2._4205_LEVEL, "ExternalTransactionManager", "begin", JeusMessage_TM2._4205, (Object)xid);
                }
                if ((prevCoordinator = ThreadContexts.getCoordinator(gtid)) == null) {
                    throw new TMException("the gtid " + gtid + " is invalid, no coordinator");
                }
                try {
                    coord = ThreadContexts.getCurrentCoordinator();
                }
                catch (InvalidTransactionException ex) {
                    ex.printStackTrace();
                    coord = null;
                }
                if (coord == null || !gtid.equals(coord.getGTID())) {
                    TMServer.associateThread(gtid);
                    setTx = true;
                } else {
                    setTx = false;
                }
                if (tx != null) {
                    tx.setUse();
                }
            }
        }
        return setTx;
    }

    private GTID createTxForForeignTx(Xid xid, long txTimeout) throws TMException {
        try {
            TMServer.create(xid, txTimeout);
        }
        catch (NotSupportedException e) {
            ThreadContexts.dissociateTransactionID();
            try {
                TMServer.create(xid, txTimeout);
            }
            catch (NotSupportedException ne) {
                throw new TMException(ne);
            }
        }
        Coordinator coordinator = null;
        try {
            coordinator = TMServer.getCoordinator();
        }
        catch (InvalidTransactionException e) {
            throw new TMException(JeusMessage_TM2._4206, (Throwable)e);
        }
        if (coordinator == null) {
            throw new TMException("failed to get a coordinator. current thread has not transaction");
        }
        return coordinator.getGTID();
    }

    public final void start(Xid xid, int flags) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "start called for the xid : " + xid + ", and flag " + flags);
        }
        try {
            this.begin(xid, this.defaultTimeout.get());
        }
        catch (TMException e) {
            e.printStackTrace();
            throw new XAException(e.toString());
        }
    }

    public final void commit(Xid xid) throws TMException, XAException {
        String xidString = XidToString.getGtidStringFromXid(xid);
        if (TMServer.checkExternalXidIncompleted(xid)) {
            try {
                try {
                    TMServer.setGlobalDecisionForUncompletedExternalTransaction(xid, true);
                }
                catch (TMException e) {
                    if (logger.isLoggable(JeusMessage_TM2._4906_LEVEL)) {
                        logger.log(JeusMessage_TM2._4906_LEVEL, JeusMessage_TM2._4906, xid, (Throwable)e);
                    }
                    throw e;
                }
                Object var5_3 = null;
                XID_MAPPER.remove(xidString);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                XID_MAPPER.remove(xidString);
                PREPARED_XIDS.remove(xidString);
                throw throwable;
            }
            PREPARED_XIDS.remove(xidString);
            return;
        }
        try {
            this.commit(xid, !PREPARED_XIDS.containsKey(xidString));
        }
        catch (XAException e) {
            throw new TMException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void commit(Xid xid, boolean onePhase) throws XAException {
        String xidString;
        block15: {
            block14: {
                xidString = null;
                try {
                    RootCoordinator coord;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "commit called for xid " + xid + "with onePhaseCommit " + onePhase);
                    }
                    if (TMServer.checkExternalXidIncompleted(xid)) {
                        try {
                            TMServer.setGlobalDecisionForUncompletedExternalTransaction(xid, true);
                        }
                        catch (TMException e) {
                            if (!logger.isLoggable(JeusMessage_TM2._4906_LEVEL)) throw new XAException(e.getMessage());
                            logger.log(JeusMessage_TM2._4906_LEVEL, JeusMessage_TM2._4906, xid, (Throwable)e);
                            throw new XAException(e.getMessage());
                        }
                        Object var9_6 = null;
                        if (xidString == null) return;
                        XID_MAPPER.remove(xidString);
                        break block14;
                    }
                    xidString = XidToString.getGtidStringFromXid(xid);
                    GTID gtid = null;
                    TransactionState tx = XID_MAPPER.get(xidString);
                    if (tx != null) {
                        gtid = tx.getGtid();
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "xid " + xid + " mapped to the gtid " + gtid);
                    }
                    if ((coord = this.getCoordinator(gtid, xid)) == null) {
                        throw new XAException(-3);
                    }
                    if (!onePhase || coord.isPrepared()) {
                        if (Terminator.commitForXA(coord) != 0) {
                            throw new XAException(-3);
                        }
                        break block15;
                    }
                    try {
                        Terminator.commit(coord);
                        break block15;
                    }
                    catch (RollbackException e) {
                        throw new XAException(-3);
                    }
                    catch (HeuristicMixedException e) {
                        throw new XAException(-3);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    if (xidString == null) throw throwable;
                    XID_MAPPER.remove(xidString);
                    PREPARED_XIDS.remove(xidString);
                    throw throwable;
                }
            }
            PREPARED_XIDS.remove(xidString);
            return;
        }
        Object var9_7 = null;
        if (xidString == null) return;
        XID_MAPPER.remove(xidString);
        PREPARED_XIDS.remove(xidString);
    }

    private RootCoordinator getCoordinator(GTID gtid, Xid xid) throws XAException {
        if (gtid == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "start is not called for this xid : " + xid);
            }
            throw new XAException(-4);
        }
        return TMServer.getRootCoordinator(gtid.getLTID());
    }

    public long getDefaultTransactionTimeout() {
        return this.defaultTimeout.get();
    }

    public static void disconnectThreadContext() {
        TMServer.disconnectContext();
    }

    public static boolean contains(Xid xid) {
        return XID_MAPPER.containsKey(XidToString.getGtidStringFromXid(xid));
    }

    public static int getTxStatus(Xid xid) {
        GTID gtid = null;
        TransactionState tx = XID_MAPPER.get(XidToString.getGtidStringFromXid(xid));
        if (tx != null) {
            gtid = tx.getGtid();
        }
        if (gtid == null || gtid.isInvalid()) {
            return -1;
        }
        RootCoordinator coord = (RootCoordinator)ThreadContexts.getCoordinator(gtid);
        if (coord == null) {
            return -1;
        }
        return coord.getStatus();
    }

    public static TMXAResource getTMXAResource() {
        return tmxaResource;
    }

    private final class TransactionState {
        private GTID gtid;
        private boolean inUse;

        private TransactionState(GTID gtid) {
            this.gtid = gtid;
            this.setUse();
        }

        private void setUse() {
            this.inUse = true;
        }

        private void unsetUse() {
            this.inUse = false;
        }

        private GTID getGtid() {
            return this.gtid;
        }

        private boolean isInUse() {
            return this.inUse;
        }
    }
}

