/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.logging.Level;
import javax.transaction.HeuristicMixedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.JTAStatisticsProvider;
import jeus.transaction.TMException;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxStatus;
import jeus.transaction.root.RootCoordinator;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_TM3;
import jeus.util.properties.JeusTMProperties;

public final class Terminator {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void commit(RootCoordinator coord) throws IllegalStateException, RollbackException, HeuristicMixedException {
        try {
            if (coord == null) {
                if (logger.isLoggable(JeusMessage_TM3._5101_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5101_LEVEL, "Terminator", "commit", JeusMessage_TM3._5101);
                }
                try {
                    coord = (RootCoordinator)TMServer.getCoordinator();
                }
                catch (InvalidTransactionException e) {
                    if (!logger.isLoggable(JeusMessage_TM3._5102_LEVEL)) throw new IllegalStateException("this transaction is already timeout");
                    logger.logp(JeusMessage_TM3._5102_LEVEL, "Terminator", "commit", JeusMessage_TM3._5102);
                    throw new IllegalStateException("this transaction is already timeout");
                }
            } else if (logger.isLoggable(JeusMessage_TM3._5103_LEVEL)) {
                logger.logp(JeusMessage_TM3._5103_LEVEL, "Terminator", "commit", JeusMessage_TM3._5103, (Object)coord);
            }
            if (coord == null) {
                if (!logger.isLoggable(JeusMessage_TM3._5104_LEVEL)) throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM3._5104));
                logger.logp(JeusMessage_TM3._5104_LEVEL, "Terminator", "commit", JeusMessage_TM3._5104);
                throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM3._5104));
            }
            if (logger.isLoggable(JeusMessage_TM3._5105_LEVEL)) {
                logger.logp(JeusMessage_TM3._5105_LEVEL, "Terminator", "commit", JeusMessage_TM3._5105, (Object)coord.getGTID());
            }
            coord.cancelActiveTimer();
            try {
                coord.beforeCompletion();
            }
            catch (IllegalStateException ise) {
                if (logger.isLoggable(JeusMessage_TM3._5106_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5106_LEVEL, "Terminator", "commit", JeusMessage_TM3._5106, new String[]{"commit()", coord.getGTID().toString(), TxStatus.getState(coord.getStatus())}, (Throwable)ise);
                }
                TMServer.disconnectContext();
                throw new RollbackException(JeusMessageBundles.getMessage(JeusMessage_TM3._5125, TxStatus.getState(coord.getStatus())));
            }
            if (coord.isRollbackOnly()) {
                String message;
                boolean timedOut;
                GTID gtid = coord.getGTID();
                boolean bl = timedOut = gtid != null && gtid.isActiveTimedOut();
                if (logger.isLoggable(JeusMessage_TM3._5107_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5107_LEVEL, "Terminator", "commit", JeusMessage_TM3._5107, (Object[])new String[]{gtid == null ? "null" : gtid.toString(), String.valueOf(timedOut)});
                }
                try {
                    coord.rollback();
                }
                catch (IllegalStateException ise) {
                }
                catch (TMException e) {
                    // empty catch block
                }
                coord.destroy();
                if (timedOut) {
                    message = JeusMessageBundles.getMessage(JeusMessage_TM3._5406);
                    throw new RollbackException(message);
                }
                message = JeusMessageBundles.getMessage(JeusMessage_TM3._5410);
                throw new RollbackException(message);
            }
            int response = 0;
            block8 : switch (coord.getNumResources()) {
                case 0: {
                    if (logger.isLoggable(JeusMessage_TM3._5108_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5108_LEVEL, "Terminator", "commit", JeusMessage_TM3._5108, (Object)coord.getGTID());
                    }
                    try {
                        coord.afterCompletion(3);
                    }
                    catch (IllegalStateException e) {}
                    break;
                }
                case 1: {
                    if (!JeusTMProperties.USE_2PC_ALWAYS) {
                        if (logger.isLoggable(JeusMessage_TM3._5109_LEVEL)) {
                            logger.logp(JeusMessage_TM3._5109_LEVEL, "Terminator", "commit", JeusMessage_TM3._5109, (Object)coord.getGTID());
                        }
                        response = coord.onePhaseCommit();
                        break;
                    }
                }
                default: {
                    if (logger.isLoggable(JeusMessage_TM3._5110_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5110_LEVEL, "Terminator", "commit", JeusMessage_TM3._5110, (Object)coord.getGTID());
                    }
                    if (logger.isLoggable(JeusMessage_TM3._5111_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5111_LEVEL, "Terminator", "commit", JeusMessage_TM3._5111, (Object)coord.getGTID());
                    }
                    byte result = coord.prepare();
                    if (logger.isLoggable(JeusMessage_TM3._5112_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5112_LEVEL, "Terminator", "commit", JeusMessage_TM3._5112, new Object[]{coord.getGTID(), TxStatus.getState(result)});
                    }
                    switch (result) {
                        case 0: {
                            if (logger.isLoggable(JeusMessage_TM3._5113_LEVEL)) {
                                logger.logp(JeusMessage_TM3._5113_LEVEL, "Terminator", "commit", JeusMessage_TM3._5113, (Object)coord.getGTID());
                            }
                            try {
                                coord.commit();
                            }
                            catch (IllegalStateException ise) {
                                if (logger.isLoggable(JeusMessage_TM3._5106_LEVEL)) {
                                    logger.logp(JeusMessage_TM3._5106_LEVEL, "Terminator", "commit", JeusMessage_TM3._5106, new String[]{"commit()", coord.getGTID().toString(), TxStatus.getState(coord.getStatus())}, (Throwable)ise);
                                }
                                response = 4;
                                JTAStatisticsProvider.incrementIncompleteCommitCount();
                            }
                            catch (TMException e) {
                                response = 4;
                                JTAStatisticsProvider.incrementIncompleteCommitCount();
                            }
                            break block8;
                        }
                        case 1: {
                            if (logger.isLoggable(JeusMessage_TM3._5114_LEVEL)) {
                                logger.logp(JeusMessage_TM3._5114_LEVEL, "Terminator", "commit", JeusMessage_TM3._5114, (Object)coord.getGTID());
                            }
                            try {
                                coord.rollback();
                            }
                            catch (IllegalStateException ise) {
                            }
                            catch (TMException e) {
                                // empty catch block
                            }
                            response = 1;
                            break block8;
                        }
                        case 2: {
                            if (logger.isLoggable(JeusMessage_TM3._5115_LEVEL)) {
                                logger.logp(JeusMessage_TM3._5115_LEVEL, "Terminator", "commit", JeusMessage_TM3._5115, (Object)coord.getGTID());
                            }
                            try {
                                coord.afterCompletion(3);
                            }
                            catch (IllegalStateException illegalStateException) {}
                            break block8;
                        }
                    }
                }
            }
            if (logger.isLoggable(JeusMessage_TM3._5116_LEVEL)) {
                logger.logp(JeusMessage_TM3._5116_LEVEL, "Terminator", "commit", JeusMessage_TM3._5116, new Object[]{coord.getGTID(), TxStatus.getState((byte)response)});
            }
            coord.destroy();
            switch (response) {
                case 0: {
                    Object var5_16 = null;
                    break;
                }
                case 1: {
                    throw new RollbackException();
                }
                case 4: {
                    throw new HeuristicMixedException();
                }
                default: {
                    throw new IllegalStateException("jeus internal tx status(" + response + ") is unknown");
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_17 = null;
            ThreadContexts.dissociateTransactionID();
            throw throwable;
        }
        ThreadContexts.dissociateTransactionID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte rollback(Coordinator coord) throws IllegalStateException {
        byte by;
        try {
            byte result;
            if (coord == null) {
                if (logger.isLoggable(JeusMessage_TM3._5117_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5117_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5117);
                }
                try {
                    coord = TMServer.getCoordinator();
                }
                catch (InvalidTransactionException e) {
                    if (!logger.isLoggable(JeusMessage_TM3._5118_LEVEL)) throw new IllegalStateException("this transaction is already timeout");
                    logger.logp(JeusMessage_TM3._5118_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5118);
                    throw new IllegalStateException("this transaction is already timeout");
                }
            } else if (logger.isLoggable(JeusMessage_TM3._5119_LEVEL)) {
                logger.logp(JeusMessage_TM3._5119_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5119, (Object)coord);
            }
            if (coord == null) {
                if (!logger.isLoggable(JeusMessage_TM3._5120_LEVEL)) throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM3._5120));
                logger.logp(JeusMessage_TM3._5120_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5120);
                throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM3._5120));
            }
            if (logger.isLoggable(JeusMessage_TM3._5122_LEVEL)) {
                logger.logp(JeusMessage_TM3._5122_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5122, (Object)coord.getGTID());
            }
            coord.cancelActiveTimer();
            try {
                coord.rollback();
                result = 1;
            }
            catch (IllegalStateException ise) {
                if (logger.isLoggable(JeusMessage_TM3._5106_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5106_LEVEL, "Terminator", "rollback", JeusMessage_TM3._5106, new String[]{"rollback()", coord.getGTID().toString(), TxStatus.getState(coord.getStatus())}, (Throwable)ise);
                }
                TMServer.disconnectContext();
                byte by2 = 1;
                Object var5_7 = null;
                ThreadContexts.dissociateTransactionID();
                return by2;
            }
            catch (TMException e) {
                result = 4;
            }
            coord.destroy();
            by = result;
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            ThreadContexts.dissociateTransactionID();
            throw throwable;
        }
        ThreadContexts.dissociateTransactionID();
        return by;
    }

    public static byte prepareForXA(RootCoordinator coord) {
        if (coord == null) {
            return -4;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "prepareForXA called for the GTID " + coord.getGTID());
        }
        coord.cancelActiveTimer();
        try {
            coord.beforeCompletion();
        }
        catch (IllegalStateException ise) {
            if (logger.isLoggable(JeusMessage_TM3._5106_LEVEL)) {
                logger.logp(JeusMessage_TM3._5106_LEVEL, "Terminator", "prepareForXA", JeusMessage_TM3._5106, new String[]{"prepareForXA()", coord.getGTID().toString(), TxStatus.getState(coord.getStatus())}, (Throwable)ise);
            }
            TMServer.disconnectContext();
            return 106;
        }
        if (coord.isRollbackOnly()) {
            try {
                coord.rollback();
            }
            catch (IllegalStateException ise) {
            }
            catch (TMException e) {
                // empty catch block
            }
            coord.destroy();
            return 100;
        }
        switch (coord.getNumResources()) {
            case 0: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "No resource for this tx, prepareForXA result is READ_ONLY for the GTID " + coord.getGTID());
                }
                try {
                    coord.afterCompletion(3);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
                coord.destroy();
                return 3;
            }
        }
        byte result = coord.prepare();
        if (logger.isLoggable(JeusMessage_TM3._5124_LEVEL)) {
            logger.logp(JeusMessage_TM3._5124_LEVEL, "Terminator", "prepareForXA", JeusMessage_TM3._5124);
        }
        switch (result) {
            case 0: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "prepareForXA result is XA_OK for the GTID " + coord.getGTID());
                }
                return 0;
            }
            case 1: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "prepareForXA result is ROLLBACK for the GTID " + coord.getGTID());
                }
                try {
                    coord.rollback();
                }
                catch (IllegalStateException ise) {
                }
                catch (TMException e) {
                    // empty catch block
                }
                coord.destroy();
                return 100;
            }
            case 2: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "prepareForXA result is READ_ONLY for the GTID " + coord.getGTID());
                }
                try {
                    coord.afterCompletion(3);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                coord.destroy();
                return 3;
            }
        }
        return -3;
    }

    public static byte commitForXA(RootCoordinator coord) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "commitForXA called for the GTID " + coord.getGTID());
        }
        int response = 0;
        if (coord == null) {
            return 4;
        }
        coord.cancelActiveTimer();
        switch (coord.getNumResources()) {
            case 0: {
                try {
                    coord.afterCompletion(3);
                }
                catch (IllegalStateException e) {}
                break;
            }
            default: {
                try {
                    coord.commit();
                    break;
                }
                catch (IllegalStateException ise) {
                    if (logger.isLoggable(JeusMessage_TM3._5106_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5106_LEVEL, "Terminator", "commitForXA", JeusMessage_TM3._5106, new String[]{"commitForXA()", coord.getGTID().toString(), TxStatus.getState(coord.getStatus())}, (Throwable)ise);
                    }
                    response = 4;
                    JTAStatisticsProvider.incrementIncompleteCommitCount();
                    break;
                }
                catch (TMException e) {
                    response = 4;
                    JTAStatisticsProvider.incrementIncompleteCommitCount();
                }
            }
        }
        coord.destroy();
        return (byte)response;
    }
}

