/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.JeusSynchronization;
import jeus.transaction.JeusSystemException;
import jeus.transaction.TMException;
import jeus.transaction.Terminator;
import jeus.transaction.Transaction;
import jeus.transaction.resources.LocalResource;
import jeus.transaction.resources.LocalXAResourceWrapper;
import jeus.transaction.root.RootCoordinator;
import jeus.transaction.util.XidToString;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM3;
import jeus.util.properties.JeusTMProperties;

public final class TransactionImpl
implements Transaction {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    private final Coordinator coord;
    private final GTID gtid;
    private final Vector usedXARscs = new Vector(5);
    private final Vector usedXIDs = new Vector(5);
    private int hashcode = -2;
    private Map<Object, Object> transactionLocalMap = null;
    private LocalXAResourceWrapper resource = null;

    public TransactionImpl(Coordinator coord, GTID gtid) {
        int timeout = 0;
        if (coord != null) {
            timeout = coord.getTimeoutInSeconds();
        }
        if (logger.isLoggable(JeusMessage_TM3._5901_LEVEL)) {
            logger.logp(JeusMessage_TM3._5901_LEVEL, "TransactionImpl", "<init>", JeusMessage_TM3._5901, new Object[]{gtid, String.valueOf(timeout)});
        }
        this.coord = coord;
        this.gtid = gtid;
    }

    public final GTID getGTID() {
        if (logger.isLoggable(JeusMessage_TM3._5902_LEVEL)) {
            logger.logp(JeusMessage_TM3._5902_LEVEL, "TransactionImpl", "getGTID", JeusMessage_TM3._5902, (Object)this.gtid);
        }
        return this.gtid;
    }

    final Coordinator getCoordinator() {
        if (logger.isLoggable(JeusMessage_TM3._5903_LEVEL)) {
            logger.logp(JeusMessage_TM3._5903_LEVEL, "TransactionImpl", "getCoordinator", JeusMessage_TM3._5903, (Object)this.coord);
        }
        return this.coord;
    }

    public final int hashCode() {
        if (this.hashcode == -2) {
            this.hashcode = this.gtid == null ? -1 : this.gtid.hashCode();
        }
        return this.hashcode;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransactionImpl) {
            if (this.gtid == null) {
                return ((TransactionImpl)obj).gtid == null;
            }
            return this.gtid.equals(((TransactionImpl)obj).gtid);
        }
        return false;
    }

    public final void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        if (logger.isLoggable(JeusMessage_TM3._5904_LEVEL)) {
            logger.logp(JeusMessage_TM3._5904_LEVEL, "TransactionImpl", "commit", JeusMessage_TM3._5904, (Object)this);
        }
        if (this.coord == null) {
            if (logger.isLoggable(JeusMessage_TM3._5905_LEVEL)) {
                logger.logp(JeusMessage_TM3._5905_LEVEL, "TransactionImpl", "commit", JeusMessage_TM3._5905);
            }
            throw new JeusSystemException(JeusMessage_TM3._5905);
        }
        try {
            Terminator.commit((RootCoordinator)this.coord);
        }
        catch (RollbackException re) {
            if (logger.isLoggable(JeusMessage_TM3._5907_LEVEL)) {
                logger.logp(JeusMessage_TM3._5907_LEVEL, "TransactionImpl", "commit", JeusMessage_TM3._5907, (Throwable)re);
            }
            throw re;
        }
        catch (HeuristicMixedException hme) {
            if (logger.isLoggable(JeusMessage_TM3._5908_LEVEL)) {
                logger.logp(JeusMessage_TM3._5908_LEVEL, "TransactionImpl", "commit", JeusMessage_TM3._5908, (Throwable)hme);
            }
            throw hme;
        }
        if (logger.isLoggable(JeusMessage_TM3._5906_LEVEL)) {
            logger.logp(JeusMessage_TM3._5906_LEVEL, "TransactionImpl", "commit", JeusMessage_TM3._5906);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean delistResource(XAResource xaRsc, int flag) throws IllegalStateException, SystemException {
        if (logger.isLoggable(JeusMessage_TM3._5909_LEVEL)) {
            logger.logp(JeusMessage_TM3._5909_LEVEL, "TransactionImpl", "delistResource", JeusMessage_TM3._5909, new Object[]{xaRsc, this});
        }
        if (this.coord == null) {
            if (logger.isLoggable(JeusMessage_TM3._5910_LEVEL)) {
                logger.logp(JeusMessage_TM3._5910_LEVEL, "TransactionImpl", "delistResource", JeusMessage_TM3._5910);
            }
            throw new JeusSystemException(JeusMessage_TM3._5910);
        }
        Xid xid = this.coord.getXidFromXAResource(xaRsc);
        if (xid == null) {
            if (logger.isLoggable(JeusMessage_TM3._5911_LEVEL)) {
                logger.logp(JeusMessage_TM3._5911_LEVEL, "TransactionImpl", "delistResource", JeusMessage_TM3._5911, (Object)xaRsc);
            }
            throw new JeusSystemException(JeusMessage_TM3._5911, xaRsc.toString());
        }
        try {
            XAResource xAResource = xaRsc;
            synchronized (xAResource) {
                if (logger.isLoggable(JeusMessage_TM3._5912_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5912_LEVEL, "TransactionImpl", "delistResource", JeusMessage_TM3._5912, (Object)xaRsc);
                }
                xaRsc.end(xid, flag);
            }
        }
        catch (XAException ex) {
            if (logger.isLoggable(JeusMessage_TM3._5913_LEVEL)) {
                logger.logp(JeusMessage_TM3._5913_LEVEL, "TransactionImpl", "delistResource", JeusMessage_TM3._5913, new Object[]{xaRsc, new Integer(ex.errorCode)}, (Throwable)ex);
            }
            throw new JeusSystemException(JeusMessage_TM3._5913, new String[]{xaRsc.toString(), String.valueOf(ex.errorCode)}, (Throwable)ex);
        }
        boolean suspend = false;
        if (flag == 0x2000000) {
            suspend = true;
        }
        Vector vector = this.usedXARscs;
        synchronized (vector) {
            if (logger.isLoggable(JeusMessage_TM3._5914_LEVEL)) {
                logger.logp(JeusMessage_TM3._5914_LEVEL, "TransactionImpl", "delistResource", JeusMessage_TM3._5914, new Object[]{xaRsc, xid});
            }
            this.usedXARscs.add(xaRsc);
            this.usedXIDs.add(new XIDInfo(xid, suspend));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean enlistResource(XAResource xaRsc) throws RollbackException, IllegalStateException, SystemException {
        if (logger.isLoggable(JeusMessage_TM3._5915_LEVEL)) {
            logger.logp(JeusMessage_TM3._5915_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5915, new Object[]{xaRsc, this});
        }
        if (this.coord == null) {
            if (logger.isLoggable(JeusMessage_TM3._5916_LEVEL)) {
                logger.logp(JeusMessage_TM3._5916_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5916);
            }
            throw new JeusSystemException(JeusMessage_TM3._5916);
        }
        if (this.coord.isRollbackOnly()) {
            if (logger.isLoggable(JeusMessage_TM3._5917_LEVEL)) {
                logger.logp(JeusMessage_TM3._5917_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5917, (Object)this.coord);
            }
            throw new RollbackException(ErrorMsgManager.getLocalizedString(JeusMessage_TM3._5917, this.coord));
        }
        Xid xid = null;
        int flag = 0;
        XAResource reusedRsc = null;
        Object object = this.usedXARscs;
        synchronized (object) {
            if (!JeusTMProperties.DISABLE_JOIN) {
                int len = this.usedXARscs.size();
                for (int i = 0; i < len; ++i) {
                    if (logger.isLoggable(JeusMessage_TM3._5918_LEVEL)) {
                        logger.logp(JeusMessage_TM3._5918_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5918);
                    }
                    XAResource xa = (XAResource)this.usedXARscs.elementAt(i);
                    try {
                        if (!xa.isSameRM(xaRsc)) continue;
                        XIDInfo info = (XIDInfo)this.usedXIDs.elementAt(i);
                        xid = info.xid;
                        if (logger.isLoggable(JeusMessage_TM3._5919_LEVEL)) {
                            logger.logp(JeusMessage_TM3._5919_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5919, new Object[]{xa, xid});
                        }
                        if (info.suspend) {
                            if (logger.isLoggable(JeusMessage_TM3._5920_LEVEL)) {
                                logger.logp(JeusMessage_TM3._5920_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5920);
                            }
                            flag = 0x8000000;
                        } else {
                            if (logger.isLoggable(JeusMessage_TM3._5921_LEVEL)) {
                                logger.logp(JeusMessage_TM3._5921_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5921);
                            }
                            flag = 0x200000;
                        }
                        this.usedXARscs.remove(i);
                        this.usedXIDs.remove(i);
                        reusedRsc = xa;
                        break;
                    }
                    catch (Throwable ex) {
                        if (!logger.isLoggable(JeusMessage_TM3._5922_LEVEL)) continue;
                        logger.logp(JeusMessage_TM3._5922_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5922, ex);
                    }
                }
            }
            if (xid == null) {
                if (logger.isLoggable(JeusMessage_TM3._5923_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5923_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5923, (Object)xaRsc);
                }
                xid = this.coord.createXID();
            }
        }
        if (logger.isLoggable(JeusMessage_TM3._5926_LEVEL)) {
            logger.logp(JeusMessage_TM3._5926_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5926, (Object)xaRsc);
        }
        try {
            object = xaRsc;
            synchronized (object) {
                xaRsc.start(xid, flag);
            }
        }
        catch (XAException ex) {
            Object[] params = new String[]{xaRsc.toString(), XidToString.getXAErrorCode(ex.errorCode)};
            logger.logp(JeusMessage_TM3._5927_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5927, params, (Throwable)ex);
            throw new JeusSystemException(JeusMessage_TM3._5927, params, (Throwable)ex);
        }
        if (reusedRsc == null) {
            if (logger.isLoggable(JeusMessage_TM3._5928_LEVEL)) {
                logger.logp(JeusMessage_TM3._5928_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5928, (Object)xaRsc);
            }
            this.coord.registerResource(new LocalResource(xaRsc, xid, false, this.coord));
        } else {
            if (logger.isLoggable(JeusMessage_TM3._5929_LEVEL)) {
                logger.logp(JeusMessage_TM3._5929_LEVEL, "TransactionImpl", "enlistResource", JeusMessage_TM3._5929, (Object)xaRsc);
            }
            LocalResource rsc = this.coord.getLocalResource(reusedRsc);
            rsc.setXAResource(xaRsc);
        }
        return true;
    }

    public final int getStatus() {
        if (this.coord == null) {
            return 6;
        }
        return this.coord.getStatus();
    }

    public final void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (logger.isLoggable(JeusMessage_TM3._5933_LEVEL)) {
            logger.logp(JeusMessage_TM3._5933_LEVEL, "TransactionImpl", "registerSynchronization", JeusMessage_TM3._5933, new Object[]{sync, this});
        }
        if (this.coord == null) {
            if (logger.isLoggable(JeusMessage_TM3._5934_LEVEL)) {
                logger.logp(JeusMessage_TM3._5934_LEVEL, "TransactionImpl", "registerSynchronization", JeusMessage_TM3._5934);
            }
            if (sync instanceof JeusSynchronization) {
                if (logger.isLoggable(JeusMessage_TM3._5935_LEVEL)) {
                    logger.logp(JeusMessage_TM3._5935_LEVEL, "TransactionImpl", "registerSynchronization", JeusMessage_TM3._5935);
                }
                ((JeusSynchronization)sync).resetTransaction();
            }
            throw new JeusSystemException(JeusMessage_TM3._5934);
        }
        this.coord.registerSynchronization(sync);
        if (logger.isLoggable(JeusMessage_TM3._5936_LEVEL)) {
            logger.logp(JeusMessage_TM3._5936_LEVEL, "TransactionImpl", "registerSynchronization", JeusMessage_TM3._5936, (Object)this);
        }
    }

    public final void rollback() throws IllegalStateException, SystemException {
        if (logger.isLoggable(JeusMessage_TM3._5937_LEVEL)) {
            logger.logp(JeusMessage_TM3._5937_LEVEL, "TransactionImpl", "rollback", JeusMessage_TM3._5937, (Object)this);
        }
        if (this.coord == null) {
            if (logger.isLoggable(JeusMessage_TM3._5938_LEVEL)) {
                logger.logp(JeusMessage_TM3._5938_LEVEL, "TransactionImpl", "rollback", JeusMessage_TM3._5938);
            }
            throw new JeusSystemException(JeusMessage_TM3._5938);
        }
        Terminator.rollback(this.coord);
        if (logger.isLoggable(JeusMessage_TM3._5939_LEVEL)) {
            logger.logp(JeusMessage_TM3._5939_LEVEL, "TransactionImpl", "rollback", JeusMessage_TM3._5939, (Object)this);
        }
    }

    public final void setRollbackOnly() throws IllegalStateException, SystemException {
        if (logger.isLoggable(JeusMessage_TM3._5940_LEVEL)) {
            logger.logp(JeusMessage_TM3._5940_LEVEL, "TransactionImpl", "setRollbackOnly", JeusMessage_TM3._5940, (Object)this);
        }
        if (this.coord == null) {
            if (logger.isLoggable(JeusMessage_TM3._5941_LEVEL)) {
                logger.logp(JeusMessage_TM3._5941_LEVEL, "TransactionImpl", "setRollbackOnly", JeusMessage_TM3._5941);
            }
            throw new JeusSystemException(JeusMessage_TM3._5941);
        }
        this.coord.setRollbackOnly();
        if (logger.isLoggable(JeusMessage_TM3._5942_LEVEL)) {
            logger.logp(JeusMessage_TM3._5942_LEVEL, "TransactionImpl", "setRollbackOnly", JeusMessage_TM3._5942, (Object)this);
        }
    }

    public final void clear() {
        if (logger.isLoggable(JeusMessage_TM3._5943_LEVEL)) {
            logger.logp(JeusMessage_TM3._5943_LEVEL, "TransactionImpl", "clear", JeusMessage_TM3._5943);
        }
        this.usedXARscs.clear();
        this.usedXIDs.clear();
        if (logger.isLoggable(JeusMessage_TM3._5944_LEVEL)) {
            logger.logp(JeusMessage_TM3._5944_LEVEL, "TransactionImpl", "clear", JeusMessage_TM3._5944);
        }
    }

    public final void setLocalXAResource(LocalXAResourceWrapper xaRsc) {
        if (logger.isLoggable(JeusMessage_TM3._5945_LEVEL)) {
            logger.log(JeusMessage_TM3._5945_LEVEL, JeusMessage_TM3._5945, (Object)this);
        }
        if (this.resource != null) {
            if (logger.isLoggable(JeusMessage_TM3._5946_LEVEL)) {
                logger.logp(JeusMessage_TM3._5946_LEVEL, "TransactionImpl", "setLocalXAResource", JeusMessage_TM3._5946);
            }
            throw new JeusRuntimeException(JeusMessage_TM3._5946);
        }
        this.resource = xaRsc;
        if (logger.isLoggable(JeusMessage_TM3._5947_LEVEL)) {
            logger.log(JeusMessage_TM3._5947_LEVEL, JeusMessage_TM3._5947, new Object[]{xaRsc, this.coord});
        }
        this.coord.registerResource(new LocalResource(xaRsc, null, true, this.coord));
        if (logger.isLoggable(JeusMessage_TM3._5948_LEVEL)) {
            logger.log(JeusMessage_TM3._5948_LEVEL, JeusMessage_TM3._5948, (Object)this.coord);
        }
    }

    public final LocalXAResourceWrapper getLocalXAResource() {
        if (logger.isLoggable(JeusMessage_TM3._5949_LEVEL)) {
            logger.log(JeusMessage_TM3._5949_LEVEL, JeusMessage_TM3._5949, new Object[]{this.resource, this});
        }
        return this.resource;
    }

    public final void enlistLocalXAResource(LocalXAResourceWrapper resource) throws XAException {
        if (logger.isLoggable(JeusMessage_TM3._5952_LEVEL)) {
            logger.log(JeusMessage_TM3._5952_LEVEL, JeusMessage_TM3._5952, new Object[]{resource, this});
        }
        this.setLocalXAResource(resource);
        resource.start(null, 0);
    }

    public final String toString() {
        if (this.gtid == null) {
            return "null transaction";
        }
        return "Transaction" + this.gtid;
    }

    public final void flush() throws TMException {
        if (logger.isLoggable(JeusMessage_TM3._5954_LEVEL)) {
            logger.logp(JeusMessage_TM3._5954_LEVEL, "TransactionImpl", "flush", JeusMessage_TM3._5954, (Object)this.coord);
        }
        this.coord.flush();
        if (logger.isLoggable(JeusMessage_TM3._5955_LEVEL)) {
            logger.logp(JeusMessage_TM3._5955_LEVEL, "TransactionImpl", "flush", JeusMessage_TM3._5955, (Object)this.coord);
        }
    }

    Map getLocalMap() {
        if (this.transactionLocalMap == null) {
            this.transactionLocalMap = new HashMap<Object, Object>();
        }
        return this.transactionLocalMap;
    }

    public byte[] getGlobalTransactionId() {
        if (this.gtid != null) {
            Xid externalXid = this.gtid.getExternalXid();
            if (externalXid != null) {
                return externalXid.getGlobalTransactionId();
            }
            return this.gtid.toBytes();
        }
        return new byte[0];
    }

    public long getElapseSinceBegin() {
        if (this.coord != null) {
            return this.coord.getElapseSinceBegin();
        }
        throw new IllegalStateException("this transaction is not associated with a coordinator");
    }

    public long getRemainingTimeout() {
        if (this.coord != null) {
            return this.coord.getRemainingTimeout();
        }
        throw new IllegalStateException("this transaction is not associated with a coordinator");
    }

    public long getTimeout() {
        if (this.coord != null) {
            return this.coord.getTimeout();
        }
        throw new IllegalStateException("this transaction is not associated with a coordinator");
    }

    public boolean isTimedOut() {
        if (this.gtid != null) {
            return this.gtid.isActiveTimedOut();
        }
        return false;
    }

    public static final class XIDInfo {
        public final Xid xid;
        public final boolean suspend;

        public XIDInfo(Xid xid, boolean suspend) {
            this.xid = xid;
            this.suspend = suspend;
        }
    }
}

