/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.logging.Level;
import javax.transaction.HeuristicMixedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.JeusSystemException;
import jeus.transaction.TMException;
import jeus.transaction.TMNotAvailableException;
import jeus.transaction.TMServer;
import jeus.transaction.Terminator;
import jeus.transaction.ThreadContexts;
import jeus.transaction.Transaction;
import jeus.transaction.TransactionImpl;
import jeus.transaction.TransactionManager;
import jeus.transaction.XAResourceFactory;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM4;

public final class TransactionManagerImpl
implements TransactionManager {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    public static final TransactionManagerImpl txManager = new TransactionManagerImpl();

    protected TransactionManagerImpl() {
        if (logger.isLoggable(JeusMessage_TM4._6001_LEVEL)) {
            logger.logp(JeusMessage_TM4._6001_LEVEL, "TransactionManagerImpl", "<init>", JeusMessage_TM4._6001);
        }
    }

    public final void begin() throws NotSupportedException, SystemException {
        if (logger.isLoggable(JeusMessage_TM4._6002_LEVEL)) {
            logger.logp(JeusMessage_TM4._6002_LEVEL, "TransactionManagerImpl", "begin", JeusMessage_TM4._6002);
        }
        try {
            TMServer.create(ThreadContexts.getNextTimeout());
        }
        catch (TMNotAvailableException e) {
            throw new SystemException(e.toString());
        }
        if (logger.isLoggable(JeusMessage_TM4._6003_LEVEL)) {
            logger.logp(JeusMessage_TM4._6003_LEVEL, "TransactionManagerImpl", "begin", JeusMessage_TM4._6003);
        }
    }

    public final void registerResource(String name, XAResourceFactory factory) throws TMException {
        TMServer.registerXAResourceReference(factory, name);
    }

    public final void commit() throws RollbackException, HeuristicMixedException, SecurityException, IllegalStateException {
        if (logger.isLoggable(JeusMessage_TM4._6004_LEVEL)) {
            logger.logp(JeusMessage_TM4._6004_LEVEL, "TransactionManagerImpl", "commit", JeusMessage_TM4._6004);
        }
        try {
            Terminator.commit(null);
        }
        catch (RollbackException re) {
            if (logger.isLoggable(JeusMessage_TM4._6006_LEVEL)) {
                logger.logp(JeusMessage_TM4._6006_LEVEL, "TransactionManagerImpl", "commit", JeusMessage_TM4._6006, (Throwable)re);
            }
            throw re;
        }
        catch (HeuristicMixedException hme) {
            if (logger.isLoggable(JeusMessage_TM4._6007_LEVEL)) {
                logger.logp(JeusMessage_TM4._6007_LEVEL, "TransactionManagerImpl", "commit", JeusMessage_TM4._6007, (Throwable)hme);
            }
            throw hme;
        }
        if (logger.isLoggable(JeusMessage_TM4._6005_LEVEL)) {
            logger.logp(JeusMessage_TM4._6005_LEVEL, "TransactionManagerImpl", "commit", JeusMessage_TM4._6005);
        }
    }

    public final int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return 6;
        }
        return tx.getStatus();
    }

    public final Transaction getTransaction() {
        Coordinator coord;
        if (logger.isLoggable(JeusMessage_TM4._6012_LEVEL)) {
            logger.logp(JeusMessage_TM4._6012_LEVEL, "TransactionManagerImpl", "getTransaction", JeusMessage_TM4._6012);
        }
        try {
            coord = TMServer.getCoordinator();
        }
        catch (InvalidTransactionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "TransactionManagerImpl", "getTransaction", JeusMessage_TM4._6013, Thread.currentThread(), (Throwable)e);
            } else if (logger.isLoggable(JeusMessage_TM4._6013_LEVEL)) {
                logger.logp(JeusMessage_TM4._6013_LEVEL, "TransactionManagerImpl", "getTransaction", JeusMessage_TM4._6013, (Object)Thread.currentThread());
            }
            return null;
        }
        if (coord == null) {
            if (logger.isLoggable(JeusMessage_TM4._6014_LEVEL)) {
                logger.logp(JeusMessage_TM4._6014_LEVEL, "TransactionManagerImpl", "getTransaction", JeusMessage_TM4._6014, (Object)Thread.currentThread());
            }
            return null;
        }
        if (logger.isLoggable(JeusMessage_TM4._6015_LEVEL)) {
            logger.logp(JeusMessage_TM4._6015_LEVEL, "TransactionManagerImpl", "getTransaction", JeusMessage_TM4._6015);
        }
        return coord.getTransaction();
    }

    public final void resume(javax.transaction.Transaction tx) throws InvalidTransactionException, IllegalStateException {
        GTID gtid;
        if (logger.isLoggable(JeusMessage_TM4._6016_LEVEL)) {
            logger.logp(JeusMessage_TM4._6016_LEVEL, "TransactionManagerImpl", "resume", JeusMessage_TM4._6016, (Object)tx);
        }
        if ((gtid = ThreadContexts.getAssociatedTransactionID()) != null && !gtid.isInvalid()) {
            if (logger.isLoggable(JeusMessage_TM4._6017_LEVEL)) {
                logger.logp(JeusMessage_TM4._6017_LEVEL, "TransactionManagerImpl", "resume", JeusMessage_TM4._6017, (Object)Thread.currentThread());
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM4._6017, Thread.currentThread()));
        }
        if (tx != null) {
            gtid = ((TransactionImpl)tx).getGTID();
            if (gtid == null || gtid.isInvalid()) {
                if (logger.isLoggable(JeusMessage_TM4._6018_LEVEL)) {
                    logger.logp(JeusMessage_TM4._6018_LEVEL, "TransactionManagerImpl", "resume", JeusMessage_TM4._6018, (Object)Thread.currentThread());
                }
                throw new InvalidTransactionException(ErrorMsgManager.getLocalizedString(JeusMessage_TM4._6018, Thread.currentThread()));
            }
            TMServer.associateThread(gtid);
            if (logger.isLoggable(JeusMessage_TM4._6019_LEVEL)) {
                logger.logp(JeusMessage_TM4._6019_LEVEL, "TransactionManagerImpl", "resume", JeusMessage_TM4._6019);
            }
        }
    }

    public final void rollback() throws IllegalStateException, SecurityException {
        if (logger.isLoggable(JeusMessage_TM4._6020_LEVEL)) {
            logger.logp(JeusMessage_TM4._6020_LEVEL, "TransactionManagerImpl", "rollback", JeusMessage_TM4._6020);
        }
        Terminator.rollback(null);
        if (logger.isLoggable(JeusMessage_TM4._6021_LEVEL)) {
            logger.logp(JeusMessage_TM4._6021_LEVEL, "TransactionManagerImpl", "rollback", JeusMessage_TM4._6021);
        }
    }

    public final void setRollbackOnly() throws IllegalStateException {
        Coordinator coord;
        if (logger.isLoggable(JeusMessage_TM4._6022_LEVEL)) {
            logger.logp(JeusMessage_TM4._6022_LEVEL, "TransactionManagerImpl", "setRollbackOnly", JeusMessage_TM4._6022);
        }
        try {
            coord = TMServer.getCoordinator();
        }
        catch (InvalidTransactionException e) {
            if (logger.isLoggable(JeusMessage_TM4._6023_LEVEL)) {
                logger.logp(JeusMessage_TM4._6023_LEVEL, "TransactionManagerImpl", "setRollbackOnly", JeusMessage_TM4._6023, (Object)Thread.currentThread());
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM4._6023, Thread.currentThread()));
        }
        if (coord == null) {
            if (logger.isLoggable(JeusMessage_TM4._6024_LEVEL)) {
                logger.logp(JeusMessage_TM4._6024_LEVEL, "TransactionManagerImpl", "setRollbackOnly", JeusMessage_TM4._6024, (Object)Thread.currentThread());
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM4._6024, Thread.currentThread()));
        }
        coord.setRollbackOnly();
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        Coordinator coord;
        if (logger.isLoggable(JeusMessage_TM4._6114_LEVEL)) {
            logger.logp(JeusMessage_TM4._6114_LEVEL, "UserTransactionImpl", "getRollbackOnly", JeusMessage_TM4._6114);
        }
        try {
            coord = TMServer.getCoordinator();
        }
        catch (InvalidTransactionException e) {
            if (logger.isLoggable(JeusMessage_TM4._6115_LEVEL)) {
                logger.logp(JeusMessage_TM4._6115_LEVEL, "UserTransactionImpl", "getRollbackOnly", JeusMessage_TM4._6115, (Object)Thread.currentThread());
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM4._6115, Thread.currentThread()));
        }
        if (coord == null) {
            if (logger.isLoggable(JeusMessage_TM4._6116_LEVEL)) {
                logger.logp(JeusMessage_TM4._6116_LEVEL, "UserTransactionImpl", "getRollbackOnly", JeusMessage_TM4._6116, (Object)Thread.currentThread());
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM4._6116, Thread.currentThread()));
        }
        boolean rollback = coord.isRollbackOnly();
        if (logger.isLoggable(JeusMessage_TM4._6117_LEVEL)) {
            logger.logp(JeusMessage_TM4._6117_LEVEL, "UserTransactionImpl", "getRollbackOnly", JeusMessage_TM4._6117, (Object)(rollback ? "not " : ""));
        }
        return rollback;
    }

    public final void setTransactionTimeout(int seconds) throws SystemException {
        if (logger.isLoggable(JeusMessage_TM4._6025_LEVEL)) {
            logger.logp(JeusMessage_TM4._6025_LEVEL, "TransactionManagerImpl", "setTransactionTimeout", JeusMessage_TM4._6025, (Object)String.valueOf(seconds));
        }
        if (seconds < 0) {
            throw new JeusSystemException(JeusMessage_TM4._6026, String.valueOf(seconds));
        }
        ThreadContexts.setNextTimeout(seconds * 1000);
    }

    public final Transaction suspend() {
        Coordinator coord;
        if (logger.isLoggable(JeusMessage_TM4._6028_LEVEL)) {
            logger.logp(JeusMessage_TM4._6028_LEVEL, "TransactionManagerImpl", "suspend", JeusMessage_TM4._6028);
        }
        if ((coord = TMServer.dissociateThread()) == null) {
            if (logger.isLoggable(JeusMessage_TM4._6029_LEVEL)) {
                logger.log(JeusMessage_TM4._6029_LEVEL, JeusMessage_TM4._6029, (Object)Thread.currentThread());
            }
            return null;
        }
        if (logger.isLoggable(JeusMessage_TM4._6030_LEVEL)) {
            logger.logp(JeusMessage_TM4._6030_LEVEL, "TransactionManagerImpl", "suspend", JeusMessage_TM4._6030);
        }
        return coord.getTransaction();
    }

    public static TransactionManagerImpl getTransactionManager() {
        return txManager;
    }
}

