/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.io.Serializable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import jeus.transaction.Coordinator;
import jeus.transaction.TMNotAvailableException;
import jeus.transaction.TMServer;
import jeus.transaction.Terminator;
import jeus.transaction.ThreadContexts;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM4;

public final class UserTransactionImpl
implements UserTransaction,
Serializable {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    protected static final UserTransactionImpl userTx = new UserTransactionImpl();

    protected UserTransactionImpl() {
        if (logger.isLoggable(JeusMessage_TM4._6101_LEVEL)) {
            logger.logp(JeusMessage_TM4._6101_LEVEL, "UserTransactionImpl", "<init>", JeusMessage_TM4._6101);
        }
    }

    public final void begin() throws NotSupportedException, SystemException {
        if (logger.isLoggable(JeusMessage_TM4._6102_LEVEL)) {
            logger.logp(JeusMessage_TM4._6102_LEVEL, "UserTransactionImpl", "begin", JeusMessage_TM4._6102);
        }
        try {
            TMServer.create(ThreadContexts.getNextTimeout());
        }
        catch (TMNotAvailableException e) {
            throw new SystemException(e.toString());
        }
        if (logger.isLoggable(JeusMessage_TM4._6103_LEVEL)) {
            logger.logp(JeusMessage_TM4._6103_LEVEL, "UserTransactionImpl", "begin", JeusMessage_TM4._6103);
        }
    }

    public final void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (logger.isLoggable(JeusMessage_TM4._6104_LEVEL)) {
            logger.logp(JeusMessage_TM4._6104_LEVEL, "UserTransactionImpl", "commit", JeusMessage_TM4._6104);
        }
        try {
            Terminator.commit(null);
        }
        catch (RollbackException re) {
            if (logger.isLoggable(JeusMessage_TM4._6106_LEVEL)) {
                logger.logp(JeusMessage_TM4._6106_LEVEL, "UserTransactionImpl", "commit", JeusMessage_TM4._6106, (Throwable)re);
            }
            throw re;
        }
        catch (HeuristicMixedException hme) {
            if (logger.isLoggable(JeusMessage_TM4._6107_LEVEL)) {
                logger.logp(JeusMessage_TM4._6107_LEVEL, "UserTransactionImpl", "commit", JeusMessage_TM4._6107, (Throwable)hme);
            }
            throw hme;
        }
        if (logger.isLoggable(JeusMessage_TM4._6105_LEVEL)) {
            logger.logp(JeusMessage_TM4._6105_LEVEL, "UserTransactionImpl", "commit", JeusMessage_TM4._6105);
        }
    }

    public final void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (logger.isLoggable(JeusMessage_TM4._6108_LEVEL)) {
            logger.logp(JeusMessage_TM4._6108_LEVEL, "UserTransactionImpl", "rollback", JeusMessage_TM4._6108);
        }
        Terminator.rollback(null);
        if (logger.isLoggable(JeusMessage_TM4._6109_LEVEL)) {
            logger.logp(JeusMessage_TM4._6109_LEVEL, "UserTransactionImpl", "rollback", JeusMessage_TM4._6109);
        }
    }

    public final void setRollbackOnly() throws IllegalStateException {
        Coordinator coord;
        if (logger.isLoggable(JeusMessage_TM4._6110_LEVEL)) {
            logger.logp(JeusMessage_TM4._6110_LEVEL, "UserTransactionImpl", "setRollbackOnly", JeusMessage_TM4._6110);
        }
        try {
            coord = TMServer.getCoordinator();
        }
        catch (InvalidTransactionException e) {
            if (logger.isLoggable(JeusMessage_TM4._6111_LEVEL)) {
                logger.logp(JeusMessage_TM4._6111_LEVEL, "UserTransactionImpl", "setRollbackOnly", JeusMessage_TM4._6111, (Object)Thread.currentThread());
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM4._6111, Thread.currentThread()));
        }
        if (coord == null) {
            if (logger.isLoggable(JeusMessage_TM4._6112_LEVEL)) {
                logger.logp(JeusMessage_TM4._6112_LEVEL, "UserTransactionImpl", "setRollbackOnly", JeusMessage_TM4._6112, (Object)Thread.currentThread());
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM4._6112, Thread.currentThread()));
        }
        coord.setRollbackOnly();
        if (logger.isLoggable(JeusMessage_TM4._6113_LEVEL)) {
            logger.logp(JeusMessage_TM4._6113_LEVEL, "UserTransactionImpl", "setRollbackOnly", JeusMessage_TM4._6113);
        }
    }

    public static boolean getRollbackOnly() throws IllegalStateException {
        Coordinator coord;
        if (logger.isLoggable(JeusMessage_TM4._6114_LEVEL)) {
            logger.logp(JeusMessage_TM4._6114_LEVEL, "UserTransactionImpl", "getRollbackOnly", JeusMessage_TM4._6114);
        }
        try {
            coord = TMServer.getCoordinator();
        }
        catch (InvalidTransactionException e) {
            if (logger.isLoggable(JeusMessage_TM4._6115_LEVEL)) {
                logger.logp(JeusMessage_TM4._6115_LEVEL, "UserTransactionImpl", "getRollbackOnly", JeusMessage_TM4._6115, (Object)Thread.currentThread());
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM4._6115, Thread.currentThread()));
        }
        if (coord == null) {
            if (logger.isLoggable(JeusMessage_TM4._6116_LEVEL)) {
                logger.logp(JeusMessage_TM4._6116_LEVEL, "UserTransactionImpl", "getRollbackOnly", JeusMessage_TM4._6116, (Object)Thread.currentThread());
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString(JeusMessage_TM4._6116, Thread.currentThread()));
        }
        boolean rollback = coord.isRollbackOnly();
        if (logger.isLoggable(JeusMessage_TM4._6117_LEVEL)) {
            logger.logp(JeusMessage_TM4._6117_LEVEL, "UserTransactionImpl", "getRollbackOnly", JeusMessage_TM4._6117, (Object)(rollback ? "not " : ""));
        }
        return rollback;
    }

    public final int getStatus() {
        Coordinator coord;
        try {
            coord = TMServer.getCoordinator();
        }
        catch (InvalidTransactionException e) {
            if (logger.isLoggable(JeusMessage_TM4._6119_LEVEL)) {
                logger.logp(JeusMessage_TM4._6119_LEVEL, "UserTransactionImpl", "getStatus", JeusMessage_TM4._6119, (Object)Thread.currentThread());
            }
            return 6;
        }
        if (coord == null) {
            return 6;
        }
        return coord.getStatus();
    }

    public final void setTransactionTimeout(int seconds) throws SystemException {
        if (logger.isLoggable(JeusMessage_TM4._6122_LEVEL)) {
            logger.logp(JeusMessage_TM4._6122_LEVEL, "UserTransactionImpl", "setTransactionTimeout", JeusMessage_TM4._6122, (Object)String.valueOf(seconds));
        }
        if (seconds < 0) {
            if (logger.isLoggable(JeusMessage_TM4._6123_LEVEL)) {
                logger.logp(JeusMessage_TM4._6123_LEVEL, "UserTransactionImpl", "setTransactionTimeout", JeusMessage_TM4._6123, (Object)String.valueOf(seconds));
            }
            throw new SystemException(ErrorMsgManager.getLocalizedString(JeusMessage_TM4._6123, String.valueOf(seconds)));
        }
        ThreadContexts.setNextTimeout(seconds * 1000);
    }
}

