/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.client;

import javax.transaction.xa.Xid;
import jeus.transaction.ContextSenderReceiver;
import jeus.transaction.GTID;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxStatus;
import jeus.transaction.collector.OnePCommitResponseCollector;
import jeus.util.ByteUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;
import jeus.util.message.JeusMessage_TM0;

public final class RemoteGTID
extends GTID {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    private boolean unspecified = true;
    private boolean isRollbackOnly;
    private final long deadline;
    private boolean isActive = true;
    private byte[] propagationCtx;
    public final OnePCommitResponseCollector collector = new OnePCommitResponseCollector();
    public static final int SIZE_TX_TIMEOUT = 4;
    private static final int SIZE_LENGTH = 1;
    private static final int SIZE_FORMAT_ID = 4;
    private static final int SIZE_TX_CONTEXT_TYPE = 1;
    public static final int SIZE_UNSPECIFIED_GTID = 5;

    public RemoteGTID(Xid xid, long timeout) {
        super(xid);
        if (logger.isLoggable(JeusMessage_TM0._1201_LEVEL)) {
            logger.logp(JeusMessage_TM0._1201_LEVEL, "RemoteGTID", "<init>", JeusMessage_TM0._1201);
        }
        this.deadline = timeout;
        if (logger.isLoggable(JeusMessage_TM0._1202_LEVEL)) {
            logger.logp(JeusMessage_TM0._1202_LEVEL, "RemoteGTID", "<init>", JeusMessage_TM0._1202, (Object)String.valueOf(timeout));
        }
    }

    public boolean isUnspecified() {
        if (logger.isLoggable(JeusMessage_TM0._1206_LEVEL)) {
            logger.logp(JeusMessage_TM0._1206_LEVEL, "RemoteGTID", "isUnspecified", JeusMessage_TM0._1206, (Object)this);
        }
        if (logger.isLoggable(JeusMessage_TM0._1207_LEVEL)) {
            logger.logp(JeusMessage_TM0._1207_LEVEL, "RemoteGTID", "isUnspecified", JeusMessage_TM0._1207, (Object)(this.unspecified ? "not " : ""));
        }
        return this.unspecified;
    }

    public void specifyGTID(byte[] ctx) {
        if (logger.isLoggable(JeusMessage_TM0._1208_LEVEL)) {
            logger.logp(JeusMessage_TM0._1208_LEVEL, "RemoteGTID", "specifyGTID", JeusMessage_TM0._1208, (Object)Utility.getDump(ctx));
        }
        this.propagationCtx = ctx;
        this.setGTID(ctx);
        this.unspecified = false;
    }

    public boolean isRollbackOnly() {
        if (logger.isLoggable(JeusMessage_TM0._1209_LEVEL)) {
            logger.logp(JeusMessage_TM0._1209_LEVEL, "RemoteGTID", "isRollbackOnly", JeusMessage_TM0._1209, (Object)this);
        }
        if (logger.isLoggable(JeusMessage_TM0._1210_LEVEL)) {
            logger.logp(JeusMessage_TM0._1210_LEVEL, "RemoteGTID", "isRollbackOnly", JeusMessage_TM0._1210, (Object)(this.isRollbackOnly ? "" : "not "));
        }
        return this.isRollbackOnly;
    }

    public void setRollbackOnly() {
        if (logger.isLoggable(JeusMessage_TM0._1211_LEVEL)) {
            logger.logp(JeusMessage_TM0._1211_LEVEL, "RemoteGTID", "setRollbackOnly", JeusMessage_TM0._1211);
        }
        this.isRollbackOnly = true;
    }

    public int getStatus() {
        int status = this.isActive ? (this.isRollbackOnly ? 1 : 0) : (this.isRollbackOnly ? 9 : 8);
        if (logger.isLoggable(JeusMessage_TM0._1217_LEVEL)) {
            logger.logp(JeusMessage_TM0._1217_LEVEL, "RemoteGTID", "getStatus", JeusMessage_TM0._1217, new Object[]{this, TxStatus.getState(status)});
        }
        return status;
    }

    public byte[] getPropagationContext() {
        if (logger.isLoggable(JeusMessage_TM0._1218_LEVEL)) {
            logger.logp(JeusMessage_TM0._1218_LEVEL, "RemoteGTID", "getPropagationContext", JeusMessage_TM0._1218, (Object)this);
        }
        if (this.invalid) {
            return ContextSenderReceiver.nullTxBytes;
        }
        if (this.unspecified) {
            byte[] temp;
            if (this.externalXid != null) {
                temp = new byte[6 + this.externalXid.getGlobalTransactionId().length + 1 + this.externalXid.getBranchQualifier().length + 4];
                temp[0] = -3;
                int offset = 5;
                offset = this.writeByteArray(this.externalXid.getGlobalTransactionId(), temp, offset);
                offset = this.writeByteArray(this.externalXid.getBranchQualifier(), temp, offset);
                ByteUtil.putInt(temp, offset, this.externalXid.getFormatId());
            } else {
                temp = new byte[5];
                temp[0] = -2;
            }
            ByteUtil.putInt(temp, 1, this.deadline > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.deadline);
            if (logger.isLoggable(JeusMessage_TM0._1220_LEVEL)) {
                logger.logp(JeusMessage_TM0._1220_LEVEL, "RemoteGTID", "getPropagationContext", JeusMessage_TM0._1220, (Object)Utility.getDump(temp));
            }
            return temp;
        }
        if (logger.isLoggable(JeusMessage_TM0._1221_LEVEL)) {
            logger.logp(JeusMessage_TM0._1221_LEVEL, "RemoteGTID", "getPropagationContext", JeusMessage_TM0._1221, (Object)Utility.getDump(this.propagationCtx));
        }
        return this.propagationCtx;
    }

    private int writeByteArray(byte[] globalTransactionId, byte[] temp, int offset) {
        temp[offset] = (byte)globalTransactionId.length;
        System.arraycopy(globalTransactionId, 0, temp, ++offset, globalTransactionId.length);
        return offset += globalTransactionId.length;
    }

    public void setGTID(byte[] id) {
        this.setGTID(id, 2);
    }

    public String toString() {
        if (this.unspecified) {
            return "Unspecified";
        }
        return super.toString();
    }

    public void invalidate() {
        super.invalidate();
        ThreadContexts.dissociateTransactionID();
    }
}

