/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.comm;

import java.util.HashMap;
import javax.naming.Reference;
import jeus.jndi.objectfactory.SerializableRefAddr;
import jeus.transaction.RecoveryThread;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.TxStatus;
import jeus.transaction.comm.TMLinkManager;
import jeus.transaction.logging.CoordinatorXAResourceFactory;
import jeus.transaction.root.CoordinatorResource;
import jeus.transaction.root.RootCoordinator;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM0;
import jeus.util.message.JeusMessage_TM1;
import jeus.util.message.JeusMessage_TM2;

final class SubCoordinatorProxy {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    private final TMLinkManager manager;
    private static final HashMap coordinatorResourceMap = new HashMap();

    public SubCoordinatorProxy(TMLinkManager manager) {
        if (logger.isLoggable(JeusMessage_TM0._2901_LEVEL)) {
            logger.logp(JeusMessage_TM0._2901_LEVEL, "SubCoordinatorProxy", "<init>", JeusMessage_TM0._2901);
        }
        this.manager = manager;
    }

    public void registerResource(long ltid, TMInfo tmServer, boolean needAck) {
        if (logger.isLoggable(JeusMessage_TM0._2902_LEVEL)) {
            logger.logp(JeusMessage_TM0._2902_LEVEL, "SubCoordinatorProxy", "registerResource", JeusMessage_TM0._2902, new Object[]{tmServer, this.manager.getGTID(ltid)});
        }
        CoordinatorResource resource = this.getCoordinatorResource(tmServer);
        RootCoordinator coord = TMServer.getRootCoordinator(ltid);
        if (coord == null) {
            if (logger.isLoggable(JeusMessage_TM0._2903_LEVEL)) {
                logger.logp(JeusMessage_TM0._2903_LEVEL, "SubCoordinatorProxy", "registerResource", JeusMessage_TM0._2903, (Object)this.manager.getGTID(ltid));
            }
            if (needAck) {
                this.sendRegAck(resource, ltid, false);
            }
            return;
        }
        if (logger.isLoggable(JeusMessage_TM2._4001_LEVEL)) {
            logger.logp(JeusMessage_TM2._4001_LEVEL, "CoordinatorResource", "<init>", JeusMessage_TM2._4001, new Object[]{tmServer, this.manager.getGTID(ltid)});
        }
        boolean result = coord.registerSubCoordinatorResource(resource, needAck);
        if (needAck) {
            this.sendRegAck(resource, ltid, result);
        }
        if (logger.isLoggable(JeusMessage_TM0._2904_LEVEL)) {
            logger.logp(JeusMessage_TM0._2904_LEVEL, "SubCoordinatorProxy", "registerResource", JeusMessage_TM0._2904, (Object)tmServer);
        }
    }

    private void sendRegAck(CoordinatorResource resource, long ltid, boolean result) {
        block3: {
            if (logger.isLoggable(JeusMessage_TM1._3609_LEVEL)) {
                logger.logp(JeusMessage_TM1._3609_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3609, new Object[]{resource, String.valueOf(ltid), String.valueOf(result)});
            }
            try {
                resource.registered(ltid, result);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_TM1._3610_LEVEL)) break block3;
                logger.logp(JeusMessage_TM1._3610_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3610, new Object[]{resource, String.valueOf(ltid)}, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinatorResource getCoordinatorResource(TMInfo tmServer) {
        CoordinatorResource resource;
        HashMap hashMap = coordinatorResourceMap;
        synchronized (hashMap) {
            resource = (CoordinatorResource)coordinatorResourceMap.get(tmServer);
            if (resource == null) {
                TMInfo rootTmServer = this.manager.getMyInfo();
                resource = new CoordinatorResource(tmServer, rootTmServer);
                Reference ref = SubCoordinatorProxy.makeCoordinatorResourceReference(tmServer, rootTmServer);
                String exportName = "SubCoordinatorResource-" + tmServer;
                TMServer.registerXAResourceReference(new CoordinatorXAResourceFactory(ref), exportName);
                coordinatorResourceMap.put(tmServer, resource);
            }
        }
        return resource;
    }

    private static Reference makeCoordinatorResourceReference(TMInfo subTmServer, TMInfo rootTmServer) {
        Reference ref = new Reference("jeus.transaction.CoordinatorResource", "jeus.transaction.CoordinatorResourceFactory", null);
        ref.add(0, new SerializableRefAddr("tmInfo", subTmServer));
        if (rootTmServer != null) {
            ref.add(1, new SerializableRefAddr("rootTmInfo", rootTmServer));
        }
        return ref;
    }

    public void prepareResponse(long ltid, TMInfo subCoord, byte response) {
        RootCoordinator coord;
        if (logger.isLoggable(JeusMessage_TM0._2905_LEVEL)) {
            logger.logp(JeusMessage_TM0._2905_LEVEL, "SubCoordinatorProxy", "prepareResponse", JeusMessage_TM0._2905, new Object[]{subCoord, TxStatus.getState(response)});
        }
        if ((coord = TMServer.getRootCoordinator(ltid)) == null) {
            if (logger.isLoggable(JeusMessage_TM0._2906_LEVEL)) {
                logger.logp(JeusMessage_TM0._2906_LEVEL, "SubCoordinatorProxy", "prepareResponse", JeusMessage_TM0._2906, (Object)this.manager.getGTID(ltid));
            }
            try {
                this.manager.getLink(subCoord).rollback(ltid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        coord.prepareResponse(subCoord, response);
    }

    public void replayCompletion(TMInfo subTmServer) {
        if (logger.isLoggable(JeusMessage_TM0._2907_LEVEL)) {
            logger.logp(JeusMessage_TM0._2907_LEVEL, "SubCoordinatorProxy", "replayCompletion", JeusMessage_TM0._2907, (Object)subTmServer);
        }
        Reference ref = SubCoordinatorProxy.makeCoordinatorResourceReference(subTmServer, this.manager.getMyInfo());
        RecoveryThread t = new RecoveryThread(new CoordinatorXAResourceFactory(ref));
        t.setDaemon(true);
        t.start();
    }

    public void commitResponse(long ltid, TMInfo tmInfo, boolean done) {
        RootCoordinator coord;
        if (logger.isLoggable(JeusMessage_TM0._2914_LEVEL)) {
            logger.logp(JeusMessage_TM0._2914_LEVEL, "SubCoordinatorProxy", "commitResponse", JeusMessage_TM0._2914, (Object)(done ? "done" : "fail"));
        }
        if ((coord = TMServer.getRootCoordinator(ltid)) == null) {
            if (logger.isLoggable(JeusMessage_TM0._2915_LEVEL)) {
                logger.logp(JeusMessage_TM0._2915_LEVEL, "SubCoordinatorProxy", "commitResponse", JeusMessage_TM0._2915, (Object)this.manager.getGTID(ltid));
            }
            return;
        }
        coord.commitResponse(tmInfo, done);
    }

    public void onePhaseCommitResponse(long ltid, byte response) {
        RootCoordinator coord;
        if (logger.isLoggable(JeusMessage_TM0._2916_LEVEL)) {
            logger.logp(JeusMessage_TM0._2916_LEVEL, "SubCoordinatorProxy", "onePhaseCommitResponse", JeusMessage_TM0._2916, (Object)TxStatus.getState(response));
        }
        if ((coord = TMServer.getRootCoordinator(ltid)) == null) {
            if (logger.isLoggable(JeusMessage_TM0._2917_LEVEL)) {
                logger.logp(JeusMessage_TM0._2917_LEVEL, "SubCoordinatorProxy", "onePhaseCommitResponse", JeusMessage_TM0._2917, (Object)this.manager.getGTID(ltid));
            }
            return;
        }
        coord.onePhaseCommitResponse(response);
    }

    public void commitLocalXAResourceResponse(long ltid, boolean commit) {
        RootCoordinator coord;
        if (logger.isLoggable(JeusMessage_TM0._2918_LEVEL)) {
            logger.logp(JeusMessage_TM0._2918_LEVEL, "SubCoordinatorProxy", "commitLocalXAResourceResponse", JeusMessage_TM0._2918, new Object[]{commit, this.manager.getGTID(ltid)});
        }
        if ((coord = TMServer.getRootCoordinator(ltid)) == null) {
            if (logger.isLoggable(JeusMessage_TM0._2919_LEVEL)) {
                logger.logp(JeusMessage_TM0._2919_LEVEL, "SubCoordinatorProxy", "commitLocalXAResourceResponse", JeusMessage_TM0._2919, (Object)this.manager.getGTID(ltid));
            }
            return;
        }
        coord.commitLocalXAResourceResponse(commit);
    }

    public void beforeCompletionResponse(long ltid, byte response) {
        RootCoordinator coord;
        if (logger.isLoggable(JeusMessage_TM0._2920_LEVEL)) {
            logger.logp(JeusMessage_TM0._2920_LEVEL, "SubCoordinatorProxy", "beforeCompletionResponse", JeusMessage_TM0._2920, (Object)TxStatus.getState(response));
        }
        if ((coord = TMServer.getRootCoordinator(ltid)) == null) {
            if (logger.isLoggable(JeusMessage_TM0._2921_LEVEL)) {
                logger.logp(JeusMessage_TM0._2921_LEVEL, "SubCoordinatorProxy", "beforeCompletionResponse", JeusMessage_TM0._2921, (Object)this.manager.getGTID(ltid));
            }
            return;
        }
        coord.beforeCompletionResponse(response);
    }

    public void flushResponse(long ltid, byte b) {
        RootCoordinator coord;
        if (logger.isLoggable(JeusMessage_TM0._2922_LEVEL)) {
            logger.logp(JeusMessage_TM0._2922_LEVEL, "SubCoordinatorProxy", "flushResponse", JeusMessage_TM0._2922, (Object)TxStatus.getState(b));
        }
        if ((coord = TMServer.getRootCoordinator(ltid)) == null) {
            if (logger.isLoggable(JeusMessage_TM0._2923_LEVEL)) {
                logger.logp(JeusMessage_TM0._2923_LEVEL, "SubCoordinatorProxy", "flushResponse", JeusMessage_TM0._2923, (Object)this.manager.getGTID(ltid));
            }
            return;
        }
        coord.flushResponse(b);
    }

    public void requestFlush(long ltid, TMInfo tmServer) {
        block8: {
            RootCoordinator coord;
            if (logger.isLoggable(JeusMessage_TM0._2924_LEVEL)) {
                logger.logp(JeusMessage_TM0._2924_LEVEL, "SubCoordinatorProxy", "requestFlush", JeusMessage_TM0._2924, (Object)tmServer);
            }
            if ((coord = TMServer.getRootCoordinator(ltid)) == null) {
                if (logger.isLoggable(JeusMessage_TM0._2925_LEVEL)) {
                    logger.logp(JeusMessage_TM0._2925_LEVEL, "SubCoordinatorProxy", "requestFlush", JeusMessage_TM0._2925, (Object)this.manager.getGTID(ltid));
                }
                return;
            }
            byte response = 0;
            try {
                coord.flush();
            }
            catch (TMException ex) {
                response = 1;
            }
            if (logger.isLoggable(JeusMessage_TM0._2926_LEVEL)) {
                logger.logp(JeusMessage_TM0._2926_LEVEL, "SubCoordinatorProxy", "requestFlush", JeusMessage_TM0._2926, (Object)TxStatus.getState(response));
            }
            try {
                this.manager.getLink(tmServer).flushRequestResponse(ltid, response);
            }
            catch (Exception ex) {
                if (!logger.isLoggable(JeusMessage_TM0._2927_LEVEL)) break block8;
                logger.logp(JeusMessage_TM0._2927_LEVEL, "SubCoordinatorProxy", "requestFlush", JeusMessage_TM0._2927, tmServer, (Throwable)ex);
            }
        }
    }
}

