/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.comm;

import javax.transaction.HeuristicMixedException;
import javax.transaction.RollbackException;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.Terminator;
import jeus.transaction.root.RootCoordinator;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM0;

final class TMClientProxy {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");

    TMClientProxy() {
    }

    public static void remoteCommit(long ltid, boolean isCommit, TMInfo socketID) {
        block13: {
            if (logger.isLoggable(JeusMessage_TM0._1401_LEVEL)) {
                logger.logp(JeusMessage_TM0._1401_LEVEL, "TMClientProxy", "remoteCommit", JeusMessage_TM0._1401, new Object[]{socketID, isCommit ? "commit" : "rollback", String.valueOf(ltid)});
            }
            try {
                byte response;
                RootCoordinator coord = TMServer.getRootCoordinator(ltid);
                if (coord == null) {
                    if (logger.isLoggable(JeusMessage_TM0._1402_LEVEL)) {
                        logger.logp(JeusMessage_TM0._1402_LEVEL, "TMClientProxy", "remoteCommit", JeusMessage_TM0._1402);
                    }
                    response = 1;
                } else if (isCommit) {
                    try {
                        Terminator.commit(coord);
                        response = 0;
                    }
                    catch (RollbackException e) {
                        response = 1;
                    }
                    catch (HeuristicMixedException e) {
                        response = 4;
                    }
                } else {
                    response = Terminator.rollback(coord);
                }
                TMServer.getLink(socketID).remoteCommitResponse(ltid, response);
            }
            catch (TMException tms) {
                if (logger.isLoggable(JeusMessage_TM0._1403_LEVEL)) {
                    logger.logp(JeusMessage_TM0._1403_LEVEL, "TMClientProxy", "remoteCommit", JeusMessage_TM0._1403, socketID, (Throwable)tms);
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_TM0._1404_LEVEL)) break block13;
                logger.logp(JeusMessage_TM0._1404_LEVEL, "TMClientProxy", "remoteCommit", JeusMessage_TM0._1404, new Object[]{isCommit ? "committing" : "rolling back", String.valueOf(ltid)}, t);
            }
        }
    }

    public static void remoteXAPrepare(long ltid, TMInfo socketID) {
        block3: {
            if (logger.isLoggable(JeusMessage_TM0._1405_LEVEL)) {
                logger.logp(JeusMessage_TM0._1405_LEVEL, "TMClientProxy", "remoteXAPrepare", JeusMessage_TM0._1405);
            }
            try {
                RootCoordinator coord = TMServer.getRootCoordinator(ltid);
                byte response = coord == null ? (byte)106 : (byte)Terminator.prepareForXA(coord);
                TMServer.getLink(socketID).remoteCommitResponse(ltid, response);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_TM0._1406_LEVEL)) break block3;
                logger.logp(JeusMessage_TM0._1406_LEVEL, "TMClientProxy", "remoteXAPrepare", JeusMessage_TM0._1406, t);
            }
        }
    }

    public static void remoteXACommit(long ltid, boolean isCommit, TMInfo socketID) {
        block3: {
            if (logger.isLoggable(JeusMessage_TM0._1407_LEVEL)) {
                logger.logp(JeusMessage_TM0._1407_LEVEL, "TMClientProxy", "remoteXACommit", JeusMessage_TM0._1407);
            }
            try {
                RootCoordinator coord = TMServer.getRootCoordinator(ltid);
                byte response = coord == null ? (byte)1 : (isCommit ? Terminator.commitForXA(coord) : Terminator.rollback(coord));
                TMServer.getLink(socketID).remoteCommitResponse(ltid, response);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_TM0._1408_LEVEL)) break block3;
                logger.logp(JeusMessage_TM0._1408_LEVEL, "TMClientProxy", "remoteXACommit", JeusMessage_TM0._1408, t);
            }
        }
    }
}

