/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.comm;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import javax.management.ObjectName;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.io.protocol.message.ContentHandlerCreator;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.ConnectorException;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.net.impl.SocketStream14;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.comm.RootCoordinatorProxy;
import jeus.transaction.comm.SubCoordinatorProxy;
import jeus.transaction.comm.TMLink;
import jeus.util.PooledExecutorFactory;
import jeus.util.ThreadPoolExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM1;
import jeus.util.properties.JeusNetProperties;

public final class TMLinkManager
implements ConnectionListenerFactory {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    private static final String CLIENT_WORKER_POOL_NAME = "TMLink.Client";
    private static final String SERVER_WORKER_POOL_NAME = "TMLink.Server";
    private static final int CONNECTION_TRY_COUNT = 3;
    private static final int CONNECTION_CONNECT_TIMEOUT = JeusNetProperties.CONNECT_TIMEOUT;
    private static final int CONNECTION_READ_TIMEOUT = 20000;
    protected static final int backlog = 1000;
    private int port;
    private final boolean isNonBlocking;
    protected ObjectName parentName;
    private TMInfo myInfo;
    ThreadPoolExecutor pooledExecutorServer;
    ThreadPoolExecutor pooledExecutorClient;
    RootCoordinatorProxy rootProxy;
    SubCoordinatorProxy subProxy;
    private Endpoint endPoint;
    public static final int TM_PROTOCOL_VERSION = 1;

    public TMLinkManager(boolean isNonBlocking) {
        this.isNonBlocking = isNonBlocking;
    }

    public final int init(byte[] ipaddr, int port, int startPort, int starttime, int conId, int size, int max, long resizingPeriod) throws IOException {
        if (logger.isLoggable(JeusMessage_TM1._3203_LEVEL)) {
            logger.logp(JeusMessage_TM1._3203_LEVEL, "TMLinkManager", "init", JeusMessage_TM1._3203, new Object[]{String.valueOf(port), String.valueOf(size), String.valueOf(max), String.valueOf(resizingPeriod)});
        }
        this.rootProxy = new RootCoordinatorProxy(this);
        this.subProxy = new SubCoordinatorProxy(this);
        this.pooledExecutorServer = (ThreadPoolExecutor)PooledExecutorFactory.createThreadPoolExecutor(SERVER_WORKER_POOL_NAME, size, max, resizingPeriod);
        this.pooledExecutorClient = (ThreadPoolExecutor)PooledExecutorFactory.createThreadPoolExecutor(CLIENT_WORKER_POOL_NAME, size, max, resizingPeriod);
        if (port <= 0) {
            port = this.getAvailablePort(ipaddr, starttime, startPort);
        } else {
            this.myInfo = new TMInfo(ipaddr, port, starttime, conId);
            String name = "TMLinkManager";
            this.endPoint = new Endpoint(name, this.isNonBlocking ? JeusIOComponentCreator.DEFAULT_CREATOR : JeusIOComponentCreator.createBlockingCreator("IO-" + name, 0), (SocketID)this.myInfo, new ContentHandlerCreator(), this, null);
            this.endPoint.export();
        }
        this.port = port;
        if (logger.isLoggable(JeusMessage_TM1._3209_LEVEL)) {
            logger.logp(JeusMessage_TM1._3209_LEVEL, "TMLinkManager", "export", JeusMessage_TM1._3209, (Object)this.myInfo);
        }
        return port;
    }

    private int getAvailablePort(byte[] ipaddr, int starttime, int startPort) throws TMException {
        int index;
        if (startPort <= 0) {
            throw new TMException("startPort must be initialized");
        }
        if (logger.isLoggable(JeusMessage_TM1._3205_LEVEL)) {
            logger.logp(JeusMessage_TM1._3205_LEVEL, "TMLinkManager", "getAvailablePort", JeusMessage_TM1._3205, (Object)String.valueOf(startPort));
        }
        this.myInfo = new TMInfo(ipaddr, 0, starttime, -1);
        String name = "TMLinkManager";
        Endpoint point = new Endpoint(name, this.isNonBlocking ? JeusIOComponentCreator.DEFAULT_CREATOR : JeusIOComponentCreator.createBlockingCreator("IO-" + name, 0), (SocketID)this.myInfo, new ContentHandlerCreator(), this, null);
        for (index = 0; index < 256; ++index) {
            try {
                int port = startPort + index;
                if (port < 65535) {
                    this.myInfo.setPort(port);
                    point.setPort(this.myInfo);
                    point.export();
                    if (logger.isLoggable(JeusMessage_TM1._3208_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3208_LEVEL, "TMLinkManager", "getAvailablePort", JeusMessage_TM1._3208, (Object)String.valueOf(port));
                    }
                    this.endPoint = point;
                    return port;
                }
                break;
            }
            catch (UnknownHostException uhe) {
                throw new TMException(JeusMessage_TM1._3244, this.myInfo.toString(), (Throwable)uhe);
            }
            catch (IOException se) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(JeusMessage_TM1._3206_LEVEL, "TMLinkManager", "getAvailablePort", JeusMessage_TM1._3206, String.valueOf(this.port), (Throwable)se);
                    continue;
                }
                if (!logger.isLoggable(JeusMessage_TM1._3206_LEVEL)) continue;
                logger.logp(JeusMessage_TM1._3206_LEVEL, "TMLinkManager", "getAvailablePort", JeusMessage_TM1._3206, (Object)String.valueOf(this.port));
                continue;
            }
            catch (Throwable t) {
                throw new TMException("an unexpected error occurred", t);
            }
        }
        throw new TMException(JeusMessage_TM1._3207, new String[]{String.valueOf(startPort), String.valueOf(index)});
    }

    public final void unexport() {
        if (logger.isLoggable(JeusMessage_TM1._3210_LEVEL)) {
            logger.logp(JeusMessage_TM1._3210_LEVEL, "TMLinkManager", "unexport", JeusMessage_TM1._3210);
        }
        this.pooledExecutorServer.shutdownNow();
        this.pooledExecutorClient.shutdownNow();
        this.endPoint.unexport();
        if (this.myInfo.getVirtualID() == null && !this.isNonBlocking) {
            try {
                Socket s = new Socket("localhost", this.port);
                s.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public final TMLink getLink(TMInfo tmServer) throws ConnectorException {
        SocketStream14 sockStream14 = (SocketStream14)this.endPoint.getSocketStream(tmServer, 3, new Integer(1), CONNECTION_CONNECT_TIMEOUT, 20000);
        return (TMLink)sockStream14.getListener();
    }

    public final String getGTID(long ltid) {
        return this.myInfo.getGTID(ltid);
    }

    public final String toString() {
        return this.myInfo.toString();
    }

    public final ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        return new TMLink(this);
    }

    public final TMInfo getMyInfo() {
        return this.myInfo;
    }
}

