/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import javax.naming.Reference;
import javax.transaction.xa.XAResource;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.root.CoordinatorResource;

public final class CoordinatorXAResourceFactory
implements XAResourceFactory {
    static final long serialVersionUID = 5474365987848680389L;
    protected final Reference ref;
    protected transient XAResource xaResource;

    public CoordinatorXAResourceFactory(Reference ref) {
        this.ref = ref;
    }

    public synchronized XAResource getXAResource() throws Exception {
        if (this.xaResource == null) {
            if (this.ref == null) {
                throw new TMException("CoordinatorXAResourceFactory's Reference must be initialized");
            }
            TMInfo tmServer = (TMInfo)this.ref.get(0).getContent();
            TMInfo rootTmServer = null;
            if (this.ref.size() > 1) {
                rootTmServer = (TMInfo)this.ref.get(1).getContent();
            }
            TMServer.getLink(tmServer);
            this.xaResource = new CoordinatorResource(tmServer, rootTmServer);
        }
        return this.xaResource;
    }

    public synchronized void close(XAResource xaResource) {
        this.xaResource = null;
    }
}

