/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import jeus.transaction.GTID;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.ThreadContexts;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.XidImpl;
import jeus.transaction.external.OTSXid;
import jeus.transaction.logging.IncompletedTx;
import jeus.transaction.logging.LogManager;
import jeus.transaction.logging.ReferenceInfo;
import jeus.transaction.logging.SubCoordinatorXidContainer;
import jeus.transaction.logging.TxRecoveryDelegator;
import jeus.transaction.ots.OTSRecoveryThread;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.sub.SubCoordinator;
import jeus.transaction.util.XidToString;
import jeus.util.ByteUtil;
import jeus.util.JeusBootstrapProperties;
import jeus.util.OS;
import jeus.util.Serializer;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_OTS0;
import jeus.util.message.JeusMessage_TMRecovery0;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.ReplayListener;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogRecord;
import org.objectweb.howl.log.xa.XALogger;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions._RecoveryCoordinatorStub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HowlLogManager
extends LogManager {
    private static final byte XA_RESOURCE_LOG = 0;
    private static final byte COMMIT_LOG = 1;
    private static final byte EXTERNAL_PREPARE_LOG = 2;
    private static final byte OTS_PREPARE_LOG = 3;
    private static final byte[] XA_RESOURCE_LOG_ARRAY = new byte[]{0};
    private static final byte[] COMMIT_LOG_ARRAY = new byte[]{1};
    private static final byte[] EXTERNAL_PREPARE_LOG_ARRAY = new byte[]{2};
    private static final byte[] OTS_PREPARE_LOG_ARRAY = new byte[]{3};
    private static final int COMMIT_LOG_LENGTH = 3;
    private static final int EXTERNAL_PREPARE_LENGTH = 6;
    private static final int OTS_PREPARE_LENGTH = 7;
    private XALogger xaLog;
    private byte[] startTimeBytes;
    private final Hashtable<Long, XACommittingTx> committingTxMap = new Hashtable();
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction.recovery");
    private static final Serializer serializer = new Serializer();
    private final SubCoordinatorXidContainer subXidContainer = new SubCoordinatorXidContainer();
    private long serverStartTime;
    private XALogger resourceLog;
    private boolean running = false;
    private String name;
    private static final byte[] DUMMY_BYTES = new byte[0];
    private static final String CONTAINER_NAME_SEPARATOR = "_LOCATION_";
    protected final TxRecoveryDelegator txRecoveryDelegator;
    protected final String logDir;
    protected final TMInfo tmServer;
    protected OTSRecoveryThread otsRecoveryThread;
    private final List<ResourceItem> deferredResourcesForRegister = new ArrayList<ResourceItem>();
    private final java.lang.Object deferredResourcesForRegisterLock = new java.lang.Object();

    public HowlLogManager(String name, TMInfo tmServer, String logDir) {
        File tempDirFile;
        this.name = name;
        this.tmServer = tmServer;
        this.txRecoveryDelegator = this.getTxRecoveryDelegator();
        this.logDir = logDir != null ? ((tempDirFile = new File(logDir)).exists() && !tempDirFile.isDirectory() ? this.getLogDir() : logDir) : this.getLogDir();
    }

    public TxRecoveryDelegator getTxRecoveryDelegator() {
        if (this.txRecoveryDelegator != null) {
            return this.txRecoveryDelegator;
        }
        return new TxRecoveryDelegator(this, this.tmServer);
    }

    public String getLogDir() {
        String tempLogDir;
        if (this.logDir != null) {
            tempLogDir = this.logDir;
        } else {
            String jeusLogHome = JeusBootstrapProperties.JEUS_LOG_HOME;
            tempLogDir = jeusLogHome + File.separator + "TM";
        }
        return tempLogDir;
    }

    @Override
    public final synchronized boolean start(long startTime) throws TMException {
        if (this.running) {
            return false;
        }
        this.startTimeBytes = ByteUtil.convertToByte(this.tmServer.getTime());
        this.serverStartTime = startTime;
        String location = this.tmServer.getLocationString();
        this.xaLog = HowlLogManager.openXALogger("jeustx", 4, this.name, this.txRecoveryDelegator, this.logDir, location);
        this.resourceLog = HowlLogManager.openXALogger("jeusres", 16, this.name, this.txRecoveryDelegator, this.logDir, location);
        this.running = true;
        return true;
    }

    private static XALogger openXALogger(String fileName, int blockSize, String containerName, TxRecoveryDelegator txRecoveryDelegator, String logDir, String location) throws TMException {
        Properties howlprop = new Properties();
        String myhowlprop = System.getProperty("howl.log.ListConfiguration", "false");
        howlprop.put("listConfig", myhowlprop);
        myhowlprop = System.getProperty("howl.log.BufferSize", String.valueOf(blockSize));
        howlprop.put("bufferSize", myhowlprop);
        myhowlprop = System.getProperty("howl.log.flushPartialBuffers", "false");
        howlprop.put("flushPartialBuffers", myhowlprop);
        myhowlprop = System.getProperty("howl.log.MinimumBuffers", "16");
        howlprop.put("minBuffers", myhowlprop);
        myhowlprop = System.getProperty("howl.log.MaximumBuffers", "16");
        howlprop.put("maxBuffers", myhowlprop);
        myhowlprop = System.getProperty("howl.log.MaximumBlocksPerFile", "500");
        howlprop.put("maxBlocksPerFile", myhowlprop);
        String def = logDir + File.separator + "_" + containerName + CONTAINER_NAME_SEPARATOR + location;
        myhowlprop = System.getProperty("howl.log.FileDirectory", def);
        howlprop.put("logFileDir", myhowlprop);
        myhowlprop = System.getProperty("howl.log.FileName", fileName);
        howlprop.put("logFileName", myhowlprop);
        myhowlprop = System.getProperty("howl.log.MaximumFiles", "2");
        howlprop.put("maxLogFiles", myhowlprop);
        myhowlprop = System.getProperty("howl.log.checksumEnabled", "false");
        howlprop.put("checksumEnabled", myhowlprop);
        String defaultLogFileMode = "rwd";
        if (OS.isWindows()) {
            defaultLogFileMode = "rw";
        }
        myhowlprop = System.getProperty("howl.log.logFileMode", defaultLogFileMode);
        howlprop.put("logFileMode", myhowlprop);
        if (logger.isLoggable(JeusMessage_TMRecovery0._1001_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1001_LEVEL, "HowlLogManager", "<init>", JeusMessage_TMRecovery0._1001, (java.lang.Object)fileName);
        }
        return HowlLogManager.howlOpenLog(howlprop, txRecoveryDelegator);
    }

    private static synchronized XALogger howlOpenLog(Properties phowlprop, TxRecoveryDelegator txRecoveryDelegator) throws TMException {
        XALogger xaLog;
        try {
            Configuration cfg = new Configuration(phowlprop);
            xaLog = new XALogger(cfg);
        }
        catch (LogConfigurationException e) {
            throw new TMException("LogConfigurationException occured in XALogger() " + e.getMessage());
        }
        catch (IOException e) {
            throw new TMException("IOException occured in XALogger() " + e.getMessage());
        }
        catch (Exception e) {
            throw new TMException("Exception occurred in XALogger() " + e.getMessage());
        }
        resourceAcquirer myxarl = new resourceAcquirer(txRecoveryDelegator);
        try {
            xaLog.open(null);
        }
        catch (LogException e) {
            throw new TMException("LogException occured in xaLog.open()", (Throwable)e);
        }
        catch (IOException e) {
            throw new TMException("IOException occured in xaLog.open()", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TMException("InterruptedException occured in xaLog.open()", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new TMException("ClassNotFoundException occured in xaLog.open()", (Throwable)e);
        }
        catch (Exception e) {
            throw new TMException("Exception occurred in xaLog.open()", (Throwable)e);
        }
        xaLog.replayActiveTx((ReplayListener)myxarl);
        return xaLog;
    }

    @Override
    public final synchronized void close() throws TMException {
        if (!this.running) {
            return;
        }
        if (this.otsRecoveryThread != null) {
            this.otsRecoveryThread.interrupt();
            this.otsRecoveryThread = null;
        }
        if (!(this.txRecoveryDelegator.hasIncompletedTx() || this.subXidContainer.hasIncompleteSubTx() || ThreadContexts.hasActiveCoordinator())) {
            this.txRecoveryDelegator.removeAllCurrentResourceReferences();
        }
        try {
            if (this.xaLog != null) {
                this.xaLog.close();
            }
        }
        catch (Exception e) {
            throw new TMException("Exception occured in xaLog.close() ", (Throwable)e);
        }
        try {
            if (this.resourceLog != null) {
                this.resourceLog.close();
            }
        }
        catch (Exception e) {
            throw new TMException("Exception occured in resourceLog.close() ", (Throwable)e);
        }
        this.txRecoveryDelegator.destroy();
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void logXAResourceReference(String exportName, XAResourceFactory xaResourceFactory) throws TMException {
        java.lang.Object object = this.deferredResourcesForRegisterLock;
        synchronized (object) {
            if (this.txRecoveryDelegator.inRecovery()) {
                this.deferredResourcesForRegister.add(new ResourceItem(exportName, xaResourceFactory));
                return;
            }
        }
        this.registerXaResourceFactory(exportName, xaResourceFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerDeferredXaResourceFactory() {
        java.lang.Object object = this.deferredResourcesForRegisterLock;
        synchronized (object) {
            if (this.txRecoveryDelegator.inRecovery()) {
                return;
            }
            for (ResourceItem resourceItem : this.deferredResourcesForRegister) {
                String exportName = resourceItem.getExportName();
                XAResourceFactory xaResourceFactory = resourceItem.getXaResourceFactory();
                try {
                    this.registerXaResourceFactory(exportName, xaResourceFactory);
                }
                catch (TMException e) {
                    if (!logger.isLoggable(JeusMessage_TMRecovery0._1009_LEVEL)) continue;
                    logger.logp(JeusMessage_TMRecovery0._1009_LEVEL, "HowlLogManager", "registerDeferredXaResourceFactory", JeusMessage_TMRecovery0._1009, new String[]{exportName, xaResourceFactory == null ? "null" : xaResourceFactory.toString()}, (Throwable)e);
                }
            }
            this.deferredResourcesForRegister.clear();
        }
    }

    private void registerXaResourceFactory(String exportName, XAResourceFactory xaResourceFactory) throws TMException {
        if (logger.isLoggable(JeusMessage_TMRecovery0._1005_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1005_LEVEL, "HowlLogManager", "registerXaResourceFactory", JeusMessage_TMRecovery0._1005, (java.lang.Object[])new String[]{exportName, xaResourceFactory == null ? "null" : xaResourceFactory.toString()});
        }
        try {
            byte[] nameByte = serializer.serialize(exportName);
            byte[] b = serializer.serialize(xaResourceFactory);
            XACommittingTx tx = this.resourceLog.putCommit((byte[][])new byte[][]{XA_RESOURCE_LOG_ARRAY, nameByte, b});
            ReferenceInfo value = new ReferenceInfo(xaResourceFactory, exportName, tx, this.serverStartTime);
            this.txRecoveryDelegator.addCurrentResourceRef(value, value);
        }
        catch (Throwable ex) {
            throw new TMException(JeusMessage_TMRecovery0._1006, ex);
        }
    }

    @Override
    public final void logCommit(long ltid, Xid externalXid, ResourceImpl otsResource) throws TMException {
        byte[][] log;
        if (externalXid == null) {
            log = new byte[3][];
            log[0] = COMMIT_LOG_ARRAY;
        } else {
            if (externalXid instanceof OTSXid) {
                log = new byte[7][];
                log[0] = OTS_PREPARE_LOG_ARRAY;
                if (otsResource != null) {
                    RecoveryCoordinator recoveryCoordinator = otsResource.getRecoveryCoordinator();
                    log[6] = this.makeCorbaObjectToString(recoveryCoordinator);
                } else {
                    log[6] = DUMMY_BYTES;
                }
            } else {
                log = new byte[6][];
                log[0] = EXTERNAL_PREPARE_LOG_ARRAY;
            }
            log[3] = externalXid.getGlobalTransactionId();
            log[4] = externalXid.getBranchQualifier();
            log[5] = ByteUtil.convertToByte(externalXid.getFormatId());
        }
        log[1] = this.startTimeBytes;
        log[2] = ByteUtil.convertToByte(ltid);
        if (logger.isLoggable(JeusMessage_TMRecovery0._1007_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1007_LEVEL, "HowlLogManager", "logCommit", JeusMessage_TMRecovery0._1007, new java.lang.Object[]{new Long(ltid), XidToString.getXidString(externalXid)});
        }
        try {
            XACommittingTx tx = this.xaLog.putCommit((byte[][])log);
            this.committingTxMap.put(new Long(ltid), tx);
        }
        catch (Exception e) {
            throw new TMException(e);
        }
    }

    private byte[] makeCorbaObjectToString(Object recoveryCoordinator) {
        String objString = jeus.transaction.ots.Configuration.getORB().object_to_string(recoveryCoordinator);
        return objString.getBytes();
    }

    @Override
    public final void logDone(long ltid) throws TMException {
        XACommittingTx tx = this.committingTxMap.remove(new Long(ltid));
        if (tx == null) {
            throw new TMException("CommittingTx is null");
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1008_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1008_LEVEL, "HowlLogManager", "longDone", JeusMessage_TMRecovery0._1008, (java.lang.Object)new Long(ltid));
        }
        this.logXaDone(tx);
    }

    @Override
    public final synchronized void addIncompletedTX(long ltid, int time, long createtime, Xid xid, ResourceImpl otsResource, List<Xid> indoubtXids, List<TMInfo> failedSubCoordinators) throws TMException {
        XACommittingTx committingTx = this.committingTxMap.remove(new Long(ltid));
        if (committingTx == null) {
            throw new TMException("CommittingTx is null");
        }
        IncompletedTx tx = new IncompletedTx(ltid, time, createtime, null, xid, committingTx, otsResource, false, 0, 8, failedSubCoordinators);
        for (Xid child : indoubtXids) {
            tx.addRuntimeChildXid(child);
        }
        this.txRecoveryDelegator.addIncompletedTx(tx, tx, xid, otsResource);
    }

    @Override
    public void logXaDone(XACommittingTx tx) {
        if (tx == null) {
            return;
        }
        try {
            this.xaLog.putDone((byte[][])null, tx);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "failed to put tx done log", (Throwable)e);
        }
    }

    public void logResourceDone(XACommittingTx tx) {
        if (tx == null) {
            return;
        }
        try {
            this.resourceLog.putDone((byte[][])null, tx);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "failed to put resource done log", (Throwable)e);
        }
    }

    @Override
    public final byte getDecisionForIncompletedTx(long ltid, int time) {
        this.waitForRecovery();
        IncompletedTx tx = this.txRecoveryDelegator.getIncompletedTx(ltid, time);
        return TxRecoveryDelegator.getDecision(tx);
    }

    private IncompletedTx getMatchingIncompletedTx(Xid xid) {
        if (xid == null) {
            return null;
        }
        IncompletedTx tx = this.txRecoveryDelegator.getTxFromXidList(xid);
        if (tx == null && xid != null && xid.getFormatId() == 256077) {
            byte[] gtidBytes = xid.getGlobalTransactionId();
            if (gtidBytes == null) {
                return null;
            }
            GTID jeusGtid = new GTID(gtidBytes);
            tx = this.txRecoveryDelegator.getIncompletedTx(jeusGtid.getLTID(), jeusGtid.getTime());
        }
        return tx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void setGlobalDecisionForIncompletedTransaction(Xid xid, boolean commit) throws TMException, XAException {
        this.waitForRecovery();
        IncompletedTx tx = this.getMatchingIncompletedTx(xid);
        if (tx == null) {
            throw new TMException("This xid is not known to JEUS, maybe this xid is already recovered or recover() is not called before calling commit or rollback : " + XidToString.getXidString(xid));
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1004_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1004_LEVEL, "HowlLogManager", "setGlobalDecisionForIncompletedExternalTransaction", JeusMessage_TMRecovery0._1004, new java.lang.Object[]{XidToString.getXidString(xid), commit ? "commit" : "rollback"});
        }
        Map currentFailedRef = null;
        byte decision = commit ? (byte)0 : 1;
        tx.setGlobalDecision(decision);
        if (!tx.isRecovered()) {
            currentFailedRef = this.txRecoveryDelegator.resyncCurrentXAResources();
            if (this.txRecoveryDelegator.isCompletedTx(tx)) {
                return;
            }
            if (currentFailedRef.size() != 0) throw new TMException("failed to recover the xid(" + xid + ") and the incompleted tx(" + tx + ") because current failed reference size = " + currentFailedRef.size());
            if (!tx.isChildsEmpty()) throw new TMException("failed to recover the xid(" + xid + ") and the incompleted tx(" + tx + ")");
            this.logXaDone((XACommittingTx)tx.getHandback());
            this.removeIncompletedTx(tx);
            return;
        }
        if (this.txRecoveryDelegator.resyncChildTx(tx, xid)) return;
        throw new TMException("failed to recover the xid(" + xid + ") and the incompleted tx(" + tx + ") because recync child tx return false");
    }

    @Override
    public IncompletedTx getIncompletedExternalTx(Xid xid) {
        this.waitForRecovery();
        return this.txRecoveryDelegator.getTxFromXidList(xid);
    }

    @Override
    public IncompletedTx getIncompletedTx(GTID gtid) {
        if (gtid == null) {
            return null;
        }
        return this.txRecoveryDelegator.getIncompletedTx(gtid.getLTID(), gtid.getTime());
    }

    @Override
    public ResourceImpl[] getIncompletedOtsResources() {
        this.waitForRecovery();
        return this.txRecoveryDelegator.getIncompletedOtsResources();
    }

    @Override
    public IncompletedTx getIncompletedOtsTx(ResourceImpl rsc) {
        this.waitForRecovery();
        return this.txRecoveryDelegator.getIncompletedOtsTx(rsc);
    }

    @Override
    public final void removeRecoveredReferenceInfo(ReferenceInfo ref) {
        ReferenceInfo storedRef = this.txRecoveryDelegator.removeRecoveredResourceRef(ref);
        if (storedRef != null) {
            this.logResourceDone((XACommittingTx)storedRef.getHandback());
        }
    }

    @Override
    public final void addIncompletedSubTX(SubCoordinator coord) {
        this.subXidContainer.putRecoverXidMap(coord);
    }

    @Override
    public final Xid[] getSubXids(TMInfo socketID) throws TMException {
        this.waitForRecovery();
        if (this.txRecoveryDelegator.failedRsrcRemains()) {
            throw new TMException("Due to failed resources, cannot recover");
        }
        return this.subXidContainer.getXids(socketID);
    }

    @Override
    public final void setGlobalDecisionForSubXids(Xid xid, boolean commit) throws TMException {
        this.subXidContainer.setGlobalDecision(xid, commit);
    }

    @Override
    public final void removeIncompleteSubTx(SubCoordinator coord) {
        this.subXidContainer.removeIncompleteSubTx(coord);
    }

    @Override
    public void removeIncompletedTx(IncompletedTx tx) {
        if (tx == null) {
            return;
        }
        IncompletedTx removed = this.txRecoveryDelegator.removeTxFromIncompletedTxList(tx);
        if (removed == null) {
            return;
        }
        Xid externalXid = removed.getExternalXid();
        if (externalXid == null) {
            return;
        }
        this.txRecoveryDelegator.removeTxFromXidList(externalXid, tx.getResource());
    }

    @Override
    public boolean completeRecoveredSubCoordinator(GTID gtid, boolean commit) throws TMException {
        return this.subXidContainer.setGlobalDecision(gtid, commit);
    }

    @Override
    public void waitForRecovery() {
        this.txRecoveryDelegator.waitForRecovery();
    }

    @Override
    public synchronized void doRecover() {
        this.txRecoveryDelegator.doTxRecovery();
        this.doRecoverOTS();
    }

    private void doRecoverOTS() {
        ResourceImpl[] resources = this.getIncompletedOtsResources();
        if (resources == null || resources.length <= 0) {
            return;
        }
        if (logger.isLoggable(JeusMessage_OTS0._1101_LEVEL)) {
            logger.logp(JeusMessage_OTS0._1101_LEVEL, "HowlLogManager", "doRecoverOTS", JeusMessage_OTS0._1101, (java.lang.Object)new Integer(resources.length));
        }
        ArrayList<ResourceImpl> list = new ArrayList<ResourceImpl>();
        for (int i = 0; i < resources.length; ++i) {
            list.add(resources[i]);
        }
        if (this.otsRecoveryThread != null) {
            this.otsRecoveryThread.interrupt();
        }
        this.otsRecoveryThread = this.getOTSRecoveryThread(this.tmServer, "OTS Recovery Thread", list);
        this.otsRecoveryThread.start();
    }

    protected OTSRecoveryThread getOTSRecoveryThread(TMInfo tmInfo, String name, List<ResourceImpl> list) {
        return new OTSRecoveryThread(tmInfo, name, list);
    }

    @Override
    public final synchronized Map resyncXAResources(Map recoveredResourceMap) {
        return this.txRecoveryDelegator.resyncXAResources(recoveredResourceMap, true);
    }

    @Override
    public final boolean hasIncompletedTx() {
        this.waitForRecovery();
        return this.txRecoveryDelegator.hasIncompletedTx();
    }

    @Override
    public final Xid[] getIncompleteExternalXids() {
        this.waitForRecovery();
        return this.txRecoveryDelegator.getIncompletedExternalXids();
    }

    @Override
    public final void forgetIncompleteTx(Xid xid) throws TMException {
        this.waitForRecovery();
        IncompletedTx tx = this.getMatchingIncompletedTx(xid);
        if (tx == null) {
            return;
        }
        boolean completionDone = this.txRecoveryDelegator.forgetChildTx(tx.getChildXids(), xid);
        if (!completionDone) {
            throw new TMException("forget() is not completed: " + completionDone + ", failedResources : " + this.txRecoveryDelegator.failedResourceSize());
        }
        this.logXaDone((XACommittingTx)tx.getHandback());
        this.removeIncompletedTx(tx);
    }

    @Override
    public final void forgetIncompleteTxForSubXids(Xid xid) throws TMException {
        this.subXidContainer.forgetIncompletedTx(xid);
    }

    @Override
    public final ReferenceInfo[] getRecoveredXAResourceInfo() {
        return this.txRecoveryDelegator.getRecoveredXAResourceInfo();
    }

    @Override
    public final ReferenceInfo[] getCurrentXAResourceInfo() {
        return this.txRecoveryDelegator.getCurrentXAResourceInfo();
    }

    @Override
    public boolean inRecovery() {
        return this.txRecoveryDelegator.inRecovery();
    }

    @Override
    public final IncompletedTx[] getAllIncompletedTx() {
        this.waitForRecovery();
        return this.txRecoveryDelegator.getAllIncompletedTx();
    }

    void addToSubXidContainer(TMInfo tmInfo, Xid xid, ReferenceInfo info) {
        this.subXidContainer.putRecoverXidMap(tmInfo, xid, info);
    }

    boolean moreIncompletedSubTx() {
        return this.subXidContainer.hasIncompleteSubTx();
    }

    void replayCompletionForSubTx() {
        this.subXidContainer.sendReplayCompletion();
    }

    public SubCoordinatorXidContainer getSubXidContainer() {
        return this.subXidContainer;
    }

    public synchronized boolean isRunningTx(long tx) {
        return this.committingTxMap.get(new Long(tx)) != null;
    }

    public boolean hasPendingRecoveryThread() {
        return this.txRecoveryDelegator.isResourceMonitorThreadRunning() || this.otsRecoveryThread != null && this.otsRecoveryThread.isRunning();
    }

    private static final class resourceAcquirer
    implements ReplayListener {
        private TxRecoveryDelegator txRecoveryDelegator;

        public resourceAcquirer(TxRecoveryDelegator txRecoveryDelegator) {
            this.txRecoveryDelegator = txRecoveryDelegator;
        }

        public final void onRecord(LogRecord lr) {
            block1 : switch (lr.type) {
                case 16512: {
                    byte[][] data = lr.getFields();
                    byte type = data[0][0];
                    switch (type) {
                        case 0: {
                            String exportName = null;
                            try {
                                exportName = (String)serializer.deserializeWithCNFE(data[1]);
                                XAResourceFactory resourceRef = (XAResourceFactory)serializer.deserializeWithCNFE(data[2]);
                                if (logger.isLoggable(JeusMessage_TMRecovery0._1101_LEVEL)) {
                                    logger.log(JeusMessage_TMRecovery0._1101_LEVEL, JeusMessage_TMRecovery0._1101, (java.lang.Object)resourceRef);
                                }
                                ReferenceInfo value = new ReferenceInfo(resourceRef, exportName, ((XALogRecord)lr).getTx(), lr.tod);
                                this.txRecoveryDelegator.addRecorveredResourceRef(value, value);
                            }
                            catch (Exception e) {
                                if (e instanceof ClassNotFoundException) {
                                    if (!logger.isLoggable(JeusMessage_TMRecovery0._1105_LEVEL)) break block1;
                                    logger.log(JeusMessage_TMRecovery0._1105_LEVEL, JeusMessage_TMRecovery0._1105, new java.lang.Object[]{exportName, ClassNotFoundException.class.getName() + ":" + e.getMessage()});
                                    break block1;
                                }
                                if (!logger.isLoggable(JeusMessage_TMRecovery0._1106_LEVEL)) break block1;
                                logger.log(JeusMessage_TMRecovery0._1106_LEVEL, JeusMessage_TMRecovery0._1106, exportName, (Throwable)e);
                            }
                            break block1;
                        }
                        case 1: {
                            int startTime = ByteUtil.convertToInt(data[1]);
                            long ltid = ByteUtil.convertToLong(data[2]);
                            IncompletedTx tx = new IncompletedTx(ltid, startTime, lr.tod, new GTID(this.txRecoveryDelegator.tmServer, ltid, null, startTime), null, ((XALogRecord)lr).getTx(), null, true, 0, 2, null);
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1102_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1102_LEVEL, "HowlLogManager$resourceAcquirer", "onRecord", JeusMessage_TMRecovery0._1102, (java.lang.Object)new Long(ltid));
                            }
                            this.txRecoveryDelegator.addIncompletedTx(tx, tx, null, null);
                            break block1;
                        }
                        case 2: {
                            int startTime = ByteUtil.convertToInt(data[1]);
                            long ltid = ByteUtil.convertToLong(data[2]);
                            XidImpl xid = new XidImpl(data[3], data[4], ByteUtil.convertToInt(data[5]));
                            IncompletedTx tx = new IncompletedTx(ltid, startTime, lr.tod, new GTID(this.txRecoveryDelegator.tmServer, ltid, null, startTime), xid, ((XALogRecord)lr).getTx(), null, true, -1, 2, null);
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1103_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1103_LEVEL, "HowlLogManager$resourceAcquirer", "onRecord", JeusMessage_TMRecovery0._1103, new java.lang.Object[]{new Long(ltid), XidToString.getXidString(xid)});
                            }
                            this.txRecoveryDelegator.addIncompletedTx(tx, tx, xid, null);
                            break block1;
                        }
                        case 3: {
                            byte decision;
                            ResourceImpl rsc;
                            int startTime = ByteUtil.convertToInt(data[1]);
                            long ltid = ByteUtil.convertToLong(data[2]);
                            OTSXid otsXid = new OTSXid(data[3], data[4], ByteUtil.convertToInt(data[5]));
                            if (data[6].length > 0) {
                                rsc = ResourceImpl.getCachedResource(otsXid);
                                if (rsc == null) {
                                    rsc = new ResourceImpl(otsXid);
                                    _RecoveryCoordinatorStub recoveryCoord = new _RecoveryCoordinatorStub();
                                    this.makeCorbaObjectFromString(data[6], recoveryCoord);
                                    rsc.setRecoveryCoordinator(recoveryCoord);
                                    ResourceImpl.putCachedResource(otsXid, rsc);
                                }
                                decision = -1;
                            } else {
                                rsc = null;
                                decision = 0;
                            }
                            IncompletedTx tx = new IncompletedTx(ltid, startTime, lr.tod, new GTID(this.txRecoveryDelegator.tmServer, ltid, null, startTime), otsXid, ((XALogRecord)lr).getTx(), rsc, true, decision, 2, null);
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1103_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1103_LEVEL, "HowlLogManager$resourceAcquirer", "onRecord", JeusMessage_TMRecovery0._1103, new java.lang.Object[]{new Long(ltid), XidToString.getXidString(otsXid)});
                            }
                            this.txRecoveryDelegator.addIncompletedTx(tx, tx, otsXid, rsc);
                            break block1;
                        }
                        default: {
                            throw new RuntimeException("Unknown log data : " + data.length);
                        }
                    }
                }
            }
        }

        private void makeCorbaObjectFromString(byte[] data, _RecoveryCoordinatorStub recoveryCoord) {
            String str = new String(data);
            Object obj = jeus.transaction.ots.Configuration.getORB().string_to_object(str);
            Delegate delegate = ((ObjectImpl)obj)._get_delegate();
            recoveryCoord._set_delegate(delegate);
        }

        public final void onError(LogException exception) {
            exception.printStackTrace();
        }

        public final LogRecord getLogRecord() {
            return new XALogRecord(120);
        }
    }

    private static final class ResourceItem {
        private final String exportName;
        private final XAResourceFactory xaResourceFactory;

        public ResourceItem(String exportName, XAResourceFactory xaResourceFactory) {
            this.exportName = exportName;
            this.xaResourceFactory = xaResourceFactory;
        }

        public String getExportName() {
            return this.exportName;
        }

        public XAResourceFactory getXaResourceFactory() {
            return this.xaResourceFactory;
        }
    }
}

