/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.xa.Xid;
import jeus.transaction.GTID;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.TxStatus;
import jeus.transaction.XidImpl;
import jeus.transaction.info.IncompletedTransactionInfo;
import jeus.transaction.info.IncompletedTransactionInfoImpl;
import jeus.transaction.logging.ReferenceInfo;
import jeus.transaction.logging.XidInfo;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.util.XidToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IncompletedTx
implements Serializable {
    static final long serialVersionUID = 5174483528099738417L;
    private final long ltid;
    private final int time;
    private Xid externalXid;
    private byte decision;
    private long createTime;
    private transient Object handback;
    private final CopyOnWriteArrayList<XidInfo> childXids = new CopyOnWriteArrayList();
    private boolean isRecovered;
    private final GTID gtid;
    private ResourceImpl otsResource;
    private int lastStatus;
    private final transient CopyOnWriteArrayList<Xid> runtimeChildXids = new CopyOnWriteArrayList();
    private final List<TMInfo> failedSubCoordinators;

    public IncompletedTx() {
        this(0L, 0, 0L, null, null, null, null, false, -1, 2, null);
    }

    public IncompletedTx(long ltid, int time) {
        this(ltid, time, 0L, null, null, null, null, false, -1, 5, null);
    }

    public IncompletedTx(long ltid, int time, long createTime, GTID gtid, Xid xid, Object handback, ResourceImpl rsc, boolean isRecovered, byte decision, int lastStatus, List<TMInfo> failedSubCoordinators) {
        this.ltid = ltid;
        this.time = time;
        this.createTime = createTime;
        if (gtid == null) {
            gtid = new GTID(TMServer.getTMInfo(), ltid, this.externalXid, time);
        }
        this.gtid = gtid;
        if (xid != null) {
            this.externalXid = new XidImpl(xid);
        }
        this.handback = handback;
        this.otsResource = rsc;
        this.isRecovered = isRecovered;
        this.decision = decision;
        this.lastStatus = lastStatus;
        this.failedSubCoordinators = failedSubCoordinators;
    }

    public GTID getGTID() {
        return this.gtid;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IncompletedTx) {
            IncompletedTx tx = (IncompletedTx)obj;
            return tx.ltid == this.ltid && tx.time == this.time;
        }
        if (obj instanceof Long) {
            return this.ltid == (Long)obj;
        }
        if (obj instanceof Xid) {
            return this.externalXid != null && IncompletedTx.isTheSameXid(this.externalXid, (Xid)obj);
        }
        return false;
    }

    private static boolean isTheSameXid(Xid externalXid, Xid xid) {
        return IncompletedTx.isTheSameByteArray(externalXid.getGlobalTransactionId(), xid.getGlobalTransactionId()) && IncompletedTx.isTheSameByteArray(externalXid.getBranchQualifier(), xid.getBranchQualifier()) && externalXid.getFormatId() == xid.getFormatId();
    }

    private static boolean isTheSameByteArray(byte[] gtid, byte[] targetGtid) {
        if (gtid.length != targetGtid.length) {
            return false;
        }
        for (int i = 0; i < targetGtid.length; ++i) {
            if (gtid[i] == targetGtid[i]) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        return (int)this.ltid;
    }

    public final Xid getExternalXid() {
        return this.externalXid;
    }

    public final void setGlobalDecision(byte decision) {
        this.decision = decision;
    }

    public final byte getDecision() {
        return this.decision;
    }

    public int getLastStatus() {
        return this.lastStatus;
    }

    public final String toString() {
        if (this.externalXid == null) {
            return String.valueOf(this.ltid) + ":" + this.time + ":" + this.createTime;
        }
        return String.valueOf(this.ltid) + ":" + XidToString.getXidString(this.externalXid) + ":" + this.time + ":" + this.createTime;
    }

    public final long getLTID() {
        return this.ltid;
    }

    public final Object getHandback() {
        return this.handback;
    }

    public final boolean isSameLTID(GTID gtid) {
        return this.ltid == gtid.getLTID() && this.time == gtid.getTime();
    }

    public final void addChildXid(Xid xid, ReferenceInfo info) {
        this.childXids.add(new XidInfo(xid, info));
    }

    public final void removeChildXid(Xid xid, ReferenceInfo info) {
        this.childXids.remove(new XidInfo(xid, info));
    }

    public final int getTime() {
        return this.time;
    }

    public final List getChildXids() {
        return this.childXids;
    }

    public final boolean isRecovered() {
        return this.isRecovered;
    }

    public void setHandback(Object handback) {
        this.handback = handback;
    }

    public ResourceImpl getResource() {
        return this.otsResource;
    }

    public IncompletedTransactionInfo getIncompletedTransactionInfo() {
        Xid externalXid;
        IncompletedTransactionInfoImpl incompletedTxInfo = null;
        GTID gtid = this.getGTID();
        if (gtid == null) {
            return null;
        }
        incompletedTxInfo = new IncompletedTransactionInfoImpl(new XidImpl(gtid.toBytes(), new byte[0], 256077));
        TMInfo tminfo = gtid.getTMInfo();
        if (tminfo != null) {
            incompletedTxInfo.setCoordinator(tminfo.getIPString() + ":" + tminfo.getPort());
        }
        if ((externalXid = gtid.getExternalXid()) != null) {
            incompletedTxInfo.setExternalXid(new XidImpl(externalXid));
        }
        incompletedTxInfo.setTimeout(-1L);
        incompletedTxInfo.setElapseSinceBegin(-1L);
        incompletedTxInfo.setStatus(TxStatus.getState(this.getLastStatus()));
        List childXidInfos = this.getChildXids();
        Vector<Xid> childXids = new Vector<Xid>();
        for (Object xidInfo : childXidInfos) {
            XidInfo info;
            Xid xid;
            if (!(xidInfo instanceof XidInfo) || (xid = (info = (XidInfo)xidInfo).getXid()) == null) continue;
            childXids.add(new XidImpl(xid));
        }
        childXids.addAll(this.runtimeChildXids);
        if (!childXids.isEmpty()) {
            incompletedTxInfo.setChildXids(childXids.toArray(new Xid[childXids.size()]));
        }
        incompletedTxInfo.setDecision(TxStatus.getState(this.getDecision()));
        return incompletedTxInfo;
    }

    public void addRuntimeChildXid(Xid xid) {
        if (xid != null) {
            this.runtimeChildXids.add(xid);
        }
    }

    public void removeRuntimeChildXid(Xid xid) {
        if (xid != null) {
            this.runtimeChildXids.remove(xid);
        }
    }

    public boolean isChildsEmpty() {
        return this.childXids.isEmpty() && this.runtimeChildXids.isEmpty();
    }

    public boolean hasFailedSubCoordinators() {
        return this.failedSubCoordinators != null && !this.failedSubCoordinators.isEmpty();
    }

    public boolean removeFailedSubCoordinator(TMInfo tmInfo) {
        return this.failedSubCoordinators != null && tmInfo != null && this.failedSubCoordinators.remove(tmInfo);
    }
}

