/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import java.sql.SQLException;
import javax.jms.JMSException;
import javax.jms.XAConnectionFactory;
import javax.naming.Reference;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import jeus.jdbc.connectionpool.CPObjectFactory;
import jeus.jdbc.connectionpool.ConnectionPoolManager;
import jeus.jms.client.facility.factory.ConnectionFactoryOF;
import jeus.jms.wrapper.ForeignJMSConnectionFactoryOF;
import jeus.transaction.TMException;
import jeus.transaction.logging.AbstractXAResourceFactory;
import jeus.util.message.JeusMessage_TM3;

public final class JEUSXAResourceFactory
extends AbstractXAResourceFactory {
    private static final long serialVersionUID = 4569278415872772529L;
    private transient Object xaConnection;

    public JEUSXAResourceFactory(Reference ref) {
        super(ref);
    }

    protected void open() throws Exception {
        String factoryClassName = this.ref.getFactoryClassName();
        if (factoryClassName.equals(CPObjectFactory.class.getName())) {
            XAConnection sqlXaConnection = ConnectionPoolManager.getControlSession(this.ref);
            this.xaConnection = sqlXaConnection;
            try {
                this.xaResource = sqlXaConnection.getXAResource();
            }
            catch (SQLException e) {
                this.close(null);
                throw e;
            }
            logger.log(JeusMessage_TM3._5497_LEVEL, JeusMessage_TM3._5497, new Object[]{sqlXaConnection.toString(), this.xaResource});
        } else if (factoryClassName.equals(ConnectionFactoryOF.class.getName())) {
            XAConnectionFactory factory = (XAConnectionFactory)new ConnectionFactoryOF().getObjectInstance((Object)this.ref, null, null, null);
            javax.jms.XAConnection jmsXaConnection = factory.createXAConnection();
            this.xaConnection = jmsXaConnection;
            try {
                this.xaResource = jmsXaConnection.createXASession().getXAResource();
            }
            catch (JMSException e) {
                this.close(null);
                throw e;
            }
        } else if (factoryClassName.equals(ForeignJMSConnectionFactoryOF.class.getName())) {
            XAConnectionFactory factory = (XAConnectionFactory)new ForeignJMSConnectionFactoryOF().getObjectInstance((Object)this.ref, null, null, null);
            javax.jms.XAConnection jmsXaConnection = factory.createXAConnection();
            this.xaConnection = jmsXaConnection;
            try {
                this.xaResource = jmsXaConnection.createXASession().getXAResource();
            }
            catch (JMSException e) {
                this.close(null);
                throw e;
            }
        } else {
            throw new TMException("Unknown resource reference : " + factoryClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(XAResource xaResource) {
        if (this.xaConnection != null) {
            try {
                block7: {
                    try {
                        if (this.xaConnection instanceof XAConnection) {
                            logger.logp(JeusMessage_TM3._5491_LEVEL, "TMServer", "resyncXAResources", JeusMessage_TM3._5491, (Object[])new String[]{this.xaConnection.toString(), xaResource == null ? "null" : xaResource.toString()});
                            ((XAConnection)this.xaConnection).close();
                            break block7;
                        }
                        if (this.xaConnection instanceof javax.jms.XAConnection) {
                            ((javax.jms.XAConnection)this.xaConnection).close();
                            break block7;
                        }
                        logger.log(JeusMessage_TM3._5565_LEVEL, JeusMessage_TM3._5565, this.xaConnection.getClass());
                    }
                    catch (Throwable t) {
                        logger.logp(JeusMessage_TM3._5494_LEVEL, "TMServer", "resyncXAResources", JeusMessage_TM3._5494, t);
                        Object var4_3 = null;
                        this.xaConnection = null;
                    }
                }
                Object var4_2 = null;
                this.xaConnection = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.xaConnection = null;
                throw throwable;
            }
        }
        this.xaResource = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "XAResourceFactory[" + this.ref.getFactoryClassName() + ":" + this.ref.getClassName() + "]";
    }
}

