/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.Xid;
import jeus.transaction.GTID;
import jeus.transaction.TMInfo;
import jeus.transaction.XidImpl;
import jeus.transaction.util.XidHashTable;
import jeus.transaction.util.XidToString;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TMRecovery0;

public class RecoveredRootTMInfoTable {
    private final Map recoveredTMInfoMap = new Hashtable();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction.log");
    private static final Xid[] EMPTY_RECOVER_XIDS = new XidImpl[0];

    public synchronized Object putTMInfoEntry(TMInfo key, Xid xid, Object value) {
        Map xidMap = this.getTMInfoEntry(key);
        if (xidMap == null) {
            xidMap = new XidHashTable();
            if (logger.isLoggable(JeusMessage_TMRecovery0._1401_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1401_LEVEL, "RecoveredRootTMInfoTable", "putTMInfoEntry", JeusMessage_TMRecovery0._1401, (Object)key);
            }
            this.recoveredTMInfoMap.put(key, xidMap);
        }
        return xidMap.put(xid, value);
    }

    public synchronized Map getTMInfoEntry(TMInfo key) {
        Set infoSet = this.recoveredTMInfoMap.keySet();
        for (TMInfo info : infoSet) {
            if (!info.isSameLocation(key)) continue;
            return (Map)this.recoveredTMInfoMap.get(info);
        }
        return null;
    }

    private void printKey(TMInfo key) {
        System.out.println("***** key : " + key);
        for (TMInfo tmInfo : this.recoveredTMInfoMap.keySet()) {
            System.out.println("***** map key : " + tmInfo + ", isSameLocation : " + tmInfo.isSameLocation(key));
        }
    }

    public synchronized Set getTmInfoSet() {
        return this.recoveredTMInfoMap.keySet();
    }

    public synchronized Object getXidEntry(TMInfo key, Xid xid) {
        Map xidTable = this.getTMInfoEntry(key);
        if (xidTable == null) {
            return null;
        }
        return xidTable.get(xid);
    }

    public synchronized Object removeTMInfoEntry(TMInfo key) {
        Set infoSet = this.recoveredTMInfoMap.keySet();
        for (TMInfo info : infoSet) {
            if (!info.isSameLocation(key)) continue;
            return this.recoveredTMInfoMap.remove(info);
        }
        return null;
    }

    public synchronized Object removeXidEntry(TMInfo tmInfo, Xid xid) {
        Hashtable xidTable = this.getTMInfoEntry(tmInfo);
        if (xidTable == null) {
            xidTable = new Hashtable();
            this.recoveredTMInfoMap.put(tmInfo, xidTable);
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1402_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1402_LEVEL, "RecoveredRootTMInfoTable", "removeXidEntry", JeusMessage_TMRecovery0._1402, new Object[]{XidToString.getXidString(xid), tmInfo});
        }
        return xidTable.remove(xid);
    }

    public synchronized Xid[] getXidArrayByTMInfo(TMInfo tmInfo) {
        Map xidTable = this.getTMInfoEntry(tmInfo);
        if (xidTable == null) {
            if (logger.isLoggable(JeusMessage_TMRecovery0._1403_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1403_LEVEL, "RecoveredRootTMInfoTable", "getXidArrayByTMInfo", JeusMessage_TMRecovery0._1403, (Object)tmInfo);
            }
            return EMPTY_RECOVER_XIDS;
        }
        Set xidSet = xidTable.keySet();
        if (logger.isLoggable(JeusMessage_TMRecovery0._1404_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1404_LEVEL, "RecoveredRootTMInfoTable", "getXidArrayByTMInfo", JeusMessage_TMRecovery0._1404, new Object[]{new Integer(xidSet.size()), tmInfo});
        }
        return xidSet.toArray(new Xid[xidSet.size()]);
    }

    public synchronized Xid[] getXidArrayByGTID(GTID gtid) {
        Map xidTable = (Map)this.recoveredTMInfoMap.get(gtid.getTMInfo());
        if (xidTable == null) {
            if (logger.isLoggable(JeusMessage_TMRecovery0._1405_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1405_LEVEL, "RecoveredRootTMInfoTable", "getXidArrayByTMInfo", JeusMessage_TMRecovery0._1405, (Object)gtid);
            }
            return null;
        }
        ArrayList<Xid> xidsForGTID = new ArrayList<Xid>();
        for (Xid xid : xidTable.keySet()) {
            if (!Arrays.equals(gtid.toBytes(), xid.getGlobalTransactionId())) continue;
            xidsForGTID.add(xid);
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1406_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1406_LEVEL, "RecoveredRootTMInfoTable", "getXidArrayByTMInfo", JeusMessage_TMRecovery0._1406, new Object[]{new Integer(xidsForGTID.size()), gtid});
        }
        return xidsForGTID.toArray(new Xid[xidsForGTID.size()]);
    }

    public synchronized int size() {
        return this.recoveredTMInfoMap.size();
    }

    public synchronized String getInformation(String prefix) {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry entrySet : this.recoveredTMInfoMap.entrySet()) {
            buffer.append(prefix).append("* root coordinator : ").append(entrySet.getKey()).append("\r\n");
            for (Xid xid : ((Map)entrySet.getValue()).keySet()) {
                buffer.append(prefix).append("\t* xid : ").append(XidToString.getXidString(xid)).append("\r\n");
            }
        }
        return buffer.toString();
    }
}

