/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import jeus.transaction.TMServer;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.util.XidToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceInfo
implements Serializable {
    static final long serialVersionUID = -1348889676804968349L;
    private XAResourceFactory xaResourceFactory;
    private final transient Object handback;
    private final Map<String, Xid> pendingXids = new ConcurrentHashMap<String, Xid>();
    private long recoverTime;
    private final long startTime;
    private static final AtomicInteger idGen = new AtomicInteger(0);
    private final int id;
    private final String exportName;
    private volatile transient String debugName;

    public ReferenceInfo(XAResourceFactory xaResourceFactory, String exportName) {
        this(xaResourceFactory, exportName, 0, null, 0L);
    }

    public ReferenceInfo(XAResourceFactory xaResourceFactory, String exportName, Object handback, long startTime) {
        this(xaResourceFactory, exportName, idGen.incrementAndGet(), handback, startTime);
    }

    private ReferenceInfo(XAResourceFactory xaResourceFactory, String exportName, int id, Object handback, long startTime) {
        this.xaResourceFactory = xaResourceFactory;
        this.exportName = exportName;
        this.id = id;
        this.handback = handback;
        this.startTime = startTime;
    }

    public void setPendingXids(Collection<Xid> pendingXidArray) {
        if (pendingXidArray == null) {
            return;
        }
        this.pendingXids.clear();
        for (Xid xid : pendingXidArray) {
            this.pendingXids.put(XidToString.getXidString(xid), xid);
        }
        this.recoverTime = System.currentTimeMillis();
    }

    public Object getHandback() {
        return this.handback;
    }

    public long getUsedTime() {
        return this.startTime;
    }

    public Xid[] getPendingXids() {
        Collection<Xid> set = this.pendingXids.values();
        return set.toArray(new Xid[set.size()]);
    }

    public long getRecoverTime() {
        return this.recoverTime;
    }

    public XAResourceFactory getResourceReference() {
        return this.xaResourceFactory;
    }

    public void setResourceReference(XAResourceFactory xaResourceFactory) {
        this.xaResourceFactory = xaResourceFactory;
    }

    public void removePendingXid(Xid xid) {
        this.pendingXids.remove(XidToString.getXidString(xid));
        if (this.pendingXids.size() == 0) {
            TMServer.removeXAResourceInfo(this);
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReferenceInfo) {
            return this.id == ((ReferenceInfo)obj).id;
        }
        return false;
    }

    public String getExportName() {
        return this.exportName;
    }

    public String toString() {
        if (this.debugName == null) {
            String xaResourceFactoryName = this.xaResourceFactory != null ? this.xaResourceFactory.toString() + ":" : "";
            this.debugName = "ReferenceInfo[id=" + this.id + ", " + xaResourceFactoryName + this.exportName + "]";
        }
        return this.debugName;
    }
}

