/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.net.impl.NodeInfo;
import jeus.transaction.GTID;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.comm.RootCoordinatorProxy;
import jeus.transaction.comm.TMLink;
import jeus.transaction.logging.RecoveredRootTMInfoTable;
import jeus.transaction.logging.ReferenceInfo;
import jeus.transaction.logging.TxRecoveryDelegator;
import jeus.transaction.sub.SubCoordinator;
import jeus.transaction.util.XidToString;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TMRecovery0;

final class SubCoordinatorXidContainer {
    private final RecoveredRootTMInfoTable recoverXidMap = new RecoveredRootTMInfoTable();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction.recovery");

    SubCoordinatorXidContainer() {
    }

    public final synchronized void putRecoverXidMap(TMInfo tmInfo, Xid xid, ReferenceInfo info) {
        HashSet<ReferenceInfo> referenceInfoList = (HashSet<ReferenceInfo>)this.recoverXidMap.getXidEntry(tmInfo, xid);
        if (referenceInfoList == null) {
            referenceInfoList = new HashSet<ReferenceInfo>();
            if (logger.isLoggable(JeusMessage_TMRecovery0._1301_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1301_LEVEL, "SubCoordinatorXidContainer", "putRecoverXidMap", JeusMessage_TMRecovery0._1301, new Object[]{XidToString.getXidString(xid), tmInfo});
            }
            this.recoverXidMap.putTMInfoEntry(tmInfo, xid, referenceInfoList);
        }
        referenceInfoList.add(info);
    }

    public final void putRecoverXidMap(SubCoordinator coord) {
        GTID gtid = coord.getGTID();
        if (logger.isLoggable(JeusMessage_TMRecovery0._1302_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1302_LEVEL, "SubCoordinatorXidContainer", "putRecoverXidMap", JeusMessage_TMRecovery0._1302, new Object[]{gtid, gtid.getTMInfo()});
        }
        this.recoverXidMap.putTMInfoEntry(gtid.getTMInfo(), gtid.getXidFormat(), coord);
    }

    public final void removeIncompleteSubTx(SubCoordinator coord) {
        GTID gtid = coord.getGTID();
        if (logger.isLoggable(JeusMessage_TMRecovery0._1303_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1303_LEVEL, "SubCoordinatorXidContainer", "removeIncompleteSubTx", JeusMessage_TMRecovery0._1303, new Object[]{gtid, gtid.getTMInfo()});
        }
        this.recoverXidMap.removeXidEntry(gtid.getTMInfo(), gtid.getXidFormat());
        this.recoverXidMap.removeTMInfoEntry(gtid.getTMInfo());
    }

    public final Xid[] getXids(TMInfo socketID) {
        return this.recoverXidMap.getXidArrayByTMInfo(socketID);
    }

    public final void setGlobalDecision(Xid xid, boolean commit) throws TMException {
        GTID gtid = new GTID(xid.getGlobalTransactionId());
        TMInfo rootCoordinatorInfo = gtid.getTMInfo();
        Map incompletedTxs = this.recoverXidMap.getTMInfoEntry(rootCoordinatorInfo);
        if (logger.isLoggable(JeusMessage_TMRecovery0._1304_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1304_LEVEL, "SubCoordinatorXidContainer", "setGlobalDecision", JeusMessage_TMRecovery0._1304, new Object[]{commit ? "commit" : "rollback", XidToString.getXidString(xid), gtid});
        }
        if (this.getGlobalDecisionForXid(incompletedTxs, xid, commit, gtid)) {
            incompletedTxs.remove(xid);
            if (incompletedTxs.size() == 0) {
                this.recoverXidMap.removeTMInfoEntry(rootCoordinatorInfo);
            }
        } else {
            throw new TMException("Not recovered completely");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getGlobalDecisionForXid(Map incompletedTxs, Xid xid, boolean commit, GTID gtid) throws TMException {
        boolean allRemoved = true;
        Object obj = incompletedTxs.get(xid);
        if (obj == null) {
            System.out.println("***** hashcode : " + xid.hashCode() + ", xid : " + XidToString.getXidString(xid) + ", class : " + xid.getClass());
            for (Xid xid1 : incompletedTxs.keySet()) {
                System.out.println("***** xid in table : " + XidToString.getXidString(xid1) + ", equals : " + xid1.equals(xid) + ", hashcode : " + xid1.hashCode() + ", class : " + xid1.getClass());
            }
            System.out.println("***** info : " + this.getInformation(""));
            throw new TMException("This xid is not known to this sub coordinator, maybe recover is not called before calling commit or rollback : " + XidToString.getXidString(xid));
        }
        if (obj instanceof Set) {
            Set infos = (Set)obj;
            byte decision = commit ? (byte)0 : 1;
            Iterator i = infos.iterator();
            while (i.hasNext()) {
                ReferenceInfo info = (ReferenceInfo)i.next();
                XAResourceFactory xaResourceFactory = info.getResourceReference();
                XAResource xaResource = null;
                XAResourceFactory xAResourceFactory = xaResourceFactory;
                synchronized (xAResourceFactory) {
                    block28: {
                        Object var16_22;
                        try {
                            try {
                                if (logger.isLoggable(JeusMessage_TMRecovery0._1201_LEVEL)) {
                                    logger.logp(JeusMessage_TMRecovery0._1201_LEVEL, "TxRecoveryDelegator", "createControlSessionContainer", JeusMessage_TMRecovery0._1201, (Object)info);
                                }
                                xaResource = xaResourceFactory.getXAResource();
                                TxRecoveryDelegator.applyDecision(decision, xid, xaResource);
                                info.removePendingXid(xid);
                                i.remove();
                            }
                            catch (XAException e) {
                                if (logger.isLoggable(JeusMessage_TMRecovery0._1234_LEVEL)) {
                                    logger.log(JeusMessage_TMRecovery0._1234_LEVEL, JeusMessage_TMRecovery0._1234, (Object)XidToString.getXAErrorCode(e.errorCode));
                                }
                                e.printStackTrace();
                                allRemoved = false;
                                var16_22 = null;
                                if (xaResource != null) {
                                    xaResourceFactory.close(xaResource);
                                }
                                break block28;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                allRemoved = false;
                                var16_22 = null;
                                if (xaResource != null) {
                                    xaResourceFactory.close(xaResource);
                                }
                            }
                            var16_22 = null;
                            if (xaResource != null) {
                                xaResourceFactory.close(xaResource);
                            }
                        }
                        catch (Throwable throwable) {
                            var16_22 = null;
                            if (xaResource != null) {
                                xaResourceFactory.close(xaResource);
                            }
                            throw throwable;
                        }
                    }
                }
            }
        } else {
            if (logger.isLoggable(JeusMessage_TMRecovery0._1305_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1305_LEVEL, "SubCoordinatorXidContainer", "getGlobalDecision", JeusMessage_TMRecovery0._1305, new Object[]{commit ? "commit" : "rollback", XidToString.getXidString(xid), gtid});
            }
            if (commit) {
                SubCoordinator coord = TMServer.getSubCoordinator(gtid);
                if (coord != null) {
                    byte response = RootCoordinatorProxy.commitSubCoordinator(gtid);
                    allRemoved = response == 3;
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "coordinator does not exist for tx " + gtid + ", it is removed because of RONLY from prepare stage, so recovery is ignored");
                }
            } else {
                SubCoordinator coord = TMServer.getSubCoordinator(gtid);
                if (coord != null) {
                    RootCoordinatorProxy.rollback(gtid);
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "coordinator does not exist for tx " + gtid + ", it is removed because of RONLY from prepare stage, so recovery is ignored");
                }
            }
        }
        return allRemoved;
    }

    public final boolean setGlobalDecision(GTID gtid, boolean commit) throws TMException {
        TMInfo rootCoordinatorInfo = gtid.getTMInfo();
        Map incompletedTxs = this.recoverXidMap.getTMInfoEntry(rootCoordinatorInfo);
        if (incompletedTxs == null) {
            if (logger.isLoggable(JeusMessage_TMRecovery0._1306_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1306_LEVEL, "SubCoordinatorXidContainer", "setGlobalDecision", JeusMessage_TMRecovery0._1306, (Object)gtid);
            }
            return false;
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1307_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1307_LEVEL, "SubCoordinatorXidContainer", "setGlobalDecision", JeusMessage_TMRecovery0._1307, new Object[]{commit ? "commit" : "rollback", gtid});
        }
        boolean throwException = false;
        Iterator i = incompletedTxs.keySet().iterator();
        while (i.hasNext()) {
            Xid xid = (Xid)i.next();
            if (!Arrays.equals(gtid.toBytes(), xid.getGlobalTransactionId())) continue;
            if (this.getGlobalDecisionForXid(incompletedTxs, xid, commit, gtid)) {
                i.remove();
                if (incompletedTxs.size() != 0) continue;
                this.recoverXidMap.removeTMInfoEntry(rootCoordinatorInfo);
                continue;
            }
            throwException = true;
        }
        if (throwException) {
            throw new TMException("Not recovered completely");
        }
        return true;
    }

    public final void forgetIncompletedTx(Xid xid) throws TMException {
        GTID gtid = new GTID(xid.getGlobalTransactionId());
        TMInfo rootCoordinatorInfo = gtid.getTMInfo();
        Map incompletedTxs = this.recoverXidMap.getTMInfoEntry(rootCoordinatorInfo);
        if (logger.isLoggable(JeusMessage_TMRecovery0._1304_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1304_LEVEL, "SubCoordinatorXidContainer", "setGlobalDecision", JeusMessage_TMRecovery0._1304, new Object[]{"forget", XidToString.getXidString(xid), gtid});
        }
        if (this.forgetIncompletedTx(incompletedTxs, xid, gtid)) {
            incompletedTxs.remove(xid);
            if (incompletedTxs.size() == 0) {
                this.recoverXidMap.removeTMInfoEntry(rootCoordinatorInfo);
            }
        } else {
            throw new TMException("Not recovered completely");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forgetIncompletedTx(Map incompletedTxs, Xid xid, GTID gtid) throws TMException {
        boolean allRemoved = true;
        Object obj = incompletedTxs.get(xid);
        if (obj == null) {
            System.out.println("***** hashcode : " + xid.hashCode() + ", xid : " + XidToString.getXidString(xid) + ", class : " + xid.getClass());
            for (Xid xid1 : incompletedTxs.keySet()) {
                System.out.println("***** xid in table : " + XidToString.getXidString(xid1) + ", equals : " + xid1.equals(xid) + ", hashcode : " + xid1.hashCode() + ", class : " + xid1.getClass());
            }
            System.out.println("***** info : " + this.getInformation(""));
            throw new TMException("This xid is not known to this sub coordinator, maybe recover is not called before calling commit or rollback : " + XidToString.getXidString(xid));
        }
        if (obj instanceof Set) {
            Set infos = (Set)obj;
            Iterator i = infos.iterator();
            while (i.hasNext()) {
                ReferenceInfo info = (ReferenceInfo)i.next();
                XAResourceFactory xaResourceFactory = info.getResourceReference();
                XAResource xaResource = null;
                XAResourceFactory xAResourceFactory = xaResourceFactory;
                synchronized (xAResourceFactory) {
                    block20: {
                        Object var14_17;
                        try {
                            try {
                                if (logger.isLoggable(JeusMessage_TMRecovery0._1201_LEVEL)) {
                                    logger.logp(JeusMessage_TMRecovery0._1201_LEVEL, "TxRecoveryDelegator", "createControlSessionContainer", JeusMessage_TMRecovery0._1201, (Object)info);
                                }
                                xaResource = xaResourceFactory.getXAResource();
                                xaResource.forget(xid);
                                info.removePendingXid(xid);
                                i.remove();
                            }
                            catch (XAException e) {
                                if (logger.isLoggable(JeusMessage_TMRecovery0._1310_LEVEL)) {
                                    logger.log(JeusMessage_TMRecovery0._1310_LEVEL, JeusMessage_TMRecovery0._1310, (Object)XidToString.getXAErrorCode(e.errorCode));
                                }
                                e.printStackTrace();
                                allRemoved = false;
                                var14_17 = null;
                                if (xaResource != null) {
                                    xaResourceFactory.close(xaResource);
                                }
                                break block20;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                allRemoved = false;
                                var14_17 = null;
                                if (xaResource != null) {
                                    xaResourceFactory.close(xaResource);
                                }
                            }
                            var14_17 = null;
                            if (xaResource != null) {
                                xaResourceFactory.close(xaResource);
                            }
                        }
                        catch (Throwable throwable) {
                            var14_17 = null;
                            if (xaResource != null) {
                                xaResourceFactory.close(xaResource);
                            }
                            throw throwable;
                        }
                    }
                }
            }
        } else {
            if (logger.isLoggable(JeusMessage_TMRecovery0._1305_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1305_LEVEL, "SubCoordinatorXidContainer", "getGlobalDecision", JeusMessage_TMRecovery0._1305, new Object[]{"forget", XidToString.getXidString(xid), gtid});
            }
            throw new TMException("cannot forget an active or prepared transaction");
        }
        return allRemoved;
    }

    public final boolean hasIncompleteSubTx() {
        return this.recoverXidMap.size() > 0;
    }

    void sendReplayCompletion() {
        Set rootTM = this.recoverXidMap.getTmInfoSet();
        Iterator iter = rootTM.iterator();
        HashSet<NodeInfo> set = new HashSet<NodeInfo>();
        while (iter.hasNext()) {
            NodeInfo rootNode;
            TMInfo root = (TMInfo)iter.next();
            if (logger.isLoggable(JeusMessage_TMRecovery0._1308_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1308_LEVEL, "SubCoordinatorXidContainer", "sendReplayCompletion", JeusMessage_TMRecovery0._1308, (Object)root);
            }
            if (set.contains(rootNode = new NodeInfo(root.getHost(), root.getPort(), root.getVirtualID()))) continue;
            set.add(rootNode);
            try {
                TMLink link = TMServer.getLink(root);
                link.replayCompletion();
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_TMRecovery0._1309_LEVEL)) continue;
                logger.logp(JeusMessage_TMRecovery0._1309_LEVEL, "SubCoordinatorXidContainer", "sendReplayCompletion", JeusMessage_TMRecovery0._1309, root, (Throwable)e);
            }
        }
    }

    public String getInformation(String prefix) {
        return this.recoverXidMap.getInformation(prefix);
    }
}

