/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.transaction.GTID;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.TxStatus;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.XidImpl;
import jeus.transaction.external.OTSXid;
import jeus.transaction.logging.CoordinatorXAResourceFactory;
import jeus.transaction.logging.HowlLogManager;
import jeus.transaction.logging.IncompletedTx;
import jeus.transaction.logging.ReferenceInfo;
import jeus.transaction.logging.XAResourceFactoryCreationException;
import jeus.transaction.logging.XidInfo;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.util.XidHashTable;
import jeus.transaction.util.XidToString;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_TM3;
import jeus.util.message.JeusMessage_TMRecovery0;
import jeus.util.properties.JeusTMProperties;
import org.objectweb.howl.log.xa.XACommittingTx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxRecoveryDelegator {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction.recovery");
    private final AtomicBoolean isFirstRecoveryStarted = new AtomicBoolean(false);
    private final CountDownLatch startGate = new CountDownLatch(1);
    private final Map incompletedTxList = new Hashtable();
    private final Map incompletedTxXidList = new XidHashTable();
    private final Map incompletedOtsTxList = new Hashtable();
    private final Map<ReferenceInfo, ReferenceInfo> currentResourceRefs = new Hashtable<ReferenceInfo, ReferenceInfo>();
    private final Map<ReferenceInfo, ReferenceInfo> recoveredResourceRefs = new Hashtable<ReferenceInfo, ReferenceInfo>();
    protected final ResourceMonitor resourceMonitorThread = this.getResourceMonitor();
    private Map failedReferences;
    protected final HowlLogManager logManager;
    protected final TMInfo tmServer;

    public TxRecoveryDelegator(HowlLogManager howlLogManager, TMInfo tmServer) {
        this.logManager = howlLogManager;
        this.tmServer = tmServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTxRecovery() {
        boolean showLogs = false;
        if (logger.isLoggable(JeusMessage_TMRecovery0._1223_LEVEL)) {
            int resources = this.recoveredResourceRefs.size();
            int indoubtTxs = this.incompletedTxList.size();
            int indoubtExternalTxs = this.incompletedTxXidList.size();
            int indoubtOtsTxs = this.incompletedOtsTxList.size();
            if (resources != 0 || indoubtTxs != 0 || indoubtExternalTxs != 0 || indoubtOtsTxs != 0) {
                showLogs = true;
                StringBuffer tempBuffer = new StringBuffer(384);
                tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1219, "Current Recovery Information"));
                tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1220, resources));
                tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1221, indoubtTxs));
                tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1222, indoubtExternalTxs));
                tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1232, indoubtOtsTxs));
                logger.logp(JeusMessage_TMRecovery0._1223_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1223, (Object)tempBuffer.toString());
            }
        }
        if (this.isFirstRecoveryStarted.compareAndSet(false, true)) {
            try {
                this.failedReferences = this.resyncXAResources(this.recoveredResourceRefs, true);
                if (this.failedReferences != null && this.failedReferences.size() > 0 || this.logManager.moreIncompletedSubTx()) {
                    this.resourceMonitorThread.setDaemon(true);
                    this.resourceMonitorThread.start();
                } else if (JeusTMProperties.REMOVE_INCOMPLETE_TX) {
                    this.removeRecoveredIncompleteTxs();
                }
                Object var8_16 = null;
                this.startGate.countDown();
                this.completeDeferredOperations();
            }
            catch (Throwable throwable) {
                Object var8_17 = null;
                this.startGate.countDown();
                this.completeDeferredOperations();
                throw throwable;
            }
        }
        if (this.waitForRecovery()) {
            Map indoubtTxs = this.incompletedTxList;
            synchronized (indoubtTxs) {
                Map currentFailedReferences;
                Map<ReferenceInfo, ReferenceInfo> indoubtExternalTxs = this.currentResourceRefs;
                synchronized (indoubtExternalTxs) {
                    currentFailedReferences = this.resyncXAResources(this.currentResourceRefs, false);
                }
                if (currentFailedReferences.size() == 0 && JeusTMProperties.REMOVE_INCOMPLETE_TX) {
                    this.removeCurrentIncompleteTx();
                }
            }
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1223_LEVEL) && showLogs) {
            StringBuffer tempBuffer = new StringBuffer(1024);
            tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1219, " After Recovery Information "));
            tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1220, this.recoveredResourceRefs.size()));
            tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1221, this.incompletedTxList.size()));
            for (IncompletedTx incompletedTx : this.incompletedTxList.keySet()) {
                tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1224, incompletedTx.getLTID()));
                tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1225, incompletedTx.getTime()));
                tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1226, XidToString.getXidString(incompletedTx.getExternalXid())));
                tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1227));
                List childXids = incompletedTx.getChildXids();
                for (int j = 0; j < childXids.size(); ++j) {
                    XidInfo xidInfo = (XidInfo)childXids.get(j);
                    tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1228, XidToString.getXidString(xidInfo.getXid())));
                    logger.logp(JeusMessage_TMRecovery0._1228_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1228, (Object)XidToString.getXidString(xidInfo.getXid()));
                }
            }
            tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1222, this.incompletedTxXidList.size()));
            tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1232, this.incompletedOtsTxList.size()));
            String subTxXids = this.logManager.getSubXidContainer().getInformation("\t");
            if (subTxXids != null && subTxXids.length() > 0) {
                tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1230, subTxXids));
            }
            tempBuffer.append('\n').append(JeusMessageBundles.getMessage(JeusMessage_TMRecovery0._1229, this.failedReferences == null ? 0 : this.failedReferences.size()));
            logger.logp(JeusMessage_TMRecovery0._1223_LEVEL, "TxRecoveryDelegator", "doTxRecovery", JeusMessage_TMRecovery0._1223, (Object)tempBuffer.toString());
        }
    }

    private final void completeDeferredOperations() {
        this.logManager.registerDeferredXaResourceFactory();
    }

    private void removeCurrentIncompleteTx() {
        Iterator i = this.incompletedTxList.keySet().iterator();
        while (i.hasNext()) {
            IncompletedTx incompletedTx = (IncompletedTx)i.next();
            if (incompletedTx.isRecovered() || incompletedTx.getExternalXid() != null) continue;
            this.logManager.logXaDone((XACommittingTx)incompletedTx.getHandback());
            i.remove();
        }
    }

    private void removeRecoveredIncompleteTxs() {
        Iterator i = this.incompletedTxList.keySet().iterator();
        while (i.hasNext()) {
            IncompletedTx incompletedTx = (IncompletedTx)i.next();
            if (incompletedTx.getExternalXid() != null || !incompletedTx.isRecovered()) continue;
            this.logManager.logXaDone((XACommittingTx)incompletedTx.getHandback());
            i.remove();
        }
    }

    protected boolean recoverAllTx(Xid[] xids, XAResource xaResource, ReferenceInfo info, HashMap<GTID, IncompletedTx> recoveredTx) {
        HashSet<Xid> notRecoveredXids = new HashSet<Xid>();
        for (int k = 0; k < xids.length; ++k) {
            GTID gtid;
            Xid xid = xids[k];
            if (xid == null || (gtid = TxRecoveryDelegator.getGTIDFromXid(xid)) == null) continue;
            if (this.tmServer.isGeneratedAtThisTM(gtid)) {
                IncompletedTx tx = this.getIncompletedTx(gtid.getLTID(), gtid.getTime());
                if (tx == null && this.logManager.isRunningTx(gtid.getLTID())) continue;
                TxRecoveryDelegator.recoverTxWithAuthority(tx, gtid, recoveredTx, xid, xaResource, notRecoveredXids, info);
                continue;
            }
            if (TxRecoveryDelegator.isXidAssociatedWithThisTM(TMServer.bqbase, xid)) {
                notRecoveredXids.add(xid);
                TMInfo tmInfo = gtid.getTMInfo();
                if (logger.isLoggable(JeusMessage_TMRecovery0._1204_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1204_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1204, new Object[]{XidToString.getXidString(xid), "sub", "unknown", gtid});
                }
                this.logManager.addToSubXidContainer(tmInfo, xid, info);
                continue;
            }
            if (!logger.isLoggable(JeusMessage_TMRecovery0._1210_LEVEL)) continue;
            logger.logp(JeusMessage_TMRecovery0._1210_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1210, (Object)XidToString.getXidString(xid));
        }
        if (notRecoveredXids.size() == 0) {
            return true;
        }
        info.setPendingXids(notRecoveredXids);
        return false;
    }

    protected static void recoverTxWithAuthority(IncompletedTx tx, GTID gtid, HashMap<GTID, IncompletedTx> recoveredTx, Xid xid, XAResource xaResource, HashSet<Xid> notRecoveredXids, ReferenceInfo info) {
        block12: {
            if (xid == null || xaResource == null) {
                return;
            }
            if (tx != null && recoveredTx != null) {
                recoveredTx.put(gtid, tx);
            }
            byte decision = TxRecoveryDelegator.getDecision(tx);
            if (logger.isLoggable(JeusMessage_TMRecovery0._1204_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1204_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1204, new Object[]{XidToString.getXidString(xid), decision == -1 ? "external" : "root", TxStatus.getState(decision), gtid});
            }
            try {
                if (!TxRecoveryDelegator.applyDecision(decision, xid, xaResource)) {
                    if (notRecoveredXids != null) {
                        notRecoveredXids.add(xid);
                    }
                    if (tx != null) {
                        tx.addChildXid(xid, info);
                    }
                } else if (tx != null) {
                    tx.removeChildXid(xid, info);
                    tx.removeRuntimeChildXid(xid);
                }
            }
            catch (Throwable ex) {
                if (notRecoveredXids != null) {
                    notRecoveredXids.add(xid);
                }
                if (tx != null) {
                    tx.addChildXid(xid, info);
                }
                if (!logger.isLoggable(JeusMessage_TMRecovery0._1208_LEVEL)) break block12;
                logger.logp(JeusMessage_TMRecovery0._1208_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1208, new Object[]{XidToString.getXidString(xid), TxStatus.getState(decision)}, ex);
            }
        }
    }

    protected void completeRecoveredTx(HashMap<GTID, IncompletedTx> recoveredTx) {
        if (recoveredTx == null) {
            return;
        }
        for (IncompletedTx tx : recoveredTx.values()) {
            this.checkChildXids(tx);
        }
    }

    protected boolean checkChildXids(IncompletedTx tx) {
        if (tx == null) {
            return true;
        }
        if (tx.isChildsEmpty()) {
            this.logManager.logXaDone((XACommittingTx)tx.getHandback());
            Xid externalXid = tx.getExternalXid();
            if (externalXid != null) {
                this.removeTxFromXidList(externalXid, tx.getResource());
            }
            this.removeTxFromIncompletedTxList(tx);
            if (logger.isLoggable(JeusMessage_TM3._5827_LEVEL)) {
                logger.logp(JeusMessage_TM3._5827_LEVEL, "TxRecoveryDelegator", "checkChildXids", JeusMessage_TM3._5827, (Object)tx.getGTID());
            }
            return true;
        }
        return false;
    }

    static GTID getGTIDFromXid(Xid xid) {
        if (xid.getFormatId() == 9736) {
            try {
                return new GTID(xid.getGlobalTransactionId());
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                if (logger.isLoggable(JeusMessage_TMRecovery0._1209_LEVEL)) {
                    logger.logp(JeusMessage_TMRecovery0._1209_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1209, (Object)XidToString.getXidString(xid));
                }
                return null;
            }
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1209_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1209_LEVEL, "TxRecoveryDelegator", "recoverAllTx", JeusMessage_TMRecovery0._1209, (Object)XidToString.getXidString(xid));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map resyncCurrentXAResources() {
        Map<ReferenceInfo, ReferenceInfo> map = this.currentResourceRefs;
        synchronized (map) {
            return this.resyncXAResources(this.currentResourceRefs, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map resyncXAResources(Map recoveredResourceMap, boolean removeResource) {
        XAResourceFactory xAResourceFactory;
        XAResourceFactory xaResourceFactory;
        Hashtable<ReferenceInfo, ReferenceInfo> failedReferenceList = new Hashtable<ReferenceInfo, ReferenceInfo>();
        ArrayList<XAResourceItem> oldXaResourceItems = new ArrayList<XAResourceItem>();
        if (recoveredResourceMap == null) {
            return failedReferenceList;
        }
        HashMap<GTID, IncompletedTx> recoveredTx = new HashMap<GTID, IncompletedTx>();
        Iterator iterator = recoveredResourceMap.keySet().iterator();
        while (iterator.hasNext()) {
            XAResource xaResource = null;
            ReferenceInfo reference = (ReferenceInfo)iterator.next();
            if (logger.isLoggable(JeusMessage_TMRecovery0._1201_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1201_LEVEL, "TxRecoveryDelegator", "createControlSessionContainer", JeusMessage_TMRecovery0._1201, (Object)reference);
            }
            if ((xaResourceFactory = this.findXAResouceFactory(reference)) == null) continue;
            xAResourceFactory = xaResourceFactory;
            synchronized (xAResourceFactory) {
                try {
                    xaResource = xaResourceFactory.getXAResource();
                    if (xaResource == null) {
                        throw new TMException("failed to get a XAResource. XAResource is null");
                    }
                }
                catch (Exception e) {
                    if (e instanceof XAResourceFactoryCreationException) {
                        if (logger.isLoggable(JeusMessage_TMRecovery0._1238_LEVEL)) {
                            logger.log(JeusMessage_TMRecovery0._1238_LEVEL, JeusMessage_TMRecovery0._1238, new Object[]{reference, e.getMessage()});
                        }
                    } else {
                        if (logger.isLoggable(JeusMessage_TMRecovery0._1211_LEVEL)) {
                            logger.log(JeusMessage_TMRecovery0._1211_LEVEL, JeusMessage_TMRecovery0._1211, new Object[]{reference, e.getMessage()});
                        }
                        logger.log(Level.FINE, "", (Throwable)e);
                    }
                    failedReferenceList.put(reference, reference);
                    continue;
                }
                if (!this.isAlreadyRecovered(xaResource, oldXaResourceItems)) {
                    oldXaResourceItems.add(new XAResourceItem(xaResourceFactory, xaResource));
                    Xid[] xids = null;
                    try {
                        xids = xaResource.recover(0x1000000);
                    }
                    catch (Throwable ex) {
                        if (ex instanceof XAException) {
                            if (((XAException)ex).errorCode == -3) {
                                if (logger.isLoggable(JeusMessage_TMRecovery0._1237_LEVEL)) {
                                    logger.logp(JeusMessage_TMRecovery0._1237_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1237, XidToString.getXAErrorCode(((XAException)ex).errorCode), ex);
                                }
                            } else if (logger.isLoggable(JeusMessage_TMRecovery0._1217_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1217_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1217, XidToString.getXAErrorCode(((XAException)ex).errorCode), ex);
                            }
                        }
                        if (logger.isLoggable(JeusMessage_TMRecovery0._1212_LEVEL)) {
                            logger.logp(JeusMessage_TMRecovery0._1212_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1212, xaResource, ex);
                        }
                        failedReferenceList.put(reference, reference);
                        continue;
                    }
                    if (logger.isLoggable(JeusMessage_TMRecovery0._1203_LEVEL)) {
                        logger.logp(JeusMessage_TMRecovery0._1203_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1203, new Object[]{xaResource, String.valueOf(xids.length)});
                    }
                    if (this.recoverAllTx(xids, xaResource, reference, recoveredTx) && removeResource) {
                        this.logManager.logResourceDone((XACommittingTx)reference.getHandback());
                        iterator.remove();
                    }
                } else {
                    if (logger.isLoggable(JeusMessage_TMRecovery0._1202_LEVEL)) {
                        logger.logp(JeusMessage_TMRecovery0._1202_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1202, (Object)xaResource);
                    }
                    if (removeResource) {
                        iterator.remove();
                        this.logManager.logResourceDone((XACommittingTx)reference.getHandback());
                    }
                    if (xaResource != null) {
                        xaResourceFactory.close(xaResource);
                    }
                }
            }
        }
        if (failedReferenceList.isEmpty()) {
            this.completeRecoveredTx(recoveredTx);
        }
        recoveredTx.clear();
        for (XAResourceItem storedXaResourceItem : oldXaResourceItems) {
            xAResourceFactory = xaResourceFactory = storedXaResourceItem.getXaResourceFactory();
            synchronized (xAResourceFactory) {
                xaResourceFactory.close(storedXaResourceItem.getXaResource());
            }
        }
        oldXaResourceItems.clear();
        return failedReferenceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XAResourceFactory findXAResouceFactory(ReferenceInfo referenceInfo) {
        if (referenceInfo == null) {
            return null;
        }
        XAResourceFactory xaResourceFactory = referenceInfo.getResourceReference();
        if (xaResourceFactory != null) {
            return xaResourceFactory;
        }
        String exportName = referenceInfo.getExportName();
        if (exportName == null) {
            return null;
        }
        Map<ReferenceInfo, ReferenceInfo> map = this.recoveredResourceRefs;
        synchronized (map) {
            for (ReferenceInfo recoveredRef : this.recoveredResourceRefs.values()) {
                if (!exportName.equals(recoveredRef.getExportName())) continue;
                xaResourceFactory = recoveredRef.getResourceReference();
                break;
            }
        }
        if (xaResourceFactory != null) {
            referenceInfo.setResourceReference(xaResourceFactory);
            return xaResourceFactory;
        }
        map = this.currentResourceRefs;
        synchronized (map) {
            for (ReferenceInfo currentRef : this.currentResourceRefs.values()) {
                if (!exportName.equals(currentRef.getExportName())) continue;
                xaResourceFactory = currentRef.getResourceReference();
                break;
            }
        }
        if (xaResourceFactory != null) {
            referenceInfo.setResourceReference(xaResourceFactory);
            return xaResourceFactory;
        }
        return null;
    }

    private boolean isAlreadyRecovered(XAResource currentXaResource, List oldXaResourceItems) {
        for (XAResourceItem xaResourceItem : oldXaResourceItems) {
            try {
                if (!currentXaResource.isSameRM(xaResourceItem.getXaResource())) continue;
                return true;
            }
            catch (XAException e) {
                if (!logger.isLoggable(JeusMessage_TMRecovery0._1231_LEVEL)) continue;
                logger.logp(JeusMessage_TMRecovery0._1231_LEVEL, "TxRecoveryDelegator", "isAlreadyRecovered", JeusMessage_TMRecovery0._1231, new Object[]{XidToString.getXAErrorCode(e.errorCode), currentXaResource}, (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resyncChildTx(IncompletedTx tx, Xid xid) throws XAException {
        byte decision = TxRecoveryDelegator.getDecision(tx);
        List childrenXids = tx.getChildXids();
        Iterator iter = childrenXids.iterator();
        while (iter.hasNext()) {
            XidInfo xidInfo = (XidInfo)iter.next();
            ReferenceInfo refInfo = xidInfo.getReferenceInfo();
            XAResourceFactory xaResourceFactory = refInfo.getResourceReference();
            Xid childXid = xidInfo.getXid();
            XAResource xaResource = null;
            XAResourceFactory xAResourceFactory = xaResourceFactory;
            synchronized (xAResourceFactory) {
                Object var14_14;
                try {
                    block15: {
                        try {
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1201_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1201_LEVEL, "TxRecoveryDelegator", "createControlSessionContainer", JeusMessage_TMRecovery0._1201, (Object)refInfo);
                            }
                            xaResource = xaResourceFactory.getXAResource();
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1213_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1213_LEVEL, "TxRecoveryDelegator", "resyncChildTx", JeusMessage_TMRecovery0._1213, new Object[]{TxStatus.getState(decision), XidToString.getXidString(childXid), XidToString.getXidString(xid), xaResource});
                            }
                            if (!TxRecoveryDelegator.applyDecision(decision, childXid, xaResource)) break block15;
                            refInfo.removePendingXid(childXid);
                            iter.remove();
                        }
                        catch (XAException e) {
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1233_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1233_LEVEL, "TxRecoveryDelegator", "isAlreadyRecovered", JeusMessage_TMRecovery0._1233, XidToString.getXAErrorCode(e.errorCode), (Throwable)e);
                            }
                            throw e;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            var14_14 = null;
                            if (xaResource != null) {
                                xaResourceFactory.close(xaResource);
                            }
                        }
                    }
                    var14_14 = null;
                    if (xaResource != null) {
                        xaResourceFactory.close(xaResource);
                    }
                }
                catch (Throwable throwable) {
                    var14_14 = null;
                    if (xaResource != null) {
                        xaResourceFactory.close(xaResource);
                    }
                    throw throwable;
                }
            }
        }
        return this.checkChildXids(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forgetChildTx(List childrenXids, Xid xid) {
        boolean completionDone = true;
        if (childrenXids == null) {
            return completionDone;
        }
        Iterator iter = childrenXids.iterator();
        while (iter.hasNext()) {
            XidInfo xidInfo = (XidInfo)iter.next();
            ReferenceInfo refInfo = xidInfo.getReferenceInfo();
            XAResourceFactory xaResourceFactory = refInfo.getResourceReference();
            Xid childXid = xidInfo.getXid();
            XAResource xaResource = null;
            XAResourceFactory xAResourceFactory = xaResourceFactory;
            synchronized (xAResourceFactory) {
                block17: {
                    Object var13_14;
                    try {
                        try {
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1201_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1201_LEVEL, "TxRecoveryDelegator", "createControlSessionContainer", JeusMessage_TMRecovery0._1201, (Object)refInfo);
                            }
                            xaResource = xaResourceFactory.getXAResource();
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1213_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1213_LEVEL, "TxRecoveryDelegator", "resyncChildTx", JeusMessage_TMRecovery0._1213, new Object[]{"forget", XidToString.getXidString(childXid), XidToString.getXidString(xid), xaResource});
                            }
                            xaResource.forget(childXid);
                            refInfo.removePendingXid(childXid);
                            iter.remove();
                        }
                        catch (XAException e) {
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1233_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1233_LEVEL, "TxRecoveryDelegator", "isAlreadyRecovered", JeusMessage_TMRecovery0._1233, XidToString.getXAErrorCode(e.errorCode), (Throwable)e);
                            }
                            completionDone = false;
                            var13_14 = null;
                            if (xaResource != null) {
                                xaResourceFactory.close(xaResource);
                            }
                            break block17;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            completionDone = false;
                            var13_14 = null;
                            if (xaResource != null) {
                                xaResourceFactory.close(xaResource);
                            }
                        }
                        var13_14 = null;
                        if (xaResource != null) {
                            xaResourceFactory.close(xaResource);
                        }
                    }
                    catch (Throwable throwable) {
                        var13_14 = null;
                        if (xaResource != null) {
                            xaResourceFactory.close(xaResource);
                        }
                        throw throwable;
                    }
                }
            }
        }
        return completionDone;
    }

    public static boolean applyDecision(byte decision, Xid xid, XAResource xaRsc) throws XAException {
        if (decision == 0) {
            if (logger.isLoggable(JeusMessage_TMRecovery0._1205_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1205_LEVEL, "TxRecoveryDelegator", "applyDecision", JeusMessage_TMRecovery0._1205, new Object[]{XidToString.getXidString(xid), xaRsc});
            }
            xaRsc.commit(xid, false);
            return true;
        }
        if (decision == 1) {
            if (logger.isLoggable(JeusMessage_TMRecovery0._1206_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1206_LEVEL, "TxRecoveryDelegator", "applyDecision", JeusMessage_TMRecovery0._1206, new Object[]{XidToString.getXidString(xid), xaRsc});
            }
            xaRsc.rollback(xid);
            return true;
        }
        if (decision == -1 && logger.isLoggable(JeusMessage_TMRecovery0._1207_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1207_LEVEL, "TxRecoveryDelegator", "applyDecision", JeusMessage_TMRecovery0._1207, (Object)XidToString.getXidString(xid));
        }
        return false;
    }

    public static byte getDecision(IncompletedTx tx) {
        if (tx == null) {
            return 1;
        }
        return tx.getDecision();
    }

    public static boolean isXidAssociatedWithThisTM(byte[] bqBase, Xid xid) {
        if (bqBase == null) {
            return false;
        }
        int compareLength = bqBase.length - 4;
        if (compareLength <= 0) {
            return false;
        }
        byte[] bq = xid.getBranchQualifier();
        if (bq == null || bq.length <= compareLength) {
            return false;
        }
        for (int j = 0; j < compareLength; ++j) {
            if (bqBase[j] == bq[j + 1]) continue;
            return false;
        }
        return true;
    }

    IncompletedTx getIncompletedTx(long ltid, int time) {
        IncompletedTx tx = new IncompletedTx(ltid, time);
        tx = (IncompletedTx)this.incompletedTxList.get(tx);
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceInfo[] getRecoveredXAResourceInfo() {
        Map<ReferenceInfo, ReferenceInfo> map = this.recoveredResourceRefs;
        synchronized (map) {
            Collection<ReferenceInfo> set = this.recoveredResourceRefs.values();
            return set.toArray(new ReferenceInfo[set.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceInfo[] getCurrentXAResourceInfo() {
        Map<ReferenceInfo, ReferenceInfo> map = this.currentResourceRefs;
        synchronized (map) {
            Collection<ReferenceInfo> set = this.currentResourceRefs.values();
            return set.toArray(new ReferenceInfo[set.size()]);
        }
    }

    public IncompletedTx[] getAllIncompletedTx() {
        Collection collection = this.incompletedTxList.values();
        return collection.toArray(new IncompletedTx[collection.size()]);
    }

    public boolean hasIncompletedTx() {
        return this.incompletedTxList.size() > 0;
    }

    public final boolean waitForRecovery() {
        return this.waitForRecovery(Integer.MAX_VALUE);
    }

    public final boolean waitForRecovery(long milliSeconds) {
        if (logger.isLoggable(JeusMessage_TMRecovery0._1214_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1214_LEVEL, "TxRecoveryDelegator", "waitForRecovery", JeusMessage_TMRecovery0._1214);
        }
        try {
            return this.startGate.await(milliSeconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            if (logger.isLoggable(JeusMessage_TMRecovery0._1236_LEVEL)) {
                logger.logp(JeusMessage_TMRecovery0._1236_LEVEL, "TxRecoveryDelegator", "waitForRecovery", JeusMessage_TMRecovery0._1236, (Throwable)ie);
            }
            return false;
        }
    }

    public boolean failedRsrcRemains() {
        if (this.failedReferences != null && this.failedReferences.size() > 0) {
            for (ReferenceInfo refInfo : this.failedReferences.keySet()) {
                XAResourceFactory rsc = refInfo.getResourceReference();
                if (rsc instanceof CoordinatorXAResourceFactory) continue;
                return true;
            }
        }
        return false;
    }

    public int failedResourceSize() {
        if (this.failedReferences == null) {
            return -1;
        }
        return this.failedReferences.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCurrentResourceRef(ReferenceInfo key, ReferenceInfo value) {
        Map<ReferenceInfo, ReferenceInfo> map = this.currentResourceRefs;
        synchronized (map) {
            this.currentResourceRefs.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCurrentResourceReferences() {
        Map<ReferenceInfo, ReferenceInfo> map = this.currentResourceRefs;
        synchronized (map) {
            for (ReferenceInfo info : this.currentResourceRefs.keySet()) {
                this.logManager.logResourceDone((XACommittingTx)info.getHandback());
            }
            this.currentResourceRefs.clear();
        }
    }

    public void addIncompletedTx(IncompletedTx key, IncompletedTx value, Xid xid, ResourceImpl otsResource) {
        IncompletedTx oldIncompletedTx = null;
        if (xid != null) {
            if (!(xid instanceof OTSXid)) {
                oldIncompletedTx = this.incompletedTxXidList.put(xid, value);
            } else if (otsResource != null) {
                oldIncompletedTx = this.incompletedTxXidList.put(xid, value);
                this.incompletedOtsTxList.put(otsResource, value);
            }
        }
        if (oldIncompletedTx != null) {
            this.incompletedTxList.remove(oldIncompletedTx);
            this.incompletedTxList.put(key, value);
        } else {
            this.incompletedTxList.put(key, value);
        }
    }

    public IncompletedTx getTxFromXidList(Xid xid) {
        IncompletedTx tx = (IncompletedTx)this.incompletedTxXidList.get(xid);
        if (tx == null && xid.getFormatId() != 9736) {
            XidImpl xidClone = new XidImpl(xid.getGlobalTransactionId(), xid.getBranchQualifier(), 9736);
            tx = (IncompletedTx)this.incompletedTxXidList.get(xidClone);
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1215_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1215_LEVEL, "TxRecoveryDelegator", "getTxFromXidList", JeusMessage_TMRecovery0._1215, new Object[]{XidToString.getXidString(xid), tx});
        }
        return tx;
    }

    public IncompletedTx removeTxFromXidList(Xid xid, ResourceImpl resource) {
        Object obj;
        IncompletedTx tx = (IncompletedTx)this.incompletedTxXidList.remove(xid);
        if (resource != null && (obj = this.incompletedOtsTxList.remove(resource)) == null) {
            throw new RuntimeException("Internal error");
        }
        return tx;
    }

    public IncompletedTx removeTxFromIncompletedTxList(IncompletedTx tx) {
        return (IncompletedTx)this.incompletedTxList.remove(tx);
    }

    public ReferenceInfo removeRecoveredResourceRef(ReferenceInfo info) {
        return this.recoveredResourceRefs.remove(info);
    }

    public Xid[] getIncompletedExternalXids() {
        Set xidSet = this.incompletedTxXidList.keySet();
        return xidSet.toArray(new Xid[xidSet.size()]);
    }

    public void addRecorveredResourceRef(ReferenceInfo key, ReferenceInfo value) {
        this.recoveredResourceRefs.put(key, value);
    }

    public boolean inRecovery() {
        try {
            return !this.startGate.await(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean isCompletedTx(IncompletedTx tx) {
        return tx == null || this.incompletedTxList.containsKey(tx);
    }

    public void destroy() {
        this.startGate.countDown();
        this.resourceMonitorThread.interrupt();
        this.incompletedTxList.clear();
        this.incompletedTxXidList.clear();
        this.incompletedOtsTxList.clear();
        this.recoveredResourceRefs.clear();
        this.currentResourceRefs.clear();
        if (this.failedReferences != null) {
            this.failedReferences.clear();
            this.failedReferences = null;
        }
    }

    ResourceImpl[] getIncompletedOtsResources() {
        return this.incompletedOtsTxList.keySet().toArray(new ResourceImpl[this.incompletedOtsTxList.size()]);
    }

    public IncompletedTx getIncompletedOtsTx(ResourceImpl rsc) {
        return (IncompletedTx)this.incompletedOtsTxList.get(rsc);
    }

    public boolean isResourceMonitorThreadRunning() {
        return this.resourceMonitorThread.isRunning();
    }

    protected ResourceMonitor getResourceMonitor() {
        if (this.resourceMonitorThread == null) {
            return new ResourceMonitor("Resource Monitor");
        }
        return this.resourceMonitorThread;
    }

    protected class ResourceMonitor
    extends Thread {
        private int retryCount;
        private boolean running;

        public ResourceMonitor(String name) {
            super(name);
            this.retryCount = 0;
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            try {
                block8: {
                    try {
                        while ((TxRecoveryDelegator.this.failedReferences != null && TxRecoveryDelegator.this.failedReferences.size() > 0 || TxRecoveryDelegator.this.logManager.moreIncompletedSubTx()) && ++this.retryCount <= JeusTMProperties.RECOVERY_RETRIAL) {
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1218_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1218_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1218, (Object)Integer.toString(this.retryCount));
                            }
                            if (TxRecoveryDelegator.this.logManager.moreIncompletedSubTx()) {
                                TxRecoveryDelegator.this.logManager.replayCompletionForSubTx();
                            }
                            Thread.sleep(JeusTMProperties.RECOVERY_INTERVAL);
                            if (TxRecoveryDelegator.this.failedReferences == null || TxRecoveryDelegator.this.failedReferences.size() <= 0) continue;
                            TxRecoveryDelegator.this.failedReferences = TxRecoveryDelegator.this.resyncXAResources(TxRecoveryDelegator.this.failedReferences, true);
                        }
                        if (!JeusTMProperties.REMOVE_INCOMPLETE_TX) break block8;
                        TxRecoveryDelegator.this.removeRecoveredIncompleteTxs();
                    }
                    catch (InterruptedException ie) {
                        if (logger.isLoggable(JeusMessage_TMRecovery0._1235_LEVEL)) {
                            logger.logp(JeusMessage_TMRecovery0._1235_LEVEL, "TxRecoveryDelegator", "resyncXAResources", JeusMessage_TMRecovery0._1235, new String[]{String.valueOf(TxRecoveryDelegator.this.failedReferences != null ? TxRecoveryDelegator.this.failedReferences.size() : 0), String.valueOf(TxRecoveryDelegator.this.logManager.moreIncompletedSubTx())}, (Throwable)ie);
                        }
                        Object var3_2 = null;
                        this.running = false;
                    }
                }
                Object var3_1 = null;
                this.running = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.running = false;
                throw throwable;
            }
        }

        public boolean isRunning() {
            return this.running;
        }
    }

    private class XAResourceItem {
        private XAResourceFactory xaResourceFactory;
        private XAResource xaResource;

        public XAResourceItem(XAResourceFactory xaResourceFactory, XAResource xaResource) {
            this.xaResourceFactory = xaResourceFactory;
            this.xaResource = xaResource;
        }

        public XAResourceFactory getXaResourceFactory() {
            return this.xaResourceFactory;
        }

        public XAResource getXaResource() {
            return this.xaResource;
        }
    }
}

