/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jeus.transaction.TMInfo;
import jeus.transaction.external.OTSXid;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_OTS0;
import jeus.util.properties.JeusTMProperties;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTSRecoveryThread
extends Thread {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction.ots");
    private final List<ResourceImpl> resourceImplList;
    private int tryCount = JeusTMProperties.RECOVERY_RETRIAL;
    private boolean running = false;
    protected final TMInfo tmInfo;

    public OTSRecoveryThread(TMInfo tmInfo, String name, List<ResourceImpl> list) {
        super(name);
        this.setDaemon(true);
        this.tmInfo = tmInfo;
        this.resourceImplList = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        try {
            while (this.resourceImplList != null && this.resourceImplList.size() > 0 && this.tryCount > 0) {
                if (logger.isLoggable(JeusMessage_OTS0._1112_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1112_LEVEL, "OTSRecoveryThread", "run", JeusMessage_OTS0._1112, (Object)new Integer(this.resourceImplList.size()));
                }
                Iterator<ResourceImpl> iter = this.resourceImplList.iterator();
                while (iter.hasNext()) {
                    ResourceImpl resource = iter.next();
                    if (!this.setDecision(resource)) continue;
                    iter.remove();
                }
                --this.tryCount;
                try {
                    Thread.sleep(JeusTMProperties.OTS_REPLAY_INTERVAL);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Object var4_4 = null;
            this.running = false;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.running = false;
            throw throwable;
        }
    }

    private boolean setDecision(ResourceImpl resource) {
        OTSXid xid;
        boolean completion;
        block34: {
            completion = false;
            xid = resource.getOTSXid();
            Status decision = ResourceImpl.getDecision(xid);
            if (decision == null || decision.value() == 5) {
                RecoveryCoordinator coord = resource.getRecoveryCoordinator();
                Resource rsc = null;
                try {
                    rsc = resource.object();
                }
                catch (Throwable t) {
                    if (logger.isLoggable(JeusMessage_OTS0._1215_LEVEL)) {
                        logger.logp(JeusMessage_OTS0._1215_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1215, new String[]{xid.toString(), resource.toString()}, t);
                    }
                    return false;
                }
                try {
                    if (logger.isLoggable(JeusMessage_OTS0._1103_LEVEL)) {
                        logger.logp(JeusMessage_OTS0._1103_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1103, (Object[])new String[]{rsc.toString(), xid.toString()});
                    }
                    decision = coord.replay_completion(rsc);
                }
                catch (Throwable t) {
                    if (logger.isLoggable(JeusMessage_OTS0._1113_LEVEL)) {
                        logger.logp(JeusMessage_OTS0._1113_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1113, xid, t);
                    }
                    decision = !(t instanceof COMM_FAILURE) && !(t instanceof TRANSIENT) ? Status.StatusRolledBack : Status.StatusUnknown;
                }
            }
            ResourceImpl.putDecision(xid, decision);
            if (logger.isLoggable(JeusMessage_OTS0._1106_LEVEL)) {
                logger.logp(JeusMessage_OTS0._1106_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1106, new Object[]{xid, this.getDecisionString(decision)});
            }
            try {
                switch (decision.value()) {
                    case 3: {
                        if (logger.isLoggable(JeusMessage_OTS0._1108_LEVEL)) {
                            logger.logp(JeusMessage_OTS0._1108_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1108, (Object)xid);
                        }
                        resource.commit();
                        completion = true;
                        break;
                    }
                    case 4: {
                        if (logger.isLoggable(JeusMessage_OTS0._1107_LEVEL)) {
                            logger.logp(JeusMessage_OTS0._1107_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1107, (Object)xid);
                        }
                        resource.rollback();
                        completion = true;
                        break;
                    }
                    case 2: {
                        decision = Status.StatusUnknown;
                        ResourceImpl.putDecision(xid, decision);
                    }
                    case 5: {
                        if (logger.isLoggable(JeusMessage_OTS0._1109_LEVEL)) {
                            logger.logp(JeusMessage_OTS0._1109_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1109, (Object)xid);
                        }
                        completion = false;
                        break;
                    }
                    case 8: {
                        if (logger.isLoggable(JeusMessage_OTS0._1114_LEVEL)) {
                            logger.logp(JeusMessage_OTS0._1114_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1114, (Object[])new String[]{xid.toString(), resource.toString()});
                        }
                        completion = true;
                        break;
                    }
                    default: {
                        if (logger.isLoggable(JeusMessage_OTS0._1110_LEVEL)) {
                            logger.logp(JeusMessage_OTS0._1110_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1110, new Object[]{this.getDecisionString(decision), xid});
                        }
                        resource.rollback();
                        completion = true;
                        break;
                    }
                }
            }
            catch (NotPrepared notPrepared) {
                if (logger.isLoggable(JeusMessage_OTS0._1111_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1111_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1111, xid, (Throwable)((Object)notPrepared));
                }
            }
            catch (HeuristicMixed heuristicMixed) {
                if (logger.isLoggable(JeusMessage_OTS0._1111_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1111_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1111, xid, (Throwable)((Object)heuristicMixed));
                }
            }
            catch (HeuristicHazard heuristicHazard) {
                if (logger.isLoggable(JeusMessage_OTS0._1111_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1111_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1111, xid, (Throwable)((Object)heuristicHazard));
                }
            }
            catch (HeuristicRollback heuristicRollback) {
                if (logger.isLoggable(JeusMessage_OTS0._1111_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1111_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1111, xid, (Throwable)((Object)heuristicRollback));
                }
            }
            catch (HeuristicCommit heuristicCommit) {
                if (logger.isLoggable(JeusMessage_OTS0._1111_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1111_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1111, xid, (Throwable)((Object)heuristicCommit));
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_OTS0._1111_LEVEL)) break block34;
                logger.logp(JeusMessage_OTS0._1111_LEVEL, "OTSRecoveryThread", "setDecision", JeusMessage_OTS0._1111, xid, t);
            }
        }
        if (completion) {
            ResourceImpl.removeDecision(xid);
            return true;
        }
        return false;
    }

    private String getDecisionString(Status decision) {
        switch (decision.value()) {
            case 0: {
                return "StatusActive";
            }
            case 3: {
                return "StatusCommitted";
            }
            case 8: {
                return "StatusCommitting";
            }
            case 1: {
                return "StatusMarkedRollback";
            }
            case 6: {
                return "StatusNoTransaction";
            }
            case 2: {
                return "StatusPrepared";
            }
            case 7: {
                return "StatusPreparing";
            }
            case 4: {
                return "StatusRolledBack";
            }
            case 9: {
                return "StatusRollingBack";
            }
            case 5: {
                return "StatusUnknown";
            }
        }
        return "UnknownValue";
    }

    public boolean isRunning() {
        return this.running;
    }

    public static void replayOtsRecovery(ResourceImpl resource) {
        if (resource == null) {
            return;
        }
        ArrayList<ResourceImpl> list = new ArrayList<ResourceImpl>();
        list.add(resource);
        if (logger.isLoggable(JeusMessage_OTS0._1102_LEVEL)) {
            logger.logp(JeusMessage_OTS0._1102_LEVEL, "OTSRecoveryThread", "replayOtsRecovery", JeusMessage_OTS0._1102, (Object)resource);
        }
        OTSRecoveryThread otsRecoveryThread = new OTSRecoveryThread(null, "OTS Recovery Thread for Decision", list);
        otsRecoveryThread.start();
    }
}

