/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots;

import jeus.transaction.ots.OTSRecoveryThread;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.util.ScheduleTask;
import jeus.util.ScheduledExecutor;
import jeus.util.properties.JeusTMProperties;

public class OtsDecisionWaitingTimer {
    private WaitingTimerTask task;

    public void startOtsDecisionWaitingTimer(ResourceImpl rsc) {
        this.task = new WaitingTimerTask(rsc);
        ScheduledExecutor.getInstance().schedule(this.task, JeusTMProperties.otsDecisionTO);
    }

    public void cancelOtsDecisionWaitingTimer() {
        this.task.cancel();
    }

    private class WaitingTimerTask
    extends ScheduleTask {
        private ResourceImpl waitingResource;

        WaitingTimerTask(ResourceImpl rsc) {
            this.waitingResource = rsc;
        }

        public void run() {
            if (this.waitingResource == null) {
                return;
            }
            try {
                OTSRecoveryThread.replayOtsRecovery(this.waitingResource);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

