/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots;

import java.util.logging.Level;
import javax.transaction.xa.XAException;
import jeus.transaction.GTID;
import jeus.transaction.TMServer;
import jeus.transaction.TMXAResource;
import jeus.transaction.ThreadContexts;
import jeus.transaction.external.OTSXid;
import jeus.transaction.ots.Configuration;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.root.RootCoordinator;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;
import jeus.util.message.JeusMessage_OTS0;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CosTSPortability.Receiver;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHolder;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.otid_t;

public class ReceiverImpl
implements Receiver {
    private static TMXAResource manager = TMXAResource.getTMXAResource();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction.ots");
    private static ThreadLocal shouldSetTxNull = new ThreadLocal();

    public void received_request(int i, PropagationContext pctx) {
        block12: {
            try {
                GTID propagatedGTID = this.getJeusGTID(pctx);
                if (propagatedGTID != null && TMServer.getTMInfo() != null && TMServer.getTMInfo().isGeneratedAtThisTM(propagatedGTID)) {
                    propagatedGTID.setLocal();
                    ThreadContexts.associateTransactionID(propagatedGTID);
                    shouldSetTxNull.set(Boolean.TRUE);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "set shouldSetTxNull to TRUE for local tx propagation");
                    }
                    break block12;
                }
                OTSXid xid = new OTSXid(pctx);
                boolean isContains = TMXAResource.contains(xid);
                if (manager.begin(xid, manager.getDefaultTransactionTimeout())) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "set shouldSetTxNull to TRUE for foreign tx");
                    }
                    shouldSetTxNull.set(Boolean.TRUE);
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "set shouldSetTxNull to NULL for foreign tx");
                    }
                    shouldSetTxNull.set(null);
                }
                GTID currentGTID = ThreadContexts.getAssociatedTransactionID();
                currentGTID.setExternalXid(xid);
                if (isContains) break block12;
                ResourceImpl resource = null;
                try {
                    resource = ResourceImpl.getCachedResource(xid);
                    if (resource == null) {
                        resource = new ResourceImpl(xid);
                        Resource res = resource.object();
                        RecoveryCoordinator recoveryCoord = pctx.current.coord.register_resource(res);
                        resource.setRecoveryCoordinator(recoveryCoord);
                        ResourceImpl.putCachedResource(xid, resource);
                    }
                }
                catch (Exception ex) {
                    if (logger.isLoggable(JeusMessage_OTS0._1400_LEVEL)) {
                        logger.log(JeusMessage_OTS0._1400_LEVEL, JeusMessage_OTS0._1400, new String[]{xid.toString(), resource == null ? "null" : resource.toString()}, (Throwable)ex);
                    }
                    throw new INTERNAL();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
    }

    private GTID getJeusGTID(PropagationContext ctx) {
        otid_t otid = ctx.current.otid;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "propagated gtid : {0}, , formatID : {1}, Thread : {2}, current thread gtid : {3}", new Object[]{Utility.getDump(otid.tid), new Integer(otid.formatID), Thread.currentThread(), ThreadContexts.getAssociatedTransactionID()});
        }
        for (int i = 0; i < OTSXid.JEUS_TID_PREFIX.length; ++i) {
            if (otid.tid[i] == OTSXid.JEUS_TID_PREFIX[i]) continue;
            return null;
        }
        return new GTID(otid.tid, OTSXid.JEUS_TID_PREFIX.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sending_reply(int i, PropagationContextHolder holder) {
        block23: {
            block22: {
                OTSXid xid = null;
                try {
                    GTID gtid = ThreadContexts.getAssociatedTransactionID();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "send reply, gtid : " + ThreadContexts.getAssociatedTransactionID());
                    }
                    if (gtid == null || gtid.isInvalid()) {
                        INVALID_TRANSACTION exc = new INVALID_TRANSACTION("no transaction or timeout : " + gtid, 0, CompletionStatus.COMPLETED_YES);
                        Thread.dumpStack();
                        throw exc;
                    }
                    RootCoordinator cood = ThreadContexts.getCoordinator(gtid.getLTID());
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "send reply, coord : " + cood);
                    }
                    if (cood == null) {
                        INVALID_TRANSACTION exc = new INVALID_TRANSACTION("no transaction or timeout", 0, CompletionStatus.COMPLETED_YES);
                        Thread.dumpStack();
                        throw exc;
                    }
                    xid = (OTSXid)gtid.getExternalXid();
                    PropagationContext context = xid.getPropagationContext();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "sending_reply context : " + context);
                        if (context != null) {
                            logger.log(Level.FINER, "sending_reply tid : " + Utility.getDump(context.current.otid.tid));
                        }
                    }
                    if (cood.isRollbackOnly()) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.log(Level.FINER, "call coord rollback only");
                        }
                        try {
                            context.current.coord.rollback_only();
                        }
                        catch (Throwable exc) {
                            // empty catch block
                        }
                    }
                    holder.value = new PropagationContext(0, new TransIdentity(null, null, context.current.otid), new TransIdentity[0], Configuration.getImplementationSpecificData());
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "gtid : " + ThreadContexts.getAssociatedTransactionID() + ", send reply tx : " + Utility.getDump(((OTSXid)gtid.getExternalXid()).getPropagationContext().current.otid.tid));
                    }
                    Object var9_10 = null;
                    if (shouldSetTxNull.get() == null) break block22;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (shouldSetTxNull.get() != null) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "clear tx context according to shouldSetTxNull");
                        }
                        try {
                            manager.end(xid, 0x4000000);
                        }
                        catch (XAException e) {}
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "NOT clear tx context according to shouldSetTxNull");
                    }
                    throw throwable;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "clear tx context according to shouldSetTxNull");
                }
                try {
                    manager.end(xid, 0x4000000);
                }
                catch (XAException e) {}
                break block23;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "NOT clear tx context according to shouldSetTxNull");
            }
        }
    }
}

