/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots.impl;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.transaction.RollbackException;
import javax.transaction.xa.Xid;
import jeus.transaction.GTID;
import jeus.transaction.TransactionImpl;
import jeus.transaction.external.OTSXid;
import jeus.transaction.ots.Configuration;
import jeus.transaction.ots.GlobalTID;
import jeus.transaction.ots.impl.RecoveryCoordinatorImpl;
import jeus.transaction.ots.jta.JTAResource;
import jeus.transaction.ots.jta.JTASynchronization;
import jeus.transaction.root.RootCoordinator;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_OTS0;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.CoordinatorPOA;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.otid_t;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class CoordinatorImpl
extends CoordinatorPOA
implements Coordinator {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction.ots");
    private static NO_IMPLEMENT no_implement = new NO_IMPLEMENT("This is a locally constrained object.");
    private static final AtomicInteger resSequence = new AtomicInteger();
    private Vector<RecoveryCoordinatorImpl> recoveryCoordinatorList = new Vector();
    private GTID gtid;
    private GlobalTID globalTID;
    private RootCoordinator coord;
    private Coordinator thisRef;
    private POA poa;
    private boolean isIncarnate;
    private int hash = 0;

    public CoordinatorImpl(GTID gtid, RootCoordinator coord) {
        this.gtid = gtid;
        this.coord = coord;
        this.globalTID = CoordinatorImpl.getGlobalTIDFromJeusGTID(gtid);
        if (this.globalTID != null) {
            this.hash = this.globalTID.hashCode();
        }
    }

    public static GlobalTID getGlobalTIDFromJeusGTID(GTID gtid) {
        if (gtid == null) {
            return null;
        }
        Xid xid = gtid.getExternalXid();
        if (xid == null || !(xid instanceof OTSXid)) {
            return null;
        }
        return CoordinatorImpl.getGlobalTIDFromOTSXid((OTSXid)xid);
    }

    private static GlobalTID getGlobalTIDFromOTSXid(OTSXid xid) {
        if (xid == null) {
            return null;
        }
        PropagationContext ctx = xid.getPropagationContext();
        if (ctx == null || ctx.current == null || ctx.current.otid == null) {
            return null;
        }
        return new GlobalTID(ctx.current.otid);
    }

    public CoordinatorImpl(byte[] oid) {
        this.isIncarnate = true;
        Thread.dumpStack();
    }

    public Status get_status() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : get_status called");
        return CoordinatorImpl.getTxStatus(this.coord.getStatus());
    }

    public static Status getTxStatus(int i) {
        switch (i) {
            case 0: {
                return Status.StatusActive;
            }
            case 1: {
                return Status.StatusMarkedRollback;
            }
            case 2: {
                return Status.StatusPrepared;
            }
            case 3: {
                return Status.StatusCommitted;
            }
            case 4: {
                return Status.StatusRolledBack;
            }
            case 5: {
                return Status.StatusUnknown;
            }
            case 6: {
                return Status.StatusNoTransaction;
            }
            case 7: {
                return Status.StatusPreparing;
            }
            case 8: {
                return Status.StatusCommitting;
            }
            case 9: {
                return Status.StatusRollingBack;
            }
        }
        return Status.StatusUnknown;
    }

    public Status get_parent_status() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : get_parent_status called");
        return this.get_status();
    }

    public Status get_top_level_status() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : get_top_level_status called");
        return this.get_status();
    }

    public boolean is_same_transaction(Coordinator tc) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : is_same_transaction called");
        if (this.globalTID != null) {
            String name = this.globalTID.toString();
            return name.equals(tc.get_transaction_name());
        }
        throw new INVALID_TRANSACTION("gtid is null", 0, CompletionStatus.COMPLETED_NO);
    }

    public boolean is_related_transaction(Coordinator tc) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : is_related_transaction called");
        return tc.is_descendant_transaction(this.object());
    }

    public boolean is_ancestor_transaction(Coordinator tc) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : is_ancestor_transaction called");
        return tc.is_descendant_transaction(this.object());
    }

    public boolean is_descendant_transaction(Coordinator tc) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : is_descendant_transaction called");
        return this.is_same_transaction(tc);
    }

    public boolean is_top_level_transaction() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : is_top_level_transaction called");
        return true;
    }

    public int hash_transaction() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : hash_transaction called");
        return this.hash;
    }

    public int hash_top_level_tran() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : hash_top_level_tran called");
        return this.hash;
    }

    public RecoveryCoordinator register_resource(Resource r) throws Inactive, TRANSACTION_ROLLEDBACK {
        try {
            int state;
            if (this.isIncarnate) {
                Thread.dumpStack();
            }
            if (logger.isLoggable(JeusMessage_OTS0._1402_LEVEL)) {
                logger.log(JeusMessage_OTS0._1402_LEVEL, JeusMessage_OTS0._1402, (java.lang.Object)r);
            }
            if ((state = this.coord.getStatus()) != 0) {
                throw new Inactive();
            }
            if (state == 1) {
                throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            }
            TransactionImpl currentTx = this.coord.getTransaction();
            currentTx.enlistResource(new JTAResource(r));
            RecoveryCoordinatorImpl recoveryCoordImpl = new RecoveryCoordinatorImpl(this.gtid, resSequence.getAndIncrement());
            this.recoveryCoordinatorList.add(recoveryCoordImpl);
            return recoveryCoordImpl.object();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_OTS0._1401_LEVEL)) {
                logger.log(JeusMessage_OTS0._1401_LEVEL, JeusMessage_OTS0._1401, r, t);
            }
            return null;
        }
    }

    public void register_synchronization(Synchronization sync) throws SystemException, Inactive, SynchronizationUnavailable {
        int state;
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        if (logger.isLoggable(JeusMessage_OTS0._1403_LEVEL)) {
            logger.log(JeusMessage_OTS0._1403_LEVEL, JeusMessage_OTS0._1403, (java.lang.Object)sync);
        }
        if ((state = this.coord.getStatus()) != 0) {
            throw new Inactive();
        }
        TransactionImpl currentTx = this.coord.getTransaction();
        try {
            currentTx.registerSynchronization(new JTASynchronization(sync));
        }
        catch (RollbackException e) {
            throw new TRANSACTION_ROLLEDBACK(e.getMessage(), 0, CompletionStatus.COMPLETED_NO);
        }
        catch (javax.transaction.SystemException e) {
            throw new INTERNAL(e.getMessage(), 0, CompletionStatus.COMPLETED_NO);
        }
    }

    public void register_subtran_aware(SubtransactionAwareResource r) throws Inactive, NotSubtransaction {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : register_subtran_aware called");
        throw new NotSubtransaction();
    }

    public void rollback_only() throws Inactive {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : rollback_only called");
        try {
            this.coord.setRollbackOnly();
        }
        catch (Throwable t) {
            throw new Inactive(t.getMessage());
        }
    }

    public String get_transaction_name() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : get_transaction_name called");
        if (this.globalTID != null) {
            return this.globalTID.toString();
        }
        throw new INVALID_TRANSACTION("gtid is null", 0, CompletionStatus.COMPLETED_NO);
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : create_subtransaction called");
        throw new SubtransactionsUnavailable();
    }

    public PropagationContext get_txcontext() throws Unavailable {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : get_txcontext called");
        int state = this.coord.getStatus();
        if (state != 0 || state == 1) {
            throw new Unavailable();
        }
        long timeLeft = this.coord.getRemainingTimeout();
        if (timeLeft <= 0L) {
            throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
        }
        OTSXid xid = (OTSXid)this.coord.getExternalXid();
        if (xid != null) {
            return xid.getPropagationContext();
        }
        throw new Unavailable();
    }

    public final synchronized Coordinator object() {
        if (this.thisRef == null) {
            if (this.poa == null) {
                this.poa = Configuration.getPOA("OTSCoordinatorPOA");
            }
            try {
                this.poa.activate_object((Servant)this);
                this.thisRef = CoordinatorHelper.narrow(this.poa.servant_to_reference((Servant)this));
            }
            catch (Exception exc) {
                if (logger.isLoggable(JeusMessage_OTS0._1209_LEVEL)) {
                    logger.log(JeusMessage_OTS0._1209_LEVEL, JeusMessage_OTS0._1209, (Throwable)exc);
                }
                throw new INTERNAL("jts.create_coordinator_object_error");
            }
        }
        return this.thisRef;
    }

    public final synchronized void destroy() {
        block4: {
            if (this.poa != null && this.thisRef != null) {
                try {
                    this.poa.deactivate_object(this.poa.reference_to_id((Object)this.thisRef));
                    this.thisRef = null;
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(JeusMessage_OTS0._1210_LEVEL)) break block4;
                    logger.log(JeusMessage_OTS0._1210_LEVEL, JeusMessage_OTS0._1210);
                }
            }
        }
        for (int i = 0; i < this.recoveryCoordinatorList.size(); ++i) {
            RecoveryCoordinatorImpl recoveryCoordinator = this.recoveryCoordinatorList.get(i);
            recoveryCoordinator.destroy();
        }
        this.recoveryCoordinatorList.clear();
    }

    public int hashCode() {
        if (this.hash == 0 && this.globalTID != null) {
            this.hash = this.globalTID.hashCode();
        }
        return this.hash;
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        otid_t otherTID = null;
        if (other instanceof CoordinatorImpl) {
            CoordinatorImpl otherCoord = (CoordinatorImpl)other;
            if (otherCoord.globalTID != null) {
                otherTID = otherCoord.globalTID.getRealTID();
            }
        } else if (other instanceof Object) {
            try {
                Coordinator coord = CoordinatorHelper.narrow((Object)other);
                PropagationContext pc = coord.get_txcontext();
                otherTID = pc.current.otid;
            }
            catch (BAD_PARAM ex2) {
            }
            catch (Unavailable ex2) {
                throw new INVALID_TRANSACTION(0, CompletionStatus.COMPLETED_NO);
            }
        }
        return otherTID != null && this.globalTID != null && this.globalTID.equals(otherTID);
    }

    public Object _duplicate() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _duplicate");
        throw no_implement;
    }

    public void _release() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _release called");
        throw no_implement;
    }

    public boolean _is_a(String repository_id) {
        throw no_implement;
    }

    public boolean _is_equivalent(Object that) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _is_equivalent");
        throw no_implement;
    }

    public boolean _non_existent() {
        throw no_implement;
    }

    public int _hash(int maximum) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _hash called");
        throw no_implement;
    }

    public Request _request(String operation) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _request");
        throw no_implement;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _create_request1");
        throw no_implement;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList exceptions, ContextList contexts) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _create_request2");
        throw no_implement;
    }

    public Object _get_interface_def() {
        throw no_implement;
    }

    public Policy _get_policy(int policy_type) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _get_policy");
        throw no_implement;
    }

    public DomainManager[] _get_domain_managers() {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _get_domain_managers");
        throw no_implement;
    }

    public Object _set_policy_override(Policy[] policies, SetOverrideType set_add) {
        if (this.isIncarnate) {
            Thread.dumpStack();
        }
        logger.log(Level.FINE, "OTS Coordinator : _set_policy_override");
        throw no_implement;
    }

    public synchronized void setGlobalTID(Xid xid) {
        if (this.globalTID == null && xid instanceof OTSXid) {
            this.globalTID = CoordinatorImpl.getGlobalTIDFromOTSXid((OTSXid)xid);
            if (this.globalTID != null) {
                this.hash = this.globalTID.hashCode();
            }
        }
    }
}

