/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.XAException;
import jeus.transaction.TMXAResource;
import jeus.transaction.external.OTSXid;
import jeus.transaction.ots.Configuration;
import jeus.transaction.util.XidToString;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_OTS0;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.CosTransactions.ResourcePOA;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Vote;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class ResourceImpl
extends ResourcePOA
implements Resource {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction.ots");
    private static final TMXAResource manager = TMXAResource.getTMXAResource();
    private OTSXid xid;
    private RecoveryCoordinator recoveryCoord;
    private transient AtomicBoolean isAlreadyCompleted = new AtomicBoolean(false);
    private transient POA poa;
    private transient Resource thisRef;
    private static transient ConcurrentHashMap decisionPerXid = new ConcurrentHashMap();
    private static transient ConcurrentHashMap resourcePerXid = new ConcurrentHashMap();
    private static NO_IMPLEMENT no_implement = new NO_IMPLEMENT("This is a locally constrained object.");

    public ResourceImpl(OTSXid xid) {
        this.xid = xid;
    }

    public Vote prepare() throws HeuristicMixed, HeuristicHazard {
        int rc;
        block5: {
            rc = -6;
            try {
                rc = manager.prepare(this.xid, this);
            }
            catch (XAException e) {
                if (logger.isLoggable(JeusMessage_OTS0._1306_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1306_LEVEL, "ResourceImpl", "prepare", JeusMessage_OTS0._1306, new String[]{this.xid == null ? "null" : this.xid.toString(), XidToString.getXAErrorCode(e.errorCode)}, (Throwable)e);
                }
                if (e.errorCode != -7 && e.errorCode != -3) break block5;
                throw new RuntimeException(e);
            }
        }
        if (rc == 0) {
            return Vote.VoteCommit;
        }
        if (rc == 3) {
            this.destroy();
            return Vote.VoteReadOnly;
        }
        this.destroy();
        return Vote.VoteRollback;
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard, SystemException {
        if (!this.isAlreadyCompleted.compareAndSet(false, true)) {
            if (logger.isLoggable(JeusMessage_OTS0._1305_LEVEL)) {
                logger.logp(JeusMessage_OTS0._1305_LEVEL, "ResourceImpl", "rollback", JeusMessage_OTS0._1305, (java.lang.Object)(this.xid == null ? "null" : this.xid.toString()));
            }
            return;
        }
        try {
            try {
                ResourceImpl.putDecision(this.xid, Status.StatusRolledBack);
                manager.rollback(this.xid);
                ResourceImpl.removeDecision(this.xid);
            }
            catch (Throwable t) {
                this.isAlreadyCompleted.set(false);
                this.destroy();
                if (!(t instanceof XAException)) {
                    INTERNAL internal = new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
                    internal.initCause(t);
                    if (logger.isLoggable(JeusMessage_OTS0._1307_LEVEL)) {
                        logger.logp(JeusMessage_OTS0._1307_LEVEL, "ResourceImpl", "rollback", JeusMessage_OTS0._1307, this.xid == null ? "null" : this.xid.toString(), t);
                    }
                    throw internal;
                }
                XAException e = (XAException)t;
                if (logger.isLoggable(JeusMessage_OTS0._1308_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1308_LEVEL, "ResourceImpl", "rollback", JeusMessage_OTS0._1308, new String[]{this.xid == null ? "null" : this.xid.toString(), XidToString.getXAErrorCode(e.errorCode)}, (Throwable)e);
                }
                if (e.errorCode == -4) {
                    java.lang.Object var5_2 = null;
                    this.destroy();
                    return;
                }
                if (e.errorCode == 7) {
                    throw new HeuristicCommit(t.getMessage());
                }
                if (e.errorCode == 8) {
                    throw new HeuristicHazard(t.getMessage());
                }
                if (e.errorCode == 5) {
                    throw new HeuristicMixed(t.getMessage());
                }
                if (e.errorCode == 7) {
                    java.lang.Object var5_3 = null;
                    this.destroy();
                    return;
                }
                if (e.errorCode == 4 || e.errorCode == 107 || e.errorCode == 101) {
                    throw new TRANSIENT();
                }
                INTERNAL internal = new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
                internal.initCause(t);
                throw internal;
            }
            java.lang.Object var5_1 = null;
            this.destroy();
        }
        catch (Throwable throwable) {
            java.lang.Object var5_4 = null;
            this.destroy();
            throw throwable;
        }
    }

    public void commit() throws NotPrepared, HeuristicRollback, HeuristicHazard, HeuristicMixed, SystemException {
        if (!this.isAlreadyCompleted.compareAndSet(false, true)) {
            if (logger.isLoggable(JeusMessage_OTS0._1305_LEVEL)) {
                logger.logp(JeusMessage_OTS0._1305_LEVEL, "ResourceImpl", "commit", JeusMessage_OTS0._1305, (java.lang.Object)(this.xid == null ? "null" : this.xid.toString()));
            }
            return;
        }
        try {
            try {
                ResourceImpl.putDecision(this.xid, Status.StatusCommitted);
                manager.commit(this.xid, false);
                ResourceImpl.removeDecision(this.xid);
            }
            catch (Throwable t) {
                this.isAlreadyCompleted.set(false);
                if (!(t instanceof XAException)) {
                    INTERNAL internal = new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
                    internal.initCause(t);
                    if (logger.isLoggable(JeusMessage_OTS0._1300_LEVEL)) {
                        logger.logp(JeusMessage_OTS0._1300_LEVEL, "ResourceImpl", "commit", JeusMessage_OTS0._1300, this.xid == null ? "null" : this.xid.toString(), t);
                    }
                    throw internal;
                }
                XAException e = (XAException)t;
                if (logger.isLoggable(JeusMessage_OTS0._1301_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1301_LEVEL, "ResourceImpl", "commit", JeusMessage_OTS0._1301, new String[]{this.xid == null ? "null" : this.xid.toString(), XidToString.getXAErrorCode(e.errorCode)}, (Throwable)e);
                }
                if (e.errorCode == -4) {
                    throw new OBJECT_NOT_EXIST(t.getMessage());
                }
                if (e.errorCode == 6) {
                    throw new HeuristicRollback(t.getMessage());
                }
                if (e.errorCode == 8) {
                    throw new HeuristicHazard(t.getMessage());
                }
                if (e.errorCode == 5) {
                    throw new HeuristicMixed(t.getMessage());
                }
                if (e.errorCode == 105) {
                    throw new NotPrepared(t.getMessage());
                }
                if (e.errorCode == 7) {
                    java.lang.Object var4_2 = null;
                    this.destroy();
                    return;
                }
                if (e.errorCode == 4 || e.errorCode == 107 || e.errorCode == 101) {
                    throw new TRANSIENT();
                }
                if (e.errorCode >= 100 && e.errorCode <= 107) {
                    throw new HeuristicRollback(t.getMessage());
                }
                throw new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
            }
            java.lang.Object var4_1 = null;
            this.destroy();
        }
        catch (Throwable throwable) {
            java.lang.Object var4_3 = null;
            this.destroy();
            throw throwable;
        }
    }

    public void commit_one_phase() throws HeuristicHazard, SystemException {
        if (!this.isAlreadyCompleted.compareAndSet(false, true)) {
            if (logger.isLoggable(JeusMessage_OTS0._1305_LEVEL)) {
                logger.logp(JeusMessage_OTS0._1305_LEVEL, "ResourceImpl", "commit_one_phase", JeusMessage_OTS0._1305, (java.lang.Object)(this.xid == null ? "null" : this.xid.toString()));
            }
            return;
        }
        try {
            try {
                ResourceImpl.putDecision(this.xid, Status.StatusCommitted);
                manager.commit(this.xid, true);
                ResourceImpl.removeDecision(this.xid);
            }
            catch (Throwable t) {
                this.isAlreadyCompleted.set(false);
                if (!(t instanceof XAException)) {
                    INTERNAL internal = new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
                    internal.initCause(t);
                    if (logger.isLoggable(JeusMessage_OTS0._1302_LEVEL)) {
                        logger.logp(JeusMessage_OTS0._1302_LEVEL, "ResourceImpl", "commit_one_phase", JeusMessage_OTS0._1302, this.xid == null ? "null" : this.xid.toString(), t);
                    }
                    throw internal;
                }
                XAException e = (XAException)t;
                if (logger.isLoggable(JeusMessage_OTS0._1303_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1303_LEVEL, "ResourceImpl", "commit_one_phase", JeusMessage_OTS0._1303, new String[]{this.xid == null ? "null" : this.xid.toString(), XidToString.getXAErrorCode(e.errorCode)}, (Throwable)e);
                }
                if (e.errorCode == -4) {
                    java.lang.Object var5_2 = null;
                    this.destroy();
                    return;
                }
                if (e.errorCode == 6) {
                    throw new HeuristicHazard(t.getMessage());
                }
                if (e.errorCode == 8) {
                    throw new HeuristicHazard(t.getMessage());
                }
                if (e.errorCode == 5) {
                    throw new HeuristicHazard(t.getMessage());
                }
                if (e.errorCode == 7) {
                    java.lang.Object var5_3 = null;
                    this.destroy();
                    return;
                }
                if (e.errorCode == 4 || e.errorCode == 107 || e.errorCode == 101) {
                    throw new TRANSIENT();
                }
                if (e.errorCode >= 100 && e.errorCode <= 107) {
                    HeuristicHazard hazex = new HeuristicHazard();
                    ((Throwable)((java.lang.Object)hazex)).initCause(t);
                    throw hazex;
                }
                INTERNAL internal = new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
                internal.initCause(t);
                throw internal;
            }
            java.lang.Object var5_1 = null;
            this.destroy();
        }
        catch (Throwable throwable) {
            java.lang.Object var5_4 = null;
            this.destroy();
            throw throwable;
        }
    }

    public void forget() {
        block5: {
            if (!this.isAlreadyCompleted.compareAndSet(false, true)) {
                if (logger.isLoggable(JeusMessage_OTS0._1305_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1305_LEVEL, "ResourceImpl", "forget", JeusMessage_OTS0._1305, (java.lang.Object)(this.xid == null ? "null" : this.xid.toString()));
                }
                return;
            }
            try {
                manager.forget(this.xid);
            }
            catch (Throwable t) {
                this.isAlreadyCompleted.set(false);
                String errorCode = null;
                if (t instanceof XAException) {
                    errorCode = XidToString.getXAErrorCode(((XAException)t).errorCode);
                }
                if (!logger.isLoggable(JeusMessage_OTS0._1304_LEVEL)) break block5;
                logger.logp(JeusMessage_OTS0._1304_LEVEL, "ResourceImpl", "commit_one_phase", JeusMessage_OTS0._1304, new String[]{this.xid == null ? "null" : this.xid.toString(), errorCode}, t);
            }
        }
        this.destroy();
    }

    public void setRecoveryCoordinator(RecoveryCoordinator recoveryCoord) {
        this.recoveryCoord = recoveryCoord;
    }

    public RecoveryCoordinator getRecoveryCoordinator() {
        return this.recoveryCoord;
    }

    public final synchronized Resource object() {
        if (this.thisRef == null) {
            try {
                if (this.poa == null) {
                    this.poa = Configuration.getPOA("OTSCoordinatorPOA");
                }
                byte[] idBytes = this.xid.getOTID();
                try {
                    this.poa.activate_object_with_id(idBytes, (Servant)this);
                }
                catch (ServantAlreadyActive saae) {
                    if (logger.isLoggable(JeusMessage_OTS0._1212_LEVEL)) {
                        logger.logp(JeusMessage_OTS0._1212_LEVEL, "ResourceImpl", "object", JeusMessage_OTS0._1212, new String[]{this.xid.toString(), this.toString()}, (Throwable)saae);
                    }
                }
                catch (ObjectAlreadyActive oaae) {
                    if (logger.isLoggable(JeusMessage_OTS0._1213_LEVEL)) {
                        logger.logp(JeusMessage_OTS0._1213_LEVEL, "ResourceImpl", "object", JeusMessage_OTS0._1213, new String[]{this.xid.toString(), this.toString()}, (Throwable)oaae);
                    }
                    try {
                        Object obj = this.poa.id_to_reference(idBytes);
                        this.thisRef = ResourceHelper.narrow(obj);
                    }
                    catch (ObjectNotActive objectNotActive) {
                    }
                    catch (WrongPolicy wrongPolicy) {
                        // empty catch block
                    }
                }
                if (this.thisRef == null) {
                    Object obj = this.poa.create_reference_with_id(idBytes, ResourceHelper.id());
                    this.thisRef = ResourceHelper.narrow(obj);
                }
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_OTS0._1214_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1214_LEVEL, "ResourceImpl", "object", JeusMessage_OTS0._1214, new String[]{this.xid.toString(), this.toString()}, t);
                }
                throw new INTERNAL();
            }
        }
        return this.thisRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void destroy() {
        try {
            try {
                if (this.poa != null && this.thisRef != null) {
                    this.poa.deactivate_object(this.poa.reference_to_id((Object)this.thisRef));
                    this.thisRef = null;
                }
                POA rcPoa = this.poa == null ? Configuration.getPOA("OTSCoordinatorPOA") : this.poa;
                if (this.thisRef == null) {
                    rcPoa.deactivate_object(rcPoa.servant_to_id((Servant)this));
                }
                rcPoa.deactivate_object(rcPoa.reference_to_id((Object)this.thisRef));
                this.thisRef = null;
            }
            catch (Exception exc) {
                if (logger.isLoggable(JeusMessage_OTS0._1205_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1205_LEVEL, "RecoveryCoordinatorImpl", "destroy", JeusMessage_OTS0._1205, (Throwable)exc);
                }
                java.lang.Object var3_4 = null;
                ResourceImpl.removeCachedResource(this.xid);
                return;
            }
            java.lang.Object var3_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var3_5 = null;
            ResourceImpl.removeCachedResource(this.xid);
            throw throwable;
        }
        ResourceImpl.removeCachedResource(this.xid);
    }

    public OTSXid getOTSXid() {
        return this.xid;
    }

    public static void putDecision(OTSXid xid, Status status) {
        if (xid == null || status == null) {
            return;
        }
        decisionPerXid.put(xid, status);
    }

    public static Status getDecision(OTSXid xid) {
        if (xid == null) {
            return null;
        }
        return (Status)decisionPerXid.get(xid);
    }

    public static void removeDecision(OTSXid xid) {
        if (xid == null) {
            return;
        }
        decisionPerXid.remove(xid);
    }

    public static void putCachedResource(OTSXid xid, ResourceImpl resource) {
        if (xid == null || resource == null) {
            return;
        }
        resourcePerXid.putIfAbsent(xid, resource);
    }

    public static ResourceImpl getCachedResource(OTSXid xid) {
        if (xid == null) {
            return null;
        }
        return (ResourceImpl)resourcePerXid.get(xid);
    }

    public static void removeCachedResource(OTSXid xid) {
        if (xid == null) {
            return;
        }
        resourcePerXid.remove(xid);
    }

    public Object _duplicate() {
        throw no_implement;
    }

    public void _release() {
        throw no_implement;
    }

    public boolean _is_a(String repository_id) {
        throw no_implement;
    }

    public boolean _is_equivalent(Object that) {
        throw no_implement;
    }

    public boolean _non_existent() {
        throw no_implement;
    }

    public int _hash(int maximum) {
        throw no_implement;
    }

    public Request _request(String operation) {
        throw no_implement;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result) {
        throw no_implement;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList exceptions, ContextList contexts) {
        throw no_implement;
    }

    public Object _get_interface_def() {
        throw no_implement;
    }

    public Policy _get_policy(int policy_type) {
        throw no_implement;
    }

    public DomainManager[] _get_domain_managers() {
        throw no_implement;
    }

    public Object _set_policy_override(Policy[] policies, SetOverrideType set_add) {
        throw no_implement;
    }
}

