/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots.jta;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_OTS0;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Vote;

public class JTAResource
implements XAResource {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction.ots");
    private Resource resource;

    public JTAResource(Resource resource) {
        this.resource = resource;
    }

    public int prepare(Xid xid) throws XAException {
        Vote v;
        try {
            v = this.resource.prepare();
        }
        catch (Throwable t) {
            XAException xaException = new XAException(t.getMessage());
            xaException.errorCode = t instanceof HeuristicHazard ? 8 : (t instanceof HeuristicMixed ? 5 : (t instanceof COMM_FAILURE || t instanceof TRANSIENT ? -7 : -3));
            if (logger.isLoggable(JeusMessage_OTS0._1320_LEVEL)) {
                logger.logp(JeusMessage_OTS0._1320_LEVEL, "JTAResource", "prepare", JeusMessage_OTS0._1320, new String[]{xid.toString(), this.resource.toString()}, t);
            }
            throw xaException;
        }
        switch (v.value()) {
            case 0: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 1: {
                throw new XAException(100);
            }
        }
        XAException xaException = new XAException(v.value() + "is unknown");
        xaException.errorCode = 105;
        throw xaException;
    }

    public void commit(Xid xid, boolean isOnePhase) throws XAException {
        try {
            if (isOnePhase) {
                this.resource.commit_one_phase();
            } else {
                this.resource.commit();
            }
        }
        catch (Throwable t) {
            XAException xaException = new XAException(t.getMessage());
            if (t instanceof HeuristicHazard) {
                xaException.errorCode = 8;
            } else if (t instanceof HeuristicMixed) {
                xaException.errorCode = 5;
            } else if (t instanceof HeuristicCommit) {
                xaException.errorCode = 7;
            } else if (t instanceof HeuristicRollback) {
                xaException.errorCode = 6;
            } else if (t instanceof NotPrepared) {
                xaException.errorCode = -6;
            } else {
                if (t instanceof INV_OBJREF || t instanceof OBJECT_NOT_EXIST) {
                    if (logger.isLoggable(JeusMessage_OTS0._1324_LEVEL)) {
                        logger.logp(JeusMessage_OTS0._1324_LEVEL, "JTAResource", "commit", JeusMessage_OTS0._1324, new String[]{xid.toString(), this.resource.toString()}, t);
                    }
                    return;
                }
                xaException.errorCode = -3;
            }
            if (logger.isLoggable(JeusMessage_OTS0._1321_LEVEL)) {
                logger.logp(JeusMessage_OTS0._1321_LEVEL, "JTAResource", "commit", JeusMessage_OTS0._1321, new String[]{xid.toString(), this.resource.toString()}, t);
            }
            throw xaException;
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.resource.rollback();
        }
        catch (Throwable t) {
            XAException xaException = new XAException(t.getMessage());
            if (!(t instanceof TRANSACTION_ROLLEDBACK)) {
                if (t instanceof HeuristicCommit) {
                    xaException.errorCode = 7;
                } else if (t instanceof HeuristicRollback) {
                    xaException.errorCode = 6;
                } else if (t instanceof HeuristicHazard) {
                    xaException.errorCode = 8;
                } else if (t instanceof HeuristicMixed) {
                    xaException.errorCode = 5;
                } else {
                    if (t instanceof INV_OBJREF || t instanceof OBJECT_NOT_EXIST) {
                        if (logger.isLoggable(JeusMessage_OTS0._1325_LEVEL)) {
                            logger.logp(JeusMessage_OTS0._1325_LEVEL, "JTAResource", "rollback", JeusMessage_OTS0._1325, new String[]{xid.toString(), this.resource.toString()}, t);
                        }
                        return;
                    }
                    xaException.errorCode = -3;
                }
            }
            if (logger.isLoggable(JeusMessage_OTS0._1322_LEVEL)) {
                logger.logp(JeusMessage_OTS0._1322_LEVEL, "JTAResource", "rollback", JeusMessage_OTS0._1322, new String[]{xid.toString(), this.resource.toString()}, t);
            }
            throw xaException;
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            this.resource.forget();
        }
        catch (Throwable t) {
            XAException xaException = new XAException(t.getMessage());
            if (t instanceof INV_OBJREF || t instanceof OBJECT_NOT_EXIST) {
                if (logger.isLoggable(JeusMessage_OTS0._1326_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1326_LEVEL, "JTAResource", "forget", JeusMessage_OTS0._1326, new String[]{xid.toString(), this.resource.toString()}, t);
                }
            } else {
                xaException.errorCode = t instanceof COMM_FAILURE || t instanceof TRANSIENT ? -7 : -3;
            }
            if (logger.isLoggable(JeusMessage_OTS0._1323_LEVEL)) {
                logger.logp(JeusMessage_OTS0._1323_LEVEL, "JTAResource", "forget", JeusMessage_OTS0._1323, new String[]{xid.toString(), this.resource.toString()}, t);
            }
            throw xaException;
        }
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource instanceof JTAResource) {
            JTAResource jtaResource = (JTAResource)xaResource;
            return this.resource._is_equivalent(jtaResource.getRealResource());
        }
        return false;
    }

    public void start(Xid xid, int i) throws XAException {
    }

    public void end(Xid xid, int i) throws XAException {
    }

    public Xid[] recover(int i) throws XAException {
        return new Xid[0];
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean setTransactionTimeout(int i) throws XAException {
        return false;
    }

    public Object getRealResource() {
        return this.resource;
    }
}

