/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.profile;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jeus.transaction.Coordinator;
import jeus.transaction.info.TransactionInfo;
import jeus.transaction.logging.IncompletedTx;
import jeus.transaction.profile.CoordinatorProfileListener;
import jeus.transaction.profile.CoordinatorProfileStages;
import jeus.transaction.profile.ProfileListener;
import jeus.transaction.profile.ProfileStages;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM4;

public class ProfileManager {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    private static final ProfileManager PROFILE = new ProfileManager();
    private List<ProfileListener> listeners = new CopyOnWriteArrayList<ProfileListener>();
    private volatile boolean enable = false;

    public void addListener(ProfileListener listener) {
        if (listener == null || !this.enable) {
            return;
        }
        this.listeners.add(listener);
        if (logger.isLoggable(JeusMessage_TM4._6400_LEVEL)) {
            logger.logp(JeusMessage_TM4._6400_LEVEL, "ProfileManager", "addListener", JeusMessage_TM4._6400, (Object)listener);
        }
    }

    public void removeListener(ProfileListener listener) {
        if (listener == null || !this.enable) {
            return;
        }
        this.listeners.remove(listener);
        if (logger.isLoggable(JeusMessage_TM4._6401_LEVEL)) {
            logger.logp(JeusMessage_TM4._6401_LEVEL, "ProfileManager", "removeListener", JeusMessage_TM4._6401, (Object)listener);
        }
    }

    public void removeAllListeners() {
        if (!this.enable) {
            return;
        }
        this.listeners.clear();
        if (logger.isLoggable(JeusMessage_TM4._6402_LEVEL)) {
            logger.logp(JeusMessage_TM4._6402_LEVEL, "ProfileManager", "removeAllListeners", JeusMessage_TM4._6402);
        }
    }

    public void callListener(ProfileStages stage, Object data) {
        if (stage == null || !this.enable) {
            return;
        }
        try {
            TransactionInfo info = this.makeTransactionInfo(data);
            for (ProfileListener listener : this.listeners) {
                try {
                    if (stage instanceof CoordinatorProfileStages && listener instanceof CoordinatorProfileListener) {
                        this.callCoordinatorListener((CoordinatorProfileListener)listener, (CoordinatorProfileStages)stage, info);
                        continue;
                    }
                    if (!logger.isLoggable(JeusMessage_TM4._6403_LEVEL)) continue;
                    logger.logp(JeusMessage_TM4._6403_LEVEL, "ProfileManager", "callListener", JeusMessage_TM4._6403, (Object[])new String[]{stage.toString(), listener.toString()});
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_TM4._6405_LEVEL)) continue;
                    logger.logp(JeusMessage_TM4._6405_LEVEL, "ProfileManager", "callListener", JeusMessage_TM4._6405, new String[]{stage.toString(), listener.toString()}, t);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private TransactionInfo makeTransactionInfo(Object data) {
        TransactionInfo info;
        block3: {
            if (data == null) {
                return null;
            }
            info = null;
            try {
                info = data instanceof Coordinator ? ((Coordinator)data).getTransactionInfoFromCoordinator() : (data instanceof IncompletedTx ? ((IncompletedTx)data).getIncompletedTransactionInfo() : null);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_TM4._6406_LEVEL)) break block3;
                logger.logp(JeusMessage_TM4._6406_LEVEL, "ProfileManager", "makeTransactionInfo", JeusMessage_TM4._6406, data);
            }
        }
        return info;
    }

    private void callCoordinatorListener(CoordinatorProfileListener listener, CoordinatorProfileStages stage, TransactionInfo info) {
        if (listener == null) {
            return;
        }
        if (stage == CoordinatorProfileStages.BEFORE_PREPARE) {
            listener.beforePrepare(info);
        } else if (stage == CoordinatorProfileStages.AFTER_PREPARE) {
            listener.afterPrepare(info);
        } else if (stage == CoordinatorProfileStages.BEFORE_SETDECISION) {
            listener.beforeSetDecision(info);
        } else if (stage == CoordinatorProfileStages.AFTER_SETDECISION) {
            listener.afterSetDecision(info);
        } else if (stage == CoordinatorProfileStages.BEFORE_COMMIT) {
            listener.beforeCommit(info);
        } else if (stage == CoordinatorProfileStages.AFTER_COMMIT) {
            listener.afterCommit(info);
        } else if (stage == CoordinatorProfileStages.BEFORE_ONEPHASECOMMIT) {
            listener.beforeOnePhaseCommit(info);
        } else if (stage == CoordinatorProfileStages.AFTER_ONEPHASECOMMIT) {
            listener.afterOnePhaseCommit(info);
        } else if (stage == CoordinatorProfileStages.BEFORE_ROLLBACK) {
            listener.beforeRollback(info);
        } else if (stage == CoordinatorProfileStages.AFTER_ROLLBACK) {
            listener.afterRollback(info);
        } else if (stage == CoordinatorProfileStages.BEFORE_DESTROY) {
            listener.beforeDestroy(info);
        } else if (stage == CoordinatorProfileStages.AFTER_DESTROY) {
            listener.afterDestroy(info);
        } else if (stage == CoordinatorProfileStages.BEFORE_ACTIVETIMEOUT) {
            listener.beforeActiveTimeout(info);
        } else if (stage == CoordinatorProfileStages.AFTER_ACTIVETIMEOUT) {
            listener.afterActiveTimeout(info);
        } else if (logger.isLoggable(JeusMessage_TM4._6404_LEVEL)) {
            logger.logp(JeusMessage_TM4._6404_LEVEL, "ProfileManager", "callCoordinatorListener", JeusMessage_TM4._6404, (Object[])new String[]{stage.toString(), listener.toString()});
        }
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public static ProfileManager getInstance() {
        return PROFILE;
    }
}

