/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.sub;

import jeus.net.ConnectorException;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.comm.TMLinkManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM3;

public final class RootCoordinatorDelegate {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.transaction");
    private final TMLinkManager manager;
    private final TMInfo tmServer;
    private final long ltid;

    public RootCoordinatorDelegate(TMInfo tmServer, long ltid, TMLinkManager manager) {
        if (logger.isLoggable(JeusMessage_TM3._5001_LEVEL)) {
            logger.logp(JeusMessage_TM3._5001_LEVEL, "RootCoordinator", "<init>", JeusMessage_TM3._5001, new Object[]{tmServer, manager.getGTID(ltid)});
        }
        this.tmServer = tmServer;
        this.ltid = ltid;
        this.manager = manager;
    }

    public void registerResource() throws TMException {
        if (logger.isLoggable(JeusMessage_TM3._5004_LEVEL)) {
            logger.logp(JeusMessage_TM3._5004_LEVEL, "RootCoordinator", "registerResource", JeusMessage_TM3._5004, (Object)this.tmServer.getGTID(this.ltid));
        }
        try {
            this.manager.getLink(this.tmServer).registerResource(this.ltid);
        }
        catch (ConnectorException e) {
            throw new TMException(e);
        }
        if (logger.isLoggable(JeusMessage_TM3._5005_LEVEL)) {
            logger.logp(JeusMessage_TM3._5005_LEVEL, "RootCoordinator", "registerResource", JeusMessage_TM3._5005);
        }
    }

    public TMInfo getTMInfo() {
        if (logger.isLoggable(JeusMessage_TM3._5006_LEVEL)) {
            logger.logp(JeusMessage_TM3._5006_LEVEL, "RootCoordinator", "getTMInfo", JeusMessage_TM3._5006, (Object)this.tmServer);
        }
        return this.tmServer;
    }

    public void requestFlush() throws TMException {
        if (logger.isLoggable(JeusMessage_TM3._5007_LEVEL)) {
            logger.logp(JeusMessage_TM3._5007_LEVEL, "RootCoordinator", "requestFlush", JeusMessage_TM3._5007, (Object)this.tmServer.getGTID(this.ltid));
        }
        try {
            this.manager.getLink(this.tmServer).requestFlush(this.ltid);
        }
        catch (ConnectorException e) {
            throw new TMException(e);
        }
        if (logger.isLoggable(JeusMessage_TM3._5008_LEVEL)) {
            logger.logp(JeusMessage_TM3._5008_LEVEL, "RootCoordinator", "requestFlush", JeusMessage_TM3._5008);
        }
    }

    public String toString() {
        return this.tmServer.toString();
    }
}

