/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.sub;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.Xid;
import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.JTAStatisticsProvider;
import jeus.transaction.PreparedTimerEntry;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxStatus;
import jeus.transaction.collector.FlushRequestResponseCollector;
import jeus.transaction.collector.RegResponseCollector;
import jeus.transaction.sub.RootCoordinatorDelegate;
import jeus.util.ScheduledExecutor;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_TM0;
import jeus.util.message.JeusMessage_TM1;
import jeus.util.message.JeusMessage_TM3;
import jeus.util.message.JeusMessage_TM4;

public final class SubCoordinator
extends Coordinator {
    private RootCoordinatorDelegate root;
    private final RegResponseCollector regCollector = new RegResponseCollector();
    private final FlushRequestResponseCollector frCollector = new FlushRequestResponseCollector();
    private final AtomicBoolean resourceRegistered = new AtomicBoolean(false);
    private boolean isRegistered;
    private final long regTO = 120000L;
    private final long preparedTO = TMConfig.preparedTO;
    private PreparedTimerEntry preparedTimer;
    private final Object preparedTimerLock = new Object();

    public SubCoordinator(RootCoordinatorDelegate root, GTID gtid, long timeout) {
        super(gtid, timeout);
        if (logger.isLoggable(JeusMessage_TM1._3601_LEVEL)) {
            logger.logp(JeusMessage_TM1._3601_LEVEL, "Coordinator", "<init>", JeusMessage_TM1._3601, new Object[]{"sub", gtid, String.valueOf(timeout)});
        }
        this.root = root;
    }

    public void registerOwnToRootCoordinator() {
        block4: {
            if (!this.resourceRegistered.compareAndSet(false, true)) {
                return;
            }
            if (logger.isLoggable(JeusMessage_TM1._3602_LEVEL)) {
                logger.logp(JeusMessage_TM1._3602_LEVEL, "Coordinator", "registerToRootCoordinator", JeusMessage_TM1._3602, new Object[]{this.root, this.gtid});
            }
            try {
                this.root.registerResource();
            }
            catch (Throwable t) {
                this.resourceRegistered.set(false);
                if (!logger.isLoggable(JeusMessage_TM1._3604_LEVEL)) break block4;
                logger.logp(JeusMessage_TM1._3604_LEVEL, "Coordinator", "registerToRootCoordinator", JeusMessage_TM1._3604, this.root, t);
            }
        }
    }

    public void checkRegistration() throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3620_LEVEL)) {
            logger.logp(JeusMessage_TM1._3620_LEVEL, "Coordinator", "checkRegistration", JeusMessage_TM1._3620, (Object)this.root);
        }
        if (this.regCollector != null) {
            if (logger.isLoggable(JeusMessage_TM1._3621_LEVEL)) {
                logger.logp(JeusMessage_TM1._3621_LEVEL, "Coordinator", "checkRegistration", JeusMessage_TM1._3621, new Object[]{String.valueOf(120000L), this.root});
            }
            this.isRegistered = this.resourceRegistered.get() ? this.regCollector.check(120000L) : false;
            if (logger.isLoggable(JeusMessage_TM1._3622_LEVEL)) {
                logger.logp(JeusMessage_TM1._3622_LEVEL, "Coordinator", "checkRegistration", JeusMessage_TM1._3622, new Object[]{this.root, String.valueOf(this.isRegistered)});
            }
            if (!this.isRegistered) {
                try {
                    this.rollback();
                }
                catch (IllegalStateException ise) {
                }
                catch (TMException tMException) {
                    // empty catch block
                }
                this.destroy();
                logger.log(JeusMessage_TM1._3631_LEVEL, JeusMessage_TM1._3631, (Object)this.root.getTMInfo().getIPString());
                throw new TMException(JeusMessageBundles.getMessage(JeusMessage_TM1._3630, this.getGTID(), this.root.getTMInfo().getIPString()));
            }
        } else if (logger.isLoggable(JeusMessage_TM1._3623_LEVEL)) {
            logger.logp(JeusMessage_TM1._3623_LEVEL, "Coordinator", "checkRegistration", JeusMessage_TM1._3623);
        }
    }

    public void registered(boolean isSuccessful) {
        if (logger.isLoggable(JeusMessage_TM1._3624_LEVEL)) {
            logger.logp(JeusMessage_TM1._3624_LEVEL, "Coordinator", "registered", JeusMessage_TM1._3624, (Object)this.root);
        }
        if (this.regCollector != null) {
            this.regCollector.received(isSuccessful);
        }
    }

    public boolean isRegCheckRequired() {
        if (logger.isLoggable(JeusMessage_TM1._3625_LEVEL)) {
            logger.logp(JeusMessage_TM1._3625_LEVEL, "Coordinator", "isRegCheckRequired", JeusMessage_TM1._3625, new Object[]{this.root, !this.isRegistered});
        }
        return !this.isRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte setReadOnlyStatus() {
        if (this.localXAResource != null) {
            Object object = this.localXAResourceLock;
            synchronized (object) {
                if (this.localXAResource != null) {
                    return 7;
                }
            }
        }
        return 2;
    }

    protected boolean postPrepare(boolean rollback) {
        if (logger.isLoggable(JeusMessage_TM0._2812_LEVEL)) {
            logger.logp(JeusMessage_TM0._2812_LEVEL, "RootCoordinatorProxy", "prepare", JeusMessage_TM0._2812);
        }
        TMServer.addIncompleteSubTx(this);
        this.setPreparedTimer();
        return rollback;
    }

    protected byte postCommit(byte response) {
        if (response == 3) {
            this.removeIncompletedSubTx();
        }
        return response;
    }

    protected byte preRollback() {
        TMServer.removeIncompleteSubTx(this);
        return 1;
    }

    protected void innerDestroy() {
        ThreadContexts.removeCoordinator(this.gtid);
        TMServer.disconnectContext();
        this.cancelPreparedTimer();
    }

    protected void innerFlush() throws TMException {
        boolean result;
        if (logger.isLoggable(JeusMessage_TM1._3780_LEVEL)) {
            logger.logp(JeusMessage_TM1._3780_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3780, new Object[]{this.root, this.gtid});
        }
        this.root.requestFlush();
        try {
            if (logger.isLoggable(JeusMessage_TM1._3781_LEVEL)) {
                logger.logp(JeusMessage_TM1._3781_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3781, new Object[]{String.valueOf(this.prepareTO), this.root, this.gtid});
            }
            result = this.frCollector.waiting(this.prepareTO);
        }
        catch (TMException ex) {
            if (logger.isLoggable(JeusMessage_TM1._3782_LEVEL)) {
                logger.logp(JeusMessage_TM1._3782_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3782, new Object[]{this.root, this.gtid}, (Throwable)ex);
            }
            throw ex;
        }
        if (result) {
            throw new TMException(JeusMessage_TM1._3783, new String[]{this.root.toString(), this.gtid.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte setCommitStatus() {
        if (this.localXAResource != null) {
            Object object = this.localXAResourceLock;
            synchronized (object) {
                if (this.localXAResource != null) {
                    if (logger.isLoggable(JeusMessage_TM1._3673_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3673_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3673, (Object)this.gtid);
                    }
                    return 6;
                }
            }
        }
        if (logger.isLoggable(JeusMessage_TM1._3674_LEVEL)) {
            logger.logp(JeusMessage_TM1._3674_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3674, new Object[]{"sub", this.gtid});
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preparedTimeout(PreparedTimerEntry entry) {
        if (logger.isLoggable(JeusMessage_TM1._3688_LEVEL)) {
            logger.logp(JeusMessage_TM1._3688_LEVEL, "Coordinator", "preparedTimeout", JeusMessage_TM1._3688, (Object)this.gtid);
        }
        Object object = this.preparedTimerLock;
        synchronized (object) {
            if (this.preparedTimer != entry) {
                return;
            }
        }
        if (logger.isLoggable(JeusMessage_TM1._3690_LEVEL)) {
            logger.logp(JeusMessage_TM1._3690_LEVEL, "Coordinator", "preparedTimeout", JeusMessage_TM1._3690, (Object)this.gtid);
        }
        object = this.localXAResourceLock;
        synchronized (object) {
            if (this.localXAResource != null) {
                TMServer.removeIncompleteSubTx(this);
                try {
                    this.rollback();
                }
                catch (IllegalStateException ise) {
                    if (logger.isLoggable(JeusMessage_TM1._3689_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3689_LEVEL, "Coordinator", "preparedTimeout", JeusMessage_TM1._3689, this.gtid, (Throwable)ise);
                    }
                }
                catch (TMException tMException) {
                    // empty catch block
                }
                this.destroy();
            }
        }
        JTAStatisticsProvider.incrementPreparedTimeOutCount();
        JTAStatisticsProvider.incrementTimeOutCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPreparedTimer() {
        if (logger.isLoggable(JeusMessage_TM1._3680_LEVEL)) {
            logger.logp(JeusMessage_TM1._3680_LEVEL, "Coordinator", "setPreparedTimer", JeusMessage_TM1._3680, (Object)this.gtid);
        }
        Object object = this.preparedTimerLock;
        synchronized (object) {
            if (logger.isLoggable(JeusMessage_TM1._3681_LEVEL)) {
                logger.logp(JeusMessage_TM1._3681_LEVEL, "Coordinator", "setPreparedTimer", JeusMessage_TM1._3681, new Object[]{String.valueOf(this.preparedTO), this.gtid});
            }
            if (logger.isLoggable(JeusMessage_TM3._5201_LEVEL)) {
                long time = System.currentTimeMillis() + this.preparedTO;
                logger.logp(JeusMessage_TM3._5201_LEVEL, "TimerEntry", "<init>", JeusMessage_TM3._5201, new Object[]{this, String.valueOf(time)});
            }
            this.preparedTimer = new PreparedTimerEntry(this);
            ScheduledExecutor.getInstance().schedule(this.preparedTimer, this.preparedTO);
        }
    }

    public void requestFlushResponse(byte response) {
        if (logger.isLoggable(JeusMessage_TM1._3789_LEVEL)) {
            logger.logp(JeusMessage_TM1._3789_LEVEL, "Coordinator", "requestFlushResponse", JeusMessage_TM1._3789, (Object)TxStatus.getState(response));
        }
        this.frCollector.received(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPreparedTimer() {
        if (logger.isLoggable(JeusMessage_TM1._3683_LEVEL)) {
            logger.logp(JeusMessage_TM1._3683_LEVEL, "Coordinator", "disablePreparedTO", JeusMessage_TM1._3683, (Object)this.gtid);
        }
        Object object = this.preparedTimerLock;
        synchronized (object) {
            if (this.preparedTimer != null) {
                this.preparedTimer.cancel();
                this.preparedTimer = null;
                if (logger.isLoggable(JeusMessage_TM1._3687_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3687_LEVEL, "Coordinator", "disablePreparedTO", JeusMessage_TM1._3687, (Object)this.gtid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte commitLocalXAResource() {
        if (logger.isLoggable(JeusMessage_TM1._3741_LEVEL)) {
            logger.logp(JeusMessage_TM1._3741_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM1._3741, new Object[]{this.localXAResource, this.gtid});
        }
        Object object = this.localXAResourceLock;
        synchronized (object) {
            byte by;
            block21: {
                byte by2;
                block20: {
                    byte by3;
                    block19: {
                        if (this.localXAResource == null) {
                            return 1;
                        }
                        try {
                            try {
                                if (this.localResources.size() == 1) {
                                    byte result;
                                    if (logger.isLoggable(JeusMessage_TM4._6307_LEVEL)) {
                                        logger.logp(JeusMessage_TM4._6307_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM4._6307, new Object[]{this.gtid});
                                    }
                                    if ((result = this.onePhaseCommit()) == 0) {
                                        if (logger.isLoggable(JeusMessage_TM1._3743_LEVEL)) {
                                            logger.logp(JeusMessage_TM1._3743_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM1._3743, new Object[]{this.localXAResource, this.gtid});
                                        }
                                        this.cancelPreparedTimer();
                                        TMServer.removeIncompleteSubTx(this);
                                        byte by4 = 9;
                                        Object var5_10 = null;
                                        this.localXAResource = null;
                                        return by4;
                                    }
                                    if (logger.isLoggable(JeusMessage_TM1._3744_LEVEL)) {
                                        logger.logp(JeusMessage_TM1._3744_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM1._3744, new Object[]{this.localXAResource, this.gtid});
                                    }
                                    by3 = result;
                                    break block19;
                                }
                                byte result = this.localXAResource.onePhaseCommit();
                                if (result == 0) {
                                    if (logger.isLoggable(JeusMessage_TM1._3743_LEVEL)) {
                                        logger.logp(JeusMessage_TM1._3743_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM1._3743, new Object[]{this.localXAResource, this.gtid});
                                    }
                                    this.cancelPreparedTimer();
                                    this.setPreparedTimer();
                                    by2 = result;
                                    break block20;
                                }
                                if (logger.isLoggable(JeusMessage_TM1._3744_LEVEL)) {
                                    logger.logp(JeusMessage_TM1._3744_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM1._3744, new Object[]{this.localXAResource, this.gtid});
                                }
                                by = result;
                                break block21;
                            }
                            catch (Throwable t) {
                                if (logger.isLoggable(JeusMessage_TM1._3745_LEVEL)) {
                                    logger.logp(JeusMessage_TM1._3745_LEVEL, "Coordinator", "commitLocalXAResource", JeusMessage_TM1._3745, new Object[]{this.localXAResource, this.gtid}, t);
                                }
                                byte by5 = 1;
                                Object var5_14 = null;
                                this.localXAResource = null;
                                return by5;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_15 = null;
                            this.localXAResource = null;
                            throw throwable;
                        }
                    }
                    Object var5_11 = null;
                    this.localXAResource = null;
                    return by3;
                }
                Object var5_12 = null;
                this.localXAResource = null;
                return by2;
            }
            Object var5_13 = null;
            this.localXAResource = null;
            return by;
        }
    }

    public void removeIncompletedSubTx() {
        TMServer.removeIncompleteSubTx(this);
    }

    public void addIndoubtXid(Xid xid) {
    }
}

