/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import jeus.util.JeusRuntimeException;
import jeus.util.properties.JeusTMProperties;

public class NetworkAddressTranslation {
    private static final ConcurrentHashMap<String, String> NAT_TABLE = new ConcurrentHashMap();
    private static final File PROPERTIES_FILE = JeusTMProperties.NAT_PROPERTIES_PATH == null ? null : new File(JeusTMProperties.NAT_PROPERTIES_PATH);
    private static final boolean ENABLED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() throws IOException {
        if (!ENABLED) {
            return;
        }
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream(PROPERTIES_FILE);
        try {
            properties.load(in);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            in.close();
            in = null;
            throw throwable;
        }
        in.close();
        in = null;
        NAT_TABLE.clear();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = ((String)keys.nextElement()).trim();
            String value = properties.getProperty(key).trim();
            NAT_TABLE.put(key, value);
        }
    }

    public static String getTranslation(String origin) {
        if (!ENABLED) {
            return null;
        }
        if (origin == null) {
            return null;
        }
        return NAT_TABLE.get(origin);
    }

    public static void main(String[] args) {
        for (String key : NAT_TABLE.keySet()) {
            String value = NAT_TABLE.get(key);
            System.out.println("key=" + key + ", value=" + value);
        }
        System.out.println(NetworkAddressTranslation.getTranslation("61.77.153.180"));
    }

    static {
        try {
            if (PROPERTIES_FILE != null && PROPERTIES_FILE.exists()) {
                ENABLED = true;
                NetworkAddressTranslation.load();
            } else {
                ENABLED = false;
            }
        }
        catch (Throwable t) {
            throw new JeusRuntimeException(t);
        }
    }
}

