/*
 * Decompiled with CFR 0.152.
 */
package jeus.transport.jeus;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jeus.transport.jeus.BlockingSocketThreadPoolFactory;
import jeus.transport.jeus.JEUSTransportConfig;
import jeus.util.ThreadPoolThreadFactory;

public class DefaultBlockingSocketThreadPoolFactory
implements BlockingSocketThreadPoolFactory {
    public static final String POOL_NAME = "pool-name";
    public static final String DAEMON = "daemon";
    private static final Map<String, Executor> threadPoolCache = new HashMap<String, Executor>();
    private static final String DEFAULT_POOL_NAME = "__JEUS_TRANSPORT_DEFAULT_THREAD__";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor createThreadPool(JEUSTransportConfig config) {
        String poolName = config.getProperty(POOL_NAME, DEFAULT_POOL_NAME);
        Map<String, Executor> map = threadPoolCache;
        synchronized (map) {
            Executor threadPool = threadPoolCache.get(poolName);
            if (threadPool == null) {
                boolean daemon = config.getBooleanProperty(DAEMON, true);
                threadPool = Executors.newCachedThreadPool(new ThreadPoolThreadFactory(poolName, daemon));
                threadPoolCache.put(poolName, threadPool);
            }
            return threadPool;
        }
    }

    static {
        ExecutorService defaultThreadPool = Executors.newCachedThreadPool(new ThreadPoolThreadFactory(DEFAULT_POOL_NAME, true));
        threadPoolCache.put(DEFAULT_POOL_NAME, defaultThreadPool);
    }
}

