/*
 * Decompiled with CFR 0.152.
 */
package jeus.transport.jeus;

import java.net.Socket;
import javax.net.ssl.SSLContext;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.IOComponentCreator;
import jeus.io.protocol.message.ssl.SSLConfiguration;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.transport.TransportException;
import jeus.transport.jeus.JEUSTransport;
import jeus.transport.jeus.JEUSTransportConfig;

public class JEUSClientTransport
extends JEUSTransport
implements ConnectionListenerFactory,
ConnectionListener {
    public JEUSClientTransport(JEUSTransportConfig config) {
        super(config);
    }

    public void start() throws Throwable {
        super.start();
        this.remoteAddress = this.getRemoteSocketAddress().toString();
    }

    protected synchronized void doStart(Object[] params) throws Throwable {
        Object piggyBackedData = null;
        if (params.length == 1) {
            piggyBackedData = params[0];
        }
        if (this.config.getName() == null) {
            throw new TransportException("Name is a mendatory property to create JEUS Transport.");
        }
        IOComponentCreator ioComponentCreator = this.config.createIOComponentCreator();
        SocketID socketID = this.config.createLocalSocketID();
        StreamContentHandlerCreator contentHandlerCreator = this.config.createStreamContentHandlerCreator();
        SSLContext sslCtx = this.config.createSSLContext();
        SSLConfiguration sslCfg = this.config.createSSLConfiguration();
        boolean onlyByteTransfer = this.config.isOnlyByteTransfer();
        int backlog = this.config.getBacklog();
        int selectorCount = this.config.getNonBlockingSelectorCount();
        boolean useDualSelector = this.config.isNonBlockingUseDualSelector();
        Endpoint endpoint = new Endpoint(this.config.getName(), ioComponentCreator, socketID, contentHandlerCreator, this, sslCtx, null, sslCfg, onlyByteTransfer, backlog, selectorCount, useDualSelector, this.config.isEnablePing(), this.config.getPingPeriod(), this.config.getPingTimeout(), this.config.isPingSyncWrite());
        SocketID connectSocketID = this.config.createSocketID();
        this.stream = endpoint.getSocketStream(connectSocketID, this.config.getConnectTryCount(), piggyBackedData, this.config.getConnectTimeout(), this.config.getReadTimeout(), this.config.getSleepTime());
    }

    protected synchronized void doStop(Object[] params) throws Throwable {
        this.stream.destroy();
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        return this;
    }
}

