/*
 * Decompiled with CFR 0.152.
 */
package jeus.transport.jeus;

import java.io.IOException;
import jeus.net.AcceptorConnectionListener;
import jeus.net.Endpoint;
import jeus.net.NetworkControlPacket;
import jeus.net.SocketStream;
import jeus.transport.TransportException;
import jeus.transport.jeus.JEUSPiggyBackRequest;
import jeus.transport.jeus.JEUSTransport;
import jeus.transport.jeus.JEUSTransportConfig;

public class JEUSServerTransport
extends JEUSTransport
implements AcceptorConnectionListener {
    private final Endpoint endpoint;

    public JEUSServerTransport(JEUSTransportConfig config, Endpoint endpoint) {
        super(config);
        this.endpoint = endpoint;
    }

    protected void doStart(Object[] params) throws Throwable {
    }

    protected synchronized void doStop(Object[] params) throws Throwable {
        if (this.isConnected()) {
            if (params.length > 0 && params[0] instanceof Exception) {
                this.stream.receiveException((Exception)params[0], this.stream.getEndpoint());
            }
            this.stream.destroy();
        }
        this.stream = null;
        this.remoteAddress = "";
    }

    public void connectionEstablished(SocketStream sockStream) {
        this.remoteAddress = sockStream.getSocket().getRemoteSocketAddress().toString();
    }

    public synchronized void connectionAllowed(SocketStream sockStream, NetworkControlPacket packet, int connectionType, Object piggybackedData) throws IOException {
        this.stream = sockStream;
        if (piggybackedData != null && this.listener != null) {
            Object response;
            try {
                response = this.listener.onRequest(this, new JEUSPiggyBackRequest(piggybackedData));
            }
            catch (Exception e) {
                throw new TransportException(e);
            }
            if (response != null) {
                packet.setData(response);
            }
        }
        sockStream.write(packet);
    }

    public void broadcast(int connectionType, Object message) throws TransportException {
        this.endpoint.broadcast(connectionType, this.stream, message);
    }
}

