/*
 * Decompiled with CFR 0.152.
 */
package jeus.transport.jeus;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import jeus.net.ConnectionListener;
import jeus.net.ReplyListener;
import jeus.net.SocketStream;
import jeus.net.helper.MsgSync;
import jeus.server.lifecycle.LifeCycleSupport;
import jeus.transport.MessageTransport;
import jeus.transport.MessageTransportListener;
import jeus.transport.Request;
import jeus.transport.TransportConfig;
import jeus.transport.TransportException;
import jeus.transport.TransportListener;
import jeus.transport.jeus.JEUSRequest;
import jeus.transport.jeus.JEUSTransportConfig;

public abstract class JEUSTransport
extends LifeCycleSupport
implements MessageTransport,
ConnectionListener {
    protected SocketStream stream;
    protected MessageTransportListener listener;
    protected final JEUSTransportConfig config;
    protected String remoteAddress = "";

    protected JEUSTransport(JEUSTransportConfig config) {
        this.config = config;
    }

    public TransportListener getTransportListener() {
        return this.listener;
    }

    public void setTransportListener(TransportListener transportListener) {
        if (!(transportListener instanceof MessageTransportListener)) {
            throw new IllegalArgumentException("jeus.transport.MessageTransportListener is required.");
        }
        this.listener = (MessageTransportListener)transportListener;
    }

    public TransportConfig getTransportConfig() {
        return this.config;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public synchronized SocketAddress getRemoteSocketAddress() {
        if (this.stream != null) {
            return this.stream.getSocket().getRemoteSocketAddress();
        }
        throw new IllegalStateException("Transport is disconnected.");
    }

    public synchronized boolean isConnected() {
        return this.stream != null && !this.stream.isClosed();
    }

    public void receiveMessage(Object message, SocketStream sockStream, Object controlInfo) throws Exception {
        if (this.listener != null) {
            if (controlInfo == null) {
                this.listener.onMessage(this, message);
            } else {
                JEUSRequest request = new JEUSRequest(message, sockStream.getReplyID());
                Object response = this.listener.onRequest(this, request);
                if (response != null) {
                    this.stream.writeReply(response, request.getReplyID());
                }
            }
        }
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        if (this.listener != null) {
            this.listener.onException(this, exception);
        }
    }

    public void connectionConnected(SocketStream sockStream) throws SocketException {
    }

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object piggybackedData) throws Exception {
        if (this.listener != null && piggybackedData != null) {
            this.listener.onMessage(this, piggybackedData);
        }
    }

    public void runDelegatedTask(Runnable messageProcessor, boolean isReplyPacket, Object message) {
        messageProcessor.run();
    }

    public Object getPiggybackData(int msgType, SocketStream sockStream, Object piggybackedData) {
        return piggybackedData;
    }

    public void writeDone(SocketStream sockStream) {
    }

    public void oneway(Object message) throws TransportException {
        try {
            this.stream.write(message);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    public boolean supportsTwoWay() {
        return true;
    }

    public Object request(Object message) throws TransportException {
        return this.request(message, Integer.MAX_VALUE);
    }

    public Object request(Object message, int timeout) throws TransportException {
        MsgSync msgSync = new MsgSync(timeout);
        try {
            this.stream.write(message, (ReplyListener)msgSync);
            return msgSync.waitReply();
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    public void response(Request request, Object message) throws TransportException {
        if (request instanceof JEUSRequest) {
            try {
                this.stream.writeReply(message, ((JEUSRequest)request).getReplyID());
            }
            catch (IOException e) {
                throw new TransportException(e);
            }
        } else {
            throw new TransportException("Invalid JEUSRequest");
        }
    }

    public String toString() {
        return this.getRemoteAddress();
    }
}

