/*
 * Decompiled with CFR 0.152.
 */
package jeus.transport.jeus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.IOComponentCreator;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.io.protocol.message.ssl.SSLConfiguration;
import jeus.net.SocketID;
import jeus.net.SocketIDParser;
import jeus.transport.TransportConfig;
import jeus.transport.TransportException;
import jeus.transport.jeus.BlockingSocketThreadPoolFactory;
import jeus.transport.jeus.DefaultBlockingSocketThreadPoolFactory;
import jeus.transport.jeus.IoType;
import jeus.transport.jeus.SocketIDFactory;
import jeus.transport.jeus.StreamContentHandlerCreatorFactory;
import jeus.util.properties.JeusNetProperties;

public class JEUSTransportConfig
extends TransportConfig {
    public static final String PROPERTY_PREFIX = "jeus.transport.jeus.";
    public static final String NAME = "jeus.transport.jeus.name";
    public static final String IO_TYPE = "jeus.transport.jeus.io-type";
    public static final String NON_BLOCKING_WRITE_LIMIT = "jeus.transport.jeus.non-blocking.write-limit";
    public static final String NON_BLOCKING_WRITE_RESTART = "jeus.transport.jeus.non-blocking.write-restart";
    public static final String NON_BLOCKING_WRITE_REPEAT = "jeus.transport.jeus.non-blocking.write-repeat";
    public static final String BLOCKING_USE_DEAMON = "jeus.transport.jeus.blocking.use-deamon";
    public static final String SOCKET_ID_FACTORY = "jeus.transport.jeus.socket-id-factory";
    private static final String SOCKET_ID_FACTORY_CACHE_SUFFIX = ".socket-id-factory-cache";
    private static final String DEFAULT_SOCKET_ID_FACTORY = "jeus.transport.jeus.DefaultSocketIDFactory";
    public static final String SOCKET_ID_HOST = "jeus.transport.jeus.socket-id.host";
    public static final String SOCKET_ID_PORT = "jeus.transport.jeus.socket-id.port";
    public static final String SOCKET_ID_VIRTUAL_ID = "jeus.transport.jeus.socket-id.virtual-id";
    public static final String LOCAL_SOCKET_ID_HOST = "jeus.transport.jeus.local-socket-id.host";
    public static final String LOCAL_SOCKET_ID_PORT = "jeus.transport.jeus.local-socket-id.port";
    public static final String LOCAL_SOCKET_ID_CONNECTION_TYPE = "jeus.transport.jeus.local-socket-id.connection-type";
    public static final String ONLY_BYTE_TRANSFER = "jeus.transport.jeus.only-byte-transfer";
    public static final String BACKLOG = "jeus.transport.jeus.backlog";
    public static final String NON_BLOCKING_SELECTOR_COUNT = "jeus.transport.jeus.non-blocking.selector-count";
    public static final String NON_BLOCKING_USE_DUAL_SELECTOR = "jeus.transport.jeus.non-blocking.use-dual-selector";
    public static final String CONNECT_TRY_COUNT = "jeus.transport.jeus.connect-try-count";
    public static final String CONNECT_TIMEOUT = "jeus.transport.jeus.connect-timeout";
    public static final String READ_TIMEOUT = "jeus.transport.jeus.read-timeout";
    public static final String LINGER_ON = "jeus.transport.jeus.linger-on";
    public static final String LINGER = "jeus.transport.jeus.linger";
    public static final String NO_DELAY = "jeus.transport.jeus.no-delay";
    public static final String RECV_BUFFER_SIZE = "jeus.transport.jeus.recv-buffer-size";
    public static final String SEND_BUFFER_SIZE = "jeus.transport.jeus.send-buffer-size";
    public static final String SLEEP_TIME = "jeus.transport.jeus.sleep-time";
    public static final String ENABLE_PING = "jeus.transport.jeus.enable-ping";
    public static final String PING_PERIOD = "jeus.transport.jeus.ping-period";
    public static final String PING_TIMEOUT = "jeus.transport.jeus.ping-timeout";
    public static final String PING_SYNC_WRITE = "jeus.transport.jeus.ping-sync-write";
    public static final String ENABLE_SSL = "jeus.transport.jeus.enable-ssl";
    public static final String SSL_CIPHER_SUITES = "jeus.transport.jeus.ssl.cipher-suites";
    public static final String SSL_PROTOCOLS = "jeus.transport.jeus.ssl.protocols";
    public static final String SSL_ENABLE_SESSION_CREATION = "jeus.transport.jeus.ssl.enable-session-creation";
    public static final String SSL_USE_CLIENT_MODE = "jeus.transport.jeus.ssl.use-client-mode";
    public static final String SSL_WANT_CLIENT_AUTH = "jeus.transport.jeus.ssl.want-client-auth";
    public static final String SSL_NEED_CLIENT_AUTH = "jeus.transport.jeus.ssl.need-client-auth";
    public static final String SSL_KEY_STORE_TYPE = "jeus.transport.jeus.ssl.key-store-type";
    public static final String SSL_KEY_STORE_PASS = "jeus.transport.jeus.ssl.key-store-passphrase";
    public static final String SSL_KEY_STORE_FILE = "jeus.transport.jeus.ssl.key-store-file";
    public static final String SSL_KEY_MANAGEMENT_ALGORITHM = "jeus.transport.jeus.ssl.key-management-algorithm";
    public static final String SSL_TRUST_STORE_TYPE = "jeus.transport.jeus.ssl.trust-store-type";
    public static final String SSL_TRUST_STORE_PASS = "jeus.transport.jeus.ssl.trust-store-passphrase";
    public static final String SSL_TRUST_STORE_FILE = "jeus.transport.jeus.ssl.trust-store-file";
    public static final String SSL_TRUST_MANAGEMENT_ALGORITHM = "jeus.transport.jeus.ssl.trust-management-algorithm";
    public static final String SSL_PROTOCOL = "jeus.transport.jeus.ssl.protocol";
    public static final String STREAM_CONTENT_HANDLER_CREATOR_FACTORY = "jeus.transport.jeus.stream-content-handler-creator-factory";
    private static final String STREAM_CONTENT_HANDLER_CREATOR_FACTORY_CACHE_SUFFIX = ".stream-content-handler-creator-factory-cache";
    private static final String DEFAULT_STREAM_CONTENT_HANDLER_CREATOR_FACTORY = "jeus.transport.jeus.DefaultStreamContentHandlerCreatorFactory";
    private static final String BLOCKING_SOCKET_THREAD_POOL_FACTORY = "jeus.transport.jeus.blocking-socket-thread-pool-factory";
    private static final String BLOCKING_SOCKET_THREAD_POOL_FACTORY_CACHE_SUFFIX = ".blocking-socket-thread-pool-factory-cache";
    private static final String DEFAULT_BLOCKING_SOCKET_THREAD_POOL_FACTORY = "jeus.transport.jeus.DefaultBlockingSocketThreadPoolFactory";
    private AtomicInteger idGenerator = new AtomicInteger(0);
    public static final BlockingSocketThreadPoolFactory defaultThreadPoolFactory = new DefaultBlockingSocketThreadPoolFactory();

    public JEUSTransportConfig() {
    }

    public JEUSTransportConfig(String address) throws TransportException {
        String[] results = SocketIDParser.parse(address);
        this.setHost(results[0]);
        this.setPort(Integer.parseInt(results[1]));
        this.setVirtualID(results[2]);
    }

    protected boolean accept(String name) {
        return name != null && name.trim().startsWith(PROPERTY_PREFIX);
    }

    public void setName(String name) {
        if (name != null) {
            this.setProperty(NAME, name);
        }
    }

    public String getName() {
        if (!this.containsKey(NAME)) {
            this.setProperty(NAME, "JEUSTransport" + this.idGenerator.getAndIncrement());
        }
        return this.getProperty(NAME);
    }

    public void setIoType(IoType type) {
        this.setProperty(IO_TYPE, type.name());
    }

    public IoType getIoType() {
        return IoType.valueOf(this.getProperty(IO_TYPE, IoType.NON_BLOCKING.name()));
    }

    public void setNonBlockingWriteLimit(int writeLimit) {
        this.setIntProperty(NON_BLOCKING_WRITE_LIMIT, writeLimit);
    }

    public int getNonBlockingWriteLimit() {
        return this.getIntProperty(NON_BLOCKING_WRITE_LIMIT, JeusNetProperties.WRITE_LIMIT);
    }

    public void setNonBlockingWriteRestart(int writeRestart) {
        this.setIntProperty(NON_BLOCKING_WRITE_RESTART, writeRestart);
    }

    public int getNonBlockingWriteRestart() {
        return this.getIntProperty(NON_BLOCKING_WRITE_RESTART, JeusNetProperties.WRITE_RESTART);
    }

    public void setNonBlockingWriteRepeat(int writeRepeat) {
        this.setIntProperty(NON_BLOCKING_WRITE_REPEAT, writeRepeat);
    }

    public int getNonBlockingWriteRepeat() {
        return this.getIntProperty(NON_BLOCKING_WRITE_REPEAT, JeusNetProperties.WRITE_REPEAT_COUNT);
    }

    public void setBlockingUseDeamon(boolean useDeamon) {
        this.setBooleanProperty(BLOCKING_USE_DEAMON, useDeamon);
    }

    public boolean isBlockingUseDeamon() {
        return this.getBooleanProperty(BLOCKING_USE_DEAMON, true);
    }

    public void setSocketIDFactory(String factory) {
        this.setProperty(SOCKET_ID_FACTORY, factory);
    }

    public SocketIDFactory getSocketIDFactory() throws TransportException {
        String className = this.getProperty(SOCKET_ID_FACTORY, DEFAULT_SOCKET_ID_FACTORY);
        String cacheName = className + SOCKET_ID_FACTORY_CACHE_SUFFIX;
        if (this.containsKey(cacheName)) {
            return (SocketIDFactory)this.get(cacheName);
        }
        try {
            Class<?> factoryClass = Class.forName(className);
            Constructor<?> constructor = factoryClass.getConstructor(JEUSTransportConfig.class);
            SocketIDFactory factory = (SocketIDFactory)constructor.newInstance(this);
            this.put(cacheName, factory);
            return factory;
        }
        catch (InstantiationException e) {
            throw new TransportException(e);
        }
        catch (IllegalAccessException e) {
            throw new TransportException(e);
        }
        catch (ClassNotFoundException e) {
            throw new TransportException(e);
        }
        catch (NoSuchMethodException e) {
            throw new TransportException(e);
        }
        catch (InvocationTargetException e) {
            throw new TransportException(e);
        }
    }

    public SocketID createLocalSocketID() throws TransportException {
        SocketIDFactory factory = this.getSocketIDFactory();
        return factory.createLocalSocketID();
    }

    public SocketID createSocketID() throws TransportException {
        SocketIDFactory factory = this.getSocketIDFactory();
        return factory.createSocketID();
    }

    public void setHost(String host) {
        if (host != null) {
            this.setProperty(SOCKET_ID_HOST, host);
        }
    }

    public String getHost() {
        return this.getProperty(SOCKET_ID_HOST);
    }

    public void setPort(int port) {
        this.setIntProperty(SOCKET_ID_PORT, port);
    }

    public int getPort() {
        return this.getIntProperty(SOCKET_ID_PORT);
    }

    public void setVirtualID(String virtualID) {
        if (virtualID != null) {
            this.setProperty(SOCKET_ID_VIRTUAL_ID, virtualID);
        }
    }

    public String getVirtualID() {
        return this.getProperty(SOCKET_ID_VIRTUAL_ID);
    }

    public void setLocalHost(String host) {
        if (host != null) {
            this.setProperty(LOCAL_SOCKET_ID_HOST, host);
        }
    }

    public String getLocalHost() {
        return this.getProperty(LOCAL_SOCKET_ID_HOST);
    }

    public void setLocalPort(int port) {
        this.setIntProperty(LOCAL_SOCKET_ID_PORT, port);
    }

    public int getLocalPort() {
        return this.getIntProperty(LOCAL_SOCKET_ID_PORT);
    }

    public void setLocalConnectionType(int connectionType) {
        this.setIntProperty(LOCAL_SOCKET_ID_CONNECTION_TYPE, connectionType);
    }

    public int getLocalConnectionType() {
        return this.getIntProperty(LOCAL_SOCKET_ID_CONNECTION_TYPE);
    }

    public void setOnlyByteTransfer(boolean onlyByteTransfer) {
        this.setBooleanProperty(ONLY_BYTE_TRANSFER, onlyByteTransfer);
    }

    public boolean isOnlyByteTransfer() {
        return this.getBooleanProperty(ONLY_BYTE_TRANSFER, false);
    }

    public void setBacklog(int backlog) {
        this.setIntProperty(BACKLOG, backlog);
    }

    public int getBacklog() {
        return this.getIntProperty(BACKLOG, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public void setNonBlockingSelectorCount(int count) {
        this.setIntProperty(NON_BLOCKING_SELECTOR_COUNT, count);
    }

    public int getNonBlockingSelectorCount() {
        return this.getIntProperty(NON_BLOCKING_SELECTOR_COUNT, 1);
    }

    public void setNonBlockingUseDualSelector(boolean useDualSelector) {
        this.setBooleanProperty(NON_BLOCKING_USE_DUAL_SELECTOR, useDualSelector);
    }

    public boolean isNonBlockingUseDualSelector() {
        return this.getBooleanProperty(NON_BLOCKING_USE_DUAL_SELECTOR, false);
    }

    public void setConnectTryCount(int count) {
        this.setIntProperty(CONNECT_TRY_COUNT, count);
    }

    public int getConnectTryCount() {
        return this.getIntProperty(CONNECT_TRY_COUNT, 1);
    }

    public void setConnectTimeout(int timeout) {
        this.setIntProperty(CONNECT_TIMEOUT, timeout);
    }

    public int getConnectTimeout() {
        return this.getIntProperty(CONNECT_TIMEOUT, 0);
    }

    public void setReadTimeout(int timeout) {
        this.setIntProperty(READ_TIMEOUT, timeout);
    }

    public int getReadTimeout() {
        return this.getIntProperty(READ_TIMEOUT, 0);
    }

    public void setLinger(int linger) {
        this.setIntProperty(LINGER, linger);
    }

    public void setSoLinger(Socket socket) throws SocketException {
        if (this.containsKey(LINGER)) {
            socket.setSoLinger(true, this.getIntProperty(LINGER));
        }
    }

    public void setRecvBufferSize(int size) {
        this.setIntProperty(RECV_BUFFER_SIZE, size);
    }

    public void setRecvBufferSize(Socket socket) throws SocketException {
        if (this.containsKey(RECV_BUFFER_SIZE)) {
            socket.setReceiveBufferSize(this.getIntProperty(RECV_BUFFER_SIZE));
        }
    }

    public void setSendBufferSize(int size) {
        this.setIntProperty(SEND_BUFFER_SIZE, size);
    }

    public void setSendBufferSize(Socket socket) throws SocketException {
        if (this.containsKey(SEND_BUFFER_SIZE)) {
            socket.setSendBufferSize(this.getIntProperty(SEND_BUFFER_SIZE));
        }
    }

    public void setSleepTime(int time) {
        this.setIntProperty(SLEEP_TIME, time);
    }

    public int getSleepTime() {
        return this.getIntProperty(SLEEP_TIME, 3000);
    }

    public void setEnablePing(boolean enable) {
        this.setBooleanProperty(ENABLE_PING, enable);
    }

    public boolean isEnablePing() {
        return this.getBooleanProperty(ENABLE_PING, JeusNetProperties.ENABLE_PING);
    }

    public void setPingPeriod(long period) {
        this.setLongProperty(PING_PERIOD, period);
    }

    public long getPingPeriod() {
        return this.getLongProperty(PING_PERIOD, JeusNetProperties.PING_PERIOD);
    }

    public void setPingTimeout(long timeout) {
        this.setLongProperty(PING_TIMEOUT, timeout);
    }

    public long getPingTimeout() {
        return this.getLongProperty(PING_TIMEOUT, JeusNetProperties.PING_TIMEOUT);
    }

    public void setPingSyncWrite(boolean sync) {
        this.setBooleanProperty(PING_SYNC_WRITE, sync);
    }

    public boolean isPingSyncWrite() {
        return this.getBooleanProperty(PING_SYNC_WRITE, JeusNetProperties.PING_SYNC_WRITE);
    }

    public void setEnableSSL(boolean enable) {
        this.setBooleanProperty(ENABLE_SSL, enable);
    }

    public boolean isEnableSSL() {
        return this.getBooleanProperty(ENABLE_SSL, false);
    }

    public IOComponentCreator createIOComponentCreator() {
        if (this.getIoType() == IoType.NON_BLOCKING) {
            return JeusIOComponentCreator.createNIOCreator(this.getName(), this.getNonBlockingWriteRepeat(), this.getNonBlockingWriteLimit(), this.getNonBlockingWriteRestart());
        }
        return JeusIOComponentCreator.createSocketBlockingCreator(this.getName(), this.createBlockingSocketThreadPool());
    }

    public void setSSLCipherSuites(String[] suites) {
        for (int i = 0; i < suites.length; ++i) {
            this.setProperty("jeus.transport.jeus.ssl.cipher-suites." + i, suites[i]);
        }
    }

    public String[] getSSLCipherSuites() {
        String suite;
        ArrayList<String> suites = new ArrayList<String>();
        int i = 0;
        while ((suite = this.getProperty("jeus.transport.jeus.ssl.cipher-suites." + i)) != null) {
            suites.add(suite);
            ++i;
        }
        if (suites.isEmpty()) {
            return null;
        }
        return suites.toArray(new String[0]);
    }

    public void setSSLProtocols(String[] protocols) {
        for (int i = 0; i < protocols.length; ++i) {
            this.setProperty("jeus.transport.jeus.ssl.protocols." + i, protocols[i]);
        }
    }

    public String[] getSSLProtocols() {
        String protocol;
        ArrayList<String> protocols = new ArrayList<String>();
        int i = 0;
        while ((protocol = this.getProperty("jeus.transport.jeus.ssl.protocols." + i)) != null) {
            protocols.add(protocol);
            ++i;
        }
        if (protocols.isEmpty()) {
            return null;
        }
        return protocols.toArray(new String[0]);
    }

    public void setSSLEnableSessionCreation(boolean enable) {
        this.setBooleanProperty(SSL_ENABLE_SESSION_CREATION, enable);
    }

    public boolean isSSLEnableSessionCreation() {
        return this.getBooleanProperty(SSL_ENABLE_SESSION_CREATION);
    }

    public void setSSLUseClientMode(boolean use) {
        this.setBooleanProperty(SSL_USE_CLIENT_MODE, use);
    }

    public boolean isSSLUseClientMode() {
        return this.getBooleanProperty(SSL_USE_CLIENT_MODE, false);
    }

    public void setSSLWantClientAuth(boolean want) {
        this.setBooleanProperty(SSL_WANT_CLIENT_AUTH, want);
    }

    public boolean isSSLWantClientAuth() {
        return this.getBooleanProperty(SSL_WANT_CLIENT_AUTH, false);
    }

    public void setSSLNeedClientAuth(boolean need) {
        this.setBooleanProperty(SSL_NEED_CLIENT_AUTH, need);
    }

    public boolean isSSLNeedClientAuth() {
        return this.getBooleanProperty(SSL_NEED_CLIENT_AUTH, false);
    }

    public void setSSLKeyStoreType(String type) {
        if (type != null) {
            this.setProperty(SSL_KEY_STORE_TYPE, type);
        }
    }

    public String getSSLKeyStoreType() {
        return this.getProperty(SSL_KEY_STORE_TYPE, "JKS");
    }

    public void setSSLKeyStorePass(String pass) {
        if (pass != null) {
            this.setProperty(SSL_KEY_STORE_PASS, pass);
        }
    }

    public String getSSLKeyStorePass() {
        return this.getProperty(SSL_KEY_STORE_PASS, "changeit");
    }

    public void setSSLKeyStoreFile(String file) {
        if (file != null) {
            this.setProperty(SSL_KEY_STORE_FILE, file);
        }
    }

    public String getSSLKeyStoreFile() {
        return this.getProperty(SSL_KEY_STORE_FILE);
    }

    public void setSSLKeyManagementAlgorithm(String algorithm) {
        if (algorithm != null) {
            this.setProperty(SSL_KEY_MANAGEMENT_ALGORITHM, algorithm);
        }
    }

    public String getSSLKeyManagementAlgorithm() {
        return this.getProperty(SSL_KEY_MANAGEMENT_ALGORITHM, "SunX509");
    }

    public void setSSLTrustStoreType(String type) {
        if (type != null) {
            this.setProperty(SSL_TRUST_STORE_TYPE, type);
        }
    }

    public String getSSLTrustStoreType() {
        return this.getProperty(SSL_TRUST_STORE_TYPE, "JKS");
    }

    public void setSSLTrustStorePass(String pass) {
        if (pass != null) {
            this.setProperty(SSL_TRUST_STORE_PASS, pass);
        }
    }

    public String getSSLTrustStorePass() {
        return this.getProperty(SSL_TRUST_STORE_PASS, "changeit");
    }

    public void setSSLTrustStoreFile(String file) {
        if (file != null) {
            this.setProperty(SSL_TRUST_STORE_FILE, file);
        }
    }

    public String getSSLTrustStoreFile() {
        return this.getProperty(SSL_TRUST_STORE_FILE);
    }

    public void setSSLTrustManagementAlgorithm(String algorithm) {
        if (algorithm != null) {
            this.setProperty(SSL_TRUST_MANAGEMENT_ALGORITHM, algorithm);
        }
    }

    public String getSSLTrustManagementAlgorithm() {
        return this.getProperty(SSL_TRUST_MANAGEMENT_ALGORITHM, "SunX509");
    }

    public void setSSLProtocol(String protocol) {
        if (protocol != null) {
            this.setProperty(SSL_PROTOCOL, protocol);
        }
    }

    public String getSSLProtocol() {
        return this.getProperty(SSL_PROTOCOL, "TLS");
    }

    public SSLContext createSSLContext() throws TransportException {
        SSLContext ctx;
        KeyManagerFactory kmf;
        KeyStore keyStore;
        if (!this.isEnableSSL()) {
            return null;
        }
        String keyStoreType = this.getSSLKeyStoreType();
        char[] keyStorePass = this.getSSLKeyStorePass().toCharArray();
        String keyStorePath = this.getSSLKeyStoreFile();
        String keyManagementAlgorithm = this.getSSLKeyManagementAlgorithm();
        String trustStoreType = this.getSSLTrustStoreType();
        char[] trustStorePass = this.getSSLTrustStorePass().toCharArray();
        String trustStorePath = this.getSSLTrustStoreFile();
        String trustManagementAlgorithm = this.getSSLTrustManagementAlgorithm();
        String protocol = this.getSSLProtocol();
        File keyStoreFile = new File(keyStorePath);
        if (!keyStoreFile.exists()) {
            throw new TransportException("Key store path '" + keyStorePath + "' does not exist.");
        }
        try {
            keyStore = KeyStore.getInstance(keyStoreType);
        }
        catch (KeyStoreException e) {
            throw new TransportException(e);
        }
        try {
            FileInputStream keyStoreInput = new FileInputStream(keyStoreFile);
            keyStore.load(keyStoreInput, keyStorePass);
            keyStoreInput.close();
        }
        catch (FileNotFoundException e) {
            throw new TransportException(e);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransportException(e);
        }
        catch (CertificateException e) {
            throw new TransportException(e);
        }
        try {
            kmf = KeyManagerFactory.getInstance(keyManagementAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransportException(e);
        }
        try {
            kmf.init(keyStore, keyStorePass);
        }
        catch (KeyStoreException e) {
            throw new TransportException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransportException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new TransportException(e);
        }
        TrustManagerFactory tmf = null;
        if (this.isSSLNeedClientAuth() || this.isSSLWantClientAuth() || this.isSSLUseClientMode()) {
            KeyStore trustManagerStore;
            File trustStoreFile = new File(keyStorePath);
            if (!trustStoreFile.exists()) {
                throw new TransportException("Trust store path '" + trustStorePath + "' does not exist.");
            }
            try {
                trustManagerStore = KeyStore.getInstance(trustStoreType);
            }
            catch (KeyStoreException e) {
                throw new TransportException(e);
            }
            try {
                FileInputStream trustManagementStoreInput = new FileInputStream(trustStoreFile);
                trustManagerStore.load(trustManagementStoreInput, trustStorePass);
                trustManagementStoreInput.close();
            }
            catch (FileNotFoundException e) {
                throw new TransportException(e);
            }
            catch (IOException e) {
                throw new TransportException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new TransportException(e);
            }
            catch (CertificateException e) {
                throw new TransportException(e);
            }
            try {
                tmf = TrustManagerFactory.getInstance(trustManagementAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new TransportException(e);
            }
            try {
                tmf.init(trustManagerStore);
            }
            catch (KeyStoreException e) {
                throw new TransportException(e);
            }
        }
        try {
            ctx = SSLContext.getInstance(protocol);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransportException(e);
        }
        try {
            ctx.init(kmf.getKeyManagers(), tmf != null ? tmf.getTrustManagers() : null, null);
        }
        catch (KeyManagementException e) {
            throw new TransportException(e);
        }
        return ctx;
    }

    public SSLConfiguration createSSLConfiguration() {
        String[] protocols;
        if (!this.isEnableSSL()) {
            return null;
        }
        SSLConfiguration config = new SSLConfiguration();
        String[] cipherSuites = this.getSSLCipherSuites();
        if (cipherSuites != null) {
            config.setCipherSuites(cipherSuites);
        }
        if ((protocols = this.getSSLProtocols()) != null) {
            config.setProtocols(protocols);
        }
        if (this.containsKey(SSL_ENABLE_SESSION_CREATION)) {
            config.setEnableSessionCreation(this.isSSLEnableSessionCreation());
        }
        if (this.containsKey(SSL_NEED_CLIENT_AUTH)) {
            config.setNeedClientAuth(this.isSSLNeedClientAuth());
        }
        if (this.containsKey(SSL_WANT_CLIENT_AUTH)) {
            config.setWantClientAuth(this.isSSLWantClientAuth());
        }
        return config;
    }

    public void setStreamContentHandlerCreatorFactory(String creator) {
        this.setProperty(STREAM_CONTENT_HANDLER_CREATOR_FACTORY, creator);
    }

    public StreamContentHandlerCreatorFactory getStreamContentHandlerCreatorFactory() throws TransportException {
        String className = this.getProperty(STREAM_CONTENT_HANDLER_CREATOR_FACTORY, DEFAULT_STREAM_CONTENT_HANDLER_CREATOR_FACTORY);
        String cacheName = className + STREAM_CONTENT_HANDLER_CREATOR_FACTORY_CACHE_SUFFIX;
        if (this.containsKey(cacheName)) {
            return (StreamContentHandlerCreatorFactory)this.get(cacheName);
        }
        try {
            StreamContentHandlerCreatorFactory factory;
            Class<?> factoryClass = Class.forName(className);
            try {
                Constructor<?> constructor = factoryClass.getConstructor(JEUSTransportConfig.class);
                factory = (StreamContentHandlerCreatorFactory)constructor.newInstance(this);
            }
            catch (NoSuchMethodException e1) {
                try {
                    Constructor<?> constructor = factoryClass.getConstructor(new Class[0]);
                    factory = (StreamContentHandlerCreatorFactory)constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e2) {
                    throw new TransportException(e2);
                }
            }
            this.put(cacheName, factory);
            return factory;
        }
        catch (InstantiationException e) {
            throw new TransportException(e);
        }
        catch (IllegalAccessException e) {
            throw new TransportException(e);
        }
        catch (ClassNotFoundException e) {
            throw new TransportException(e);
        }
        catch (InvocationTargetException e) {
            throw new TransportException(e);
        }
    }

    public StreamContentHandlerCreator createStreamContentHandlerCreator() throws TransportException {
        StreamContentHandlerCreatorFactory factory = this.getStreamContentHandlerCreatorFactory();
        return factory.createStreamContentHandlerCreator();
    }

    public void setManagedThreadPoolFactory(String factoryName) {
        this.setProperty(BLOCKING_SOCKET_THREAD_POOL_FACTORY, factoryName);
    }

    public BlockingSocketThreadPoolFactory getBlockingSocketThreadPoolFactory() {
        String className = this.getProperty(BLOCKING_SOCKET_THREAD_POOL_FACTORY);
        if (className == null || DEFAULT_BLOCKING_SOCKET_THREAD_POOL_FACTORY.equals(className)) {
            return defaultThreadPoolFactory;
        }
        String cacheName = className + BLOCKING_SOCKET_THREAD_POOL_FACTORY_CACHE_SUFFIX;
        if (this.containsKey(cacheName)) {
            return (BlockingSocketThreadPoolFactory)this.get(cacheName);
        }
        try {
            Class<?> factoryClass = Class.forName(className);
            Constructor<?> constructor = factoryClass.getConstructor(new Class[0]);
            BlockingSocketThreadPoolFactory factory = (BlockingSocketThreadPoolFactory)constructor.newInstance(new Object[0]);
            this.put(cacheName, factory);
            return factory;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultThreadPoolFactory;
        }
    }

    public Executor createBlockingSocketThreadPool() {
        return this.getBlockingSocketThreadPoolFactory().createThreadPool(this);
    }
}

