/*
 * Decompiled with CFR 0.152.
 */
package jeus.transport.jeus;

import java.net.Socket;
import javax.net.ssl.SSLContext;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.IOComponentCreator;
import jeus.io.protocol.message.ssl.SSLConfiguration;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.server.lifecycle.LifeCycleSupport;
import jeus.transport.TransportAcceptListener;
import jeus.transport.TransportException;
import jeus.transport.TransportServer;
import jeus.transport.jeus.JEUSServerTransport;
import jeus.transport.jeus.JEUSTransportConfig;

public class JEUSTransportServer
extends LifeCycleSupport
implements TransportServer,
ConnectionListenerFactory {
    private final JEUSTransportConfig config;
    private TransportAcceptListener acceptListener;
    private Endpoint endpoint;

    public JEUSTransportServer(JEUSTransportConfig config) {
        this.config = config;
    }

    public void setAcceptListener(TransportAcceptListener acceptListener) {
        this.acceptListener = acceptListener;
    }

    protected void doStart(Object[] params) throws Throwable {
        if (this.config.getName() == null) {
            throw new TransportException("Name is a mendatory property to create JEUS Transport.");
        }
        IOComponentCreator ioComponentCreator = this.config.createIOComponentCreator();
        SocketID socketID = this.config.createSocketID();
        StreamContentHandlerCreator contentHandlerCreator = this.config.createStreamContentHandlerCreator();
        SSLContext sslCtx = this.config.createSSLContext();
        SSLConfiguration sslCfg = this.config.createSSLConfiguration();
        boolean onlyByteTransfer = this.config.isOnlyByteTransfer();
        int backlog = this.config.getBacklog();
        int selectorCount = this.config.getNonBlockingSelectorCount();
        boolean useDualSelector = this.config.isNonBlockingUseDualSelector();
        this.endpoint = new Endpoint(this.config.getName(), ioComponentCreator, socketID, contentHandlerCreator, this, sslCtx, null, sslCfg, onlyByteTransfer, backlog, selectorCount, useDualSelector, this.config.isEnablePing(), this.config.getPingPeriod(), this.config.getPingTimeout(), this.config.isPingSyncWrite());
        this.endpoint.export();
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        JEUSTransportConfig transportConfig = new JEUSTransportConfig();
        transportConfig.setHost(socket != null ? socket.getInetAddress().getHostAddress() : "localhost");
        transportConfig.setPort(socket != null ? socket.getPort() : 0);
        transportConfig.setLocalHost(socket != null ? socket.getLocalAddress().getHostAddress() : this.endpoint.getMySocketID().getHost());
        transportConfig.setLocalPort(socket != null ? socket.getLocalPort() : this.endpoint.getServerSocketPort());
        JEUSServerTransport transport = new JEUSServerTransport(this.config, this.endpoint);
        if (this.acceptListener != null) {
            this.acceptListener.onAccept(this, transport);
        }
        return transport;
    }

    protected void doStop(Object[] params) throws Throwable {
        this.endpoint.unexport();
    }
}

