/*
 * Decompiled with CFR 0.152.
 */
package jeus.transport.jeus.echo;

import jeus.server.lifecycle.LifeCycleSupport;
import jeus.transport.MessageTransportListener;
import jeus.transport.Request;
import jeus.transport.Transport;
import jeus.transport.TransportAcceptListener;
import jeus.transport.TransportConfig;
import jeus.transport.TransportFactory;
import jeus.transport.TransportServer;

public class EchoServer
extends LifeCycleSupport
implements TransportAcceptListener,
MessageTransportListener {
    private final String transport;
    private final String address;
    private TransportServer server;

    public EchoServer(String transport, String address) {
        this.transport = transport;
        this.address = address;
    }

    protected void doStart(Object[] params) throws Throwable {
        System.out.println("Starting EchoServer.");
        TransportFactory factory = TransportFactory.getTransportFactory(this.transport);
        TransportConfig config = factory.createTransportConfig(this.address);
        this.server = factory.bind(config);
        this.server.setAcceptListener(this);
        this.server.start();
    }

    protected void doStop(Object[] params) throws Throwable {
        System.out.println("Stopping EchoServer.");
        this.server.stop();
    }

    public void onAccept(TransportServer transportServer, Transport transport) {
        transport.setTransportListener(this);
        try {
            transport.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void onMessage(Transport transport, Object message) throws Exception {
    }

    public Object onRequest(Transport transport, Request request) throws Exception {
        return request.getMessage();
    }

    public void onException(Transport transport, Exception error) {
    }

    public static void main(String[] args) throws Throwable {
        if (args.length != 2) {
            System.out.println("[Usage] EchoServer transport address");
            return;
        }
        EchoServer server = new EchoServer(args[0].trim(), args[1].trim());
        server.start();
        while (System.in.read() != 113) {
        }
        server.stop();
    }
}

