/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;

public class Deserializer
extends ObjectInputStream {
    private final ClassLoader designatedLoader;
    private final ClassLoader systemLoader = Deserializer.class.getClassLoader();
    private static final HashMap primClasses = new HashMap(8, 1.0f);

    public Deserializer(InputStream in) throws IOException {
        this(in, null, false);
    }

    public Deserializer(InputStream in, ClassLoader designatedLoader) throws IOException {
        this(in, designatedLoader, false);
    }

    public Deserializer(InputStream in, boolean disableUserContextLoader) throws IOException {
        this(in, null, disableUserContextLoader);
    }

    private Deserializer(InputStream in, ClassLoader designatedLoader, boolean disableUserContextLoader) throws IOException {
        super(in);
        this.designatedLoader = designatedLoader != null ? designatedLoader : (disableUserContextLoader ? this.systemLoader : null);
        this.enableResolveObject(true);
    }

    public Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            if (this.designatedLoader != null) {
                return Class.forName(desc.getName(), false, this.designatedLoader);
            }
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            if (contextLoader != null) {
                try {
                    return Class.forName(desc.getName(), false, contextLoader);
                }
                catch (ClassNotFoundException e) {
                    return Class.forName(desc.getName(), false, this.systemLoader);
                }
            }
            return Class.forName(desc.getName(), false, this.systemLoader);
        }
        catch (ClassNotFoundException ex) {
            super.resolveClass(desc);
            Class cl = (Class)primClasses.get(desc.getName());
            if (cl != null) {
                return cl;
            }
            throw ex;
        }
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

