/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Permission;
import javax.jms.JMSException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import jeus.deploy.archivist.FileArchive;
import jeus.io.helper.IOComponentCreator;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.StringUtil;

public class EnvironmentCall {
    private static EnvironmentCall call = new EnvironmentCall();

    public static EnvironmentCall getCall() {
        return call;
    }

    public static Object[] getCurrentUserPasswords() {
        return call.getUserPasswordsInternal();
    }

    protected Object[] getUserPasswordsInternal() {
        return new Object[]{null, null};
    }

    public static void loginCodeSubject() throws Exception {
        call.loginCodeSubjectInternal();
    }

    protected void loginCodeSubjectInternal() throws Exception {
    }

    public static void logoutWithRuntimeException() {
        call.logoutWithRuntimeExceptionInternal();
    }

    protected void logoutWithRuntimeExceptionInternal() {
    }

    public static FileArchive getConfigArchive() {
        return call.getConfigArchiveInternal();
    }

    protected FileArchive getConfigArchiveInternal() {
        return null;
    }

    public static void checkPermission(Permission permission) throws Exception {
        call.checkPermissionInternal(permission);
    }

    protected void checkPermissionInternal(Permission permission) throws Exception {
    }

    public static void checkCodeSubject() {
        call.checkCodeSubjectInternal();
    }

    protected void checkCodeSubjectInternal() {
    }

    public Object createSubject(String userName, String password) throws JMSException {
        return null;
    }

    public void authorize(Object subject, Permission permission) throws JMSException {
    }

    public static String getEnvName() {
        return call.getEnvNameInternal();
    }

    protected String getEnvNameInternal() {
        return null;
    }

    public static void resetEnvironmentCall() {
        call = new EnvironmentCall();
    }

    public static Object createJMSConsole(Object obj) {
        return call.createJMSConsoleInternal(obj);
    }

    protected Object createJMSConsoleInternal(Object obj) {
        return obj;
    }

    public static int getJeusBasePort() {
        return call.getJeusBasePortInternal();
    }

    protected int getJeusBasePortInternal() {
        return Integer.parseInt(System.getProperty("jeus.baseport", "9736"));
    }

    public static int getSecuritySSLPort() {
        return call.getSecuritySSLPortInternal();
    }

    protected int getSecuritySSLPortInternal() {
        return EnvironmentCall.getJeusBasePort() + 6;
    }

    public static String getSecurityID() {
        return call.getSecurityIDInternal();
    }

    protected String getSecurityIDInternal() {
        if (System.getProperty("jeus.security.enable.oneport") == null) {
            return null;
        }
        return "SecurityServer";
    }

    public static String getLocalFullHostName() {
        return call.getLocalFullHostNameInternal();
    }

    protected String getLocalFullHostNameInternal() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "localhost";
        }
    }

    public static String getLocalHostName() {
        return call.getLocalHostNameInternal();
    }

    protected String getLocalHostNameInternal() {
        String localHostName = EnvironmentCall.getLocalFullHostName();
        if (localHostName.indexOf(46) != -1) {
            return localHostName.substring(0, localHostName.indexOf(46));
        }
        return localHostName;
    }

    public static String getLocalVirutalName() {
        return call.getLocalVirtualNameInternal();
    }

    protected String getLocalVirtualNameInternal() {
        return EnvironmentCall.getLocalHostName();
    }

    public static String getRealNodeName(String targetNode) {
        return call.getRealNodeNameInternal(targetNode);
    }

    protected String getRealNodeNameInternal(String targetNode) {
        return EnvironmentCall.getLocalHostName() + ":" + EnvironmentCall.getJeusBasePort();
    }

    public static IOComponentCreator getSecurityIOComponent(String name, int expectedConnectionNumber, boolean enableNIO) {
        return call.getSecurityIOComponentInternal(name, expectedConnectionNumber, enableNIO);
    }

    protected IOComponentCreator getSecurityIOComponentInternal(String name, int expectedConnectionNumber, boolean enableNIO) {
        if (System.getProperty("jeus.security.enable.oneport") == null) {
            String blockingType = System.getProperty("jeus.net.blocking", "channel");
            if (blockingType.equals("socket")) {
                return IOComponentCreator.createBlockingCreator(name, 2, true);
            }
            return IOComponentCreator.createBlockingCreator(name, 3, true);
        }
        if (enableNIO) {
            return JeusIOComponentCreator.DEFAULT_CREATOR;
        }
        return JeusIOComponentCreator.createBlockingCreator("IO-" + name, expectedConnectionNumber);
    }

    public static SSLContext getSecuritySSLContext(boolean enableSSL) {
        return call.getSecuritySSLContextInternal(enableSSL);
    }

    protected SSLContext getSecuritySSLContextInternal(boolean enableSSL) {
        if (enableSSL) {
            try {
                KeyStore ks = KeyStore.getInstance("JKS");
                String keypass = System.getProperty("jeus.ssl.keypass", "jeuskeypass");
                String keystorePath = System.getProperty("jeus.ssl.keystore", "keystore");
                char[] passphrase = keypass.toCharArray();
                FileInputStream fin = new FileInputStream(keystorePath);
                ks.load(fin, passphrase);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, passphrase);
                fin.close();
                KeyStore ts = KeyStore.getInstance("JKS");
                String trustpass = System.getProperty("jeus.ssl.trustpass", "jeustrustpass");
                String truststorePath = System.getProperty("jeus.ssl.truststore", "truststore");
                passphrase = trustpass.toCharArray();
                fin = new FileInputStream(truststorePath);
                ts.load(fin, passphrase);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ts);
                fin.close();
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                return sslContext;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
        return null;
    }

    public static String getJeusConfigHome() {
        return call.getJeusConfigHomeInternal();
    }

    protected String getJeusConfigHomeInternal() {
        return null;
    }

    public static void initEncryptionUtil(Class c) throws IllegalAccessException, InstantiationException {
        call.initEncryptionUtilInternal(c);
    }

    protected void initEncryptionUtilInternal(Class c) throws IllegalAccessException, InstantiationException {
    }

    public static Object[] getSecurityNodeAndPort(String nodeName) {
        return call.getSecurityNodeAndPortInternal(nodeName);
    }

    protected Object[] getSecurityNodeAndPortInternal(String nodeName) {
        return StringUtil.getNodeAndPort(nodeName);
    }

    static {
        try {
            if (JeusBootstrapPropertyValues.isUpperJDK4()) {
                Class<?> c = EnvironmentCall.class.getClassLoader().loadClass("jeus.util.ServerEnvironmentCall");
                call = (EnvironmentCall)c.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

