/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import jeus.util.JeusRuntimeException;
import jeus.util.properties.JeusLoggerProperties;

public final class ErrorMsgManager {
    public static HashMap msgTable = new HashMap(10000);
    public static Object sync = new Object();
    private static final int messageUpperLimitBit = 17;
    private static final int messageUpperMask = 131071;
    private static final int messageModuleLimitBit = 10;
    private static final int messageModuleMask = 134086656;
    private static final int messageLevelLimitBit = 5;
    private static final int messageLevelMask = -134217728;
    private static final int messageModuleShiftBit = 17;
    private static final int messageLevelShiftBit = 27;
    private static HashMap[] messageArray;
    private static String[] moduleName;
    public static Level[] levels;
    private static final String language;
    private static final String country;
    private static final int MAX_MODULES = 256;
    private static HashSet moduleNames;
    private static int moduleIndex;
    private static boolean unitTestMode;

    public static void turnUnitTestModeOn() {
        unitTestMode = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Class messageClass) throws JeusRuntimeException {
        try {
            String baseClassName = messageClass.getName();
            Class<ErrorMsgManager> clazz = ErrorMsgManager.class;
            synchronized (ErrorMsgManager.class) {
                Class<?> jeusMessage;
                HashMap<Integer, ErrorMessage2> messageMap;
                int moduleNameIndex;
                block18: {
                    if (moduleNames.contains(baseClassName)) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                    moduleNames.add(baseClassName);
                    moduleNameIndex = moduleIndex++;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    ErrorMsgManager.messageArray[moduleNameIndex] = messageMap = new HashMap<Integer, ErrorMessage2>();
                    jeusMessage = messageClass;
                    if (JeusLoggerProperties.USE_LOCALE_ERR_MSG) {
                        ClassLoader loader = ErrorMsgManager.class.getClassLoader();
                        try {
                            jeusMessage = loader.loadClass(baseClassName + "_" + language + "_" + country);
                        }
                        catch (Throwable t1) {
                            try {
                                jeusMessage = loader.loadClass(baseClassName + "_" + language);
                            }
                            catch (Throwable t2) {
                                if (!unitTestMode) break block18;
                                throw t2;
                            }
                        }
                    }
                }
                Field[] fields = jeusMessage.getFields();
                HashMap<String, Field> intFieldList = new HashMap<String, Field>();
                try {
                    for (int j = 0; j < fields.length; ++j) {
                        Field field = fields[j];
                        if (!field.getType().equals(Integer.TYPE)) continue;
                        intFieldList.put(field.getName(), field);
                    }
                    Field f = jeusMessage.getField("moduleName");
                    ErrorMsgManager.moduleName[moduleNameIndex] = (String)f.get(null);
                    Set intFields = intFieldList.entrySet();
                    for (Map.Entry entry : intFields) {
                        String intFieldName = (String)entry.getKey();
                        String msgNumber = intFieldName.substring(intFieldName.indexOf(95) + 1);
                        Field intField = (Field)entry.getValue();
                        Level level = (Level)jeusMessage.getField(intFieldName + "_LEVEL").get(null);
                        try {
                            int levelNum = ErrorMsgManager.getLevelNumber(level);
                            int messageNumber = Integer.parseInt(msgNumber);
                            int num = (levelNum << 27) + (moduleNameIndex << 17) + messageNumber;
                            intField.setInt(null, num);
                            messageMap.put(new Integer(messageNumber), ErrorMsgManager.parseMessage((String)jeusMessage.getField(intFieldName + "_MSG").get(null), num));
                        }
                        catch (NumberFormatException ex) {
                            if (!unitTestMode) continue;
                            throw ex;
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!unitTestMode) return;
                    throw e;
                }
            }
        }
        catch (Throwable t) {
            if (!(t instanceof JeusRuntimeException)) throw new JeusRuntimeException("failed to read log message class", t);
            throw (JeusRuntimeException)t;
        }
    }

    private static int getLevelNumber(Level level) {
        int levelValue = level.intValue();
        switch (levelValue) {
            case 1000: {
                return 0;
            }
            case 900: {
                return 1;
            }
            case 800: {
                return 2;
            }
            case 700: {
                return 3;
            }
            case 500: {
                return 4;
            }
            case 400: {
                return 5;
            }
            case 300: {
                return 6;
            }
            case 0x7FFFFFFF: {
                return 0;
            }
            case -2147483648: {
                return 6;
            }
        }
        throw new JeusRuntimeException("Invalid level value");
    }

    private static ErrorMessage2 parseMessage(String msg, int msgNum) {
        int idx2;
        ArrayList<char[]> patterns = new ArrayList<char[]>();
        ArrayList<Integer> argIndexes = new ArrayList<Integer>();
        String msgForprocessing = msg;
        int idx = 0;
        int patternStartIndex = 0;
        while ((idx2 = msgForprocessing.indexOf(123, idx)) != -1) {
            int idx3 = msgForprocessing.indexOf(125, idx2);
            String escapedString = msgForprocessing.substring(idx2 + 1, idx3);
            try {
                Integer argIndex = new Integer(escapedString);
                patterns.add(msgForprocessing.substring(patternStartIndex, idx2).toCharArray());
                argIndexes.add(argIndex);
                patternStartIndex = idx = idx3 + 1;
            }
            catch (NumberFormatException ex) {
                msgForprocessing = msgForprocessing.substring(0, idx2) + escapedString + msgForprocessing.substring(idx3 + 1);
                idx = idx3 - 1;
            }
        }
        int[] args = new int[argIndexes.size()];
        for (int i = 0; i < argIndexes.size(); ++i) {
            Integer integer = (Integer)argIndexes.get(i);
            args[i] = integer;
        }
        patterns.add(msgForprocessing.substring(idx).toCharArray());
        return new ErrorMessage2((char[][])patterns.toArray((T[])new char[patterns.size()][]), args, patterns.size(), msg, msgNum);
    }

    public static String getLocalizedString(int errorNum) {
        ErrorMessage msg = (ErrorMessage)msgTable.get(new Integer(errorNum));
        if (msg == null) {
            try {
                ErrorMessage2 msg2 = ErrorMsgManager.getErrMessage(errorNum);
                return new String(msg2.getErrorString());
            }
            catch (Throwable t) {
                t.printStackTrace();
                return "fail to print message for " + errorNum;
            }
        }
        try {
            return new String(msg.getErrorString());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "fail to print message for " + errorNum;
        }
    }

    public static String getRawString(int errorNum) {
        return ErrorMsgManager.getErrMessage(errorNum).getRawString();
    }

    public static String getLocalizedString(int errorNum, Object msgArg) {
        ErrorMessage msg = (ErrorMessage)msgTable.get(new Integer(errorNum));
        if (msg == null) {
            ErrorMessage2 msg2 = ErrorMsgManager.getErrMessage(errorNum);
            try {
                return new String(msg2.getErrorString(msgArg));
            }
            catch (Throwable t) {
                t.printStackTrace();
                return "fail to print message for " + errorNum;
            }
        }
        try {
            return new String(msg.getErrorString(msgArg));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "fail to print message for " + errorNum;
        }
    }

    public static String getLocalizedString(int errorNum, Object[] msgArgs) {
        ErrorMessage msg = (ErrorMessage)msgTable.get(new Integer(errorNum));
        if (msg == null) {
            ErrorMessage2 msg2 = ErrorMsgManager.getErrMessage(errorNum);
            try {
                return new String(msg2.getErrorString(msgArgs));
            }
            catch (Throwable t) {
                t.printStackTrace();
                return "fail to print message for " + errorNum;
            }
        }
        return new String(msgArgs == null ? msg.getErrorString() : msg.getErrorString(msgArgs));
    }

    public static String getLocalizedString(Throwable t) {
        return t.getLocalizedMessage();
    }

    public static String getSourceModule(int msgNum) {
        return moduleName[ErrorMsgManager.getSourceModuleNumber(msgNum)];
    }

    private static int getSourceModuleNumber(int msgNum) {
        return (msgNum & 0x7FE0000) >> 17;
    }

    public static int getMessageNumber(int msgNum) {
        return msgNum & 0x1FFFF;
    }

    public static ErrorMessage2 getErrMessage(int msgNum) {
        try {
            int module = ErrorMsgManager.getSourceModuleNumber(msgNum);
            ErrorMessage2 msg = (ErrorMessage2)messageArray[module].get(new Integer(ErrorMsgManager.getMessageNumber(msgNum)));
            if (msg == null) {
                return new ErrorMessage2(new char[1][1], new int[0], 1, "", 0);
            }
            return msg;
        }
        catch (Throwable t) {
            return new ErrorMessage2(new char[1][1], new int[0], 1, "", 0);
        }
    }

    public static String getErrorStringMessage(int msgNum) {
        return ErrorMsgManager.getErrorStringMessage(msgNum, null);
    }

    public static String getErrorStringMessage(int msgNum, Object arg) {
        if (arg == null) {
            return ErrorMsgManager.getErrorStringMessage(msgNum, null);
        }
        return ErrorMsgManager.getErrorStringMessage(msgNum, new Object[]{arg});
    }

    public static String getErrorStringMessage(int msgNum, Object[] args) {
        if (msgNum <= 0) {
            return null;
        }
        try {
            ErrorMessage2 msg = ErrorMsgManager.getErrMessage(msgNum);
            if (msg != null) {
                if (args != null) {
                    return new String(msg.getErrorString(args));
                }
                return new String(msg.getErrorString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Level getLevel(int msgNum) {
        return levels[(msgNum & 0xF8000000) >>> 27];
    }

    public static int getLevelValue(int msgNum) {
        return ((msgNum & 0xF8000000) >>> 27) * 100;
    }

    public static void main(String[] args) throws ClassNotFoundException {
        ErrorMsgManager.printMsgStatus(args);
    }

    private static void printMsgStatus(String[] args) throws ClassNotFoundException {
        if (args.length == 0) {
            for (int i = 0; i < moduleName.length; ++i) {
                String s = moduleName[i];
                System.out.println("module name : " + s);
                System.out.println("\tindex : " + i);
                System.out.println("\tmessage number : " + messageArray[i].size());
                ErrorMsgManager.printLevelMessageNumber(i);
                System.out.println("---------------------------------------");
            }
        } else {
            String s;
            int i;
            String module = args[0];
            for (i = 0; i < moduleName.length && !(s = moduleName[i]).equals(module); ++i) {
            }
            if (i == moduleName.length) {
                System.out.println("The module name " + module + " is not correct");
                return;
            }
            System.out.println("module name : " + module);
            System.out.println("\tindex : " + i);
            System.out.println("\tmessage number : " + messageArray[i].size());
            ErrorMsgManager.printLevelMessageNumber(i);
        }
    }

    private static void printLevelMessageNumber(int i) throws ClassNotFoundException {
        Class<?> jeusMessage;
        String nameBase = "jeus.util.message.JeusMessage";
        Locale currLocale = Locale.getDefault();
        String language = currLocale.getLanguage();
        String country = currLocale.getCountry();
        ClassLoader loader = ErrorMsgManager.class.getClassLoader();
        try {
            jeusMessage = loader.loadClass(nameBase + "_" + moduleName[i] + "_" + language + "_" + country);
        }
        catch (Throwable t1) {
            try {
                jeusMessage = loader.loadClass(nameBase + "_" + moduleName[i] + "_" + language);
            }
            catch (Throwable t2) {
                jeusMessage = loader.loadClass(nameBase + "_" + moduleName[i]);
            }
        }
        int[] levelNum = new int[16];
        int offLevel = 0;
        int allLevel = 0;
        Field[] fields = jeusMessage.getFields();
        ErrorMsgManager.messageArray[i] = new HashMap();
        HashMap<String, Field> intFieldList = new HashMap<String, Field>();
        try {
            for (int j = 0; j < fields.length; ++j) {
                String fieldName;
                Field field = fields[j];
                if (!field.getType().equals(Integer.TYPE) || (fieldName = field.getName()).equals("startNumber") || fieldName.equals("upperLimit")) continue;
                intFieldList.put(field.getName(), field);
            }
            Set intFields = intFieldList.entrySet();
            for (Map.Entry entry : intFields) {
                String intFieldName = (String)entry.getKey();
                Level level = (Level)jeusMessage.getField(intFieldName + "_LEVEL").get(null);
                if (level.equals(Level.OFF)) {
                    ++offLevel;
                    continue;
                }
                if (level.equals(Level.ALL)) {
                    ++allLevel;
                    continue;
                }
                int n = ErrorMsgManager.getLevelNumber(level);
                levelNum[n] = levelNum[n] + 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\tNumber of messages for level");
        for (int j = 0; j < levels.length; ++j) {
            Level level = levels[j];
            if (level == null) continue;
            System.out.println("\t\tLevel : " + level.getName() + ", Number of messages : " + levelNum[j]);
        }
        if (offLevel > 0) {
            System.out.println("\t\tStrange Level : OFF, Number of messages : " + offLevel);
        }
        if (allLevel > 0) {
            System.out.println("\t\tStrange Level : ALL, Number of messages : " + allLevel);
        }
    }

    static {
        moduleNames = new HashSet();
        unitTestMode = false;
        levels = new Level[32];
        ErrorMsgManager.levels[ErrorMsgManager.getLevelNumber((Level)Level.SEVERE)] = Level.SEVERE;
        ErrorMsgManager.levels[ErrorMsgManager.getLevelNumber((Level)Level.WARNING)] = Level.WARNING;
        ErrorMsgManager.levels[ErrorMsgManager.getLevelNumber((Level)Level.INFO)] = Level.INFO;
        ErrorMsgManager.levels[ErrorMsgManager.getLevelNumber((Level)Level.CONFIG)] = Level.CONFIG;
        ErrorMsgManager.levels[ErrorMsgManager.getLevelNumber((Level)Level.FINE)] = Level.FINE;
        ErrorMsgManager.levels[ErrorMsgManager.getLevelNumber((Level)Level.FINER)] = Level.FINER;
        ErrorMsgManager.levels[ErrorMsgManager.getLevelNumber((Level)Level.FINEST)] = Level.FINEST;
        moduleName = new String[256];
        messageArray = new HashMap[256];
        Locale currLocale = Locale.getDefault();
        language = currLocale.getLanguage();
        if (language.equals("")) {
            throw new JeusRuntimeException("[ErrorMsgManager] no language property set");
        }
        country = currLocale.getCountry();
    }

    public static final class ErrorMessage2 {
        private char[][] pattern;
        private int[] argIDs;
        private int patternLen;
        private int numberOfPatterns;
        private String rawMsg;
        private String sourceModuleName;
        private int messageNumber;

        public ErrorMessage2(char[][] pattern, int[] argIDs, int size) {
            this.pattern = pattern;
            this.argIDs = argIDs;
            for (int i = 0; i < size; ++i) {
                this.patternLen += pattern[i].length;
            }
            this.numberOfPatterns = size;
        }

        public ErrorMessage2(char[][] pattern, int[] argIDs, int size, String rawMsg, int msgNum) {
            this(pattern, argIDs, size);
            this.rawMsg = rawMsg;
            this.sourceModuleName = ErrorMsgManager.getSourceModule(msgNum);
            this.messageNumber = ErrorMsgManager.getMessageNumber(msgNum);
        }

        public ErrorMessage2(String sourceModule, int number) {
            this.sourceModuleName = sourceModule;
            this.messageNumber = number;
        }

        public char[] getErrorString() {
            return this.pattern[0];
        }

        public String getRawString() {
            return this.rawMsg;
        }

        public char[] getErrorString(Object argObj) {
            String arg = null;
            if (argObj != null) {
                arg = argObj.toString();
            }
            if (arg == null) {
                arg = "";
            } else {
                arg = argObj.toString();
                if (arg == null) {
                    arg = "";
                }
            }
            int len = this.patternLen + arg.length();
            char[] msg = new char[len];
            int idx = 0;
            System.arraycopy(this.pattern[0], 0, msg, idx, this.pattern[0].length);
            char[] arg1 = arg.toCharArray();
            System.arraycopy(arg1, 0, msg, idx += this.pattern[0].length, arg1.length);
            idx += arg1.length;
            if (this.pattern.length >= 2) {
                System.arraycopy(this.pattern[1], 0, msg, idx, this.pattern[1].length);
            }
            return msg;
        }

        public char[] getErrorString(Object[] argObjs) {
            try {
                int i;
                String[] args = new String[argObjs.length];
                for (int j = 0; j < argObjs.length; ++j) {
                    Object argObj = argObjs[j];
                    args[j] = argObj != null ? argObj.toString() : "null";
                }
                int len = this.patternLen;
                for (i = 0; i < this.numberOfPatterns - 1; ++i) {
                    int index = this.argIDs[i];
                    if (args[index] == null) {
                        args[index] = "";
                    }
                    len += args[index].length();
                }
                char[] msg = new char[len];
                int idx = 0;
                for (i = 0; i < this.numberOfPatterns - 1; ++i) {
                    System.arraycopy(this.pattern[i], 0, msg, idx, this.pattern[i].length);
                    char[] arg = args[this.argIDs[i]].toCharArray();
                    System.arraycopy(arg, 0, msg, idx += this.pattern[i].length, arg.length);
                    idx += arg.length;
                }
                System.arraycopy(this.pattern[i], 0, msg, idx, this.pattern[i].length);
                return msg;
            }
            catch (ArrayIndexOutOfBoundsException t) {
                System.out.println("***** invalid message : " + this.rawMsg + ", sourceModuleName : " + this.sourceModuleName + ", numberOfPatterns : " + this.numberOfPatterns + ", patternLen : " + this.patternLen + ", argIDs length : " + this.argIDs.length + ", pattern length : " + this.pattern.length + ", arg length : " + argObjs.length);
                t.printStackTrace();
                return new char[0];
            }
            catch (Throwable t) {
                t.printStackTrace();
                return new char[0];
            }
        }

        public String getSourceModuleName() {
            return this.sourceModuleName;
        }

        public int getMessageNumber() {
            return this.messageNumber;
        }
    }

    public static final class ErrorMessage {
        private char[][] pattern;
        private int[] argIDs;
        private int patternLen = 0;
        private int numberOfParams;
        private String rawMsg;
        private String sourceModuleName;
        private int messageNumber;

        public ErrorMessage(char[][] pattern, int[] argIDs, int size) {
            this.pattern = pattern;
            this.argIDs = argIDs;
            for (int i = 0; i < size; ++i) {
                this.patternLen += pattern[i].length;
            }
            this.numberOfParams = size;
        }

        public ErrorMessage(char[][] pattern, int[] argIDs, int size, String rawMsg, int msgNum) {
            this(pattern, argIDs, size);
            this.rawMsg = rawMsg;
            this.sourceModuleName = ErrorMsgManager.getSourceModule(msgNum);
            this.messageNumber = ErrorMsgManager.getMessageNumber(msgNum);
        }

        public char[] getErrorString() {
            return this.pattern[0];
        }

        public String getRawString() {
            return this.rawMsg;
        }

        public char[] getErrorString(Object argObj) {
            String arg;
            if (argObj == null) {
                arg = "";
            } else {
                arg = argObj.toString();
                if (arg == null) {
                    arg = "";
                }
            }
            int len = this.patternLen + arg.length();
            char[] msg = new char[len];
            int idx = 0;
            System.arraycopy(this.pattern[0], 0, msg, idx, this.pattern[0].length);
            char[] arg1 = arg.toCharArray();
            System.arraycopy(arg1, 0, msg, idx += this.pattern[0].length, arg1.length);
            System.arraycopy(this.pattern[1], 0, msg, idx += arg1.length, this.pattern[1].length);
            return msg;
        }

        public char[] getErrorString(Object[] argObjs) {
            int i;
            int len = this.patternLen;
            String[] args = new String[argObjs.length];
            for (int j = 0; j < argObjs.length; ++j) {
                Object argObj = argObjs[j];
                args[j] = argObj == null ? "?" : argObj.toString();
            }
            for (i = 0; i < this.numberOfParams - 1; ++i) {
                int index = this.argIDs[i];
                len += args[index].length();
            }
            char[] msg = new char[len];
            int idx = 0;
            for (i = 0; i < this.numberOfParams - 1; ++i) {
                System.arraycopy(this.pattern[i], 0, msg, idx, this.pattern[i].length);
                char[] arg = args[this.argIDs[i]].toCharArray();
                System.arraycopy(arg, 0, msg, idx += this.pattern[i].length, arg.length);
                idx += arg.length;
            }
            System.arraycopy(this.pattern[i], 0, msg, idx, this.pattern[i].length);
            return msg;
        }

        public String getSourceModuleName() {
            return this.sourceModuleName;
        }

        public int getMessageNumber() {
            return this.messageNumber;
        }
    }
}

